/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.launching.sourcelookup.containers;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.containers.CompositeSourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.FolderSourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.ProjectSourceContainer;
import org.eclipse.dltk.mod.core.DLTKContentTypeManager;
import org.eclipse.dltk.mod.core.DLTKLanguageManager;
import org.eclipse.dltk.mod.core.IBuildpathEntry;
import org.eclipse.dltk.mod.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IScriptProject;

public class ScriptProjectSourceContainer
extends CompositeSourceContainer {
    public static final String TYPE_ID = "org.eclipse.dltk.mod.launching.sourceContainer.scriptProject";
    private IScriptProject project;
    private ISourceContainer[] sourceFolders;
    private ISourceContainer[] others;

    public ScriptProjectSourceContainer(IScriptProject project) {
        this.project = project;
    }

    protected ISourceContainer[] createSourceContainers() throws CoreException {
        ArrayList<Object> containers = new ArrayList<Object>();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        if (this.project.getProject().isOpen()) {
            IBuildpathEntry[] entries = this.project.getRawBuildpath();
            int i = 0;
            while (i < entries.length) {
                IBuildpathEntry entry = entries[i];
                switch (entry.getEntryKind()) {
                    case 3: {
                        IPath path = entry.getPath();
                        IResource resource = root.findMember(path);
                        if (!(resource instanceof IContainer)) break;
                        containers.add(new FolderSourceContainer((IContainer)resource, false));
                    }
                }
                ++i;
            }
        }
        this.sourceFolders = containers.toArray(new ISourceContainer[containers.size()]);
        ProjectSourceContainer theProject = new ProjectSourceContainer(this.project.getProject(), false);
        this.others = new ISourceContainer[]{theProject};
        containers.add(theProject);
        return containers.toArray(new ISourceContainer[containers.size()]);
    }

    public IScriptProject getScriptProject() {
        return this.project;
    }

    public String getName() {
        return this.project.getElementName();
    }

    public ISourceContainerType getType() {
        return this.getSourceContainerType(TYPE_ID);
    }

    public Object[] findSourceElements(String name) throws CoreException {
        this.getSourceContainers();
        if (this.isScriptLikeFile(name)) {
            Object[] objects = this.findSourceElements(name, this.sourceFolders);
            ArrayList<Object> filtered = null;
            int i = 0;
            while (i < objects.length) {
                Object object = objects[i];
                if (object instanceof IResource && !this.project.isOnBuildpath((IResource)object)) {
                    if (filtered == null) {
                        filtered = new ArrayList<Object>(objects.length);
                        int j = 0;
                        while (j < objects.length) {
                            filtered.add(objects[j]);
                            ++j;
                        }
                    }
                    filtered.remove(object);
                }
                ++i;
            }
            if (filtered == null) {
                return objects;
            }
            return filtered.toArray();
        }
        return this.findSourceElements(name, this.others);
    }

    public void dispose() {
        this.others = null;
        this.sourceFolders = null;
        super.dispose();
    }

    public int hashCode() {
        return this.project.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ScriptProjectSourceContainer) {
            return this.project.equals(((ScriptProjectSourceContainer)((Object)obj)).getScriptProject());
        }
        return super.equals(obj);
    }

    private boolean isScriptLikeFile(String name) {
        IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit((IModelElement)this.project);
        if (toolkit != null) {
            return false;
        }
        return DLTKContentTypeManager.isValidFileNameForContentType((IDLTKLanguageToolkit)toolkit, (String)name);
    }
}

