/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.ui.wizards.buildpath.newsourcepage;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IProjectFragment;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.internal.corext.buildpath.BuildpathModifier;
import org.eclipse.dltk.mod.internal.ui.actions.ActionMessages;
import org.eclipse.dltk.mod.internal.ui.wizards.NewWizardMessages;
import org.eclipse.dltk.mod.internal.ui.wizards.buildpath.AddSourceFolderWizard;
import org.eclipse.dltk.mod.internal.ui.wizards.buildpath.BPListElement;
import org.eclipse.dltk.mod.internal.ui.wizards.buildpath.EditFilterWizard;
import org.eclipse.dltk.mod.internal.ui.wizards.buildpath.newsourcepage.AddArchiveToBuildpathAction;
import org.eclipse.dltk.mod.internal.ui.wizards.buildpath.newsourcepage.AddFolderToBuildpathAction;
import org.eclipse.dltk.mod.internal.ui.wizards.buildpath.newsourcepage.AddLibraryToBuildpathAction;
import org.eclipse.dltk.mod.internal.ui.wizards.buildpath.newsourcepage.AddSelectedLibraryToBuildpathAction;
import org.eclipse.dltk.mod.internal.ui.wizards.buildpath.newsourcepage.ConfigureBuildPathAction;
import org.eclipse.dltk.mod.internal.ui.wizards.buildpath.newsourcepage.ExcludeFromBuildpathAction;
import org.eclipse.dltk.mod.internal.ui.wizards.buildpath.newsourcepage.IncludeToBuildpathAction;
import org.eclipse.dltk.mod.internal.ui.wizards.buildpath.newsourcepage.RemoveFromBuildpathAction;
import org.eclipse.dltk.mod.ui.DLTKPluginImages;
import org.eclipse.dltk.mod.ui.actions.AbstractOpenWizardAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.texteditor.IUpdate;

public class GenerateBuildPathActionGroup
extends ActionGroup {
    public static final String MENU_ID = "org.eclipse.dltk.mod.ui.buildpath.menu";
    public static final String GROUP_BUILDPATH = "buildpathGroup";
    public static final String GROUP_FILTER = "filterGroup";
    public static final String GROUP_CUSTOMIZE = "customizeGroup";
    private Action fNoActionAvailable = new NoActionAvailable();
    private IWorkbenchSite fSite;
    private List fActions;
    private String fGroupName = "group.reorganize";

    public GenerateBuildPathActionGroup(Page page) {
        this((IWorkbenchSite)page.getSite());
    }

    public GenerateBuildPathActionGroup(IViewPart part) {
        this((IWorkbenchSite)part.getSite());
    }

    private GenerateBuildPathActionGroup(IWorkbenchSite site) {
        this.fSite = site;
        this.fActions = new ArrayList();
        CreateLinkedSourceFolderAction addLinkedSourceFolderAction = new CreateLinkedSourceFolderAction();
        this.fActions.add(addLinkedSourceFolderAction);
        CreateLocalSourceFolderAction addSourceFolderAction = new CreateLocalSourceFolderAction();
        this.fActions.add(addSourceFolderAction);
        AddFolderToBuildpathAction addFolder = new AddFolderToBuildpathAction(site);
        this.fActions.add(addFolder);
        AddSelectedLibraryToBuildpathAction addSelectedLibrary = new AddSelectedLibraryToBuildpathAction(site);
        this.fActions.add(addSelectedLibrary);
        RemoveFromBuildpathAction remove = new RemoveFromBuildpathAction(site);
        this.fActions.add(remove);
        AddArchiveToBuildpathAction addArchive = new AddArchiveToBuildpathAction(site);
        this.fActions.add(addArchive);
        AddLibraryToBuildpathAction addLibrary = new AddLibraryToBuildpathAction(site);
        this.fActions.add(addLibrary);
        if (DLTKCore.DEBUG) {
            System.err.println("Add Update Zip Action here...");
        }
        ExcludeFromBuildpathAction exclude = new ExcludeFromBuildpathAction(site);
        this.fActions.add(exclude);
        IncludeToBuildpathAction include = new IncludeToBuildpathAction(site);
        this.fActions.add(include);
        EditFilterAction editFilterAction = new EditFilterAction();
        this.fActions.add(editFilterAction);
        ConfigureBuildPathAction configure = new ConfigureBuildPathAction(site);
        this.fActions.add(configure);
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        for (Action action : this.fActions) {
            if (!(action instanceof ISelectionChangedListener)) continue;
            provider.addSelectionChangedListener((ISelectionChangedListener)action);
        }
    }

    public void fillActionBars(IActionBars actionBar) {
        super.fillActionBars(actionBar);
        this.setGlobalActionHandlers(actionBar);
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        if (!this.canOperateOnSelection()) {
            return;
        }
        String menuText = ActionMessages.BuildPath_label;
        MenuManager subMenu = new MenuManager(menuText, MENU_ID);
        subMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                GenerateBuildPathActionGroup.this.fillViewSubMenu(manager);
            }
        });
        subMenu.setRemoveAllWhenShown(true);
        subMenu.add((IAction)new ConfigureBuildPathAction(this.fSite));
        menu.appendToGroup(this.fGroupName, (IContributionItem)subMenu);
    }

    private void fillViewSubMenu(IMenuManager source) {
        int added = 0;
        int i = 0;
        for (Action action : this.fActions) {
            if (action instanceof IUpdate) {
                ((IUpdate)action).update();
            }
            if (i == 2) {
                source.add((IContributionItem)new Separator(GROUP_BUILDPATH));
            } else if (i == 8) {
                source.add((IContributionItem)new Separator(GROUP_FILTER));
            } else if (i == 10) {
                source.add((IContributionItem)new Separator(GROUP_CUSTOMIZE));
            }
            added += this.addAction(source, (IAction)action);
            ++i;
        }
        if (added == 0) {
            source.add((IAction)this.fNoActionAvailable);
        }
    }

    private void setGlobalActionHandlers(IActionBars actionBar) {
    }

    private int addAction(IMenuManager menu, IAction action) {
        if (action != null && action.isEnabled()) {
            menu.add(action);
            return 1;
        }
        return 0;
    }

    private boolean canOperateOnSelection() {
        ISelection sel = this.fSite.getSelectionProvider().getSelection();
        if (!(sel instanceof IStructuredSelection)) {
            return false;
        }
        IStructuredSelection selection = (IStructuredSelection)sel;
        for (Object element : selection) {
            if (!(element instanceof IWorkingSet)) continue;
            return false;
        }
        return true;
    }

    public void dispose() {
        if (this.fActions != null) {
            ISelectionProvider provider = this.fSite.getSelectionProvider();
            for (Action action : this.fActions) {
                if (!(action instanceof ISelectionChangedListener)) continue;
                provider.removeSelectionChangedListener((ISelectionChangedListener)action);
            }
        }
        this.fActions = null;
        super.dispose();
    }

    public static class CreateLinkedSourceFolderAction
    extends CreateSourceFolderAction {
        public CreateLinkedSourceFolderAction() {
            super(true);
            this.setText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Link_label);
            this.setToolTipText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Link_tooltip);
            this.setImageDescriptor(DLTKPluginImages.DESC_ELCL_ADD_LINKED_SOURCE_TO_BUILDPATH);
            this.setDescription(NewWizardMessages.PackageExplorerActionGroup_FormText_createLinkedFolder);
        }
    }

    public static class CreateLocalSourceFolderAction
    extends CreateSourceFolderAction {
        public CreateLocalSourceFolderAction() {
            super(false);
            this.setText(ActionMessages.OpenNewSourceFolderWizardAction_text2);
            this.setDescription(ActionMessages.OpenNewSourceFolderWizardAction_description);
            this.setToolTipText(ActionMessages.OpenNewSourceFolderWizardAction_tooltip);
            this.setImageDescriptor(DLTKPluginImages.DESC_TOOL_NEWPACKROOT);
            if (DLTKCore.DEBUG) {
                System.err.println("Add help support here...");
            }
        }
    }

    private static abstract class CreateSourceFolderAction
    extends OpenBuildPathWizardAction {
        private AddSourceFolderWizard fAddSourceFolderWizard;
        private IScriptProject fSelectedProject;
        private final boolean fIsLinked;

        public CreateSourceFolderAction(boolean isLinked) {
            this.fIsLinked = isLinked;
        }

        @Override
        protected INewWizard createWizard() throws CoreException {
            BPListElement newEntrie = new BPListElement(this.fSelectedProject, 3, false);
            BPListElement[] existing = BPListElement.createFromExisting(this.fSelectedProject);
            boolean isProjectSrcFolder = BPListElement.isProjectSourceFolder(existing, this.fSelectedProject);
            this.fAddSourceFolderWizard = new AddSourceFolderWizard(existing, newEntrie, this.fIsLinked, false, false, isProjectSrcFolder, isProjectSrcFolder);
            return this.fAddSourceFolderWizard;
        }

        @Override
        public boolean selectionChanged(IStructuredSelection selection) {
            if (selection.size() == 1 && selection.getFirstElement() instanceof IScriptProject) {
                this.fSelectedProject = (IScriptProject)selection.getFirstElement();
                return true;
            }
            return false;
        }

        public List getBPListElements() {
            return this.fAddSourceFolderWizard.getExistingEntries();
        }
    }

    public static class EditFilterAction
    extends OpenBuildPathWizardAction {
        private IScriptProject fSelectedProject;
        private IModelElement fSelectedElement;
        private EditFilterWizard fEditFilterWizard;

        public EditFilterAction() {
            this.setText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Edit_label);
            this.setDescription(NewWizardMessages.PackageExplorerActionGroup_FormText_Edit);
            this.setToolTipText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Edit_tooltip);
            this.setImageDescriptor(DLTKPluginImages.DESC_ELCL_CONFIGURE_BUILDPATH_FILTERS);
            this.setDisabledImageDescriptor(DLTKPluginImages.DESC_DLCL_CONFIGURE_BUILDPATH_FILTERS);
        }

        @Override
        protected INewWizard createWizard() throws CoreException {
            BPListElement[] existingEntries = BPListElement.createFromExisting(this.fSelectedProject);
            BPListElement elementToEdit = EditFilterAction.findElement(this.fSelectedElement, existingEntries);
            this.fEditFilterWizard = new EditFilterWizard(existingEntries, elementToEdit);
            return this.fEditFilterWizard;
        }

        @Override
        public boolean selectionChanged(IStructuredSelection selection) {
            Object element;
            block7: {
                if (selection.size() != 1) {
                    return false;
                }
                try {
                    element = selection.getFirstElement();
                    if (!(element instanceof IScriptProject)) break block7;
                    IScriptProject project = (IScriptProject)element;
                    if (BuildpathModifier.isSourceFolder(project)) {
                        this.fSelectedProject = project;
                        this.fSelectedElement = (IModelElement)element;
                        return true;
                    }
                }
                catch (ModelException modelException) {
                    return false;
                }
            }
            if (element instanceof IProjectFragment) {
                IProjectFragment ProjectFragment = (IProjectFragment)element;
                IScriptProject project = ProjectFragment.getScriptProject();
                if (ProjectFragment.getKind() == 1 && project != null) {
                    this.fSelectedProject = project;
                    this.fSelectedElement = (IModelElement)element;
                    return true;
                }
            }
            return false;
        }

        private static BPListElement findElement(IModelElement element, BPListElement[] elements) {
            IPath path = element.getPath();
            int i = 0;
            while (i < elements.length) {
                BPListElement cur = elements[i];
                if (cur.getEntryKind() == 3 && cur.getPath().equals((Object)path)) {
                    return cur;
                }
                ++i;
            }
            return null;
        }

        public List getBPListElements() {
            return this.fEditFilterWizard.getExistingEntries();
        }
    }

    private static class NoActionAvailable
    extends Action {
        public NoActionAvailable() {
            this.setEnabled(false);
            this.setText(NewWizardMessages.GenerateBuildPathActionGroup_no_action_available);
        }
    }

    private static abstract class OpenBuildPathWizardAction
    extends AbstractOpenWizardAction
    implements ISelectionChangedListener {
        private OpenBuildPathWizardAction() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection selection = event.getSelection();
            if (selection instanceof IStructuredSelection) {
                this.setEnabled(this.selectionChanged((IStructuredSelection)selection));
            } else {
                this.setEnabled(this.selectionChanged((IStructuredSelection)StructuredSelection.EMPTY));
            }
        }

        public abstract boolean selectionChanged(IStructuredSelection var1);
    }
}

