/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.ui.workingsets;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IProjectFragment;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.internal.ui.scriptview.BuildPathContainer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.IWorkingSet;

public class WorkingSetFilter
extends ViewerFilter {
    private IWorkingSet fWorkingSet = null;
    private IAdaptable[] fCachedWorkingSet = null;

    public IWorkingSet getWorkingSet() {
        return this.fWorkingSet;
    }

    public void setWorkingSet(IWorkingSet workingSet) {
        this.fWorkingSet = workingSet;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.fWorkingSet == null || this.fWorkingSet.isAggregateWorkingSet() && this.fWorkingSet.getElements().length == 0) {
            return true;
        }
        if (element instanceof IModelElement) {
            return this.isEnclosing((IModelElement)element);
        }
        if (element instanceof IResource) {
            return this.isEnclosing(((IResource)element).getFullPath());
        }
        if (element instanceof BuildPathContainer) {
            return this.isEnclosing((BuildPathContainer)element);
        }
        if (element instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)element;
            IModelElement je = (IModelElement)adaptable.getAdapter(IModelElement.class);
            if (je != null) {
                return this.isEnclosing(je);
            }
            IResource resource = (IResource)adaptable.getAdapter(IResource.class);
            if (resource != null) {
                return this.isEnclosing(resource.getFullPath());
            }
        }
        return true;
    }

    private boolean isEnclosing(BuildPathContainer container) {
        IProjectFragment[] roots = container.getProjectFragments();
        if (roots.length > 0) {
            return this.isEnclosing((IModelElement)roots[0]);
        }
        return false;
    }

    public Object[] filter(Viewer viewer, Object parent, Object[] elements) {
        Object[] result = null;
        if (this.fWorkingSet != null) {
            this.fCachedWorkingSet = this.fWorkingSet.getElements();
        }
        try {
            result = super.filter(viewer, parent, elements);
        }
        finally {
            this.fCachedWorkingSet = null;
        }
        return result;
    }

    private boolean isEnclosing(IPath elementPath) {
        if (elementPath == null) {
            return false;
        }
        IAdaptable[] cachedWorkingSet = this.fCachedWorkingSet;
        if (cachedWorkingSet == null) {
            cachedWorkingSet = this.fWorkingSet.getElements();
        }
        int length = cachedWorkingSet.length;
        int i = 0;
        while (i < length) {
            if (this.isEnclosing(cachedWorkingSet[i], elementPath)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isEnclosing(IModelElement element) {
        Assert.isNotNull((Object)element);
        IAdaptable[] cachedWorkingSet = this.fCachedWorkingSet;
        if (cachedWorkingSet == null) {
            cachedWorkingSet = this.fWorkingSet.getElements();
        }
        boolean isElementPathComputed = false;
        IPath elementPath = null;
        int length = cachedWorkingSet.length;
        int i = 0;
        while (i < length) {
            IModelElement scopeElement = (IModelElement)cachedWorkingSet[i].getAdapter(IModelElement.class);
            if (scopeElement != null) {
                IModelElement searchedElement = element;
                while (searchedElement != null) {
                    IProjectFragment pkgRoot;
                    if (searchedElement.equals(scopeElement)) {
                        return true;
                    }
                    if (scopeElement.getElementType() == 2 && searchedElement.getElementType() == 3 && (pkgRoot = (IProjectFragment)searchedElement).isExternal() && pkgRoot.isArchive() && ((IScriptProject)scopeElement).isOnBuildpath(searchedElement)) {
                        return true;
                    }
                    if ((searchedElement = searchedElement.getParent()) == null || searchedElement.getElementType() != 5) continue;
                    ISourceModule unit = (ISourceModule)searchedElement;
                    unit = unit.getPrimary();
                }
                while (scopeElement != null) {
                    if (element.equals(scopeElement)) {
                        return true;
                    }
                    scopeElement = scopeElement.getParent();
                }
            } else {
                IResource elementResource;
                if (!isElementPathComputed && (elementResource = (IResource)element.getAdapter(IResource.class)) != null) {
                    elementPath = elementResource.getFullPath();
                }
                if (this.isEnclosing(cachedWorkingSet[i], elementPath)) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    private boolean isEnclosing(IAdaptable element, IPath path) {
        IModelElement ScriptElement;
        if (path == null) {
            return false;
        }
        IPath elementPath = null;
        IResource elementResource = (IResource)element.getAdapter(IResource.class);
        if (elementResource != null) {
            elementPath = elementResource.getFullPath();
        }
        if (elementPath == null && (ScriptElement = (IModelElement)element.getAdapter(IModelElement.class)) != null) {
            elementPath = ScriptElement.getPath();
        }
        if (elementPath == null && element instanceof IStorage) {
            elementPath = ((IStorage)element).getFullPath();
        }
        if (elementPath == null) {
            return false;
        }
        if (elementPath.isPrefixOf(path)) {
            return true;
        }
        return path.isPrefixOf(elementPath);
    }
}

