/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.ui.actions;

import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.core.search.IDLTKSearchScope;
import org.eclipse.dltk.mod.internal.ui.callhierarchy.SearchUtil;
import org.eclipse.dltk.mod.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.mod.internal.ui.search.DLTKSearchScopeFactory;
import org.eclipse.dltk.mod.internal.ui.search.SearchMessages;
import org.eclipse.dltk.mod.ui.DLTKPluginImages;
import org.eclipse.dltk.mod.ui.actions.FindDeclarationsAction;
import org.eclipse.dltk.mod.ui.search.ElementQuerySpecification;
import org.eclipse.dltk.mod.ui.search.QuerySpecification;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;

public abstract class FindDeclarationsInWorkingSetAction
extends FindDeclarationsAction {
    private IWorkingSet[] fWorkingSet;

    public FindDeclarationsInWorkingSetAction(IWorkbenchSite site) {
        this(site, (IWorkingSet[])null);
    }

    public FindDeclarationsInWorkingSetAction(IWorkbenchSite site, IWorkingSet[] workingSets) {
        super(site);
        this.fWorkingSet = workingSets;
    }

    public FindDeclarationsInWorkingSetAction(ScriptEditor editor) {
        this(editor, null);
    }

    public FindDeclarationsInWorkingSetAction(ScriptEditor editor, IWorkingSet[] workingSets) {
        super(editor);
        this.fWorkingSet = workingSets;
    }

    @Override
    void init() {
        this.setText(SearchMessages.Search_FindDeclarationsInWorkingSetAction_label);
        this.setToolTipText(SearchMessages.Search_FindDeclarationsInWorkingSetAction_tooltip);
        this.setImageDescriptor(DLTKPluginImages.DESC_OBJS_SEARCH_DECL);
        if (DLTKCore.DEBUG) {
            System.out.println("TODO: Add help support here..");
        }
    }

    @Override
    QuerySpecification createQuery(IModelElement element) throws ModelException {
        DLTKSearchScopeFactory factory = DLTKSearchScopeFactory.getInstance();
        IWorkingSet[] workingSets = this.fWorkingSet;
        if (this.fWorkingSet == null && (workingSets = factory.queryWorkingSets()) == null) {
            return null;
        }
        SearchUtil.updateLRUWorkingSets(workingSets);
        IDLTKSearchScope scope = factory.createSearchScope(workingSets, true, this.getLanguageToolkit());
        String description = factory.getWorkingSetScopeDescription(workingSets, true);
        return new ElementQuerySpecification(element, this.getLimitTo(), scope, description);
    }
}

