/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.ui.actions;

import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.IField;
import org.eclipse.dltk.mod.core.IMethod;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.IType;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.core.search.IDLTKSearchScope;
import org.eclipse.dltk.mod.core.search.SearchEngine;
import org.eclipse.dltk.mod.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.mod.internal.ui.search.DLTKSearchScopeFactory;
import org.eclipse.dltk.mod.internal.ui.search.SearchMessages;
import org.eclipse.dltk.mod.ui.DLTKPluginImages;
import org.eclipse.dltk.mod.ui.actions.FindReferencesAction;
import org.eclipse.dltk.mod.ui.search.ElementQuerySpecification;
import org.eclipse.dltk.mod.ui.search.QuerySpecification;
import org.eclipse.ui.IWorkbenchSite;

public abstract class FindReferencesInHierarchyAction
extends FindReferencesAction {
    public FindReferencesInHierarchyAction(IWorkbenchSite site) {
        super(site);
    }

    public FindReferencesInHierarchyAction(ScriptEditor editor) {
        super(editor);
    }

    @Override
    Class[] getValidTypes() {
        return new Class[]{ISourceModule.class, IType.class, IMethod.class, IField.class};
    }

    @Override
    void init() {
        this.setText(SearchMessages.Search_FindHierarchyReferencesAction_label);
        this.setToolTipText(SearchMessages.Search_FindHierarchyReferencesAction_tooltip);
        this.setImageDescriptor(DLTKPluginImages.DESC_OBJS_SEARCH_REF);
        if (DLTKCore.DEBUG) {
            System.out.println("TODO: Add helkp support here...");
        }
    }

    @Override
    QuerySpecification createQuery(IModelElement element) throws ModelException {
        IType type = this.getType(element);
        if (type == null) {
            return super.createQuery(element);
        }
        DLTKSearchScopeFactory factory = DLTKSearchScopeFactory.getInstance();
        IDLTKSearchScope scope = SearchEngine.createHierarchyScope((IType)type);
        String description = factory.getHierarchyScopeDescription(type);
        return new ElementQuerySpecification(element, this.getLimitTo(), scope, description);
    }
}

