/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.ui.browsing;

import java.util.ArrayList;
import org.eclipse.dltk.mod.core.IField;
import org.eclipse.dltk.mod.core.IMember;
import org.eclipse.dltk.mod.core.IMethod;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IPackageDeclaration;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.IType;
import org.eclipse.dltk.mod.internal.ui.editor.DLTKEditorMessages;
import org.eclipse.dltk.mod.ui.DLTKPluginImages;
import org.eclipse.dltk.mod.ui.DLTKUIPlugin;
import org.eclipse.dltk.mod.ui.MembersOrderPreferenceCache;
import org.eclipse.dltk.mod.ui.ModelElementSorter;
import org.eclipse.dltk.mod.ui.ScriptElementLabels;
import org.eclipse.dltk.mod.ui.actions.MemberFilterActionGroup;
import org.eclipse.dltk.mod.ui.browsing.ColoredViewersManager;
import org.eclipse.dltk.mod.ui.browsing.ScriptBrowsingPart;
import org.eclipse.dltk.mod.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.dltk.mod.ui.viewsupport.ProblemTreeViewer;
import org.eclipse.dltk.mod.ui.viewsupport.ScriptUILabelProvider;
import org.eclipse.dltk.mod.ui.viewsupport.SourcePositionSorter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IShowInTargetList;

public class MembersView
extends ScriptBrowsingPart
implements IPropertyChangeListener {
    private MemberFilterActionGroup fMemberFilterActionGroup;
    public static final String VIEW_ID = "org.eclipse.dltk.mod.ui.browsing.MembersView";
    ProblemTreeViewer viewer = null;

    public MembersView() {
        this.setHasWorkingSetFilter(false);
        this.setHasCustomSetFilter(true);
        DLTKUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    @Override
    public Object getAdapter(Class key) {
        if (key == IShowInTargetList.class) {
            return new IShowInTargetList(){

                public String[] getShowInTargetIds() {
                    return new String[]{"org.eclipse.dltk.mod.ui.ScriptExplorer"};
                }
            };
        }
        return super.getAdapter(key);
    }

    @Override
    protected ScriptUILabelProvider createLabelProvider() {
        return new AppearanceAwareLabelProvider(0x201000000402BL | ScriptElementLabels.ALL_CATEGORY, 1, DLTKUIPlugin.getDefault().getPreferenceStore());
    }

    @Override
    protected String getHelpContextId() {
        return "";
    }

    @Override
    protected String getLinkToEditorKey() {
        return "org.eclipse.dltk.mod.ui.browsing.member.to.editor";
    }

    @Override
    protected StructuredViewer createViewer(Composite parent) {
        this.viewer = new ProblemTreeViewer(parent, 2);
        ColoredViewersManager.install((StructuredViewer)this.viewer);
        this.fMemberFilterActionGroup = new MemberFilterActionGroup((StructuredViewer)this.viewer, DLTKUIPlugin.getDefault().getPreferenceStore());
        return this.viewer;
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        final SourcePositionSorter fSourcePositonComparator = new SourcePositionSorter();
        BusyIndicator.showWhile((Display)this.viewer.getControl().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                MembersView.this.viewer.setComparator((ViewerComparator)fSourcePositonComparator);
            }
        });
    }

    @Override
    protected void fillToolBar(IToolBarManager tbm) {
        tbm.add((IAction)new LexicalSortingAction());
        this.fMemberFilterActionGroup.contributeToToolBar(tbm);
        super.fillToolBar(tbm);
    }

    @Override
    protected void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
    }

    @Override
    protected void setInput(Object input) {
        super.setInput(input);
    }

    private IModelElement[] getCategoryFilterActionGroupInput() {
        Object input = this.getInput();
        if (input instanceof IModelElement) {
            return new IModelElement[]{(IModelElement)input};
        }
        return new IModelElement[0];
    }

    @Override
    protected boolean isValidInput(Object element) {
        return element instanceof ISourceModule || element instanceof IType;
    }

    @Override
    protected IContentProvider createContentProvider() {
        final ITreeContentProvider original = (ITreeContentProvider)super.createContentProvider();
        return new ITreeContentProvider(){

            public Object[] getChildren(Object parentElement) {
                Object[] children = original.getChildren(parentElement);
                ArrayList<Object> newChildren = new ArrayList<Object>();
                int i = 0;
                while (i < children.length) {
                    if (children[i] instanceof IField || children[i] instanceof IMethod || children[i] instanceof IPackageDeclaration) {
                        newChildren.add(children[i]);
                    }
                    ++i;
                }
                return newChildren.toArray();
            }

            public Object getParent(Object element) {
                return original.getParent(element);
            }

            public boolean hasChildren(Object element) {
                return false;
            }

            public Object[] getElements(Object inputElement) {
                Object[] children = original.getElements(inputElement);
                ArrayList<Object> newChildren = new ArrayList<Object>();
                int i = 0;
                while (i < children.length) {
                    if (children[i] instanceof IField || children[i] instanceof IMethod || children[i] instanceof IPackageDeclaration) {
                        newChildren.add(children[i]);
                    }
                    ++i;
                }
                return newChildren.toArray();
            }

            public void dispose() {
                original.dispose();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                original.inputChanged(viewer, oldInput, newInput);
            }
        };
    }

    @Override
    protected boolean isValidElement(Object element) {
        return element instanceof IField || element instanceof IMethod || element instanceof IPackageDeclaration;
    }

    @Override
    protected IModelElement findElementToSelect(IModelElement je) {
        if (je == null) {
            return null;
        }
        switch (je.getElementType()) {
            case 7: {
                return je;
            }
            case 8: 
            case 9: 
            case 10: {
                return je;
            }
            case 5: {
                return je;
            }
        }
        return je;
    }

    @Override
    protected IModelElement findInputForJavaElement(IModelElement je) {
        if (je == null || !je.exists() || je.getScriptProject() != null && !je.getScriptProject().isOnBuildpath(je)) {
            return null;
        }
        switch (je.getElementType()) {
            case 7: {
                IType type = ((IType)je).getDeclaringType();
                if (type == null) {
                    return je;
                }
                return this.findInputForJavaElement((IModelElement)type);
            }
            case 10: {
                IModelElement parent = je.getParent();
                if (parent instanceof IType) {
                    return parent;
                }
                return null;
            }
        }
        if (je instanceof IMember) {
            return this.findInputForJavaElement((IModelElement)((IMember)je).getDeclaringType());
        }
        return null;
    }

    @Override
    public void saveState(IMemento memento) {
        super.saveState(memento);
    }

    @Override
    protected void restoreState(IMemento memento) {
        super.restoreState(memento);
        this.getViewer().getControl().setRedraw(false);
        this.getViewer().refresh();
        this.getViewer().getControl().setRedraw(true);
    }

    @Override
    protected void hookViewerListeners() {
        super.hookViewerListeners();
        this.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object element;
                TreeViewer viewer = (TreeViewer)MembersView.this.getViewer();
                if (viewer.isExpandable(element = ((IStructuredSelection)event.getSelection()).getFirstElement())) {
                    viewer.setExpandedState(element, !viewer.getExpandedState(element));
                }
            }
        });
    }

    boolean isInputAWorkingCopy() {
        ISourceModule cu;
        Object input = this.getViewer().getInput();
        if (input instanceof IModelElement && (cu = (ISourceModule)((IModelElement)input).getAncestor(5)) != null) {
            return cu.isWorkingCopy();
        }
        return false;
    }

    @Override
    protected void restoreSelection() {
        IEditorPart editor = this.getViewSite().getPage().getActiveEditor();
        if (editor != null) {
            this.setSelectionFromEditor((IWorkbenchPart)editor);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (MembersOrderPreferenceCache.isMemberOrderProperty(event.getProperty())) {
            this.getViewer().refresh();
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        DLTKUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    class LexicalSortingAction
    extends Action {
        private ModelElementSorter fComparator = new ModelElementSorter();
        private SourcePositionSorter fSourcePositonComparator = new SourcePositionSorter();

        public LexicalSortingAction() {
            this.setText(DLTKEditorMessages.ScriptOutlinePage_Sort_label);
            DLTKPluginImages.setLocalImageDescriptors((IAction)this, "alphab_sort_co.gif");
            this.setToolTipText(DLTKEditorMessages.ScriptOutlinePage_Sort_tooltip);
            this.setDescription(DLTKEditorMessages.ScriptOutlinePage_Sort_description);
            boolean checked = DLTKUIPlugin.getDefault().getPreferenceStore().getBoolean("LexicalSortingAction.isChecked");
            this.valueChanged(checked, false);
        }

        public void run() {
            this.valueChanged(this.isChecked(), true);
        }

        private void valueChanged(final boolean on, boolean store) {
            this.setChecked(on);
            BusyIndicator.showWhile((Display)MembersView.this.viewer.getControl().getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    if (on) {
                        ((LexicalSortingAction)LexicalSortingAction.this).MembersView.this.viewer.setComparator((ViewerComparator)LexicalSortingAction.this.fComparator);
                    } else {
                        ((LexicalSortingAction)LexicalSortingAction.this).MembersView.this.viewer.setComparator((ViewerComparator)LexicalSortingAction.this.fSourcePositonComparator);
                    }
                }
            });
            if (store) {
                DLTKUIPlugin.getDefault().getPreferenceStore().setValue("LexicalSortingAction.isChecked", on);
            }
        }
    }
}

