/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.ui.preferences;

import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

public abstract class ComboViewerBlock {
    private ComboViewer viewer;

    public ComboViewerBlock(Composite composite, GridData layout) {
        this.viewer = new ComboViewer(composite);
        this.viewer.getCombo().setLayoutData((Object)layout);
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ComboViewerBlock.this.getObjectName(element);
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ComboViewerBlock.this.selectedObjectChanged(ComboViewerBlock.this.getSelectedObject());
            }
        });
    }

    public void initialize(Object[] elements) {
        this.viewer.add(elements);
        this.setSelectedObject();
        int itemCount = this.viewer.getCombo().getItemCount();
        this.viewer.getCombo().setEnabled(itemCount != 0);
    }

    public void performDefaults() {
        this.setSelectedObject();
    }

    protected abstract String getSavedObjectId();

    protected abstract String getObjectName(Object var1);

    protected abstract void selectedObjectChanged(Object var1);

    protected abstract String getObjectId(Object var1);

    protected abstract Object getDefaultObject();

    protected abstract Object getObjectById(String var1);

    public Object getSelectedObject() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection != null) {
            return selection.getFirstElement();
        }
        return null;
    }

    private void setSelectedObject() {
        String id = this.getSavedObjectId();
        Object selected = null;
        if (id == null || "".equals(id)) {
            selected = this.getDefaultObject();
        } else {
            selected = this.getObjectById(id);
            if (selected == null) {
                selected = this.getDefaultObject();
            }
        }
        if (selected != null) {
            this.viewer.setSelection((ISelection)new StructuredSelection(selected));
        }
    }
}

