/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.IBuildpathEntry;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.internal.ui.wizards.NewWizardMessages;
import org.eclipse.dltk.mod.ui.util.IStatusChangeListener;
import org.eclipse.dltk.mod.ui.wizards.BuildpathsBlock;
import org.eclipse.dltk.mod.ui.wizards.NewElementWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public abstract class CapabilityConfigurationPage
extends NewElementWizardPage {
    private static final String PAGE_NAME = "DLTKCapabilityConfigurationPage";
    private IScriptProject fScriptProject = null;
    private BuildpathsBlock fBuildPathsBlock;

    public CapabilityConfigurationPage() {
        super(PAGE_NAME);
        this.setTitle(NewWizardMessages.ScriptCapabilityConfigurationPage_title);
        this.setDescription(NewWizardMessages.ScriptCapabilityConfigurationPage_description);
    }

    private BuildpathsBlock getBuildPathsBlock() {
        if (this.fBuildPathsBlock == null) {
            IStatusChangeListener listener = new IStatusChangeListener(){

                @Override
                public void statusChanged(IStatus status) {
                    CapabilityConfigurationPage.this.updateStatus(status);
                }
            };
            this.fBuildPathsBlock = this.createBuildpathBlock(listener);
        }
        return this.fBuildPathsBlock;
    }

    protected abstract BuildpathsBlock createBuildpathBlock(IStatusChangeListener var1);

    protected boolean useNewSourcePage() {
        return false;
    }

    public void init(IScriptProject jproject, IBuildpathEntry[] defaultEntries, boolean defaultsOverrideExistingBuildpath) {
        if (!defaultsOverrideExistingBuildpath && jproject.exists() && jproject.getProject().getFile(".buildpath").exists()) {
            defaultEntries = null;
        }
        this.getBuildPathsBlock().init(jproject, defaultEntries);
        this.fScriptProject = jproject;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)new GridLayout(1, false));
        Control control = this.getBuildPathsBlock().createControl(composite);
        control.setLayoutData((Object)new GridData(4, 4, true, true));
        Dialog.applyDialogFont((Control)composite);
        if (DLTKCore.DEBUG) {
            System.err.println("Add help support here...");
        }
        this.setControl((Control)composite);
    }

    public IBuildpathEntry[] getRawBuildPath() {
        return this.getBuildPathsBlock().getRawBuildPath();
    }

    public IScriptProject getScriptProject() {
        return this.fScriptProject;
    }

    protected abstract String getScriptNature();

    public IRunnableWithProgress getRunnable() {
        if (this.getScriptProject() != null) {
            return new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        CapabilityConfigurationPage.this.configureScriptProject(monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
        }
        return null;
    }

    public static void createProject(IProject project, URI locationURI, IProgressMonitor monitor) throws CoreException {
        BuildpathsBlock.createProject(project, locationURI, monitor);
    }

    public void configureScriptProject(IProgressMonitor monitor) throws CoreException, InterruptedException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        int nSteps = 6;
        monitor.beginTask(NewWizardMessages.ScriptCapabilityConfigurationPage_op_desc_Script, nSteps);
        try {
            try {
                IProject project = this.getScriptProject().getProject();
                BuildpathsBlock.addScriptNature(project, (IProgressMonitor)new SubProgressMonitor(monitor, 1), this.getScriptNature());
                this.getBuildPathsBlock().configureScriptProject((IProgressMonitor)new SubProgressMonitor(monitor, 5));
            }
            catch (OperationCanceledException operationCanceledException) {
                throw new InterruptedException();
            }
        }
        finally {
            monitor.done();
        }
    }
}

