/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.ui.wizards;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IProjectFragment;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.internal.core.ExternalScriptFolder;
import org.eclipse.dltk.mod.internal.corext.util.Messages;
import org.eclipse.dltk.mod.internal.ui.StandardModelElementContentProvider;
import org.eclipse.dltk.mod.internal.ui.dialogs.StatusInfo;
import org.eclipse.dltk.mod.internal.ui.wizards.NewWizardMessages;
import org.eclipse.dltk.mod.internal.ui.wizards.TypedViewerFilter;
import org.eclipse.dltk.mod.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.dltk.mod.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.dltk.mod.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.dltk.mod.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.dltk.mod.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.dltk.mod.ui.DLTKUIPlugin;
import org.eclipse.dltk.mod.ui.ModelElementLabelProvider;
import org.eclipse.dltk.mod.ui.ModelElementSorter;
import org.eclipse.dltk.mod.ui.viewsupport.IViewPartInputProvider;
import org.eclipse.dltk.mod.ui.wizards.NewElementWizardPage;
import org.eclipse.jdt.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.views.contentoutline.ContentOutline;

public abstract class NewContainerWizardPage
extends NewElementWizardPage {
    protected static final String CONTAINER = "NewContainerWizardPage.container";
    protected IStatus containerStatus;
    private StringButtonDialogField containerDialogField;
    private IProjectFragment currRoot;
    private IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();

    public NewContainerWizardPage(String name) {
        super(name);
        ContainerFieldAdapter adapter = new ContainerFieldAdapter();
        this.containerDialogField = new StringButtonDialogField(adapter);
        this.containerDialogField.setDialogFieldListener(adapter);
        this.containerDialogField.setLabelText(this.getContainerLabel());
        this.containerDialogField.setButtonLabel(NewWizardMessages.NewContainerWizardPage_container_button);
        this.containerStatus = new StatusInfo();
        this.currRoot = null;
    }

    protected String getContainerLabel() {
        return NewWizardMessages.NewContainerWizardPage_container_label;
    }

    protected void initContainerPage(IModelElement elem) {
        IProjectFragment initRoot = null;
        if (elem != null) {
            initRoot = (IProjectFragment)elem.getAncestor(3);
            if (initRoot instanceof ExternalScriptFolder) {
                initRoot = null;
            }
            try {
                IScriptProject jproject;
                if ((initRoot == null || initRoot.getKind() != 1) && (jproject = elem.getScriptProject()) != null) {
                    initRoot = null;
                    if (jproject.exists()) {
                        IProjectFragment[] roots = jproject.getProjectFragments();
                        int i = 0;
                        while (i < roots.length) {
                            if (roots[i].getKind() == 1) {
                                initRoot = roots[i];
                                break;
                            }
                            ++i;
                        }
                    }
                    if (initRoot == null) {
                        initRoot = jproject.getProjectFragment(jproject.getResource());
                    }
                }
            }
            catch (ModelException e) {
                DLTKUIPlugin.log(e);
            }
        }
        this.setProjectFragmentRoot(initRoot, true);
        this.handleFieldChanged(CONTAINER);
    }

    protected IModelElement getInitialScriptElement(IStructuredSelection selection) {
        IResource resource;
        IAdaptable adaptable;
        Object selectedElement;
        IModelElement scriptElement = null;
        if (selection != null && !selection.isEmpty() && (selectedElement = selection.getFirstElement()) instanceof IAdaptable && (scriptElement = (IModelElement)(adaptable = (IAdaptable)selectedElement).getAdapter(IModelElement.class)) == null && (resource = (IResource)adaptable.getAdapter(IResource.class)) != null && resource.getType() != 8) {
            while (scriptElement == null && resource.getType() != 4) {
                resource = resource.getParent();
                scriptElement = (IModelElement)resource.getAdapter(IModelElement.class);
            }
            if (scriptElement == null) {
                scriptElement = DLTKCore.create((IResource)resource);
            }
        }
        if (scriptElement == null) {
            Object provider;
            IWorkbenchPart part = DLTKUIPlugin.getActivePage().getActivePart();
            if (part instanceof ContentOutline) {
                part = DLTKUIPlugin.getActivePage().getActiveEditor();
            }
            if (part instanceof IViewPartInputProvider && (provider = ((IViewPartInputProvider)part).getViewPartInput()) instanceof IModelElement) {
                scriptElement = (IModelElement)provider;
            }
        }
        if (scriptElement == null || scriptElement.getElementType() == 1) {
            try {
                IScriptProject[] projects = DLTKCore.create((IWorkspaceRoot)this.getWorkspaceRoot()).getScriptProjects();
                if (projects.length == 1) {
                    scriptElement = projects[0];
                }
            }
            catch (ModelException e) {
                DLTKUIPlugin.log(e);
            }
        }
        return scriptElement;
    }

    protected int getMaxFieldWidth() {
        return this.convertWidthInCharsToPixels(40);
    }

    protected void createContainerControls(Composite parent, int nColumns) {
        this.containerDialogField.doFillIntoGrid(parent, nColumns);
        LayoutUtil.setWidthHint((Control)this.containerDialogField.getTextControl(null), this.getMaxFieldWidth());
    }

    protected void setFocusOnContainer() {
        this.containerDialogField.setFocus();
    }

    private void containerChangeControlPressed(DialogField field) {
        IProjectFragment root = this.chooseContainer();
        if (root != null) {
            this.setProjectFragmentRoot(root, true);
        }
    }

    private void containerDialogFieldChanged(DialogField field) {
        if (field == this.containerDialogField) {
            this.containerStatus = this.containerChanged();
        }
        this.handleFieldChanged(CONTAINER);
    }

    protected abstract String getRequiredNature();

    protected IStatus containerChanged() {
        StatusInfo status = new StatusInfo();
        this.currRoot = null;
        String str = this.getScriptFolderText();
        if (str.length() == 0) {
            status.setError(NewWizardMessages.NewContainerWizardPage_error_EnterContainerName);
            return status;
        }
        Path path = new Path(str);
        IResource res = this.workspaceRoot.findMember((IPath)path);
        if (res != null) {
            int resType = res.getType();
            if (resType == 4 || resType == 2) {
                IProject proj = res.getProject();
                if (!proj.isOpen()) {
                    status.setError(Messages.format(NewWizardMessages.NewContainerWizardPage_error_ProjectClosed, proj.getFullPath().toString()));
                    return status;
                }
                IScriptProject jproject = DLTKCore.create((IProject)proj);
                this.currRoot = resType == 4 ? jproject.getProjectFragment(res) : jproject.getProjectFragment(res);
                if (res.exists()) {
                    try {
                        String nature = this.getRequiredNature();
                        if (nature != null && !proj.hasNature(nature)) {
                            if (resType == 4) {
                                status.setError(NewWizardMessages.NewContainerWizardPage_warning_NotAScriptProject);
                            } else {
                                status.setError(NewWizardMessages.NewContainerWizardPage_warning_NotInAScriptProject);
                            }
                            return status;
                        }
                    }
                    catch (CoreException coreException) {
                        status.setWarning(NewWizardMessages.NewContainerWizardPage_warning_NotAScriptProject);
                    }
                }
                return status;
            }
            status.setError(Messages.format(NewWizardMessages.NewContainerWizardPage_error_NotAFolder, str));
            return status;
        }
        status.setError(Messages.format(NewWizardMessages.NewContainerWizardPage_error_ContainerDoesNotExist, str));
        return status;
    }

    protected void handleFieldChanged(String fieldName) {
    }

    protected IWorkspaceRoot getWorkspaceRoot() {
        return this.workspaceRoot;
    }

    public IProjectFragment getProjectFragment() {
        return this.currRoot;
    }

    public String getScriptFolderText() {
        return this.containerDialogField.getText();
    }

    public void setProjectFragmentRoot(IProjectFragment root, boolean canBeModified) {
        this.currRoot = root;
        String str = root == null ? "" : root.getPath().makeRelative().toString();
        this.containerDialogField.setText(str);
        this.containerDialogField.setEnabled(canBeModified);
    }

    protected IProjectFragment chooseContainer() {
        IProjectFragment initElement = this.getProjectFragment();
        Class[] acceptedClasses = new Class[]{IScriptProject.class, IProjectFragment.class};
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, false){

            public boolean isSelectedValid(Object element) {
                try {
                    if (element instanceof IScriptProject) {
                        IScriptProject jproject = (IScriptProject)element;
                        IPath path = jproject.getProject().getFullPath();
                        return jproject.findProjectFragment(path) != null;
                    }
                    if (element instanceof IProjectFragment) {
                        return ((IProjectFragment)element).getKind() == 1;
                    }
                    return true;
                }
                catch (ModelException e) {
                    DLTKUIPlugin.log(e.getStatus());
                    return false;
                }
            }
        };
        TypedViewerFilter filter = new TypedViewerFilter(acceptedClasses){

            @Override
            public boolean select(Viewer viewer, Object parent, Object element) {
                if (element instanceof IProjectFragment) {
                    try {
                        IProjectFragment fragment = (IProjectFragment)element;
                        return fragment.getKind() == 1 && !fragment.isExternal();
                    }
                    catch (ModelException modelException) {
                        return false;
                    }
                }
                return super.select(viewer, parent, element);
            }
        };
        StandardModelElementContentProvider provider = new StandardModelElementContentProvider();
        ModelElementLabelProvider labelProvider = new ModelElementLabelProvider(ModelElementLabelProvider.SHOW_DEFAULT);
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)labelProvider, (ITreeContentProvider)provider);
        dialog.setValidator((ISelectionStatusValidator)validator);
        dialog.setComparator((ViewerComparator)new ModelElementSorter());
        dialog.setTitle(NewWizardMessages.NewContainerWizardPage_ChooseSourceContainerDialog_title);
        dialog.setMessage(NewWizardMessages.NewContainerWizardPage_ChooseSourceContainerDialog_description);
        dialog.addFilter((ViewerFilter)filter);
        dialog.setInput((Object)DLTKCore.create((IWorkspaceRoot)this.workspaceRoot));
        dialog.setInitialSelection((Object)initElement);
        dialog.setHelpAvailable(false);
        if (dialog.open() == 0) {
            Object element = dialog.getFirstResult();
            if (element instanceof IScriptProject) {
                IScriptProject jproject = (IScriptProject)element;
                return jproject.getProjectFragment(jproject.getResource());
            }
            if (element instanceof IProjectFragment) {
                return (IProjectFragment)element;
            }
            return null;
        }
        return null;
    }

    private class ContainerFieldAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener {
        private ContainerFieldAdapter() {
        }

        @Override
        public void changeControlPressed(DialogField field) {
            NewContainerWizardPage.this.containerChangeControlPressed(field);
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            NewContainerWizardPage.this.containerDialogFieldChanged(field);
        }
    }
}

