/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.validators.internal.ui.popup.actions;

import org.eclipse.dltk.mod.core.DLTKLanguageManager;
import org.eclipse.dltk.mod.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.environment.EnvironmentManager;
import org.eclipse.dltk.mod.core.environment.IEnvironment;
import org.eclipse.dltk.mod.ui.actions.AbstractMenuCreatorObjectActionDelegate;
import org.eclipse.dltk.mod.validators.core.IResourceValidator;
import org.eclipse.dltk.mod.validators.core.ISourceModuleValidator;
import org.eclipse.dltk.mod.validators.core.IValidator;
import org.eclipse.dltk.mod.validators.core.IValidatorType;
import org.eclipse.dltk.mod.validators.core.ValidatorRuntime;
import org.eclipse.dltk.mod.validators.internal.ui.popup.actions.RemoveAllMarkersAction;
import org.eclipse.dltk.mod.validators.internal.ui.popup.actions.ValidateAction;
import org.eclipse.dltk.mod.validators.internal.ui.popup.actions.ValidateAllAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;

public class DLTKValidatorsModelElementAction
extends AbstractMenuCreatorObjectActionDelegate {
    protected void fillMenu(AbstractMenuCreatorObjectActionDelegate.IMenuBuilder menu, IStructuredSelection selection) {
        if (selection == null || selection.isEmpty()) {
            return;
        }
        Object input = selection.getFirstElement();
        if (!(input instanceof IModelElement)) {
            return;
        }
        IModelElement element = (IModelElement)input;
        IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit((IModelElement)element);
        if (toolkit == null) {
            return;
        }
        IEnvironment environment = EnvironmentManager.getEnvironment((IModelElement)element);
        if (environment == null) {
            return;
        }
        IValidatorType[] validatorTypes = ValidatorRuntime.getValidatorTypes((String)toolkit.getNatureId());
        if (validatorTypes == null || validatorTypes.length == 0) {
            return;
        }
        int validatorCount = 0;
        int i = 0;
        while (i < validatorTypes.length) {
            IValidator[] validators;
            IValidatorType type = validatorTypes[i];
            if (DLTKValidatorsModelElementAction.isSupported(type) && (validators = type.getValidators()) != null && validators.length != 0) {
                int j = 0;
                while (j < validators.length) {
                    IValidator validator = validators[j];
                    menu.addAction((IAction)new ValidateAction(validator, selection));
                    ++validatorCount;
                    ++j;
                }
            }
            ++i;
        }
        if (validatorCount != 0) {
            menu.addSeparator();
        }
        menu.addAction((IAction)new RemoveAllMarkersAction(selection));
        if (validatorCount != 0) {
            menu.addAction((IAction)new ValidateAllAction(selection));
        }
    }

    private static boolean isSupported(IValidatorType type) {
        return type.supports(ISourceModuleValidator.class) || type.supports(IResourceValidator.class);
    }
}

