/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.validators.internal.ui.popup.actions;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.validators.core.IResourceValidator;
import org.eclipse.dltk.mod.validators.core.ISourceModuleValidator;
import org.eclipse.dltk.mod.validators.core.IValidator;
import org.eclipse.dltk.mod.validators.core.IValidatorOutput;
import org.eclipse.dltk.mod.validators.internal.ui.ValidatorsUI;
import org.eclipse.dltk.mod.validators.internal.ui.popup.actions.Messages;
import org.eclipse.dltk.mod.validators.ui.AbstractConsoleValidateJob;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;

public class ValidateAction
extends Action {
    static final String VALIDATE_IMAGE = "icons/goto_input.gif";
    private final IValidator validator;
    private final IStructuredSelection selection;

    public ValidateAction(IValidator validator, IStructuredSelection selection) {
        this.validator = validator;
        this.selection = selection;
        String text = NLS.bind((String)Messages.DLTKValidatorsEditorContextMenu_validateWith, (Object)validator.getName());
        this.setText(text);
        this.setImageDescriptor(ValidatorsUI.getDefault().getImageDescriptor(VALIDATE_IMAGE));
    }

    public void run() {
        AbstractConsoleValidateJob delegate = new AbstractConsoleValidateJob(this.validator.getName()){

            protected void invokeValidationFor(IValidatorOutput output, IScriptProject project, ISourceModule[] modules, IResource[] resources, IProgressMonitor monitor) {
                if (ValidateAction.this.validator.isValidatorValid(project)) {
                    IResourceValidator resourceValidator;
                    ISourceModuleValidator sourceModuleValidator = (ISourceModuleValidator)ValidateAction.this.validator.getValidator(project, ISourceModuleValidator.class);
                    if (sourceModuleValidator != null) {
                        sourceModuleValidator.validate(modules, output, monitor);
                    }
                    if ((resourceValidator = (IResourceValidator)ValidateAction.this.validator.getValidator(project, IResourceValidator.class)) != null) {
                        resourceValidator.validate(resources, output, monitor);
                    }
                }
            }
        };
        delegate.run(this.selection.toArray());
    }
}

