/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.kernel.util.xml.rt;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class XmlReaderHelper {
    static final String NAMESPACES_FEATURE_ID = "http://xml.org/sax/features/namespaces";
    static final String NAMESPACE_PREFIXES_FEATURE_ID = "http://xml.org/sax/features/namespace-prefixes";
    static final String VALIDATION_FEATURE_ID = "http://xml.org/sax/features/validation";
    static final String SCHEMA_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/schema";
    static final String SCHEMA_FULL_CHECKING_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";
    static final String DYNAMIC_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/dynamic";
    static final String NO_NAMESPACE_SCHEMA_LOCATION_ID = "http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation";
    static final String DEFAULT_PARSER_NAME = "org.apache.xerces.parsers.SAXParser";
    private static final ThreadLocal<XMLReader> s_tl = new ThreadLocal();

    public static XMLReader createXmlReader() throws SAXException {
        XMLReader xmlReader = XMLReaderFactory.createXMLReader(DEFAULT_PARSER_NAME);
        return xmlReader;
    }

    public static XMLReader getSimpleThreadLocalXmlReader() throws SAXException {
        return XmlReaderHelper.getSimpleThreadLocalXmlReader(s_tl);
    }

    public static XMLReader getSimpleThreadLocalXmlReader(ThreadLocal<XMLReader> tl) throws SAXException {
        ReaderDelegate reader = (ReaderDelegate)tl.get();
        if (reader == null) {
            reader = new ReaderDelegate(XMLReaderFactory.createXMLReader(DEFAULT_PARSER_NAME));
            tl.set(reader);
        } else {
            reader.clearAll();
        }
        return reader;
    }

    public static void setDefaultParams(XMLReader xmlReader, boolean validateXml) throws SAXException {
        boolean namespaces = true;
        boolean namespacePrefixes = false;
        boolean validation = validateXml;
        boolean schemaValidation = validateXml;
        boolean schemaFullChecking = validateXml;
        boolean dynamicValidation = validateXml;
        xmlReader.setFeature(NAMESPACES_FEATURE_ID, namespaces);
        xmlReader.setFeature(NAMESPACE_PREFIXES_FEATURE_ID, namespacePrefixes);
        xmlReader.setFeature(VALIDATION_FEATURE_ID, validation);
        xmlReader.setFeature(SCHEMA_VALIDATION_FEATURE_ID, schemaValidation);
        xmlReader.setFeature(SCHEMA_FULL_CHECKING_FEATURE_ID, schemaFullChecking);
        xmlReader.setFeature(DYNAMIC_VALIDATION_FEATURE_ID, dynamicValidation);
    }

    public static void setDefaultNamespaceSchemaLocation(XMLReader xmlReader, URL urlToSchema) throws SAXException {
        xmlReader.setProperty(NO_NAMESPACE_SCHEMA_LOCATION_ID, urlToSchema.toExternalForm());
    }

    public static void parse(XMLReader xmlReader, URL url) throws IOException, SAXException {
        InputStream inputStream = url.openStream();
        try {
            InputSource inputSource = new InputSource(inputStream);
            xmlReader.parse(inputSource);
        }
        finally {
            inputStream.close();
        }
    }

    private static class ReaderDelegate
    implements XMLReader {
        private final XMLReader m_wrapped;
        private boolean m_entityResolverSet;
        private boolean m_errorHandlerSet;
        private Map<String, Boolean> m_features;
        private Map<String, Object> m_properties;

        public ReaderDelegate(XMLReader wrapped) {
            this.m_wrapped = wrapped;
        }

        void clearAll() throws SAXException {
            this.m_wrapped.setContentHandler(null);
            this.m_wrapped.setDTDHandler(null);
            if (this.m_entityResolverSet) {
                this.m_wrapped.setEntityResolver(null);
                this.m_entityResolverSet = false;
            }
            if (this.m_errorHandlerSet) {
                this.m_wrapped.setErrorHandler(null);
                this.m_errorHandlerSet = false;
            }
            if (this.m_features != null) {
                for (Map.Entry<String, Object> entry : this.m_features.entrySet()) {
                    this.m_wrapped.setFeature(entry.getKey(), (Boolean)entry.getValue());
                }
                this.m_features = null;
            }
            if (this.m_properties != null) {
                for (Map.Entry<String, Object> entry : this.m_properties.entrySet()) {
                    this.m_wrapped.setProperty(entry.getKey(), entry.getValue());
                }
                this.m_properties = null;
            }
        }

        @Override
        public void setFeature(String s, boolean flag) throws SAXNotRecognizedException, SAXNotSupportedException {
            if (this.m_features == null) {
                this.m_features = new HashMap<String, Boolean>();
            }
            if (!this.m_features.containsKey(s)) {
                this.m_features.put(s, this.m_wrapped.getFeature(s));
            }
            this.m_wrapped.setFeature(s, flag);
        }

        @Override
        public void setProperty(String s, Object obj) throws SAXNotRecognizedException, SAXNotSupportedException {
            if (this.m_properties == null) {
                this.m_properties = new HashMap<String, Object>();
            }
            if (!this.m_properties.containsKey(s)) {
                this.m_properties.put(s, this.m_wrapped.getProperty(s));
            }
            this.m_wrapped.setProperty(s, obj);
        }

        @Override
        public ContentHandler getContentHandler() {
            return this.m_wrapped.getContentHandler();
        }

        @Override
        public DTDHandler getDTDHandler() {
            return this.m_wrapped.getDTDHandler();
        }

        @Override
        public EntityResolver getEntityResolver() {
            return this.m_wrapped.getEntityResolver();
        }

        @Override
        public ErrorHandler getErrorHandler() {
            return this.m_wrapped.getErrorHandler();
        }

        @Override
        public boolean getFeature(String s) throws SAXNotRecognizedException, SAXNotSupportedException {
            return this.m_wrapped.getFeature(s);
        }

        @Override
        public Object getProperty(String s) throws SAXNotRecognizedException, SAXNotSupportedException {
            return this.m_wrapped.getProperty(s);
        }

        @Override
        public void parse(InputSource inputsource) throws IOException, SAXException {
            this.m_wrapped.parse(inputsource);
        }

        @Override
        public void parse(String s) throws IOException, SAXException {
            this.m_wrapped.parse(s);
        }

        @Override
        public void setContentHandler(ContentHandler contenthandler) {
            this.m_wrapped.setContentHandler(contenthandler);
        }

        @Override
        public void setDTDHandler(DTDHandler dtdhandler) {
            this.m_wrapped.setDTDHandler(dtdhandler);
        }

        @Override
        public void setEntityResolver(EntityResolver entityresolver) {
            this.m_entityResolverSet = true;
            this.m_wrapped.setEntityResolver(entityresolver);
        }

        @Override
        public void setErrorHandler(ErrorHandler errorhandler) {
            this.m_errorHandlerSet = true;
            this.m_wrapped.setErrorHandler(errorhandler);
        }
    }
}

