/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.af.common.types;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import org.eclipse.vjet.dsf.logger.LogLevel;
import org.eclipse.vjet.dsf.logger.Logger;

public class RawString
implements Serializable,
Cloneable {
    private static final String DEFAULT_ENCODING = "ISO8859_1";
    private byte UNKNOWN_ASCII_COMPLIANCE = 0;
    private byte ASCII_COMPLIANT = 1;
    private byte ASCII_NOT_COMPLIANT = (byte)2;
    private byte[] m_rawData = null;
    private byte m_ascii = this.UNKNOWN_ASCII_COMPLIANCE;
    private String m_encoding = null;
    private String m_str = null;
    private static Logger s_logger = null;
    private static final long serialVersionUID = -1672725935888381611L;

    public RawString() {
        this(new byte[0], DEFAULT_ENCODING);
    }

    public RawString(String str) {
        this(str, DEFAULT_ENCODING);
    }

    public RawString(String str, String encoding) {
        this.m_str = str;
        this.m_encoding = encoding != null ? encoding : DEFAULT_ENCODING;
    }

    public RawString(byte[] rawData, String encoding) {
        this.m_rawData = rawData;
        this.m_encoding = encoding != null ? encoding : DEFAULT_ENCODING;
    }

    public Object clone() {
        RawString to = null;
        try {
            to = (RawString)super.clone();
            if (this.m_rawData != null) {
                to.m_rawData = new byte[this.m_rawData.length];
                System.arraycopy(this.m_rawData, 0, to.m_rawData, 0, this.m_rawData.length);
            } else {
                to.m_rawData = null;
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return to;
    }

    public byte[] getBytes() {
        if (this.m_rawData == null) {
            try {
                return this.m_str.getBytes(this.m_encoding);
            }
            catch (UnsupportedEncodingException e) {
                RawString.getLogger().log(LogLevel.ERROR, String.valueOf(this.m_encoding) + " is not supported:" + e.getMessage());
            }
        }
        return this.m_rawData;
    }

    public byte[] getBytes(String encoding) {
        if (this.m_encoding.equals(encoding)) {
            return this.getBytes();
        }
        if (this.isRawDataAsciiCompliantFor(encoding)) {
            return this.getBytes();
        }
        byte[] data = null;
        try {
            data = this.getString().getBytes(encoding);
        }
        catch (UnsupportedEncodingException e) {
            RawString.getLogger().log(LogLevel.ERROR, String.valueOf(this.m_encoding) + " is not supported:" + e.getMessage());
        }
        return data;
    }

    public boolean isRawDataAsciiCompliantFor(String encoding) {
        if (this.m_rawData == null) {
            return false;
        }
        if (this.m_ascii == this.ASCII_COMPLIANT) {
            return true;
        }
        if (this.m_ascii == this.ASCII_NOT_COMPLIANT) {
            return false;
        }
        boolean hasSignBit = false;
        int i = 0;
        while (i < this.m_rawData.length) {
            if (this.m_rawData[i] < 0) {
                hasSignBit = true;
                break;
            }
            ++i;
        }
        if (hasSignBit) {
            this.m_ascii = this.ASCII_NOT_COMPLIANT;
            return false;
        }
        this.m_ascii = this.ASCII_COMPLIANT;
        return true;
    }

    public String getString() {
        if (this.m_str == null) {
            try {
                this.m_str = new String(this.m_rawData, this.m_encoding);
            }
            catch (UnsupportedEncodingException e) {
                RawString.getLogger().log(LogLevel.ERROR, String.valueOf(this.m_encoding) + " is not supported:" + e.getMessage());
            }
        }
        return this.m_str;
    }

    public int getStrSize() {
        if (this.m_str != null) {
            return this.m_str.length();
        }
        if (this.m_rawData == null) {
            return 0;
        }
        return 2 * this.m_rawData.length;
    }

    public String toString() {
        return this.getString();
    }

    public int indexOf(String s) {
        if (this.m_str != null) {
            return this.m_str.indexOf(s);
        }
        if (this.m_rawData == null || this.m_rawData.length == 0 || s == null || s.length() == 0) {
            return -1;
        }
        byte[] token = null;
        try {
            token = s.getBytes(this.m_encoding);
        }
        catch (UnsupportedEncodingException e) {
            RawString.getLogger().log(LogLevel.ERROR, String.valueOf(this.m_encoding) + " is not supported:" + e.getMessage());
            return -1;
        }
        return this.indexOf(token);
    }

    public RawString getRawStringAfter(String s) {
        if (this.m_str != null) {
            int index = this.m_str.indexOf(s);
            if (index != -1) {
                return new RawString(this.m_str.substring(index), this.m_encoding);
            }
            return this;
        }
        if (this.m_rawData == null || this.m_rawData.length == 0 || s == null || s.length() == 0) {
            return this;
        }
        byte[] token = null;
        try {
            token = s.getBytes(this.m_encoding);
        }
        catch (UnsupportedEncodingException e) {
            RawString.getLogger().log(LogLevel.ERROR, String.valueOf(this.m_encoding) + " is not supported:" + e.getMessage());
            return this;
        }
        if (token.length == 0) {
            return this;
        }
        int index = this.indexOf(token);
        if (index == -1) {
            return this;
        }
        byte[] subBytes = new byte[this.m_rawData.length - (index + s.length())];
        System.arraycopy(this.m_rawData, index + s.length(), subBytes, 0, subBytes.length);
        return new RawString(subBytes, this.m_encoding);
    }

    public String getEncoding() {
        return this.m_encoding;
    }

    public boolean hasRawData() {
        return this.m_rawData != null;
    }

    private int indexOf(byte[] token) {
        int ending = this.m_rawData.length - token.length;
        if (ending <= 0) {
            return -1;
        }
        int index = 0;
        block0: while (true) {
            if (index <= ending && this.m_rawData[index] != token[0]) {
                ++index;
                continue;
            }
            if (index > ending) {
                return -1;
            }
            int i = index + 1;
            int j = i + token.length - 1;
            int k = 1;
            while (i < j) {
                if (this.m_rawData[i++] == token[k++]) continue;
                ++index;
                continue block0;
            }
            break;
        }
        return index;
    }

    private static Logger getLogger() {
        if (s_logger == null) {
            s_logger = Logger.getInstance(RawString.class);
        }
        return s_logger;
    }
}

