/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.javatojs.control;

import java.net.URL;
import org.eclipse.vjet.dsf.javatojs.control.IBuildResourceFilter;
import org.eclipse.vjet.dsf.javatojs.translate.policy.ITranslationPolicy;
import org.eclipse.vjet.dsf.javatojs.translate.policy.WildcardList;
import org.eclipse.vjet.dsf.jsgen.shared.util.CodeGenCleaner;

public class BuildFileFilter
implements IBuildResourceFilter {
    private static WildcardList s_excludeList = new WildcardList();
    private static WildcardList s_includeList = new WildcardList();

    static {
        s_excludeList.addWildcard("*Jsr.java");
        s_includeList.addWildcard("*.java");
    }

    public BuildFileFilter(ITranslationPolicy policy) {
    }

    @Override
    public boolean accept(URL file) {
        if (CodeGenCleaner.isCodeGened((URL)file, (boolean)false)) {
            return false;
        }
        String fileName = this.getFileName(file);
        return !this.isFileExcluded(fileName);
    }

    private String getFileName(URL file) {
        String fileName = null;
        try {
            fileName = file.getPath().substring(file.getPath().lastIndexOf(47) + 1);
        }
        catch (Exception e) {
            System.err.println(e.toString());
        }
        return fileName;
    }

    private boolean isFileExcluded(String fileName) {
        if (!s_includeList.contains(fileName)) {
            return true;
        }
        return s_excludeList.contains(fileName);
    }
}

