/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.javatojs.control.translate;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.vjet.dsf.common.trace.TraceAttr;
import org.eclipse.vjet.dsf.common.trace.event.TraceId;
import org.eclipse.vjet.dsf.javatojs.control.translate.BasePhase;
import org.eclipse.vjet.dsf.javatojs.control.translate.TranslationParallelRunner;
import org.eclipse.vjet.dsf.javatojs.control.translate.TypeTranslateTask;
import org.eclipse.vjet.dsf.javatojs.trace.ITranslateTracer;
import org.eclipse.vjet.dsf.javatojs.trace.TranslateError;
import org.eclipse.vjet.dsf.javatojs.trace.TranslationTraceId;
import org.eclipse.vjet.dsf.javatojs.translate.TranslateCtx;
import org.eclipse.vjet.dsf.javatojs.translate.TranslationMode;
import org.eclipse.vjet.dsf.javatojs.util.AstBindingHelper;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstType;

public class ImplementationPhase
extends BasePhase {
    private static final TraceId IMPLEMENTATION_PHASE = TranslationTraceId.IMPLEMENTATION_PHASE;

    public ImplementationPhase(JstType type) {
        super(new TranslationMode().addImplementation());
        this.addStartingType(type);
    }

    public ImplementationPhase(List<JstType> types) {
        super(new TranslationMode().addImplementation());
        this.setStartingTypes(types);
    }

    public List<JstType> translate() {
        ITranslateTracer tracer = this.getTracer();
        tracer.startGroup(IMPLEMENTATION_PHASE, new TraceAttr[0]);
        try {
            TranslateCtx ctx = this.getCtx();
            TranslationMode mode = this.getMode();
            ArrayList<TypeTranslateTask> tasks = new ArrayList<TypeTranslateTask>();
            for (JstType jstType : this.getStartingTypes()) {
                if (jstType == null) {
                    this.addError(new TranslateError("NullInput", "jstType is null"));
                    continue;
                }
                if (ctx.isJavaOnly((IJstType)jstType) || ctx.isJSProxy((IJstType)jstType) || ctx.isExcluded((IJstType)jstType)) continue;
                CompilationUnit cu = AstBindingHelper.getCompilationUnit(jstType);
                String srcName = AstBindingHelper.getSourceName((IJstNode)jstType);
                ctx.getTranslateInfo(jstType).addMode(mode);
                this.setModeForInnerTypes(jstType, mode, ctx);
                tasks.add(new TypeTranslateTask(srcName, cu, jstType, ctx, this.getTracer(jstType), ctx));
            }
            if (tasks.size() == 1 || !ctx.isParallelEnabled()) {
                for (TypeTranslateTask task : tasks) {
                    task.execute();
                    this.setExceptions(task.getType(), task.getExceptions());
                }
            } else if (tasks.size() > 0) {
                TranslationParallelRunner.getInstance().execute(tasks);
                for (TypeTranslateTask task : tasks) {
                    this.setExceptions(task.getType(), task.getExceptions());
                }
            }
            this.mergeTraces();
            List<JstType> list = this.getStartingTypes();
            return list;
        }
        finally {
            tracer.endGroup(IMPLEMENTATION_PHASE);
        }
    }

    private void setModeForInnerTypes(JstType jstType, TranslationMode mode, TranslateCtx ctx) {
        List inners = jstType.getEmbededTypes();
        for (JstType t : inners) {
            ctx.getTranslateInfo(t).addMode(mode);
            this.setModeForInnerTypes(t, mode, ctx);
        }
    }
}

