/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.javatojs.trace;

import org.eclipse.vjet.dsf.logger.LogLevel;

public class TranslateError {
    private String m_msgId;
    private String m_srcName;
    private long m_srcLineNo;
    private String m_msg;
    private LogLevel m_level = LogLevel.ERROR;

    public TranslateError(String msgId, String msg) {
        this(LogLevel.ERROR, msgId, msg);
    }

    public TranslateError(LogLevel level, String msgId, String msg) {
        this.m_msgId = msgId;
        this.m_msg = msg;
        this.m_level = level;
    }

    public TranslateError(String msgId, String srcName, long srcLineNo, String msg) {
        this(LogLevel.ERROR, msgId, srcName, srcLineNo, msg);
    }

    public TranslateError(LogLevel level, String msgId, String srcName, long srcLineNo, String msg) {
        this.m_msgId = msgId;
        this.m_srcName = srcName;
        this.m_srcLineNo = srcLineNo;
        this.m_msg = msg;
        this.m_level = level;
    }

    public String getMsgId() {
        return this.m_msgId;
    }

    public String getSrcName() {
        return this.m_srcName;
    }

    public void setSrcLineNo(long srcLineNo) {
        this.m_srcLineNo = srcLineNo;
    }

    public long getSrcLineNo() {
        return this.m_srcLineNo;
    }

    public String getMsg() {
        return this.m_msg;
    }

    public void setLevel(LogLevel level) {
        this.m_level = level;
    }

    public LogLevel getLevel() {
        return this.m_level;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.getLevel() != null) {
            sb.append(this.getLevel().name()).append(": ");
        }
        if (this.getMsgId() != null) {
            sb.append(this.getMsgId()).append(", ");
        }
        if (this.getMsg() != null) {
            sb.append(this.getMsg()).append(", ");
        }
        if (this.getSrcName() != null) {
            sb.append(this.getSrcName()).append(", ");
        }
        if (this.getSrcLineNo() > 0L) {
            sb.append("line ").append(String.valueOf(this.getSrcLineNo()));
        }
        return sb.toString();
    }
}

