/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.javatojs.trace;

import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.eclipse.vjet.dsf.common.trace.ITraceData;
import org.eclipse.vjet.dsf.common.trace.TraceAttr;
import org.eclipse.vjet.dsf.common.trace.event.TraceEvent;
import org.eclipse.vjet.dsf.common.trace.event.TraceType;
import org.eclipse.vjet.dsf.common.trace.listener.ITraceEventListener;
import org.eclipse.vjet.dsf.common.trace.listener.ListenerId;
import org.eclipse.vjet.dsf.common.xml.IIndenter;
import org.eclipse.vjet.dsf.common.xml.XmlStreamWriter;
import org.eclipse.vjet.dsf.javatojs.trace.TraceErrors;
import org.eclipse.vjet.dsf.javatojs.trace.TraceTime;
import org.eclipse.vjet.dsf.javatojs.trace.TranslateError;
import org.eclipse.vjet.dsf.javatojs.trace.TranslateTraceType;

public class TranslateTraceListener
implements ITraceEventListener {
    private static final ListenerId ID = new ListenerId(TranslateTraceListener.class.getSimpleName());
    private XmlStreamWriter m_xmlWriter;
    private static final String START = "start";
    private static final String END = "end";
    private static final String DURATION = "duration";
    private static final String ERR_SEVERITY = "severity";
    private static final String ERR_TYPE = "type";
    private static final String SRC_NAME = "srcName";
    private static final String SRC_LINE_NO = "srcLineNo";
    private static final String MSG = "msg";

    public TranslateTraceListener(StringWriter writer) {
        this.m_xmlWriter = new XmlStreamWriter((Writer)writer, IIndenter.COMPACT);
    }

    public TranslateTraceListener(XmlStreamWriter writer) {
        this.m_xmlWriter = writer;
    }

    public ListenerId getId() {
        return ID;
    }

    public boolean isApplicable(TraceEvent event) {
        return true;
    }

    public void beforeTrace(TraceEvent event) {
    }

    public void trace(TraceEvent event) {
        if (event == null) {
            return;
        }
        TraceType type = event.getType();
        if (type == TranslateTraceType.START_GROUP) {
            this.startGroup(event);
        } else if (type == TranslateTraceType.END_GROUP) {
            this.endGroup(event);
        } else if (type == TranslateTraceType.ERRORS) {
            this.traceError(event);
        } else if (type == TranslateTraceType.TIME) {
            this.traceTime(event);
        }
    }

    public void afterTrace(TraceEvent event) {
    }

    public void close() {
        this.m_xmlWriter.flush();
    }

    private void startGroup(TraceEvent event) {
        this.m_xmlWriter.writeStartElement(event.getId().getName());
        this.writeData(event.getData());
    }

    private void endGroup(TraceEvent event) {
        this.m_xmlWriter.writeEndElement();
    }

    private void traceError(TraceEvent event) {
        this.m_xmlWriter.writeStartElement(event.getType().name());
        this.writeData(event.getData());
        this.m_xmlWriter.writeEndElement();
    }

    private void traceTime(TraceEvent event) {
        this.m_xmlWriter.writeStartElement(event.getType().name());
        this.writeData(event.getData());
        this.m_xmlWriter.writeEndElement();
    }

    private void writeData(ITraceData[] data) {
        if (data == null || data.length == 0) {
            return;
        }
        ITraceData[] iTraceDataArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            Object t;
            ITraceData d = iTraceDataArray[n2];
            if (d instanceof TraceAttr) {
                TraceAttr attr = (TraceAttr)d;
                this.m_xmlWriter.writeAttribute(attr.getName(), attr.getValue());
            } else if (d instanceof TraceErrors) {
                t = (TraceErrors)d;
                List<TranslateError> errors = ((TraceErrors)t).getErrors();
                if (errors != null && !errors.isEmpty()) {
                    for (TranslateError e : errors) {
                        this.m_xmlWriter.writeStartElement(e.getLevel().name());
                        if (e.getMsgId() != null) {
                            this.m_xmlWriter.writeAttribute(ERR_TYPE, e.getMsgId());
                        }
                        if (e.getMsg() != null) {
                            this.m_xmlWriter.writeAttribute(MSG, e.getMsg());
                        }
                        if (e.getSrcName() != null) {
                            this.m_xmlWriter.writeAttribute(SRC_NAME, e.getSrcName());
                        }
                        if (e.getSrcLineNo() > 0L) {
                            this.m_xmlWriter.writeAttribute(SRC_LINE_NO, String.valueOf(e.getSrcLineNo()));
                        }
                        this.m_xmlWriter.writeEndElement();
                    }
                }
            } else if (d instanceof TraceTime) {
                t = (TraceTime)d;
                this.m_xmlWriter.writeAttribute(START, ((TraceTime)t).getStartTime());
                this.m_xmlWriter.writeAttribute(END, ((TraceTime)t).getEndTime());
                this.m_xmlWriter.writeAttribute(DURATION, ((TraceTime)t).getDuration());
            }
            ++n2;
        }
    }
}

