/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.javatojs.translate;

import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.WildcardType;
import org.eclipse.vjet.dsf.javatojs.translate.BaseTranslator;
import org.eclipse.vjet.dsf.javatojs.translate.TranslateCtx;
import org.eclipse.vjet.dsf.javatojs.translate.TranslateHelper;
import org.eclipse.vjet.dsf.javatojs.translate.TranslateInfo;
import org.eclipse.vjet.dsf.javatojs.translate.VjoTranslateHelper;
import org.eclipse.vjet.dsf.jsnative.global.Object;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstCache;
import org.eclipse.vjet.dsf.jst.declaration.JstFactory;
import org.eclipse.vjet.dsf.jst.declaration.JstMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstParamType;
import org.eclipse.vjet.dsf.jst.declaration.JstRefType;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.declaration.JstTypeWithArgs;
import org.eclipse.vjet.dsf.jst.declaration.JstWildcardType;
import org.eclipse.vjet.dsf.jst.term.JstIdentifier;
import org.eclipse.vjet.dsf.jst.util.DataTypeHelper;

public class DataTypeTranslator
extends BaseTranslator {
    public JstType processImport(ImportDeclaration importDec, JstType ownerType) {
        TranslateInfo tInfo = this.getCtx().getTranslateInfo(ownerType.getRootType());
        String typeName = null;
        String refName = null;
        if (importDec.isStatic()) {
            QualifiedName qName = (QualifiedName)importDec.getName();
            if (importDec.isOnDemand()) {
                refName = "*";
                typeName = qName.getFullyQualifiedName();
                tInfo.addImportedStaticRef(refName, typeName);
                typeName = this.getCtx().getConfig().getPackageMapping().mapTo(typeName);
                JstType jstType = JstFactory.getInstance().createJstType(typeName, false);
                tInfo.setType(jstType.getSimpleName(), (IJstType)jstType);
                return jstType;
            }
            refName = qName.getName().toString();
            typeName = qName.getQualifier().getFullyQualifiedName();
            tInfo.addImportedStaticRef(refName, typeName);
        } else if (importDec.isOnDemand()) {
            tInfo.addImportedPkg(importDec.getName().getFullyQualifiedName());
        } else {
            typeName = importDec.getName().getFullyQualifiedName();
            tInfo.addImport(TranslateHelper.getShortName(typeName), typeName);
        }
        return null;
    }

    public IJstType processType(Type astType, BaseJstNode jstNode) {
        boolean processed = false;
        if (astType == null) {
            return null;
        }
        IJstType processType = null;
        if (astType.isArrayType()) {
            return this.processArrayType((ArrayType)astType, jstNode);
        }
        if (astType.isParameterizedType()) {
            return this.processTypeWithArgs((ParameterizedType)astType, jstNode);
        }
        if (astType.isQualifiedType()) {
            return this.processQualifiedType((QualifiedType)astType, jstNode);
        }
        if (astType.isWildcardType()) {
            return this.processWildcardType((WildcardType)astType, jstNode);
        }
        if (astType.isSimpleType()) {
            return this.processName(((SimpleType)astType).getName(), jstNode);
        }
        JstType ownerType = jstNode.getOwnerType();
        String typeName = astType.toString();
        IJstType jstType = this.findJstType(typeName, jstNode);
        if (jstType == null) {
            jstType = this.getJstType((ASTNode)astType, typeName, ownerType, true);
        }
        if (processed) {
            return processType;
        }
        this.getCtx().getTranslateInfo(ownerType).setType(typeName, jstType);
        return jstType;
    }

    public IJstType processName(Name name, BaseJstNode jstNode) {
        JstIdentifier identifier;
        IJstType jstType;
        TranslateInfo tInfo = this.getCtx().getTranslateInfo(jstNode.getRootType());
        if (name instanceof QualifiedName && (jstType = TranslateHelper.Type.getType(identifier = this.getNameTranslator().processName(name, false, jstNode))) != null) {
            tInfo.setType(name.toString(), jstType);
            return jstType;
        }
        String typeName = name.getFullyQualifiedName();
        jstType = this.findJstType(typeName, jstNode);
        if (jstType == null) {
            jstType = this.getJstType((ASTNode)name, typeName, jstNode.getOwnerType(), true);
        }
        TranslateHelper.Type.validateTypeReference(jstType, (ASTNode)name, jstNode, this);
        tInfo.setType(typeName, jstType);
        return jstType;
    }

    public IJstType toJstType(String typeName, JstType ownerType) {
        IJstType jstType = this.findJstType(typeName, (BaseJstNode)ownerType);
        if (jstType != null) {
            return jstType;
        }
        return this.createJstType(typeName, ownerType);
    }

    public IJstType findJstType(String name, BaseJstNode jstNode) {
        TranslateCtx ctx;
        TranslateInfo info;
        if (name == null || jstNode == null) {
            return null;
        }
        JstRefType jstType = JstCache.getInstance().getRefType(name);
        if (jstType != null) {
            return jstType;
        }
        jstType = this.getCtx().getJsType(name);
        if (jstType != null) {
            return jstType;
        }
        if (name.equals("Object") || name.equals("java.lang.Object")) {
            jstType = DataTypeTranslator.getNativeJsObject();
        }
        if (jstType != null) {
            return jstType;
        }
        if (name.equals("vjo.Object")) {
            return JstCache.getInstance().getType("vjo.Object");
        }
        if (jstNode instanceof JstMethod && (jstType = ((JstMethod)jstNode).getParamType(name)) != null) {
            return jstType;
        }
        JstType ownerType = jstNode.getOwnerType();
        jstType = this.getParamType(name, jstNode);
        if (jstType != null) {
            return jstType;
        }
        String typeName = name;
        if (typeName.startsWith("java.lang.") && typeName.lastIndexOf(".") == 9) {
            typeName = name.substring(10);
        }
        if ((jstType = (info = (ctx = this.getCtx()).getTranslateInfo(ownerType)).getType(typeName, true)) != null) {
            if (!typeName.equals(jstType.getSimpleName()) && !typeName.equals(jstType.getName())) {
                this.addImport((IJstType)jstType, ownerType, jstType.getName());
            }
            return jstType;
        }
        if (typeName.equals(ownerType.getSimpleName())) {
            return ownerType;
        }
        JstType jstLocalType = info.getLocalType(typeName);
        if (jstLocalType != null) {
            return jstLocalType;
        }
        String jstTypeName = DataTypeHelper.getNativeType((String)typeName) == null ? ctx.getConfig().getPackageMapping().mapTo(typeName) : typeName;
        jstType = JstCache.getInstance().getType(jstTypeName);
        if (jstType != null) {
            return jstType;
        }
        jstType = info.getUnknownType(typeName);
        if (jstType != null) {
            return jstType;
        }
        jstType = TranslateHelper.Type.getEmbededType(ownerType.getRootType(), typeName);
        if (jstType != null) {
            return jstType;
        }
        jstType = TranslateHelper.Type.getDependedType(ownerType, typeName);
        if (jstType != null) {
            return jstType;
        }
        jstType = this.getFromImport(typeName, jstNode.getOwnerType());
        if (jstType != null) {
            return jstType;
        }
        jstType = this.getFromSamePackage(typeName, (IJstNode)jstNode);
        if (jstType != null) {
            return jstType;
        }
        return null;
    }

    public static JstType getNativeJsObject() {
        return JstCache.getInstance().getType(Object.class.getName());
    }

    public void addImport(IJstType jstType, JstType ownerType, String key) {
        TranslateCtx ctx;
        if (key == null) {
            return;
        }
        if (jstType == null || jstType == ownerType) {
            return;
        }
        if (!(jstType instanceof JstType)) {
            return;
        }
        if (jstType.getRootType() == ownerType) {
            return;
        }
        if (DataTypeHelper.isPrimitiveType((String)jstType.getName())) {
            return;
        }
        if (VjoTranslateHelper.isVjoNativeType(jstType.getName())) {
            return;
        }
        if (this.getCtx().isJsType(jstType)) {
            return;
        }
        JstType outerType = ownerType;
        BaseJstNode parentNode = outerType.getParentNode();
        while (parentNode != null) {
            parentNode = outerType.getParentNode();
            if (parentNode == null || parentNode.getOwnerType() == null || !(parentNode.getOwnerType() instanceof JstType)) break;
            outerType = (JstType)parentNode.getOwnerType();
            parentNode = outerType.getParentNode();
        }
        if ((ctx = this.getCtx()).isExcluded(jstType)) {
            return;
        }
        if (ctx.isMappedToJS(jstType) || ctx.isJavaOnly(jstType)) {
            return;
        }
        if (jstType.isEmbededType() && jstType.getOuterType() == ownerType || jstType.isSiblingType() && jstType.getOuterType() == ownerType) {
            return;
        }
        String importKey = key;
        IJstType importType = jstType.getRootType();
        if (importType != jstType) {
            importKey = key != null && key.equals(jstType.getSimpleName()) ? importType.getSimpleName() : importType.getName();
        } else if (importKey == null) {
            importKey = importType.getName();
        }
        if (!(importType instanceof JstType)) {
            return;
        }
        if (this.getCtx().isJavaOnly(importType)) {
            return;
        }
        outerType.addImport(importKey, (IJstType)((JstType)importType));
    }

    private IJstType getFromImport(String name, JstType ownerType) {
        JstType rootType = ownerType.getRootType();
        TranslateInfo tInfo = this.getCtx().getTranslateInfo(rootType);
        String fullName = tInfo.getImported(name);
        if (fullName == null) {
            return null;
        }
        fullName = this.getCtx().getConfig().getPackageMapping().mapTo(fullName);
        JstType jstType = JstCache.getInstance().getType(fullName);
        if (jstType == null || this.getCtx().isMappedToJS((IJstType)jstType) || this.getCtx().isMappedToVJO((IJstType)jstType)) {
            return null;
        }
        this.addImport((IJstType)jstType, ownerType, name);
        tInfo.setType(name, (IJstType)jstType);
        return jstType;
    }

    private IJstType getFromSamePackage(String name, IJstNode jstNode) {
        IJstType rootType = jstNode.getRootType();
        if (rootType == null) {
            return rootType;
        }
        StringBuffer sb = new StringBuffer();
        if (rootType.getPackage() != null) {
            sb.append(rootType.getPackage().getName()).append(".");
        }
        sb.append(name);
        String fullName = sb.toString();
        fullName = this.getCtx().getConfig().getPackageMapping().mapTo(fullName);
        return JstCache.getInstance().getType(fullName);
    }

    private IJstType getJstType(ASTNode node, String typeName, JstType ownerType, boolean tryCustomTranslation) {
        if (tryCustomTranslation) {
            IJstType jstType;
            TranslateInfo tInfo = this.getCtx().getTranslateInfo(ownerType.getRootType());
            boolean enableShortName = true;
            String fullName = tInfo.getImported(typeName);
            if (fullName == null) {
                enableShortName = DataTypeHelper.isInJavaLang((String)typeName);
                fullName = TranslateHelper.Type.resolveImplicitImport(typeName, ownerType.getRootType());
                if (fullName != null) {
                    tInfo.addImport(typeName, fullName);
                }
            }
            if (fullName == null) {
                fullName = typeName;
            }
            if ((jstType = this.getCustomTranslator().processType(fullName, node, (BaseJstNode)ownerType)) != null) {
                if (enableShortName) {
                    this.addImport(jstType, ownerType, jstType.getSimpleName());
                } else {
                    this.addImport(jstType, ownerType, jstType.getName());
                }
                return jstType;
            }
        }
        JstType type = this.createJstType(typeName, ownerType);
        return type;
    }

    private JstType createJstType(String typeName, JstType ownerType) {
        if (typeName == null) {
            return null;
        }
        JstType type = null;
        TranslateInfo tInfo = this.getCtx().getTranslateInfo(ownerType.getRootType());
        if (typeName.indexOf(".") > 0) {
            String fullName = this.getCtx().getConfig().getPackageMapping().mapTo(typeName);
            type = JstCache.getInstance().getType(fullName, true);
        } else {
            String fullName = tInfo.getImported(typeName);
            if (fullName == null && (fullName = TranslateHelper.Type.resolveImplicitImport(typeName, ownerType.getRootType())) != null) {
                tInfo.addImport(typeName, fullName);
            }
            if (fullName == null) {
                type = JstFactory.getInstance().createJstType(typeName, false);
                tInfo.addUnknownType(typeName, type);
            } else {
                String translatedFullName = this.getCtx().getConfig().mapToNative(fullName);
                if (translatedFullName == null) {
                    translatedFullName = this.getCtx().getConfig().getPackageMapping().mapTo(fullName);
                }
                type = JstCache.getInstance().getType(translatedFullName, true);
            }
        }
        return type;
    }

    private JstParamType getParamType(String name, BaseJstNode jstNode) {
        JstType ownerType = jstNode.getOwnerType();
        JstParamType jstType = ownerType.getParamType(name);
        if (jstType != null) {
            return jstType;
        }
        JstType outerType = ownerType.getOuterType();
        while (outerType != null) {
            jstType = outerType.getParamType(name);
            if (jstType != null) {
                return jstType;
            }
            outerType = outerType.getOuterType();
        }
        return null;
    }

    private JstType processArrayType(ArrayType type, BaseJstNode jstNode) {
        IJstType eleType = this.processType(type.getComponentType(), jstNode);
        if (eleType == null) {
            this.getLogger().logError("NullResult", "Fail to translate element type", this, (ASTNode)type, (BaseJstNode)jstNode.getOwnerType());
            return null;
        }
        return JstFactory.getInstance().createJstArrayType(eleType, true);
    }

    private IJstType processTypeWithArgs(ParameterizedType astType, BaseJstNode jstNode) {
        Type type = astType.getType();
        IJstType jstType = this.processType(type, jstNode);
        if (jstType == null) {
            this.getLogger().logError("NullResult", "Fail to translate parameterized type", this, (ASTNode)type, (BaseJstNode)jstNode.getOwnerType());
            return null;
        }
        if (!(jstType instanceof JstType)) {
            this.getLogger().logError("InvalidType", "jstType not a JstType", this, (ASTNode)type, (BaseJstNode)jstNode.getOwnerType());
            return null;
        }
        List args = astType.typeArguments();
        JstTypeWithArgs jpType = new JstTypeWithArgs((IJstType)((JstType)jstType));
        for (Type arg : args) {
            jpType.addArgType(this.processType(arg, jstNode));
        }
        return jpType;
    }

    private IJstType processQualifiedType(QualifiedType type, BaseJstNode jstNode) {
        TranslateInfo tInfo = this.getCtx().getTranslateInfo(jstNode.getOwnerType());
        if (tInfo.getMode().hasImplementation()) {
            return this.processName((Name)type.getName(), jstNode);
        }
        return this.processType(type.getQualifier(), jstNode);
    }

    private IJstType processWildcardType(WildcardType astType, BaseJstNode jstNode) {
        Type type = astType.getBound();
        IJstType jstType = this.processType(type, jstNode);
        return new JstWildcardType(jstType, astType.isUpperBound());
    }
}

