/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.javatojs.translate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.vjet.dsf.javatojs.control.ExpressionTypeVisitor;
import org.eclipse.vjet.dsf.javatojs.translate.BaseTranslator;
import org.eclipse.vjet.dsf.javatojs.translate.TranslateCtx;
import org.eclipse.vjet.dsf.javatojs.translate.TranslateHelper;
import org.eclipse.vjet.dsf.javatojs.translate.TranslateInfo;
import org.eclipse.vjet.dsf.javatojs.translate.VjoTranslateHelper;
import org.eclipse.vjet.dsf.javatojs.translate.custom.CustomAttr;
import org.eclipse.vjet.dsf.javatojs.translate.custom.CustomInfo;
import org.eclipse.vjet.dsf.javatojs.translate.custom.anno.IAnnoProcessor;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstDoc;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstDoc;
import org.eclipse.vjet.dsf.jst.declaration.JstFactory;
import org.eclipse.vjet.dsf.jst.declaration.JstMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstModifiers;
import org.eclipse.vjet.dsf.jst.declaration.JstProperty;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.declaration.JstVar;
import org.eclipse.vjet.dsf.jst.expr.AssignExpr;
import org.eclipse.vjet.dsf.jst.expr.FuncExpr;
import org.eclipse.vjet.dsf.jst.expr.ObjCreationExpr;
import org.eclipse.vjet.dsf.jst.term.JstIdentifier;
import org.eclipse.vjet.dsf.jst.term.SimpleLiteral;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.dsf.jst.token.ILHS;
import org.eclipse.vjet.dsf.jst.token.ISimpleTerm;
import org.eclipse.vjet.dsf.jst.token.IStmt;
import org.eclipse.vjet.vjo.meta.VjoConvention;

public class FieldTranslator
extends BaseTranslator {
    private ExpressionTypeVisitor m_autoBoxer = new ExpressionTypeVisitor();

    /*
     * Unable to fully structure code
     */
    public IJstType processField(FieldDeclaration astField, JstType jstType) {
        block11: {
            ctx = this.getCtx();
            tInfo = this.getCtx().getTranslateInfo(jstType);
            ite = astField.fragments().iterator();
            include = false;
            if (tInfo.getMode().hasImplementation()) ** GOTO lbl27
            for (IAnnoProcessor ap : ctx.getConfig().getAnnoProcessors()) {
                cInfo = ap.process((ASTNode)astField, jstType);
                while (ite.hasNext()) {
                    fName = ((VariableDeclarationFragment)ite.next()).getName().getIdentifier();
                    fInfo = tInfo.getFieldCustomInfo(fName);
                    if (cInfo != null && cInfo != CustomInfo.NONE) {
                        if (fInfo == null || fInfo == CustomInfo.NONE) {
                            fInfo = new CustomInfo(cInfo);
                            tInfo.addFieldCustomInfo(fName, fInfo);
                        } else {
                            fInfo = CustomInfo.update(fInfo, cInfo);
                        }
                    }
                    if (include || !TranslateHelper.Property.includeFieldForDecl(astField, fInfo, jstType)) continue;
                    include = true;
                }
                if (include) continue;
                return null;
            }
            break block11;
lbl-1000:
            // 1 sources

            {
                fName = ((VariableDeclarationFragment)ite.next()).getName().getIdentifier();
                fInfo = tInfo.getFieldCustomInfo(fName);
                if (include || !TranslateHelper.Property.includeFieldForImpl(astField, fInfo, jstType)) continue;
                include = true;
lbl27:
                // 3 sources

                ** while (ite.hasNext())
            }
        }
        if (!include) {
            return null;
        }
        fldType = this.getDataTypeTranslator().processType(astField.getType(), (BaseJstNode)jstType);
        if (fldType == null) {
            this.getLogger().logInfo("NullResult", "failed translation", this, (ASTNode)astField, (BaseJstNode)jstType);
            return null;
        }
        if (!tInfo.getStatus().isDeclTranlationDone()) {
            this.processFieldDecl(astField, fldType, jstType);
        }
        if (tInfo.getMode().hasImplementation()) {
            if (tInfo.clearTypeRefs()) {
                this.processFieldDecl(astField, fldType, jstType);
            }
            this.processFieldImpl(astField, fldType, jstType);
        }
        return fldType;
    }

    public void processEnumConstsDecl(EnumConstantDeclaration astEnum, JstType jstType) {
        String name = astEnum.getName().toString();
        TranslateCtx ctx = this.getCtx();
        TranslateInfo tInfo = this.getCtx().getTranslateInfo(jstType);
        if (!tInfo.getMode().hasImplementation()) {
            for (IAnnoProcessor ap : ctx.getConfig().getAnnoProcessors()) {
                CustomInfo cInfo = ap.process((ASTNode)astEnum, jstType);
                String fName = astEnum.getName().toString();
                CustomInfo fInfo = tInfo.getFieldCustomInfo(fName);
                if (cInfo == null) continue;
                if (fInfo == null || fInfo == CustomInfo.NONE) {
                    fInfo = new CustomInfo(cInfo);
                    tInfo.addFieldCustomInfo(fName, fInfo);
                    continue;
                }
                fInfo = CustomInfo.update(fInfo, cInfo);
            }
        }
        if (tInfo.getFieldCustomInfo(name).isExcluded()) {
            return;
        }
        IJstProperty pty = null;
        pty = jstType.getEnumValue(name);
        if (pty == null) {
            pty = this.createProperty((IJstType)jstType, name, true, (BaseJstNode)jstType);
            pty.getModifiers().setPublic();
            pty.getModifiers().setFinal();
            jstType.addEnumValue(pty);
        }
    }

    public void processEnumConstsImpl(EnumConstantDeclaration astEnum, JstType jstType) {
        IJstType anonymousType;
        ObjCreationExpr objCreation;
        String name = astEnum.getName().toString();
        if (this.getCtx().getTranslateInfo(jstType).getFieldCustomInfo(name).isExcluded()) {
            return;
        }
        List args = astEnum.arguments();
        IJstProperty pty = null;
        if (pty == null) {
            pty = jstType.getEnumValue(name);
        }
        IExpr[] valArg = new IExpr[args.size()];
        int counter = 0;
        for (Object itm : args) {
            Object constValLit = null;
            constValLit = itm instanceof ExpressionStatement ? SimpleLiteral.getStringLiteral((String)itm.toString()) : (itm instanceof Expression ? this.getExprTranslator().processExpression((Expression)itm, (BaseJstNode)jstType) : SimpleLiteral.getStringLiteral((String)itm.toString()));
            valArg[counter++] = constValLit;
        }
        ObjCreationExpr initializer = TranslateHelper.Expression.createObjCreationExpr(jstType, valArg);
        this.setInitializer(pty, (IExpr)initializer);
        AnonymousClassDeclaration anonymousClassDeclaration = astEnum.getAnonymousClassDeclaration();
        if (anonymousClassDeclaration != null && (objCreation = this.getExprTranslator().toObjCreation(null, (IJstType)jstType, null, name, null, args, anonymousClassDeclaration, (BaseJstNode)jstType)) != null && (anonymousType = objCreation.getAnonymousType()) != null) {
            JstIdentifier lhs;
            JstIdentifier qualifier = new JstIdentifier(name, VjoTranslateHelper.getStaticMemberQualifier((IJstType)jstType, (BaseJstNode)jstType));
            for (IJstProperty p : anonymousType.getProperties()) {
                lhs = new JstIdentifier(p.getName().getName(), qualifier);
                if (p.getValue() != null && p.getValue() instanceof IExpr) {
                    jstType.addInit((IStmt)new AssignExpr((ILHS)lhs, (IExpr)p.getValue()), true);
                    continue;
                }
                if (p.getInitializer() == null) continue;
                jstType.addInit((IStmt)new AssignExpr((ILHS)lhs, p.getInitializer()), true);
            }
            for (IJstMethod m : anonymousType.getMethods()) {
                lhs = new JstIdentifier(m.getName().getName(), qualifier);
                AssignExpr assignExpr = new AssignExpr((ILHS)lhs, (IExpr)new FuncExpr((JstMethod)m));
                jstType.addInit((IStmt)assignExpr, true);
            }
        }
    }

    private void setInitializer(IJstProperty pty, IExpr initializer) {
        if (pty instanceof JstProperty) {
            ((JstProperty)pty).setInitializer(initializer);
        }
    }

    JstProperty createProperty(IJstType type, String name, boolean isStatic, BaseJstNode parent) {
        JstProperty pty = isStatic ? new JstProperty(type, name, new JstModifiers(8)) : new JstProperty(type, name);
        pty.setParent((IJstNode)parent);
        return pty;
    }

    void initPtys(IJstProperty pty, IExpr initializer, JstType jstType) {
        if (initializer == null || pty == null) {
            return;
        }
        ArrayList<IJstProperty> ptys = new ArrayList<IJstProperty>();
        ptys.add(pty);
        this.initPtys(ptys, initializer, jstType);
    }

    void initPtys(Collection<IJstProperty> ptys, IExpr initializer, JstType jstType) {
        if (initializer == null || ptys == null || ptys.size() == 0) {
            return;
        }
        IJstProperty pty1 = ptys.iterator().next();
        if (pty1 == null) {
            return;
        }
        VjoConvention conv = this.getCtx().getConfig().getVjoConvention();
        boolean isStatic = pty1.isStatic();
        String qualifier = VjoConvention.getThisPrefix();
        if (isStatic) {
            qualifier = VjoConvention.getNameWithStaticThis((String)pty1.getOwnerType().getSimpleName());
        }
        List list = jstType.getProperties(isStatic);
        IJstType type = pty1.getType();
        if (ptys.size() > 1) {
            JstVar tempVar = new JstVar(type, conv.getTempVar());
            JstIdentifier tempIdentifier = new JstIdentifier(tempVar.getName());
            AssignExpr tempExpr = new AssignExpr((ILHS)tempVar, initializer);
            jstType.addInit((IStmt)tempExpr, isStatic);
            for (IJstProperty p : list) {
                if (!ptys.contains(p)) continue;
                String name = p.getName().getName();
                JstIdentifier identifier = new JstIdentifier(name);
                if (qualifier != null) {
                    identifier.setQualifier(new JstIdentifier(qualifier));
                }
                identifier.setJstBinding((IJstNode)p);
                AssignExpr assignExpr = new AssignExpr((ILHS)identifier, (IExpr)tempIdentifier);
                jstType.addInit((IStmt)assignExpr, isStatic);
                this.setInitializer(p, (IExpr)assignExpr);
            }
        } else {
            JstIdentifier identifier = new JstIdentifier(pty1.getName().getName());
            if (qualifier != null) {
                identifier.setQualifier(new JstIdentifier(qualifier));
            }
            identifier.setJstBinding((IJstNode)pty1);
            AssignExpr assignExpr = new AssignExpr((ILHS)identifier, initializer);
            jstType.addInit((IStmt)assignExpr, isStatic);
            this.setInitializer(pty1, (IExpr)assignExpr);
        }
    }

    private void processFieldDecl(FieldDeclaration astField, IJstType fieldType, JstType jstType) {
        boolean isStatic = jstType.isInterface() || TranslateHelper.isStatic(astField.modifiers());
        for (Object o : astField.fragments()) {
            IJstType currentType = fieldType;
            if (o instanceof VariableDeclarationFragment) {
                VariableDeclarationFragment v = (VariableDeclarationFragment)o;
                if (v.getExtraDimensions() > 0) {
                    int i = 0;
                    while (i < v.getExtraDimensions()) {
                        currentType = JstFactory.getInstance().createJstArrayType(currentType, true);
                        ++i;
                    }
                }
                String name = this.getNameTranslator().processVarName(v.getName(), (BaseJstNode)jstType);
                if (!"org.eclipse.vjet.dsf.dap.proxy.INativeJsFuncProxy".equals(fieldType.getName())) {
                    for (IJstMethod p : jstType.getMethods()) {
                        if (!p.getName().getName().equals(name)) continue;
                        this.getLogger().logError("Duplicate method or filed name", "Field name is same as other method name: ", this, (ASTNode)astField, (BaseJstNode)jstType);
                    }
                }
                jstType.getVarTable().addVarType(name, currentType);
                IJstProperty pty = jstType.getProperty(name, isStatic);
                if (pty == null) {
                    pty = this.createProperty(currentType, name, isStatic, (BaseJstNode)jstType);
                } else if (pty instanceof JstProperty) {
                    ((JstProperty)pty).setType(currentType);
                }
                JstModifiers modifiers = pty.getModifiers();
                for (Object m : astField.modifiers()) {
                    if (m instanceof Modifier) {
                        modifiers.merge(((Modifier)m).getKeyword().toFlagValue());
                        continue;
                    }
                    if (m instanceof Annotation) {
                        this.getOtherTranslator().processAnnotation((Annotation)m, (BaseJstNode)jstType);
                        continue;
                    }
                    this.getLogger().logUnhandledNode(this, (ASTNode)m, (BaseJstNode)jstType);
                }
                if (jstType.isInterface()) {
                    modifiers.setPublic();
                }
                this.processFieldJavadoc(astField, (JstProperty)pty);
                jstType.addProperty(pty);
                continue;
            }
            this.getLogger().logUnhandledNode(this, (ASTNode)o, (BaseJstNode)jstType);
        }
    }

    private void processFieldJavadoc(FieldDeclaration astField, JstProperty pty) {
        Javadoc javadoc = astField.getJavadoc();
        if (javadoc == null) {
            return;
        }
        JstDoc jstDoc = new JstDoc(javadoc.toString());
        pty.setDoc((IJstDoc)jstDoc);
    }

    private void processFieldImpl(FieldDeclaration astField, IJstType fieldType, JstType jstType) {
        boolean isStatic = jstType.isInterface() || TranslateHelper.isStatic(astField.modifiers());
        TranslateInfo tInfo = this.getCtx().getTranslateInfo(jstType);
        boolean isFieldTypeJavaOnly = this.getCtx().isJavaOnly(fieldType);
        for (Object o : astField.fragments()) {
            if (o instanceof VariableDeclarationFragment) {
                Expression initializer;
                String name;
                CustomInfo cInfo;
                VariableDeclarationFragment v = (VariableDeclarationFragment)o;
                if (v.getInitializer() == null || (cInfo = tInfo.getFieldCustomInfo(name = v.getName().toString())).isJavaOnly() || cInfo.isJSProxy() || cInfo.isMappedToJS() || cInfo.isMappedToVJO()) continue;
                if (isFieldTypeJavaOnly) {
                    if (cInfo == CustomInfo.NONE) {
                        cInfo = new CustomInfo();
                        tInfo.addFieldCustomInfo(name, cInfo);
                    }
                    cInfo.setAttr(CustomAttr.JAVA_ONLY);
                    continue;
                }
                IJstProperty pty = jstType.getProperty(name, isStatic, false);
                ArrayList<IJstProperty> ptys = new ArrayList<IJstProperty>();
                if (pty != null) {
                    ptys.add(pty);
                }
                if ((initializer = v.getInitializer()) instanceof Assignment) {
                    Assignment a = (Assignment)initializer;
                    ArrayList<SimpleName> vars = new ArrayList<SimpleName>();
                    initializer = this.getMostRight(a, vars, jstType);
                    for (SimpleName var : vars) {
                        String ptyName = var.getIdentifier();
                        pty = jstType.getProperty(ptyName, isStatic, false);
                        if (pty == null) {
                            pty = this.createProperty(fieldType, name, isStatic, (BaseJstNode)jstType);
                            jstType.addProperty(pty);
                        }
                        ptys.add(pty);
                    }
                }
                List list = jstType.getProperties();
                boolean isAnon = jstType.isAnonymous();
                ISimpleTerm simpleTerm = this.getExprTranslator().toSimpleTerm(initializer, (BaseJstNode)(ptys.isEmpty() ? jstType : (BaseJstNode)ptys.get(0)));
                if (simpleTerm != null) {
                    for (IJstProperty p : list) {
                        if (!ptys.contains(p) || !(p instanceof JstProperty)) continue;
                        if (simpleTerm instanceof JstIdentifier && !isAnon) {
                            this.initPtys(p, (IExpr)((JstIdentifier)simpleTerm), jstType);
                            continue;
                        }
                        ((JstProperty)p).setValue(simpleTerm);
                        this.m_autoBoxer.autoBoxingVisit((IJstNode)p);
                    }
                    continue;
                }
                IExpr expr = this.getExprTranslator().processExpression(initializer, (BaseJstNode)(ptys.isEmpty() ? jstType : (BaseJstNode)ptys.get(0)));
                if (expr == null) {
                    this.getLogger().logError("NullResult", "Null result when translating to IExpr from: " + initializer, this, (ASTNode)initializer, (BaseJstNode)jstType);
                    continue;
                }
                this.initPtys(ptys, expr, jstType);
                continue;
            }
            this.getLogger().logUnhandledNode(this, (ASTNode)o, (BaseJstNode)jstType);
        }
    }

    private Expression getMostRight(Assignment a, List<SimpleName> vars, JstType jstType) {
        Expression left = a.getLeftHandSide();
        if (!(left instanceof SimpleName)) {
            this.getLogger().logUnhandledNode(this, (ASTNode)left, (BaseJstNode)jstType);
            return null;
        }
        vars.add((SimpleName)left);
        Expression right = a.getRightHandSide();
        if (right == null) {
            return null;
        }
        if (right instanceof Assignment) {
            return this.getMostRight((Assignment)right, vars, jstType);
        }
        return right;
    }
}

