/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.javatojs.translate;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclarationStatement;
import org.eclipse.vjet.dsf.javatojs.translate.AstBinding;
import org.eclipse.vjet.dsf.javatojs.translate.BaseTranslator;
import org.eclipse.vjet.dsf.javatojs.translate.TranslateCtx;
import org.eclipse.vjet.dsf.javatojs.translate.TranslateInfo;
import org.eclipse.vjet.dsf.javatojs.translate.TranslationMode;
import org.eclipse.vjet.dsf.javatojs.translate.VjoTranslateHelper;
import org.eclipse.vjet.dsf.javatojs.translate.config.MethodKey;
import org.eclipse.vjet.dsf.javatojs.translate.custom.CustomInfo;
import org.eclipse.vjet.dsf.javatojs.translate.util.AutoBoxer;
import org.eclipse.vjet.dsf.javatojs.translate.util.AutoUnboxer;
import org.eclipse.vjet.dsf.jsnative.global.Object;
import org.eclipse.vjet.dsf.jsnative.global.String;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.JstSource;
import org.eclipse.vjet.dsf.jst.declaration.JstArg;
import org.eclipse.vjet.dsf.jst.declaration.JstArray;
import org.eclipse.vjet.dsf.jst.declaration.JstBlock;
import org.eclipse.vjet.dsf.jst.declaration.JstCache;
import org.eclipse.vjet.dsf.jst.declaration.JstFactory;
import org.eclipse.vjet.dsf.jst.declaration.JstMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstParamType;
import org.eclipse.vjet.dsf.jst.declaration.JstProperty;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.declaration.JstTypeWithArgs;
import org.eclipse.vjet.dsf.jst.declaration.VarTable;
import org.eclipse.vjet.dsf.jst.expr.BoolExpr;
import org.eclipse.vjet.dsf.jst.expr.MtdInvocationExpr;
import org.eclipse.vjet.dsf.jst.expr.ObjCreationExpr;
import org.eclipse.vjet.dsf.jst.stmt.JstBlockInitializer;
import org.eclipse.vjet.dsf.jst.term.JstIdentifier;
import org.eclipse.vjet.dsf.jst.term.SimpleLiteral;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.dsf.jst.util.DataTypeHelper;
import org.eclipse.vjet.dsf.jst.util.JstMethodHelper;
import org.eclipse.vjet.dsf.jst.util.JstTypeHelper;
import org.eclipse.vjet.dsf.util.JavaSourceLocator;

public final class TranslateHelper {
    private static AutoBoxer s_autoBoxer = AutoBoxer.getInstance();
    private static AutoUnboxer s_autoUnboxer = AutoUnboxer.getInstance();

    public static boolean isObjectType(IJstType type) {
        return type != null && TranslateHelper.isObjectType(type.getName());
    }

    public static boolean isObjectType(java.lang.String typeName) {
        return typeName != null && (Object.class.getName().equals(typeName) || Object.class.getSimpleName().equals(typeName) || "vjo.Object".equals(typeName));
    }

    public static AbstractTypeDeclaration getOwnerType(ASTNode astNode) {
        if (astNode == null) {
            return null;
        }
        if (astNode instanceof AbstractTypeDeclaration) {
            return (AbstractTypeDeclaration)astNode;
        }
        ASTNode parent = astNode.getParent();
        while (parent != null) {
            if (parent instanceof AbstractTypeDeclaration) {
                return (AbstractTypeDeclaration)parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    public static boolean isStatic(List<?> astModifiers) {
        if (astModifiers != null) {
            for (java.lang.Object o : astModifiers) {
                if (!(o instanceof Modifier) || !((Modifier)o).isStatic()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isPublic(List<?> astModifiers) {
        if (astModifiers != null) {
            for (java.lang.Object o : astModifiers) {
                if (!(o instanceof Modifier) || !((Modifier)o).isPublic()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isPrivate(List<?> astModifiers) {
        if (astModifiers != null) {
            for (java.lang.Object o : astModifiers) {
                if (!(o instanceof Modifier) || !((Modifier)o).isPrivate()) continue;
                return true;
            }
        }
        return false;
    }

    public static java.lang.String getTypeName(java.lang.String filePath) {
        if (filePath == null) {
            return null;
        }
        int index = filePath.lastIndexOf("\\");
        if (index < 0) {
            index = filePath.lastIndexOf("/");
        }
        if (index < 0) {
            return null;
        }
        java.lang.String clsName = index < 0 ? filePath : filePath.substring(index + 1);
        if ((index = clsName.indexOf(".")) > 0) {
            clsName = clsName.substring(0, index);
        }
        return clsName;
    }

    public static java.lang.String getShortName(java.lang.String fullName) {
        if (fullName == null) {
            return null;
        }
        int index = fullName.lastIndexOf(".");
        return index >= 0 ? fullName.substring(index + 1) : fullName;
    }

    public static java.lang.String getPkgName(java.lang.String fullName) {
        if (fullName == null) {
            return null;
        }
        int index = fullName.lastIndexOf(".");
        return index >= 0 ? fullName.substring(0, index) : null;
    }

    public static VarTable getVarTable(IJstNode jstNode) {
        IJstNode node = jstNode;
        while (node != null) {
            if (node instanceof JstBlock) {
                return ((JstBlock)node).getVarTable();
            }
            if (node instanceof JstType) {
                return ((JstType)node).getVarTable();
            }
            node = node.getParentNode();
        }
        return null;
    }

    public static JstMethod getOwnerMethod(IJstNode node) {
        IJstNode parent = node;
        while (parent != null) {
            if (parent instanceof JstMethod) {
                return (JstMethod)parent;
            }
            parent = parent.getParentNode();
        }
        return null;
    }

    public static JstBlock getOwnerBlock(IJstNode node) {
        if (node instanceof JstMethod) {
            return ((JstMethod)node).getBlock();
        }
        IJstNode parent = node;
        while (parent != null) {
            if (parent instanceof JstBlock) {
                return (JstBlock)parent;
            }
            parent = parent.getParentNode();
        }
        return null;
    }

    public static JstBlockInitializer getOwnerBlockInitializer(IJstNode node) {
        IJstNode parent = node;
        while (parent != null) {
            if (parent instanceof JstBlockInitializer) {
                return (JstBlockInitializer)parent;
            }
            parent = parent.getParentNode();
        }
        return null;
    }

    public static boolean isInInstanceBlock(IJstNode node) {
        JstMethod ownerMtd = TranslateHelper.getOwnerMethod(node);
        if (ownerMtd != null && !ownerMtd.getModifiers().isStatic()) {
            return true;
        }
        JstBlockInitializer blockInitializer = TranslateHelper.getOwnerBlockInitializer(node);
        if (blockInitializer != null && !blockInitializer.getModifiers().isStatic()) {
            return true;
        }
        if (node instanceof IJstProperty) {
            return !((IJstProperty)node).isStatic();
        }
        return false;
    }

    public static boolean isStaticType(JstIdentifier identifier) {
        if (identifier == null || identifier.getJstBinding() == null) {
            return false;
        }
        IJstNode binding = identifier.getJstBinding();
        if (binding instanceof IJstType) {
            return ((IJstType)binding).getModifiers().isStatic();
        }
        return false;
    }

    public static IJstType getStaticType(JstIdentifier identifier) {
        if (identifier == null || identifier.getJstBinding() == null) {
            return null;
        }
        IJstNode binding = identifier.getJstBinding();
        if (binding instanceof IJstType) {
            return (IJstType)binding;
        }
        return null;
    }

    public static boolean isStaticMember(JstIdentifier identifier) {
        if (identifier == null || identifier.getJstBinding() == null) {
            return false;
        }
        IJstNode binding = identifier.getJstBinding();
        if (binding instanceof IJstProperty) {
            return ((IJstProperty)binding).isStatic();
        }
        if (binding instanceof IJstMethod) {
            return ((IJstMethod)binding).isStatic();
        }
        return false;
    }

    public static IJstType getJstBindingOwnerType(JstIdentifier identifier) {
        if (identifier == null || identifier.getJstBinding() == null) {
            return null;
        }
        return identifier.getJstBinding().getOwnerType();
    }

    public static IJstType getBase(IJstType jstType) {
        if (jstType == null) {
            return null;
        }
        IJstType base = jstType.getExtend();
        if (base != null && !VjoTranslateHelper.isVjoObjectType(base)) {
            return base;
        }
        if (jstType instanceof JstType) {
            return TranslateCtx.ctx().getTranslateInfo((JstType)jstType).getBaseType();
        }
        return null;
    }

    public static int getLineNumber(ASTNode node) {
        if (node != null && node.getRoot() instanceof CompilationUnit) {
            CompilationUnit cu = (CompilationUnit)node.getRoot();
            return cu.getLineNumber(node.getStartPosition());
        }
        return -1;
    }

    public static int getColumnNumber(ASTNode node) {
        if (node != null && node.getRoot() instanceof CompilationUnit) {
            CompilationUnit cu = (CompilationUnit)node.getRoot();
            return cu.getColumnNumber(node.getStartPosition());
        }
        return -1;
    }

    public static java.lang.String getResourceString(ASTNode node) {
        CompilationUnit cu;
        IJavaElement javaElement;
        if (node != null && node.getRoot() instanceof CompilationUnit && (javaElement = (cu = (CompilationUnit)node.getRoot()).getJavaElement()) != null && javaElement.getResource() != null) {
            return javaElement.getResource().getFullPath().toString();
        }
        return null;
    }

    public static boolean isNameAllCapitalized(java.lang.String name) {
        char[] chars;
        char[] cArray = chars = name.toCharArray();
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char ch = cArray[n2];
            if (Character.isLetter(ch) && !Character.isUpperCase(ch)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static java.lang.String getOperatorStringForJs(java.lang.String operator) {
        if (operator != null) {
            if (operator.equals("==")) {
                return BoolExpr.Operator.IDENTICAL.toString();
            }
            if (operator.equals("!=")) {
                return BoolExpr.Operator.NOT_IDENTICAL.toString();
            }
        }
        return operator;
    }

    public static class Expression {
        public static boolean removeQualifier(IExpr identifier, IJstNode jstNode) {
            JstProperty pty;
            JstType type;
            IJstNode binding;
            if (identifier == null || jstNode == null || !(identifier instanceof JstIdentifier)) {
                return false;
            }
            TranslateCtx ctx = TranslateCtx.ctx();
            JstIdentifier qualifier = ((JstIdentifier)identifier).getQualifier();
            if (qualifier != null && (binding = qualifier.getJstBinding()) != null && binding instanceof JstType && ctx.isJavaOnly((IJstType)(type = (JstType)binding))) {
                return true;
            }
            binding = ((JstIdentifier)identifier).getJstBinding();
            TranslateInfo tInfo = ctx.getTranslateInfo((JstType)jstNode.getOwnerType());
            if (binding == null || tInfo == null) {
                return false;
            }
            if (binding instanceof JstMethod) {
                JstMethod mtd = (JstMethod)binding;
                if (mtd != null) {
                    MethodKey mtdKey = MethodKey.genMethodKey((IJstMethod)mtd);
                    tInfo = ctx.getTranslateInfo(mtd.getOwnerType());
                    CustomInfo cInfo = tInfo.getMethodCustomInfo(mtdKey);
                    return cInfo.isJavaOnly() || cInfo.isMappedToJS() || cInfo.isMappedToVJO();
                }
            } else if (binding instanceof JstProperty && (pty = (JstProperty)binding) != null && pty.getName() != null) {
                tInfo = ctx.getTranslateInfo(pty.getOwnerType());
                CustomInfo cInfo = tInfo.getFieldCustomInfo(pty.getName().getName());
                return cInfo.isJavaOnly() || cInfo.isMappedToJS() || cInfo.isMappedToVJO();
            }
            return false;
        }

        public static ObjCreationExpr createObjCreationExpr(java.lang.String typeName, IExpr ... args) {
            JstType type = JstCache.getInstance().getType(typeName);
            if (type != null) {
                return Expression.createObjCreationExpr(type, args);
            }
            return new ObjCreationExpr(new MtdInvocationExpr(new JstIdentifier(typeName), args));
        }

        public static ObjCreationExpr createObjCreationExpr(JstType type, IExpr ... args) {
            JstIdentifier identifier = new JstIdentifier(type.getSimpleName()).setType((IJstType)type);
            return new ObjCreationExpr(new MtdInvocationExpr(identifier, args));
        }
    }

    public static class Factory {
        public static JstType createJstType(ASTNode astNode, IJstNode scopeNode) {
            JstType jstType = JstFactory.getInstance().createJstType(false);
            jstType.setSource(new JstSource((JstSource.IBinding)new AstBinding(astNode)));
            JstType rootType = null;
            if (scopeNode == null) {
                rootType = jstType;
            } else if (scopeNode.getRootType() instanceof JstType) {
                rootType = (JstType)scopeNode.getRootType();
            }
            if (rootType == null) {
                return jstType;
            }
            java.lang.String symbol = null;
            if (astNode instanceof TypeDeclaration) {
                symbol = ((TypeDeclaration)astNode).getName().toString();
            } else if (astNode instanceof TypeDeclarationStatement) {
                symbol = ((TypeDeclarationStatement)astNode).getDeclaration().getName().toString();
            }
            TranslateInfo tInfo = TranslateCtx.ctx().getTranslateInfo(rootType.getRootType());
            if (astNode instanceof AnonymousClassDeclaration) {
                tInfo.addAnonymousType((AnonymousClassDeclaration)astNode, jstType);
            } else if (astNode instanceof TypeDeclarationStatement) {
                tInfo.addLocalType((TypeDeclarationStatement)astNode, jstType);
                VarTable varTable = TranslateHelper.getVarTable(scopeNode);
                if (varTable != null) {
                    varTable.addLocalType(symbol, jstType);
                }
            }
            if (symbol != null) {
                tInfo.setType(symbol, (IJstType)jstType);
            }
            return jstType;
        }
    }

    public static class Method {
        public static IJstMethod getMethod(MethodDeclaration astMtd, JstType jstType) {
            TranslateInfo tInfo;
            java.lang.String mtdName = astMtd.getName().toString();
            mtdName = TranslateCtx.ctx().getProvider().getNameTranslator().processVarName(mtdName);
            boolean isStatic = TranslateHelper.isStatic(astMtd.modifiers());
            if (astMtd.isConstructor()) {
                mtdName = "constructs";
            }
            if (!(tInfo = TranslateCtx.ctx().getTranslateInfo(jstType)).isOverloaded(mtdName, TranslateHelper.isStatic(astMtd.modifiers()))) {
                if (astMtd.isConstructor()) {
                    return jstType.getConstructor();
                }
                return jstType.getMethod(mtdName, isStatic);
            }
            return tInfo.getOverloaded(astMtd);
        }

        public static IJstMethod getConstructor(IJstType ownerType, List<IExpr> args) {
            Integer argCount;
            List<JstMethod> list;
            TranslateInfo tInfo;
            Map<Integer, List<JstMethod>> map;
            IJstType aType;
            JstType type = null;
            if (ownerType instanceof JstType) {
                type = (JstType)ownerType;
            } else if (ownerType instanceof JstTypeWithArgs && (aType = ((JstTypeWithArgs)ownerType).getType()) instanceof JstType) {
                type = (JstType)aType;
            }
            if (type == null) {
                return null;
            }
            ArrayList<IJstMethod> mtds = new ArrayList<IJstMethod>();
            if (type.getConstructor() instanceof JstMethod) {
                mtds.add((IJstMethod)type.getConstructor());
            }
            if ((map = (tInfo = TranslateCtx.ctx().getTranslateInfo(type)).getOverloaded("constructs", false)) != null && (list = map.get(argCount = new Integer(args.size()))) != null) {
                mtds.addAll(list);
            }
            Map<MethodDeclaration, JstMethod> removedMap = tInfo.getRemovedMtds(type.getSimpleName());
            for (Map.Entry<MethodDeclaration, JstMethod> entry : removedMap.entrySet()) {
                mtds.add((IJstMethod)entry.getValue());
            }
            if (mtds.size() == 1) {
                return (IJstMethod)mtds.get(0);
            }
            return Method.getMatchingMethod((IJstType)type, mtds, args);
        }

        public static IJstMethod getMethod(ASTNode astNode, IJstType qualifierType, java.lang.String mtdName, List<IExpr> args) {
            ArrayList<IJstMethod> mtds = new ArrayList<IJstMethod>();
            Method.collectMethods(astNode, qualifierType, mtdName, mtds);
            Collections.sort(mtds, JstMethodHelper.s_mtdComparator);
            return Method.getMatchingMethod(qualifierType, mtds, args);
        }

        private static void collectMethods(ASTNode astNode, IJstType jstType, java.lang.String mtdName, List<IJstMethod> mtds) {
            Collection<JstMethod> c;
            if (jstType == null) {
                return;
            }
            IJstType type = jstType;
            if (type instanceof JstTypeWithArgs) {
                type = ((JstTypeWithArgs)type).getType();
            }
            for (IJstMethod jstMtd : type.getMethods()) {
                if (!jstMtd.getName().getName().equals(mtdName)) continue;
                mtds.add(jstMtd);
                for (IJstMethod overloaded : jstMtd.getOverloaded()) {
                    if (!(overloaded instanceof JstMethod)) continue;
                    mtds.add((IJstMethod)((JstMethod)overloaded));
                }
            }
            for (IJstType extend : type.getExtends()) {
                Method.collectMethods(astNode, extend, mtdName, mtds);
            }
            if (!type.isInterface()) {
                for (IJstType satisfy : type.getSatisfies()) {
                    Method.collectMethods(astNode, satisfy, mtdName, mtds);
                }
            }
            if (type instanceof JstType && (c = Method.getRemovedMethods(astNode, (BaseJstNode)((JstType)type))) != null) {
                for (JstMethod m : c) {
                    mtds.add((IJstMethod)m);
                }
            }
        }

        public static IJstMethod getOwnerMethod(IJstNode expr) {
            if (expr == null) {
                return null;
            }
            IJstNode parentNode = expr.getParentNode();
            while (parentNode != null) {
                if (parentNode instanceof IJstMethod) {
                    return (IJstMethod)parentNode;
                }
                parentNode = parentNode.getParentNode();
            }
            return null;
        }

        public static boolean includeMethodForDecl(MethodDeclaration astMtd, CustomInfo fInfo, JstType jstType) {
            if (!TranslateHelper.isPrivate(astMtd.modifiers())) {
                return true;
            }
            TranslateCtx ctx = TranslateCtx.ctx();
            if (ctx.isJavaOnly((IJstType)jstType) || ctx.isJSProxy((IJstType)jstType)) {
                return false;
            }
            JstType outer = jstType.getOuterType();
            while (outer != null) {
                if (ctx.isJavaOnly((IJstType)outer) || ctx.isJSProxy((IJstType)outer)) {
                    return false;
                }
                outer = outer.getOuterType();
            }
            return true;
        }

        public static boolean includeMethodForImpl(MethodDeclaration astMtd, CustomInfo fInfo, JstType jstType) {
            if (fInfo != null && (fInfo.isExcluded() || fInfo.isMappedToJS() || fInfo.isMappedToVJO())) {
                return false;
            }
            if (!TranslateHelper.isPrivate(astMtd.modifiers())) {
                return true;
            }
            if (fInfo != null && fInfo.isJavaOnly()) {
                return false;
            }
            TranslateCtx ctx = TranslateCtx.ctx();
            if (ctx.isJavaOnly((IJstType)jstType) || ctx.isJSProxy((IJstType)jstType)) {
                return false;
            }
            JstType outer = jstType.getOuterType();
            while (outer != null) {
                if (ctx.isJavaOnly((IJstType)outer) || ctx.isJSProxy((IJstType)outer)) {
                    return false;
                }
                outer = outer.getOuterType();
            }
            return true;
        }

        public static void validateMethodReference(IJstMethod jstMtd, ASTNode astNode, BaseJstNode scopeNode, BaseTranslator translator) {
            if (jstMtd == null) {
                return;
            }
            IJstType ownerType = jstMtd.getOwnerType();
            if (!(ownerType instanceof JstType)) {
                return;
            }
            JstType scopeType = scopeNode.getOwnerType();
            if (scopeType == null || !(scopeType instanceof JstType)) {
                return;
            }
            TranslateCtx ctx = TranslateCtx.ctx();
            CustomInfo cInfo = Method.getCustomInfo((JstType)ownerType, jstMtd, ctx, false);
            if (cInfo.isExcluded()) {
                StringBuffer sb = new StringBuffer();
                if (jstMtd.getName().getName().equals(ownerType.getSimpleName())) {
                    sb.append("Constructor of ");
                } else {
                    sb.append("Method ").append(jstMtd.getName().getName()).append(" of ");
                }
                sb.append(ownerType.getName()).append(" is excluded");
                ctx.getLogger().logError("ExcludedMethod", sb.toString(), translator, astNode, scopeNode);
            }
        }

        private static IJstMethod getMatchingMethod(IJstType qualifierType, List<IJstMethod> mtds, List<IExpr> args) {
            IJstMethod mtdHasVarArgs = null;
            IJstMethod mtdNeedBoxing = null;
            int indexOfFirstArgForBoxing = -1;
            int index = 0;
            while (index < mtds.size()) {
                IJstMethod mtd = mtds.get(index);
                if (!mtd.isDispatcher()) {
                    int baseSize;
                    int n = baseSize = mtd.isVarArgs() ? mtd.getArgs().size() - 1 : mtd.getArgs().size();
                    if (!(mtd.isVarArgs() ? args.size() < baseSize : args.size() != mtd.getArgs().size())) {
                        ComparisonResult result = new ComparisonResult();
                        int i = 0;
                        while (i < baseSize) {
                            if (!Method.comapreArg(qualifierType, mtd, i, args.get(i), (JstArg)mtd.getArgs().get(i), result)) break;
                            ++i;
                        }
                        if (mtd.isVarArgs()) {
                            JstArg varArg = (JstArg)mtd.getArgs().get(baseSize);
                            int i2 = baseSize;
                            while (i2 < args.size()) {
                                if (!Method.comapreArg(qualifierType, mtd, i2, args.get(i2), varArg, result)) break;
                                ++i2;
                            }
                        }
                        if (result.m_found) {
                            if (!result.m_needAutoBoxing && !mtd.isVarArgs()) {
                                return mtd;
                            }
                            if (mtd.isVarArgs()) {
                                mtdHasVarArgs = mtd;
                            } else if (indexOfFirstArgForBoxing < 0 || result.m_mtdIndexOfFirstArgForBoxing < indexOfFirstArgForBoxing) {
                                indexOfFirstArgForBoxing = result.m_mtdIndexOfFirstArgForBoxing;
                                mtdNeedBoxing = mtd;
                            }
                        }
                    }
                }
                ++index;
            }
            if (mtdNeedBoxing != null) {
                return mtdNeedBoxing;
            }
            if (mtdHasVarArgs != null) {
                return mtdHasVarArgs;
            }
            return null;
        }

        private static boolean comapreArg(IJstType jstType, IJstMethod mtd, int index, IExpr actualArg, JstArg expectedArg, ComparisonResult result) {
            IJstType tmp;
            if (actualArg instanceof SimpleLiteral && ((SimpleLiteral)actualArg).getValue() == null) {
                return true;
            }
            IJstType actualType = actualArg.getResultType();
            if (actualType != null && (tmp = Method.getCurrentArgType(actualArg, actualType)) != null) {
                actualType = tmp;
            }
            IJstType cType = expectedArg.getType();
            if (actualType == null || cType == null) {
                result.m_found = false;
                return false;
            }
            java.lang.String cTypeName = DataTypeHelper.getTypeName((java.lang.String)cType.getName());
            while (actualType instanceof JstArray && cType instanceof JstArray) {
                actualType = ((JstArray)actualType).getComponentType();
                cType = ((JstArray)cType).getComponentType();
                cTypeName = DataTypeHelper.getTypeName((java.lang.String)cType.getName());
            }
            if (TranslateHelper.isObjectType(cTypeName) && !DataTypeHelper.isPrimitiveType((IJstType)actualType)) {
                return true;
            }
            if (JstTypeHelper.isTemplateType((IJstType)cType, (IJstMethod)mtd)) {
                return true;
            }
            java.lang.String typeName = DataTypeHelper.getTypeName((java.lang.String)actualType.getName());
            if (cTypeName.equals(typeName)) {
                return true;
            }
            if (JstTypeHelper.isTypeOf((IJstType)actualType, (IJstType)cType)) {
                return true;
            }
            if (cType instanceof JstParamType && jstType != null && jstType instanceof JstTypeWithArgs) {
                cType = ((JstTypeWithArgs)jstType).getArgType();
            }
            if (s_autoBoxer.needAutoBoxing(actualArg, cType) || s_autoUnboxer.needAutoUnboxing(actualArg, cType)) {
                result.m_needAutoBoxing = true;
                if (result.m_mtdIndexOfFirstArgForBoxing < 0) {
                    result.m_mtdIndexOfFirstArgForBoxing = index;
                }
                return true;
            }
            if (DataTypeHelper.canPromote((IJstType)actualType, (IJstType)cType)) {
                return true;
            }
            result.m_found = false;
            return false;
        }

        public static IJstType getCurrentArgType(IExpr expr, IJstType argType) {
            IJstType scopeType;
            if (expr instanceof MtdInvocationExpr) {
                MtdInvocationExpr mtdInvocationExpr = (MtdInvocationExpr)expr;
                IJstType type = Method.findTypeInMethodParams(mtdInvocationExpr, argType);
                if (type != null) {
                    return type;
                }
                if (mtdInvocationExpr.getQualifyExpr() == null) {
                    return null;
                }
                scopeType = mtdInvocationExpr.getQualifyExpr().getResultType();
            } else if (expr instanceof JstIdentifier) {
                JstIdentifier jstIdn = (JstIdentifier)expr;
                if (jstIdn.getQualifier() == null) {
                    return null;
                }
                if (jstIdn.getQualifier() == null) {
                    return null;
                }
                scopeType = jstIdn.getQualifier().getResultType();
            } else {
                return null;
            }
            if (scopeType instanceof JstTypeWithArgs) {
                JstTypeWithArgs scopeT = (JstTypeWithArgs)scopeType;
                int i = 0;
                while (i < scopeT.getType().getParamTypes().size()) {
                    IJstType itm = (IJstType)scopeT.getType().getParamTypes().get(i);
                    if (itm != null && argType != null && itm.getName().equals(argType.getName())) {
                        return (IJstType)scopeT.getArgTypes().get(i);
                    }
                    ++i;
                }
            }
            return null;
        }

        private static IJstType findTypeInMethodParams(MtdInvocationExpr expr, IJstType argType) {
            JstIdentifier methodIdentifier = (JstIdentifier)expr.getMethodIdentifier();
            if (methodIdentifier.getJstBinding() instanceof JstMethod) {
                JstMethod jstBinding = (JstMethod)methodIdentifier.getJstBinding();
                if (jstBinding == null || jstBinding.getParamTypes().isEmpty()) {
                    return null;
                }
                int i = 0;
                while (i < jstBinding.getParamTypes().size()) {
                    if (argType.getName().equals(((JstParamType)jstBinding.getParamTypes().get(i)).getName())) {
                        int j = 0;
                        while (j < jstBinding.getArgs().size()) {
                            if (((JstArg)jstBinding.getArgs().get(j)).getType().getName().equals(argType.getName())) {
                                return ((IExpr)expr.getArgs().get(j)).getResultType();
                            }
                            ++j;
                        }
                        break;
                    }
                    ++i;
                }
            }
            return null;
        }

        private static Collection<JstMethod> getRemovedMethods(ASTNode astExpr, BaseJstNode jstNode) {
            SimpleName astName;
            if (astExpr instanceof MethodInvocation) {
                astName = ((MethodInvocation)astExpr).getName();
            } else if (astExpr instanceof SuperMethodInvocation) {
                astName = ((SuperMethodInvocation)astExpr).getName();
            } else {
                return Collections.emptySet();
            }
            return TranslateCtx.ctx().getTranslateInfo(jstNode.getOwnerType()).getRemovedMtds(astName.toString()).values();
        }

        private static CustomInfo getCustomInfo(JstType jstType, IJstMethod jstMtd, TranslateCtx ctx, boolean recusive) {
            TranslateInfo tInfo = ctx.getTranslateInfo(jstType);
            CustomInfo cInfo = tInfo.getMethodCustomInfo(MethodKey.genMethodKey(jstMtd));
            if (cInfo != CustomInfo.NONE || !recusive) {
                return cInfo;
            }
            IJstType baseType = TranslateHelper.getBase((IJstType)jstType);
            while (baseType != null && baseType instanceof JstType) {
                cInfo = Method.getCustomInfo((JstType)baseType, jstMtd, ctx, recusive);
                if (cInfo != CustomInfo.NONE) {
                    return cInfo;
                }
                baseType = TranslateHelper.getBase(baseType);
            }
            JstType outer = jstType.getOuterType();
            while (outer != null && outer instanceof JstType) {
                cInfo = Method.getCustomInfo(outer, jstMtd, ctx, recusive);
                if (cInfo != CustomInfo.NONE) {
                    return cInfo;
                }
                outer = outer.getOuterType();
            }
            return CustomInfo.NONE;
        }

        private static class ComparisonResult {
            boolean m_found = true;
            boolean m_needAutoBoxing = false;
            int m_mtdIndexOfFirstArgForBoxing = -1;

            private ComparisonResult() {
            }
        }
    }

    public static class Property {
        public static IJstProperty getProperty(IJstType type, java.lang.String name) {
            if (type == null || name == null) {
                return null;
            }
            IJstProperty pty = type.getProperty(name, true, true);
            if (pty == null) {
                pty = type.getProperty(name, false, true);
            }
            return pty;
        }

        public static boolean includeFieldForDecl(FieldDeclaration astField, CustomInfo fInfo, JstType jstType) {
            if (fInfo != null && fInfo.isExcluded()) {
                return false;
            }
            if (!TranslateHelper.isPrivate(astField.modifiers())) {
                return true;
            }
            TranslateCtx ctx = TranslateCtx.ctx();
            if (ctx.isJavaOnly((IJstType)jstType) || ctx.isJSProxy((IJstType)jstType)) {
                return false;
            }
            JstType outer = jstType.getOuterType();
            while (outer != null) {
                if (ctx.isJavaOnly((IJstType)outer) || ctx.isJSProxy((IJstType)outer)) {
                    return false;
                }
                outer = outer.getOuterType();
            }
            return true;
        }

        public static boolean includeFieldForImpl(FieldDeclaration astField, CustomInfo fInfo, JstType jstType) {
            if (fInfo != null && (fInfo.isExcluded() || fInfo.isMappedToJS() || fInfo.isMappedToVJO())) {
                return false;
            }
            if (!TranslateHelper.isPrivate(astField.modifiers())) {
                return true;
            }
            if (fInfo != null && fInfo.isJavaOnly()) {
                return false;
            }
            TranslateCtx ctx = TranslateCtx.ctx();
            if (ctx.isJavaOnly((IJstType)jstType) || ctx.isJSProxy((IJstType)jstType)) {
                return false;
            }
            JstType outer = jstType.getOuterType();
            while (outer != null) {
                if (ctx.isJavaOnly((IJstType)outer) || ctx.isJSProxy((IJstType)outer)) {
                    return false;
                }
                outer = outer.getOuterType();
            }
            return true;
        }

        public static void validateFieldReference(Name astName, BaseJstNode theNode, BaseJstNode scopeNode, BaseTranslator translator) {
            JstType ownerType = scopeNode.getOwnerType();
            if (ownerType == null || !(ownerType instanceof JstType)) {
                return;
            }
            TranslateCtx ctx = TranslateCtx.ctx();
            java.lang.String fieldName = astName.toString();
            CustomInfo cInfo = Property.getCustomInfo(ownerType, fieldName, ctx);
            if (cInfo.isExcluded()) {
                ctx.getLogger().logError("ExcludedField", "'" + fieldName + "' of type '" + ownerType.getName() + "' or from its base or outer", translator, (ASTNode)astName, theNode);
            }
        }

        private static CustomInfo getCustomInfo(JstType jstType, java.lang.String fieldName, TranslateCtx ctx) {
            TranslateInfo tInfo = ctx.getTranslateInfo(jstType);
            CustomInfo cInfo = tInfo.getFieldCustomInfo(fieldName);
            if (cInfo != CustomInfo.NONE) {
                return cInfo;
            }
            IJstType baseType = TranslateHelper.getBase((IJstType)jstType);
            while (baseType != null && baseType instanceof JstType) {
                cInfo = Property.getCustomInfo((JstType)baseType, fieldName, ctx);
                if (cInfo != CustomInfo.NONE) {
                    return cInfo;
                }
                baseType = TranslateHelper.getBase(baseType);
            }
            JstType outer = jstType.getOuterType();
            while (outer != null && outer instanceof JstType) {
                cInfo = Property.getCustomInfo(outer, fieldName, ctx);
                if (cInfo != CustomInfo.NONE) {
                    return cInfo;
                }
                outer = outer.getOuterType();
            }
            return CustomInfo.NONE;
        }
    }

    public static class Type {
        public static boolean isEmbededType(AbstractTypeDeclaration astType) {
            return astType.getParent() instanceof AbstractTypeDeclaration;
        }

        public static boolean isFullyQualifiedTypeName(java.lang.String name) {
            return JavaSourceLocator.getInstance().getSourceUrl(name) != null;
        }

        public static java.lang.String resolveEmbeddedType(java.lang.String dependentName, JstType referencingType) {
            int index = dependentName.indexOf(".");
            if (index < 0) {
                return null;
            }
            java.lang.String rootName = dependentName.substring(0, index);
            IJstType rootType = referencingType.getImport(rootName);
            if (rootType != null) {
                return rootType.getName();
            }
            return TranslateCtx.ctx().getTranslateInfo(referencingType).getImported(rootName);
        }

        public static java.lang.String resolveImplicitImport(java.lang.String dependentName, JstType referencingType) {
            if (dependentName == null || referencingType == null) {
                return null;
            }
            JstType rootType = referencingType;
            while (rootType.getOuterType() != null) {
                rootType = rootType.getOuterType();
            }
            java.lang.String clsName = Type.getOwnerClassName(dependentName);
            if (clsName != null) {
                return clsName;
            }
            TranslateCtx ctx = TranslateCtx.ctx();
            if (rootType.getPackage() != null) {
                ctx.getTranslateInfo(rootType).addImportedPkg(ctx.getConfig().getPackageMapping().mapFrom(rootType.getPackage().getName()));
            }
            List<java.lang.String> pkgs = ctx.getTranslateInfo(rootType).getImportedPkgs();
            for (java.lang.String pkg : pkgs) {
                if (pkg == null || pkg.length() == 0 || (clsName = Type.getOwnerClassName(java.lang.String.valueOf(pkg) + "." + dependentName)) == null) continue;
                return clsName;
            }
            if (DataTypeHelper.isInJavaLang((java.lang.String)dependentName)) {
                return "java.lang." + dependentName;
            }
            return clsName;
        }

        public static java.lang.String getTypeFullName(java.lang.String simpleName, JstType jstType) {
            TranslateInfo tInfo = TranslateCtx.ctx().getTranslateInfo(jstType);
            java.lang.String fullName = tInfo.getImported(simpleName);
            if (fullName != null) {
                return fullName;
            }
            IJstType javaOnlyType = tInfo.getType(simpleName, true);
            if (javaOnlyType != null) {
                return javaOnlyType.getName();
            }
            return null;
        }

        public static IJstType getType(IExpr expr) {
            if (expr == null) {
                return null;
            }
            IJstType jstType = expr.getResultType();
            if (jstType != null) {
                return jstType;
            }
            if (expr instanceof JstIdentifier) {
                return Type.getType((JstIdentifier)expr);
            }
            return expr.getResultType();
        }

        public static IJstType getType(JstIdentifier identifier) {
            if (identifier == null) {
                return null;
            }
            if (identifier.getType() != null) {
                return identifier.getType();
            }
            JstIdentifier qualifier = identifier.getQualifier();
            if (qualifier == null) {
                return null;
            }
            JstType jstType = JstTypeHelper.getJstType((IJstType)Type.getType(identifier.getQualifier()));
            if (jstType == null) {
                return null;
            }
            java.lang.String innerFullName = java.lang.String.valueOf(jstType.getName()) + "." + identifier.getName();
            JstType inner = JstCache.getInstance().getType(innerFullName, false);
            if (inner != null) {
                jstType.addInnerType(inner);
            }
            return inner;
        }

        public static IJstType getIdentifierType(java.lang.String name, BaseJstNode node) {
            IJstType jstType = Type.getVarType(name, (IJstNode)node);
            if (jstType != null) {
                return jstType;
            }
            return TranslateCtx.ctx().getProvider().getDataTypeTranslator().findJstType(name, (BaseJstNode)node.getOwnerType());
        }

        public static IJstType getLocalVarType(java.lang.String name, IJstNode node) {
            JstBlock block;
            if (node == null) {
                return null;
            }
            if (node instanceof JstType) {
                return null;
            }
            IJstType varType = null;
            if (node instanceof JstBlock && (varType = (block = (JstBlock)node).getVarTable().getVarType(name)) != null) {
                return varType;
            }
            if (node.getParentNode() != null) {
                return Type.getLocalVarType(name, node.getParentNode());
            }
            return null;
        }

        public static IJstType getVarType(java.lang.String name, IJstNode node) {
            return Type.getVarType(name, node, true);
        }

        public static IJstType getVarType(java.lang.String name, IJstNode node, boolean deep) {
            JstBlock block;
            JstType jstType;
            if (node == null) {
                return null;
            }
            IJstType varType = null;
            if (node instanceof JstType && (varType = (jstType = (JstType)node).getVarTable().getVarType(name)) != null) {
                return varType;
            }
            if (node instanceof JstBlock && (varType = (block = (JstBlock)node).getVarTable().getVarType(name)) != null) {
                return varType;
            }
            if (deep && node.getParentNode() != null) {
                return Type.getVarType(name, node.getParentNode(), deep);
            }
            return null;
        }

        public static IJstType getLocalType(java.lang.String name, IJstNode node) {
            JstBlock block;
            if (node == null) {
                return null;
            }
            JstType varType = null;
            if (node instanceof JstBlock && (varType = (block = (JstBlock)node).getVarTable().getLocalType(name)) != null) {
                return varType;
            }
            return null;
        }

        public static boolean hasLocalType(java.lang.String name, IJstNode node) {
            if (node == null) {
                return false;
            }
            if (node instanceof JstBlock) {
                JstBlock block = (JstBlock)node;
                return block.getVarTable().hasLocalType(name);
            }
            return false;
        }

        public static JstType getEmbededType(JstType jstType, java.lang.String shortName) {
            for (JstType type : jstType.getEmbededTypes()) {
                if (shortName.equals(type.getSimpleName())) {
                    return type;
                }
                JstType embeded = Type.getEmbededType(type, shortName);
                if (embeded == null) continue;
                return embeded;
            }
            return null;
        }

        public static IJstType getEmbededType(IJstType type, java.lang.String shortName, boolean recursive) {
            if (type == null) {
                return null;
            }
            IJstType embededType = type.getEmbededType(shortName);
            if (embededType != null) {
                return embededType;
            }
            for (IJstType e : type.getEmbededTypes()) {
                embededType = Type.getEmbededType(e, shortName, recursive);
                if (embededType == null) continue;
                return embededType;
            }
            return null;
        }

        public static IJstType getDependedType(JstType jstType, java.lang.String shortName) {
            JstType depended = jstType.getEmbededType(shortName);
            if (depended != null) {
                return depended;
            }
            JstType outerType = jstType.getOuterType();
            if (outerType != null) {
                if (shortName.equals(outerType.getSimpleName())) {
                    return outerType;
                }
                depended = Type.getDependedType(outerType, shortName);
                if (depended != null) {
                    return depended;
                }
            }
            Map imports = jstType.getImportsMap();
            for (Map.Entry entry : imports.entrySet()) {
                if (((java.lang.String)entry.getKey()).equals(shortName)) {
                    return (IJstType)entry.getValue();
                }
                IJstType imported = (IJstType)entry.getValue();
                depended = imported.getEmbededType(shortName);
                if (depended == null) continue;
                return depended;
            }
            return null;
        }

        public static java.lang.String getOwnerClassName(java.lang.String srcName) {
            int index;
            URL url = null;
            for (java.lang.String clsName = srcName; clsName != null; clsName = clsName.substring(0, index)) {
                url = JavaSourceLocator.getInstance().getSourceUrl(clsName);
                if (url != null) {
                    return clsName;
                }
                index = clsName.lastIndexOf(".");
                if (index > 0) {
                    continue;
                }
                return null;
            }
            return null;
        }

        public static boolean isExcluded(IJstType jstType, ASTNode astNode, BaseJstNode scopeNode) {
            JstType rootType;
            if (scopeNode == null) {
                return false;
            }
            TranslateCtx ctx = TranslateCtx.ctx();
            TranslationMode mode = ctx.getTranslateInfo(rootType = scopeNode.getRootType()).getMode();
            if (!mode.hasImplementation()) {
                return false;
            }
            if (ctx.isJavaOnly((IJstType)rootType) || ctx.isJSProxy((IJstType)rootType)) {
                return false;
            }
            IJstType baseType = TranslateHelper.getBase((IJstType)scopeNode.getOwnerType());
            if (ctx.isExcluded(baseType)) {
                return false;
            }
            return ctx.isExcluded(jstType);
        }

        public static boolean isExcluded(ASTNode astNode, JstType outerType, java.lang.String embeddedypeName, BaseJstNode scopeNode) {
            JstType ownerType = scopeNode.getOwnerType();
            if (ownerType == null || !(ownerType instanceof JstType)) {
                return false;
            }
            TranslateCtx ctx = TranslateCtx.ctx();
            TranslationMode mode = ctx.getTranslateInfo(ownerType).getMode();
            if (!mode.hasImplementation()) {
                return false;
            }
            if (ctx.isJavaOnly((IJstType)ownerType) || ctx.isJSProxy((IJstType)ownerType)) {
                return false;
            }
            IJstType baseType = TranslateHelper.getBase((IJstType)ownerType);
            if (ctx.isExcluded(baseType)) {
                return false;
            }
            CustomInfo cInfo = Type.getCustomInfo(outerType, embeddedypeName, ctx);
            return cInfo.isExcluded();
        }

        public static boolean isMapped(IJstType jstType, SimpleName astName) {
            if (jstType == null || astName == null) {
                return false;
            }
            return !astName.toString().equals(jstType.getSimpleName());
        }

        public static void validateTypeReference(IJstType jstType, ASTNode astNode, BaseJstNode scopeNode, BaseTranslator translator) {
            Type.validateTypeReference(jstType, astNode, null, scopeNode, translator);
        }

        public static void validateTypeReference(IJstType jstType, ASTNode astNode, BaseJstNode theNode, BaseJstNode scopeNode, BaseTranslator translator) {
            if (scopeNode == null) {
                return;
            }
            TranslateCtx ctx = TranslateCtx.ctx();
            BaseJstNode jstNode = theNode != null ? theNode : scopeNode;
            boolean removeParentNode = false;
            try {
                if (Type.isExcluded(jstType, astNode, scopeNode)) {
                    if (jstNode.getParentNode() == null && jstNode != scopeNode) {
                        jstNode.setParent((IJstNode)scopeNode);
                        removeParentNode = true;
                    }
                    java.lang.String msgId = jstType.getOuterType() == null ? "ExcludedType" : "ExcludedEmbeddedType";
                    ctx.getLogger().logError(msgId, java.lang.String.valueOf(jstType.getName()) + " excluded", translator, astNode, jstNode);
                }
            }
            finally {
                if (removeParentNode) {
                    jstNode.setParent(null);
                }
            }
        }

        public static void validateEmbeddedTypeReference(ASTNode astNode, JstType outerType, java.lang.String embeddedypeName, BaseJstNode theNode, BaseJstNode scopeNode, BaseTranslator translator) {
            JstType ownerType = scopeNode.getOwnerType();
            if (ownerType == null || !(ownerType instanceof JstType)) {
                return;
            }
            TranslateCtx ctx = TranslateCtx.ctx();
            if (Type.isExcluded(astNode, outerType, embeddedypeName, (BaseJstNode)ownerType)) {
                ctx.getLogger().logError("ExcludedEmbeddedType", "'" + embeddedypeName + "' of type '" + ownerType.getName() + "' or its base or outer is excluded", translator, astNode, theNode);
            }
        }

        public static JstIdentifier createIdentifier(IJstType jstType, BaseJstNode scopeNode) {
            java.lang.String typeName = jstType.getName();
            if (DataTypeHelper.getNativeType((java.lang.String)typeName) != null || DataTypeHelper.isJavaMappedToNative((java.lang.String)typeName) || String.class.getName().equals(typeName)) {
                return new JstIdentifier(DataTypeHelper.getTypeName((java.lang.String)jstType.getName()));
            }
            JstIdentifier jstIdentifier = new JstIdentifier(scopeNode.getOwnerType() == jstType ? null : jstType.getSimpleName(), VjoTranslateHelper.getStaticTypeQualifier(jstType, scopeNode));
            jstIdentifier.setJstBinding((IJstNode)jstType);
            jstIdentifier.setType(jstType);
            return jstIdentifier;
        }

        private static CustomInfo getCustomInfo(JstType jstType, java.lang.String embeddedName, TranslateCtx ctx) {
            TranslateInfo tInfo = ctx.getTranslateInfo(jstType);
            CustomInfo cInfo = tInfo.getEmbeddedTypeCustomInfo(embeddedName);
            if (cInfo != CustomInfo.NONE) {
                return cInfo;
            }
            IJstType baseType = TranslateHelper.getBase((IJstType)jstType);
            while (baseType != null && baseType instanceof JstType) {
                cInfo = Type.getCustomInfo((JstType)baseType, embeddedName, ctx);
                if (cInfo != CustomInfo.NONE) {
                    return cInfo;
                }
                baseType = TranslateHelper.getBase(baseType);
            }
            JstType outer = jstType.getOuterType();
            while (outer != null && outer instanceof JstType) {
                cInfo = Type.getCustomInfo(outer, embeddedName, ctx);
                if (cInfo != CustomInfo.NONE) {
                    return cInfo;
                }
                outer = outer.getOuterType();
            }
            return CustomInfo.NONE;
        }
    }
}

