/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.javatojs.translate.config;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.vjet.dsf.javatojs.translate.TranslateCtx;
import org.eclipse.vjet.dsf.javatojs.translate.TranslateHelper;
import org.eclipse.vjet.dsf.javatojs.util.AstBindingHelper;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstArg;

public class MethodKey {
    private final String m_name;
    private final List<String> m_argTypeNames;
    private final boolean m_isStatic;
    private final boolean m_isVarArgs;
    private final String m_key;

    public MethodKey(String name) {
        this(name, false, false, new String[0]);
    }

    public MethodKey(String name, boolean isStatic) {
        this(name, isStatic, false, new String[0]);
    }

    public MethodKey(String name, boolean isStatic, String ... argTypeNames) {
        this(name, isStatic, false, argTypeNames);
    }

    public MethodKey(String name, boolean isStatic, boolean isVarArgs, String ... argTypeNames) {
        if (name == null) {
            throw new AssertionError((Object)"name canot be null");
        }
        this.m_name = name;
        this.m_isStatic = isStatic;
        this.m_isVarArgs = isVarArgs;
        if (argTypeNames != null) {
            this.m_argTypeNames = new ArrayList<String>(argTypeNames.length);
            String[] stringArray = argTypeNames;
            int n = argTypeNames.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                this.m_argTypeNames.add(arg);
                ++n2;
            }
        } else {
            this.m_argTypeNames = Collections.emptyList();
        }
        this.m_key = MethodKey.toString(this);
    }

    public String getName() {
        return this.m_name;
    }

    public boolean isStatic() {
        return this.m_isStatic;
    }

    public boolean isVarArg() {
        return this.m_isVarArgs;
    }

    public List<String> getArgTypeNames() {
        if (this.m_argTypeNames == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_argTypeNames);
    }

    public static MethodKey genMethodKey(Method mtd) {
        String[] params = new String[mtd.getParameterTypes().length];
        int i = 0;
        while (i < mtd.getParameterTypes().length) {
            params[i] = mtd.getParameterTypes()[i].getSimpleName();
            ++i;
        }
        return new MethodKey(mtd.getName(), Modifier.isStatic(mtd.getModifiers()), mtd.isVarArgs(), params);
    }

    public static MethodKey genMethodKey(Class<?> type, String mtdName) {
        Method[] methodArray = type.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method mtd = methodArray[n2];
            if (mtd.getName().equals(mtdName)) {
                return MethodKey.genMethodKey(mtd);
            }
            ++n2;
        }
        throw new RuntimeException(String.format("Method %s not found in type %s", type.getName(), mtdName));
    }

    public static MethodKey genMethodKey(Class<?> type, String mtdName, Class<?> ... paramTypes) {
        Method[] methodArray = type.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method mtd = methodArray[n2];
            if (mtd.getName().equals(mtdName) && paramTypes.length == mtd.getParameterTypes().length) {
                int i = 0;
                boolean match = true;
                Class<?>[] classArray = mtd.getParameterTypes();
                int n3 = classArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Class<?> classtype = classArray[n4];
                    if (!classtype.getName().equals(paramTypes[i].getName())) {
                        match = false;
                    }
                    ++i;
                    ++n4;
                }
                if (match) {
                    return MethodKey.genMethodKey(mtd);
                }
            }
            ++n2;
        }
        throw new RuntimeException(String.format("Method %s not found in type %s", type.getName(), mtdName));
    }

    public static MethodKey genMethodKey(IJstMethod jstMtd) {
        if (jstMtd == null) {
            return null;
        }
        MethodDeclaration astMtd = AstBindingHelper.getAstMethod(jstMtd);
        if (astMtd != null) {
            return MethodKey.genMethodKey(astMtd);
        }
        String[] params = new String[jstMtd.getArgs().size()];
        boolean hasVarArg = false;
        int i = 0;
        while (i < params.length) {
            JstArg arg = (JstArg)jstMtd.getArgs().get(i);
            params[i] = arg.getType().getName();
            if (arg.isVariable()) {
                hasVarArg = true;
            }
            ++i;
        }
        return new MethodKey(jstMtd.getName().getName(), jstMtd.isStatic(), hasVarArg, params);
    }

    public static MethodKey genMethodKey(MethodDeclaration mtd) {
        if (mtd == null) {
            return null;
        }
        String[] params = new String[mtd.parameters().size()];
        boolean hasVarArg = false;
        int i = 0;
        while (i < mtd.parameters().size()) {
            if (mtd.parameters().get(i) instanceof SingleVariableDeclaration) {
                SingleVariableDeclaration varDec = (SingleVariableDeclaration)mtd.parameters().get(i);
                params[i] = varDec.getType().toString();
                if (varDec.isVarargs()) {
                    hasVarArg = true;
                }
            } else {
                TranslateCtx ctx = TranslateCtx.ctx();
                ctx.getLogger().logError(ctx.getErrorReporter(), "Unknown type found while getting MethodKey from MethodDeclaration", (ASTNode)mtd);
            }
            ++i;
        }
        return new MethodKey(mtd.getName().getFullyQualifiedName(), TranslateHelper.isStatic(mtd.modifiers()), hasVarArg, params);
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        return this.m_key.equals(MethodKey.toString((MethodKey)obj));
    }

    public String toString() {
        return this.m_key;
    }

    public int hashCode() {
        return this.m_key.hashCode();
    }

    public static String toString(MethodKey key) {
        if (key == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        if (key.m_isStatic) {
            sb.append("S:");
        }
        sb.append(key.m_name).append(":");
        for (String arg : key.m_argTypeNames) {
            sb.append(arg).append(",");
        }
        if (key.m_isVarArgs) {
            sb.append("V");
        }
        return sb.toString();
    }
}

