/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.javatojs.translate.custom.meta;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.vjet.dsf.javatojs.translate.custom.meta.CustomType;
import org.eclipse.vjet.dsf.javatojs.translate.custom.meta.ICustomMetaProvider;
import org.eclipse.vjet.dsf.javatojs.translate.custom.meta.IPrivilegedProcessor;

public abstract class BaseCustomMetaProvider
implements ICustomMetaProvider {
    private Map<String, CustomType> m_customTypes = new HashMap<String, CustomType>();
    private Map<String, IPrivilegedProcessor> m_processors = new HashMap<String, IPrivilegedProcessor>();
    private Map<String, IPrivilegedProcessor> m_ctrProcessors = new HashMap<String, IPrivilegedProcessor>();
    private Map<String, Map<String, IPrivilegedProcessor>> m_mtdProcessors = new HashMap<String, Map<String, IPrivilegedProcessor>>();
    private Map<String, Map<String, IPrivilegedProcessor>> m_fldProcessors = new HashMap<String, Map<String, IPrivilegedProcessor>>();

    @Override
    public CustomType getCustomType(String javaTypeName) {
        return this.m_customTypes.get(javaTypeName);
    }

    @Override
    public IPrivilegedProcessor getPrivilegedTypeProcessor(String typeName) {
        return this.m_processors.get(typeName);
    }

    @Override
    public IPrivilegedProcessor getPrivilegedConstructorProcessor(String typeName) {
        return this.m_ctrProcessors.get(typeName);
    }

    @Override
    public IPrivilegedProcessor getPrivilegedMethodProcessor(String typeName, String mtdName) {
        Map<String, IPrivilegedProcessor> processors = this.m_mtdProcessors.get(typeName);
        if (processors != null) {
            return processors.get(mtdName);
        }
        return null;
    }

    @Override
    public IPrivilegedProcessor getPrivilegedFieldProcessor(String typeName, String fldName) {
        Map<String, IPrivilegedProcessor> processors = this.m_fldProcessors.get(typeName);
        if (processors != null) {
            return processors.get(fldName);
        }
        return null;
    }

    public void addCustomType(String typeName, CustomType cType) {
        assert (typeName != null) : "typeName is null";
        assert (cType != null) : "cType is null";
        this.m_customTypes.put(typeName, cType);
    }

    public void addPrivilegedTypeProcessor(String typeName, IPrivilegedProcessor processor) {
        assert (typeName != null) : "typeName is null";
        assert (processor != null) : "processor is null";
        this.m_processors.put(typeName, processor);
    }

    public void addPrivilegedConstructorProcessor(String typeName, IPrivilegedProcessor processor) {
        assert (typeName != null) : "typeName is null";
        assert (processor != null) : "processor is null";
        this.m_ctrProcessors.put(typeName, processor);
    }

    public void addPrivilegedMethodProcessor(String typeName, String mtdName, IPrivilegedProcessor processor) {
        assert (typeName != null) : "typeName is null";
        assert (mtdName != null) : "mtdName is null";
        assert (processor != null) : "processor is null";
        Map<String, IPrivilegedProcessor> mtdProcessors = this.m_mtdProcessors.get(typeName);
        if (mtdProcessors == null) {
            mtdProcessors = new HashMap<String, IPrivilegedProcessor>();
            this.m_mtdProcessors.put(typeName, mtdProcessors);
        }
        mtdProcessors.put(mtdName, processor);
    }

    public void addPrivilegedFieldProcessor(String typeName, String fieldName, IPrivilegedProcessor processor) {
        assert (typeName != null) : "typeName is null";
        assert (fieldName != null) : "fieldName is null";
        assert (processor != null) : "processor is null";
        Map<String, IPrivilegedProcessor> fieldProcessors = this.m_fldProcessors.get(typeName);
        if (fieldProcessors == null) {
            fieldProcessors = new HashMap<String, IPrivilegedProcessor>();
            this.m_fldProcessors.put(typeName, fieldProcessors);
        }
        fieldProcessors.put(fieldName, processor);
    }
}

