/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.javatojs.translate.custom.meta;

import org.eclipse.vjet.dsf.common.Z;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.javatojs.translate.config.MethodKey;
import org.eclipse.vjet.dsf.javatojs.translate.custom.CustomAttr;
import org.eclipse.vjet.dsf.javatojs.translate.custom.meta.CustomType;

public class CustomMethod {
    private MethodKey m_mtdKey;
    private String m_javaName;
    private String m_jstName;
    private String m_jstOrigName;
    private String m_jstRtnTypeName;
    private boolean m_isPty;
    private String m_jstOwnerType;
    private String m_delegateType;
    private boolean m_removeQualifier = false;
    private boolean m_lookupBySignature = true;
    private CustomAttr m_attr = CustomAttr.NONE;
    private CustomType m_cType;

    public CustomMethod(MethodKey mtdKey) {
        this(mtdKey, mtdKey != null ? mtdKey.getName() : null);
    }

    public CustomMethod(String javaName) {
        this(javaName, javaName);
    }

    public CustomMethod(MethodKey mtdKey, String jstName) {
        if (mtdKey == null) {
            throw new DsfRuntimeException("mtdKey cannot be null");
        }
        this.m_mtdKey = mtdKey;
        this.m_javaName = this.m_mtdKey.getName();
        this.m_jstName = jstName;
    }

    public CustomMethod(String javaName, String jstName) {
        if (javaName == null) {
            throw new DsfRuntimeException("javaName cannot be null");
        }
        this.m_mtdKey = new MethodKey(javaName);
        this.m_javaName = javaName;
        this.m_jstName = jstName;
        this.m_lookupBySignature = false;
    }

    public MethodKey getKey() {
        return this.m_mtdKey;
    }

    public String getJavaName() {
        return this.m_javaName;
    }

    public CustomMethod setJstName(String jstName) {
        this.m_jstName = jstName;
        return this;
    }

    public String getJstName() {
        return this.m_jstName;
    }

    public CustomMethod setJstOrigName(String jstOrigName) {
        this.m_jstOrigName = jstOrigName;
        return this;
    }

    public String getJstOrigName() {
        return this.m_jstOrigName;
    }

    public CustomMethod setJstReturnTypeName(String typeName) {
        this.m_jstRtnTypeName = typeName;
        return this;
    }

    public String getJstReturnTypeName() {
        return this.m_jstRtnTypeName;
    }

    public CustomMethod setIsProperty(boolean isPty) {
        this.m_isPty = isPty;
        return this;
    }

    public boolean isProperty() {
        return this.m_isPty;
    }

    public CustomMethod setJstOwnerTypeName(String jstOwnerTypeName) {
        this.m_jstOwnerType = jstOwnerTypeName;
        return this;
    }

    public String getJstOwnerTypeName() {
        return this.m_jstOwnerType;
    }

    public CustomMethod removeQualifier(boolean removeQualifier) {
        this.m_removeQualifier = removeQualifier;
        return this;
    }

    public boolean getRemoveQualifier() {
        return this.m_removeQualifier;
    }

    public CustomMethod setDelegateTypeName(String delegateType) {
        this.m_delegateType = delegateType;
        return this;
    }

    public String getDelegateTypeName() {
        return this.m_delegateType;
    }

    public CustomMethod setLookupBySignature(boolean lookupBySignature) {
        this.m_lookupBySignature = lookupBySignature;
        return this;
    }

    public boolean isLookupBySignature() {
        return this.m_lookupBySignature;
    }

    public CustomMethod setAttr(CustomAttr attr) {
        this.m_attr = attr == null ? CustomAttr.NONE : attr;
        return this;
    }

    public CustomAttr getAttr() {
        if (this.m_attr != null) {
            return this.m_attr;
        }
        return CustomAttr.NONE;
    }

    public CustomMethod setCustomType(CustomType cType) {
        this.m_cType = cType;
        return this;
    }

    public CustomType getCustomType() {
        return this.m_cType;
    }

    public String toString() {
        Z z = new Z();
        z.format("m_mtdKey", (Object)this.m_mtdKey);
        z.format("m_jstName", (Object)this.m_jstName);
        z.format("m_jstOrigName", (Object)this.m_jstOrigName);
        z.format("m_jstRtnTypeName", (Object)this.m_jstRtnTypeName);
        z.format("m_isPty", this.m_isPty);
        z.format("m_jstOwnerType", (Object)this.m_jstOwnerType);
        z.format("m_delegateType", (Object)this.m_delegateType);
        z.format("m_removeQualifier", this.m_removeQualifier);
        z.format("m_lookupBySignature", this.m_lookupBySignature);
        z.format("m_attr", (Object)this.m_attr);
        z.format("m_cType", this.m_cType == null ? null : this.m_cType.getJavaName());
        return z.toString();
    }
}

