/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.javatojs.translate.policy;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.vjet.dsf.common.Z;

public class Pkg {
    private String m_name;
    private List<String> m_exemptedClz = new ArrayList<String>();
    private List<String> m_exemptedPkgs = new ArrayList<String>();

    public Pkg(String name) {
        assert (name != null) : "pkg name cannot be null";
        this.m_name = name.endsWith("*") ? name : String.valueOf(name) + ".";
    }

    public Pkg(Class<?> anchorCls) {
        this(anchorCls, false);
    }

    public Pkg(Class<?> anchorCls, boolean recursive) {
        assert (anchorCls != null) : "pkg name cannot be null";
        String pkgName = anchorCls.getPackage().getName();
        if (recursive) {
            pkgName = String.valueOf(pkgName) + ".*";
        }
        this.m_name = pkgName;
    }

    public boolean containsClass(String clsName) {
        if (clsName == null) {
            return false;
        }
        int index = clsName.lastIndexOf(".");
        if (index < 1 || clsName.length() <= index + 1) {
            return false;
        }
        for (String exemptedClz : this.m_exemptedClz) {
            if (!Pkg.matches(exemptedClz, clsName)) continue;
            return false;
        }
        String pkgName = clsName.substring(0, index + 1);
        for (String exemptedPkg : this.m_exemptedPkgs) {
            if (!Pkg.matches(exemptedPkg, pkgName)) continue;
            return false;
        }
        return Pkg.matches(this.m_name, pkgName);
    }

    public Pkg addExemptedClass(Class cls) {
        if (cls == null) {
            return this;
        }
        return this.addExemptedClass(cls.getName());
    }

    public Pkg addExemptedClass(String clsName) {
        if (clsName == null) {
            return this;
        }
        if (!this.m_exemptedClz.contains(clsName)) {
            this.m_exemptedClz.add(clsName);
        }
        return this;
    }

    public Pkg addExemptedPkg(String pkgName) {
        String string = pkgName = pkgName.endsWith("*") ? pkgName : String.valueOf(pkgName) + ".";
        if (!this.m_exemptedPkgs.contains(pkgName)) {
            this.m_exemptedPkgs.add(pkgName);
        }
        return this;
    }

    public String toString() {
        Z z = new Z();
        z.format("m_name", (Object)this.m_name);
        return z.toString();
    }

    static boolean matches(String pattern, String text) {
        text = String.valueOf(text) + '\u0000';
        pattern = String.valueOf(pattern) + '\u0000';
        int N = pattern.length();
        boolean[] states = new boolean[N + 1];
        boolean[] old = new boolean[N + 1];
        old[0] = true;
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            states = new boolean[N + 1];
            int j = 0;
            while (j < N) {
                char p = pattern.charAt(j);
                if (old[j] && p == '*') {
                    old[j + 1] = true;
                }
                if (old[j] && p == c) {
                    states[j + 1] = true;
                }
                if (old[j] && p == '*') {
                    states[j] = true;
                }
                if (old[j] && p == '*') {
                    states[j + 1] = true;
                }
                ++j;
            }
            old = states;
            ++i;
        }
        return states[N];
    }
}

