/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jsgen.shared.generate;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;
import org.eclipse.vjet.dsf.jsgen.shared.generate.CodeStyle;
import org.eclipse.vjet.dsf.jsgen.shared.generate.DefaultJsrFilters;
import org.eclipse.vjet.dsf.jsgen.shared.generate.GeneratorConfig;
import org.eclipse.vjet.dsf.jsgen.shared.generate.ICustomJsrProvider;
import org.eclipse.vjet.dsf.jsgen.shared.generate.IJsrFilters;
import org.eclipse.vjet.dsf.jsgen.shared.generate.IJsrGenListener;
import org.eclipse.vjet.dsf.jsgen.shared.generate.IJsrTypeProvider;
import org.eclipse.vjet.dsf.jsgen.shared.generate.Indenter;
import org.eclipse.vjet.dsf.jsgen.shared.generate.JsrTypeProvider;
import org.eclipse.vjet.dsf.jsgen.shared.generate.SimpleParam;
import org.eclipse.vjet.dsf.jsgen.shared.generate.SourceGenerator;
import org.eclipse.vjet.dsf.jsnative.anno.Alias;
import org.eclipse.vjet.dsf.jsnative.anno.JsNativeMeta;
import org.eclipse.vjet.dsf.jsnative.global.Boolean;
import org.eclipse.vjet.dsf.jsnative.global.Object;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstOType;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.IJstRefType;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.IJstTypeReference;
import org.eclipse.vjet.dsf.jst.ISynthesized;
import org.eclipse.vjet.dsf.jst.declaration.JstArg;
import org.eclipse.vjet.dsf.jst.declaration.JstArray;
import org.eclipse.vjet.dsf.jst.declaration.JstCache;
import org.eclipse.vjet.dsf.jst.declaration.JstFactory;
import org.eclipse.vjet.dsf.jst.declaration.JstFunctionRefType;
import org.eclipse.vjet.dsf.jst.declaration.JstMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstMixedType;
import org.eclipse.vjet.dsf.jst.declaration.JstObjectLiteralType;
import org.eclipse.vjet.dsf.jst.declaration.JstPackage;
import org.eclipse.vjet.dsf.jst.declaration.JstParamType;
import org.eclipse.vjet.dsf.jst.declaration.JstProxyMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstProxyProperty;
import org.eclipse.vjet.dsf.jst.declaration.JstProxyType;
import org.eclipse.vjet.dsf.jst.declaration.JstRefType;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.declaration.JstTypeWithArgs;
import org.eclipse.vjet.dsf.jst.declaration.JstWildcardType;
import org.eclipse.vjet.dsf.jst.util.DataTypeHelper;

public class JsrGenerator
extends SourceGenerator {
    private static final String DEFAULT_PARAM_PREFIX = "p";
    private static final String SERIAL_ID = "private static final long serialVersionUID = 1L;";
    private static final String NATIVE_OBJECT = "Object";
    private static final String JS_OBJ = "JsObj";
    private static final String JSR_SUFFIX = "Jsr";
    private static final String JSOBJDATA_VAR_NAME = "S";
    private static final String IMPORT = "import ";
    private static final String PACKAGE = "package ";
    private boolean m_skip_methods = false;
    private GeneratorConfig m_config;
    private ICustomJsrProvider m_customJsrProvider;
    private List<IJsrGenListener> m_listeners = new ArrayList<IJsrGenListener>();
    private IJsrTypeProvider m_JsToJavaMapper = new JsrTypeProvider();
    private IJstType m_clzType = null;
    private TypeMetaMgr m_javaTypeMgr = null;
    private TypeMetaMgr m_jsNativeTypeMgr = null;
    private TypeMetaMgr m_jsrTypeMgr = null;
    private TypeMetaMgr m_vjoSerializableTypeMgr = null;
    private List<MethodMeta> m_constructors = null;
    private List<MethodMeta> m_staticMethods = null;
    private List<MethodMeta> m_instanceMethods = null;
    private List<IJstProperty> m_staticProperties = null;
    private List<IJstProperty> m_instanceProperties = null;
    private Map<String, IJstType> m_inactiveNeedsFromMixin = null;
    private Set<IJstType> m_importExclusionList = null;
    private Map<String, Integer> m_overloadedMap = null;
    private boolean m_needsPropSetter = false;
    private boolean m_needsJsEnum = false;
    private boolean m_hasProp = false;
    private boolean m_hasFunction = false;
    private boolean m_needsIValueBinding = false;
    private boolean m_needsJsObj = false;
    private boolean m_needsObjectLiteral = false;
    private boolean m_needsFuncRef = false;
    private boolean m_oTypeNeedsJsObj = false;
    private boolean m_enableScriptingJava = false;
    private int m_initialIndent = 0;
    private boolean m_hasGenericParams = false;
    private boolean m_needsTypeRef = false;
    private static final String SUPER_FNREF_CALL = "super(obj,funcName);";
    private static final String FNREF_JSOBJ_ARGS = "(JsObj obj, String funcName)";
    private static final String FNREF_JSOBJDATA_ARGS = "(JsObjData obj, String funcName)";
    private static final List<SimpleParam> EMPTY_LIST = new ArrayList<SimpleParam>(0);
    private static final Stack<SimpleParam> EMPTY_STACK = new Stack();
    private static final Map<String, String> s_javaWrapperTypes = new HashMap<String, String>();

    static {
        s_javaWrapperTypes.put(java.lang.Boolean.TYPE.getName(), java.lang.Boolean.class.getSimpleName());
        s_javaWrapperTypes.put(Byte.TYPE.getName(), Byte.class.getSimpleName());
        s_javaWrapperTypes.put(Short.TYPE.getName(), Short.class.getSimpleName());
        s_javaWrapperTypes.put(Integer.TYPE.getName(), Integer.class.getSimpleName());
        s_javaWrapperTypes.put(Long.TYPE.getName(), Long.class.getSimpleName());
        s_javaWrapperTypes.put(Float.TYPE.getName(), Float.class.getSimpleName());
        s_javaWrapperTypes.put(Double.TYPE.getName(), Double.class.getSimpleName());
        s_javaWrapperTypes.put(Character.TYPE.getName(), Character.class.getSimpleName());
    }

    public JsrGenerator(PrintWriter writer, CodeStyle style, IJsrFilters filters) {
        super(writer, new Indenter(writer, style), style);
        this.m_config = new GeneratorConfig(filters);
        this.m_customJsrProvider = this.m_config.getJsrGenConfig().getCustomJsrProvider();
    }

    public JsrGenerator(PrintWriter writer, CodeStyle style, GeneratorConfig config) {
        super(writer, new Indenter(writer, style), style);
        this.m_config = config;
        this.m_customJsrProvider = config.getJsrGenConfig().getCustomJsrProvider();
    }

    public JsrGenerator(PrintWriter writer, CodeStyle style) {
        this(writer, style, new DefaultJsrFilters());
    }

    public void addListener(IJsrGenListener listener) {
        if (listener == null) {
            return;
        }
        this.m_listeners.add(listener);
    }

    public JsrGenerator writeJsr(IJstType type) {
        return this.writeJsr(type, false);
    }

    public JsrGenerator writeJsr(IJstType type, JsrGenerator parentJsr) {
        return this.writeJsr(type, false);
    }

    public JsrGenerator writeJsr(IJstType type, boolean enableScriptingJava) {
        if (type == null) {
            throw new NullPointerException("Invalid input, JstType cannot be null");
        }
        this.m_enableScriptingJava = enableScriptingJava;
        for (IJsrGenListener listener : this.m_listeners) {
            listener.initialize(type);
        }
        this.setUp(type);
        if (type.isOType()) {
            return this.writeOTypeJsr(type);
        }
        int i = 0;
        while (i < this.m_initialIndent) {
            this.indent();
            ++i;
        }
        if (this.m_clzType.isEmbededType()) {
            this.writeIndent();
            this.setupDefaultExtend(true);
        } else {
            this.writePkg();
            this.writeNewline();
            this.writeImports();
            this.writeNewline();
            this.writeCodeGenMarker(JsrGenerator.class);
            this.writeNewline();
        }
        String jsrName = String.valueOf(type.getSimpleName()) + JSR_SUFFIX;
        this.writeJsrClassDefinition(jsrName);
        this.getWriter().append(" {");
        this.indent();
        boolean writeStatic = false;
        if (type.isInterface() || type.isMixin()) {
            if (!this.m_clzType.isEmbededType()) {
                this.writeJsrStaticDeclaration(jsrName);
                this.writeJsrResourceSpec(type);
            }
        } else {
            this.writeNewlineAndIndent();
            this.getWriter().append(SERIAL_ID);
            this.writeNewline();
            boolean bl = writeStatic = this.m_clzType.getModifiers().isStatic() || !this.m_clzType.isEmbededType();
            if (writeStatic) {
                this.writeJsrStaticDeclaration(jsrName);
            }
            if (!this.m_clzType.isEmbededType()) {
                this.writeJsrResourceSpec(type);
            }
            if (!this.m_skip_methods) {
                this.writeConstructors(jsrName);
            }
            this.writeJsObjProtectedConstructor(jsrName);
            for (IJsrGenListener listener : this.m_listeners) {
                listener.postConstructors(this.getWriter(), this.getStyle());
            }
        }
        if (!type.isMixin() && !this.m_skip_methods) {
            this.writeProps();
            this.writeProtos();
        }
        List embededTypes = this.m_clzType.getEmbededTypes();
        if (!this.m_clzType.isMixin() && embededTypes.size() > 0) {
            this.writeNewline();
            for (IJstType embededType : embededTypes) {
                if (!this.isSameGroup(this.m_clzType, embededType) || embededType.isMixin() || embededType.getModifiers().isPrivate()) continue;
                this.writeNewline();
                JsrGenerator sibJsr = new JsrGenerator(this.getWriter(), this.getStyle(), this.m_config.getFilters());
                sibJsr.setNewline(this.getNewline());
                sibJsr.setInitialIndent(this.m_initialIndent + 1);
                sibJsr.writeJsr(embededType, this);
            }
        }
        if (!this.m_skip_methods && this.needPrototype(this.m_clzType)) {
            this.writeTypeRef();
        }
        this.outdent();
        this.writeNewline();
        if (this.m_clzType.isEmbededType()) {
            this.writeIndent();
        }
        this.getWriter().append("}");
        return this;
    }

    private boolean needPrototype(IJstType type) {
        if (type.isOType() || type.isMixin()) {
            return false;
        }
        if (type.isEmbededType()) {
            return type.getModifiers().isStatic() || type.getOuterType().isInterface();
        }
        return true;
    }

    public JsrGenerator writeOTypeJsr(IJstType type) {
        this.writePkg();
        this.writeNewline();
        this.writeImports();
        this.writeNewline();
        this.writeCodeGenMarker(JsrGenerator.class);
        this.writeNewline();
        String jsrName = String.valueOf(type.getSimpleName()) + JSR_SUFFIX;
        this.writeOTypeJsrClassDefinition(jsrName);
        this.getWriter().append(" {");
        this.indent();
        this.writeNewlineAndIndent();
        this.writeJsrStaticDeclaration(jsrName);
        this.writeJsrResourceSpec(type);
        List otypes = type.getOTypes();
        this.outdent();
        this.writeNewline();
        if (otypes.size() > 0) {
            this.writeOTypes(otypes);
        }
        this.outdent();
        this.writeNewline();
        this.getWriter().append("}");
        return this;
    }

    private void setUp(IJstType type) {
        this.m_clzType = type;
        if (this.m_config.getFilters().isSkipMethodAndProperties(type.getName())) {
            this.m_skip_methods = true;
        }
        this.m_JsToJavaMapper.setCurrentType(type);
        this.m_javaTypeMgr = new TypeMetaMgr(this.m_config.getFilters());
        this.m_jsNativeTypeMgr = new TypeMetaMgr(this.m_config.getFilters());
        this.m_jsrTypeMgr = new TypeMetaMgr();
        this.m_vjoSerializableTypeMgr = new TypeMetaMgr();
        this.m_constructors = new ArrayList<MethodMeta>();
        this.m_staticMethods = new ArrayList<MethodMeta>();
        this.m_instanceMethods = new ArrayList<MethodMeta>();
        this.m_staticProperties = new ArrayList<IJstProperty>();
        this.m_instanceProperties = new ArrayList<IJstProperty>();
        this.m_importExclusionList = new HashSet<IJstType>();
        this.m_overloadedMap = new HashMap<String, Integer>();
        this.m_inactiveNeedsFromMixin = new HashMap<String, IJstType>();
        this.m_needsPropSetter = false;
        this.m_hasProp = false;
        this.m_hasFunction = false;
        this.m_needsIValueBinding = false;
        this.m_needsJsObj = false;
        this.m_hasGenericParams = false;
        this.analyze();
    }

    private void analyze() {
        this.m_needsJsEnum = this.m_clzType.isEnum();
        this.m_needsJsObj = !this.m_needsJsEnum && !this.m_clzType.isInterface() && !this.hasNonDefaultExtend(this.m_clzType);
        this.m_jsrTypeMgr.addToSimpleNameMap(new TypeMeta(String.valueOf(this.m_clzType.getName()) + JSR_SUFFIX, String.valueOf(this.m_clzType.getSimpleName()) + JSR_SUFFIX, false));
        if (this.m_clzType.isEnum() && this.m_clzType.getEnumValues().size() > 0) {
            this.m_hasProp = true;
        }
        this.processJsrTypeImports();
        boolean bl = this.m_hasGenericParams = this.m_clzType.getParamTypes().size() > 0;
        if (!this.m_hasGenericParams) {
            this.m_hasGenericParams = this.processGenericParams(this.m_clzType);
        }
        LinkedHashSet<IJstType> typeSet = new LinkedHashSet<IJstType>();
        for (IJstOType type : this.m_clzType.getOTypes()) {
            if (type instanceof JstObjectLiteralType) {
                this.m_needsObjectLiteral = true;
                if (((JstObjectLiteralType)type).getProperties().size() > 0) {
                    this.m_needsIValueBinding = true;
                    this.collectTypeFromProperties(typeSet, ((JstObjectLiteralType)type).getProperties(), false, false);
                }
            }
            if (!(type instanceof JstFunctionRefType)) continue;
            this.m_needsFuncRef = true;
            this.m_oTypeNeedsJsObj = true;
            this.collectTypeFromMethod(((JstFunctionRefType)type).getMethodRef(), typeSet, false);
        }
        this.processMixins(typeSet);
        if (!this.m_skip_methods) {
            if (this.needPrototype(this.m_clzType)) {
                this.m_needsTypeRef = true;
            }
            this.collectTypeFromProperties(typeSet, this.m_clzType.getProperties(), false, this.m_clzType.isInterface());
            this.collectTypeFromMethods(typeSet, this.m_clzType.getMethods(), false);
            IJstMethod constructor = this.m_clzType.getConstructor();
            if (constructor != null && !(constructor instanceof ISynthesized)) {
                this.collectTypeFromMethod(constructor, typeSet, false);
            }
            List embededTypes = this.m_clzType.getEmbededTypes();
            this.collectTypesFromEmbeded(typeSet, embededTypes);
            this.addJavaTypeImport(typeSet);
        } else {
            this.processEmbeddedForJsrTypes(this.m_clzType.getEmbededTypes());
        }
        this.processInnersForJsrType();
    }

    private void processEmbeddedForJsrTypes(List<? extends IJstType> embededTypes) {
        for (IJstType iJstType : embededTypes) {
            if (iJstType.getModifiers().isPrivate()) continue;
            if (iJstType.isEnum()) {
                this.m_needsJsEnum = true;
            } else if (!this.hasNonDefaultExtend(iJstType) && !iJstType.isInterface()) {
                this.m_needsJsObj = true;
            }
            if (!this.m_skip_methods && iJstType.isEnum() && iJstType.getEnumValues().size() > 0) {
                this.m_hasProp = true;
            }
            if (!this.m_skip_methods && this.needPrototype(iJstType)) {
                this.m_needsTypeRef = true;
            }
            if (iJstType.getEmbededTypes().size() <= 0) continue;
            this.processEmbeddedForJsrTypes(iJstType.getEmbededTypes());
        }
    }

    private boolean processGenericParams(IJstType type) {
        for (IJstType t : type.getExtends()) {
            if (t.getParamTypes().size() > 0) {
                return true;
            }
            if (!this.processGenericParams(t)) continue;
            return true;
        }
        for (IJstType t : type.getSatisfies()) {
            if (t.getParamTypes().size() > 0) {
                return true;
            }
            if (!this.processGenericParams(t)) continue;
            return true;
        }
        return false;
    }

    private void collectTypesFromEmbeded(Set<IJstType> typeSet, List<? extends IJstType> embededTypes) {
        this.processEmbeddedForJsrTypes(embededTypes);
        for (IJstType iJstType : embededTypes) {
            if (iJstType.getModifiers().isPrivate()) continue;
            this.collectTypeFromProperties(typeSet, iJstType.getProperties(), true, iJstType.isInterface());
            this.collectTypeFromMethods(typeSet, iJstType.getMethods(), true);
            this.collectTypeFromMethod(iJstType.getConstructor(), typeSet, true);
            if (iJstType.getEmbededTypes().size() <= 0) continue;
            this.collectTypesFromEmbeded(typeSet, iJstType.getEmbededTypes());
        }
    }

    private boolean hasNonDefaultExtend(IJstType type) {
        IJstType extend = type.getExtend();
        if (extend == null) {
            return false;
        }
        return !this.m_config.getFilters().isSkipExtends(extend) && !this.isObjectType(extend);
    }

    private void writeImports() {
        if (this.m_clzType.isOType()) {
            this.writeOtypeImports();
        } else {
            if (!this.m_clzType.isMixin()) {
                this.writeFrameworkImports();
            }
            this.writeImport("org.eclipse.vjet.vsf.jsref.JsObjData");
            this.writeResourceSpecImports();
        }
        Iterator<TypeMeta> itr = this.m_jsrTypeMgr.getMetaItr();
        while (itr.hasNext()) {
            TypeMeta meta = itr.next();
            if (meta.m_inactiveType && this.m_clzType.isMixin() || meta.m_useFullName && (meta.m_inactiveType || !meta.m_usedInDecl)) continue;
            this.writeImport(meta.m_fullName);
        }
        for (IJsrGenListener listener : this.m_listeners) {
            listener.postImports(new ArrayList<String>(0), this.getWriter(), this.getStyle());
        }
    }

    private void writeFrameworkImports() {
        if (this.m_hasFunction) {
            this.writeImport("org.eclipse.vjet.vsf.jsref.JsFunc");
        }
        if (this.m_needsIValueBinding) {
            this.writeImport("org.eclipse.vjet.dsf.common.binding.IValueBinding");
        }
        this.setupDefaultExtend(false);
        if (this.m_hasProp) {
            this.writeImport("org.eclipse.vjet.vsf.jsref.JsProp");
        }
        if (this.m_needsPropSetter) {
            this.writeImport("org.eclipse.vjet.vsf.jsruntime.jsref.IJsPropSetter");
        }
        if (!this.m_clzType.isInterface() || this.hasNonInterfaceInnerTypes(this.m_clzType.getEmbededTypes())) {
            this.writeImport("org.eclipse.vjet.vsf.jsref.internals.JsCmpMeta");
        }
        if (!this.m_skip_methods || this.m_needsTypeRef) {
            this.writeImport("org.eclipse.vjet.vsf.jsref.JsTypeRef");
        }
    }

    private void writeOtypeImports() {
        if (this.m_needsObjectLiteral) {
            if (this.m_needsIValueBinding) {
                this.writeImport("org.eclipse.vjet.dsf.common.binding.IValueBinding");
                this.writeImport("org.eclipse.vjet.vsf.jsref.internals.BV");
            }
            this.writeImport("org.eclipse.vjet.vsf.jsref.JsObjectLiteral");
        }
        if (this.m_needsFuncRef) {
            this.writeImport("org.eclipse.vjet.vsf.jsref.JsFuncRef");
        }
        if (this.m_oTypeNeedsJsObj) {
            this.writeImport("org.eclipse.vjet.vsf.jsref.JsObj");
        }
        if (this.m_needsTypeRef) {
            this.writeImport("org.eclipse.vjet.vsf.jsref.JsTypeRef");
        }
        this.writeImport("org.eclipse.vjet.vsf.jsref.JsObjData");
        this.writeResourceSpecImports();
    }

    private void writeResourceSpecImports() {
        if (this.m_config.getJsrGenConfig().isGenResouceSpec()) {
            this.writeImport("org.eclipse.vjet.dsf.spec.component.IComponentSpec");
            this.writeImport("org.eclipse.vjet.vsf.resource.pattern.js.JsResource");
            this.writeImport("org.eclipse.vjet.vsf.resource.pattern.js.IJsResourceRef");
        }
    }

    private boolean hasNonInterfaceInnerTypes(List<? extends IJstType> list) {
        for (IJstType iJstType : list) {
            if (iJstType.isInterface() && !this.hasNonInterfaceInnerTypes(iJstType.getEmbededTypes())) continue;
            return true;
        }
        return false;
    }

    private void setupDefaultExtend(boolean noImport) {
        if (!noImport) {
            if (this.m_needsJsEnum) {
                this.writeImport("org.eclipse.vjet.vsf.jsref.JsEnum");
            }
            if (this.m_needsJsObj) {
                this.writeImport("org.eclipse.vjet.vsf.jsref.JsObj");
            }
        }
    }

    private void writeJsrClassDefinition(String jsrName) {
        PrintWriter writer = this.getWriter();
        writer.append("public ");
        if (this.m_clzType.isEmbededType() && this.m_clzType.getModifiers().isStatic()) {
            writer.append("static ");
        }
        if (this.m_clzType.isInterface()) {
            writer.append("interface ");
        } else {
            if (this.m_clzType.getModifiers().isFinal()) {
                writer.append("final ");
            }
            if (this.m_clzType.getModifiers().isAbstract() || this.m_clzType.isMixin()) {
                writer.append("abstract ");
            }
            writer.append("class ");
        }
        writer.append(jsrName);
        if (!this.m_clzType.getParamNames().isEmpty()) {
            writer.append(this.getParamsDecoration(this.m_clzType));
        }
        if (this.m_clzType.isInterface()) {
            List extendedTypes = this.m_clzType.getExtends();
            if (!extendedTypes.isEmpty()) {
                writer.append(" extends ");
                int i = 0;
                while (i < extendedTypes.size()) {
                    if (i > 0) {
                        writer.append(",").append(" ");
                    }
                    writer.append(this.getJsrNameForTypeDecl((IJstType)extendedTypes.get(i)));
                    ++i;
                }
            }
        } else if (!this.m_clzType.isMixin()) {
            if (this.hasNonDefaultExtend(this.m_clzType)) {
                writer.append(" extends ");
                writer.append(this.getJsrNameForTypeDecl(this.m_clzType.getExtend()));
            } else if (this.m_clzType.isEnum()) {
                writer.append(" extends JsEnum");
            } else {
                writer.append(" extends ").append(JS_OBJ);
            }
        }
        ArrayList<IJstType> interfaceTypes = new ArrayList<IJstType>();
        for (IJstType type : this.m_clzType.getSatisfies()) {
            interfaceTypes.add(type);
        }
        if (!interfaceTypes.isEmpty()) {
            boolean addComma = false;
            StringBuilder buf = new StringBuilder();
            int i = 0;
            while (i < interfaceTypes.size()) {
                IJstType itfType = (IJstType)interfaceTypes.get(i);
                if (!this.m_config.getFilters().isSkipSatisfies(itfType)) {
                    if (addComma) {
                        buf.append(",").append(" ");
                    }
                    buf.append(this.getJsrNameForTypeDecl(itfType));
                    addComma = true;
                }
                ++i;
            }
            if (buf.length() > 0) {
                writer.append(" implements ").append(buf.toString());
            }
        }
        for (IJsrGenListener listener : this.m_listeners) {
            listener.postInterfaces(writer, this.getStyle());
        }
    }

    private void writeOTypeJsrClassDefinition(String jsrName) {
        PrintWriter writer = this.getWriter();
        writer.append("public abstract class ").append(jsrName);
    }

    private void writeImport(String fullName) {
        this.getWriter().append(IMPORT).append(fullName).append(";");
        this.writeNewline();
    }

    private void writeJsrStaticDeclaration(String jsrName) {
        this.writeNewlineAndIndent();
        if (!this.m_clzType.isInterface()) {
            this.getWriter().append("private static final ");
        }
        this.getWriter().append("JsObjData ").append(JSOBJDATA_VAR_NAME).append(" = ");
        this.indent();
        this.writeNewlineAndIndent();
        this.getWriter().append(this.getNewJsObjDataString(this.m_clzType, jsrName)).append(";");
        this.outdent();
    }

    private void writeJsrResourceSpec(IJstType type) {
        if (!this.m_config.getJsrGenConfig().isGenResouceSpec()) {
            return;
        }
        this.writeNewline();
        this.writeNewlineAndIndent();
        PrintWriter writer = this.getWriter();
        this.writeNewlineAndIndent();
        writer.append("public static class ResourceSpec {");
        this.indent();
        this.writeNewlineAndIndent();
        writer.append("public static IComponentSpec getInstance() {");
        this.indent();
        this.writeNewlineAndIndent();
        writer.append("return S.getResourceSpec();").append(" ");
        this.outdent();
        this.writeNewlineAndIndent();
        writer.append("}");
        this.writeNewlineAndIndent();
        writer.append("public static final JsResource RESOURCE = S.getJsResource()").append(";");
        this.writeNewlineAndIndent();
        writer.append("public static final IJsResourceRef REF = S.getJsResourceRef()").append(";");
        this.outdent();
        this.writeNewlineAndIndent();
        this.indent();
        writer.append("}");
        this.writeNewline();
        this.outdent();
        this.writeNewlineAndIndent();
        writer.append("public static final IComponentSpec SPEC = ").append(JSOBJDATA_VAR_NAME).append(".getResourceSpec()");
        Iterator<TypeMeta> itr = this.m_jsrTypeMgr.getMetaItr();
        while (itr.hasNext()) {
            TypeMeta meta = itr.next();
            if (meta.m_inactiveType && !meta.m_usedInDecl) continue;
            this.writeNewlineAndIndent();
            this.writeIndent();
            writer.append(".addDependentComponent(");
            if (meta.m_useFullName) {
                writer.append(meta.m_fullName);
            } else {
                writer.append(meta.m_simpleName);
            }
            writer.append(".ResourceSpec.getInstance())");
        }
        writer.append(";");
    }

    private void writeJsObjProtectedConstructor(String jsrName) {
        this.writeNewline();
        this.writeNewlineAndIndent();
        PrintWriter writer = this.getWriter();
        writer.append("protected ").append(jsrName).append("(JsCmpMeta cmpMeta, boolean isInstance, Object... args) {");
        this.indent();
        this.writeNewlineAndIndent();
        writer.append("super(cmpMeta, isInstance, args);");
        this.outdent();
        this.writeNewlineAndIndent();
        writer.append("}");
    }

    private void writeConstructors(String jsrName) {
        if (this.m_constructors.isEmpty()) {
            this.writeConstructor(jsrName, EMPTY_LIST, false, false);
            return;
        }
        ArrayList<IJstMethod> writtenConstructors = new ArrayList<IJstMethod>();
        for (MethodMeta meta : this.m_constructors) {
            if (writtenConstructors.contains(meta.m_method)) continue;
            for (List<SimpleParam> paramList : meta.m_argListPermutation) {
                this.writeConstructor(jsrName, paramList, false, false);
                if (this.needValueBinding(paramList)) {
                    this.writeConstructor(jsrName, paramList, true, false);
                }
                if (!this.needNonProxyMethod(paramList)) continue;
                this.writeConstructor(jsrName, paramList, false, true);
            }
            writtenConstructors.add(meta.m_method);
        }
        writtenConstructors = null;
    }

    private void writeConstructor(String jsrName, List<SimpleParam> paramList, boolean useValueBinding, boolean useNonProxyType) {
        this.writeNewline();
        this.writeNewlineAndIndent();
        PrintWriter writer = this.getWriter();
        writer.append("public ").append(jsrName).append("(");
        this.writeArgs(jsrName, paramList, useValueBinding, useNonProxyType, false, null);
        writer.append("){");
        this.indent();
        this.writeNewlineAndIndent();
        writer.append("super(").append(JSOBJDATA_VAR_NAME).append(".getJsCmpMeta(), true");
        boolean isVjoSerializableType = false;
        int i = 0;
        for (SimpleParam param : paramList) {
            String pName;
            if (!isVjoSerializableType) {
                isVjoSerializableType = this.m_config.getFilters().isSerializableForVjo(param.m_type, true);
            }
            if ((pName = param.m_arg.getName()) == null) {
                pName = DEFAULT_PARAM_PREFIX + i;
            }
            writer.append(", ").append(pName);
            ++i;
        }
        writer.append(");");
        this.outdent();
        this.writeNewlineAndIndent();
        writer.append("}");
    }

    private void writeProps() {
        PrintWriter writer = this.getWriter();
        if (this.m_clzType.isInterface() && !this.m_staticProperties.isEmpty()) {
            this.writeNewline();
            this.writeNewlineAndIndent();
            writer.append("public static final class PROPS{");
            this.writeNewlineAndIndent();
        }
        for (IJstProperty p : this.m_staticProperties) {
            if (!p.isPublic()) continue;
            if (this.m_clzType.isInterface() && (p.isFinal() || p.isStatic())) {
                this.writeStaticFieldForInterface(p, writer);
                continue;
            }
            if ((this.m_clzType.isClass() || this.m_clzType.isEnum()) && p.isFinal()) {
                this.writeNewline();
                this.writePropertyGetter(p, false);
                continue;
            }
            this.writeNewline();
            this.writePropertyGetter(p, false);
            this.writeNewline();
            this.writePropertySetter(p, false, false, false);
            if (this.m_vjoSerializableTypeMgr.m_fullNameMap.containsKey(p.getType().getName())) {
                this.writeNewline();
                this.writePropertySetter(p, false, false, true);
            }
            this.writeNewline();
            this.writePropertySetter(p, true, false, false);
        }
        if (this.m_clzType.isInterface() && !this.m_staticProperties.isEmpty()) {
            this.writeIndent();
            writer.append("}");
        }
        if (!this.m_clzType.isInterface()) {
            ArrayList<IJstMethod> writtenMethods = new ArrayList<IJstMethod>();
            for (MethodMeta meta : this.m_staticMethods) {
                if (writtenMethods.contains(meta.m_method)) continue;
                this.writeMethods(meta);
                writtenMethods.add(meta.m_method);
            }
            writtenMethods = null;
        }
        for (IJstProperty p : this.m_clzType.getEnumValues()) {
            this.writeStaticVariable(p, true);
        }
    }

    private void writeProtos() {
        ArrayList<IJstMethod> writtenMethods = new ArrayList<IJstMethod>();
        boolean isI = this.m_clzType.isInterface();
        for (IJstProperty p : this.m_instanceProperties) {
            if (!p.isPublic()) continue;
            this.writeNewline();
            this.writePropertyGetter(p, isI);
            if (p.isFinal()) continue;
            this.writeNewline();
            this.writePropertySetter(p, false, isI, false);
            if (this.m_vjoSerializableTypeMgr.m_fullNameMap.containsKey(p.getType().getName())) {
                this.writeNewline();
                this.writePropertySetter(p, false, isI, true);
            }
            this.writeNewline();
            this.writePropertySetter(p, true, isI, false);
        }
        for (MethodMeta meta : this.m_instanceMethods) {
            if (writtenMethods.contains(meta.m_method)) continue;
            this.writeMethods(meta);
            writtenMethods.add(meta.m_method);
        }
        writtenMethods = null;
    }

    private void writePropertyGetter(IJstProperty p, boolean isItForInterface) {
        PrintWriter writer = this.getWriter();
        this.writeNewlineAndIndent();
        String wrapper = this.getTypeSimpleName(p.getType(), this.isQualified(p.getType()));
        writer.append("public ");
        if (p.isStatic()) {
            writer.append("static ");
        }
        if (p.isFinal()) {
            writer.append("final ");
        }
        writer.append("JsProp");
        writer.append("<").append(wrapper).append(">");
        String name = p.getName().getName();
        name = this.m_config.getFilters().decorateProperty(name);
        writer.append(" ").append(name);
        writer.append("()");
        if (isItForInterface) {
            writer.append(";");
        } else {
            writer.append("{");
            this.indent();
            this.writeNewlineAndIndent();
            writer.append("return getProp(");
            if (p.isStatic()) {
                writer.append(JSOBJDATA_VAR_NAME).append(", ");
            }
            if (p.getType() instanceof JstTypeWithArgs || p.getType() instanceof IJstRefType) {
                writer.append(this.classTemplateCast(wrapper));
            } else {
                writer.append(wrapper).append(".class");
            }
            writer.append(", \"").append(name).append("\"");
            writer.append(");");
            this.outdent();
            this.writeNewlineAndIndent();
            writer.append("}");
        }
    }

    private void writePropertySetter(IJstProperty p, boolean useBinding, boolean isItForInterface, boolean isNonProxyType) {
        PrintWriter writer = this.getWriter();
        this.writeNewlineAndIndent();
        writer.append("public ");
        if (p.isStatic()) {
            writer.append("static ");
        }
        String typeName = this.getTypeSimpleName(p.getType(), this.isQualified(p.getType()), IJsrTypeProvider.Type.Primitive);
        if (useBinding) {
            typeName = this.typeBinding(p.getType());
        }
        String name = p.getName().getName();
        name = this.m_config.getFilters().decorateProperty(name);
        writer.append("IJsPropSetter ").append(name).append("(").append(typeName).append(" v)");
        if (isItForInterface) {
            writer.append(";");
        } else {
            writer.append(" {");
            this.indent();
            this.writeNewlineAndIndent();
            writer.append("return ").append("setProp(");
            if (p.isStatic()) {
                writer.append(JSOBJDATA_VAR_NAME);
                writer.append(", ");
            }
            writer.append("\"").append(name).append("\", ");
            writer.append("v);");
            this.outdent();
            this.writeNewlineAndIndent();
            writer.append("}");
        }
    }

    private void writeStaticFieldForInterface(IJstProperty property, PrintWriter writer) {
        String propType = this.getWrapperType(property.getType());
        this.writeIndent();
        writer.append("public static final ");
        writer.append("JsProp<").append(propType).append("> ").append(property.getName().getName()).append("(){");
        this.writeNewlineAndIndent();
        this.writeIndent();
        this.writeIndent();
        writer.append("return new JsProp<").append(propType).append(">(").append(JSOBJDATA_VAR_NAME).append(".getStaticAnchor(), ").append("\"").append(property.getName().getName()).append("\");");
        this.writeNewlineAndIndent();
        this.writeIndent();
        writer.append("}");
        this.writeNewline();
    }

    private void writeStaticVariable(IJstProperty property, boolean isInterface) {
        PrintWriter writer = this.getWriter();
        this.writeNewline();
        this.writeNewlineAndIndent();
        String propType = this.getWrapperType(property.getType());
        writer.append("public static final ");
        writer.append("JsProp<").append(propType).append("> ").append(property.getName().getName());
        writer.append("(){ return getProp(").append(JSOBJDATA_VAR_NAME).append(", ");
        if (property.getType() instanceof JstTypeWithArgs || property.getType() instanceof IJstRefType) {
            writer.append(this.classTemplateCast(propType)).append(", ");
        } else {
            writer.append(propType).append(".class, ");
        }
        writer.append("\"").append(property.getName().getName()).append("\")");
        writer.append(";");
        writer.append("}");
    }

    private void writeMethods(MethodMeta meta) {
        IJstMethod method = meta.m_method;
        if (method instanceof ISynthesized) {
            return;
        }
        IJstType rtnType = method.getRtnType();
        IJstType oType = null;
        if (rtnType != null && rtnType.getModifiers().isPrivate()) {
            return;
        }
        boolean isStatic = method.isStatic();
        boolean isOType = method.isOType();
        if (isOType) {
            StringBuilder funcRef = new StringBuilder();
            JstMethod m = (JstMethod)(method instanceof JstProxyMethod ? ((JstProxyMethod)method).getTargetMethod() : method);
            oType = (IJstType)m.getOType().getParentNode();
            funcRef.append("public ");
            if (isStatic) {
                funcRef.append("static ");
            }
            this.writeNewlineAndIndent();
            this.writeNewlineAndIndent();
            String jsrName = this.getTypeName((IJstType)m.getOType(), true);
            funcRef.append(jsrName).append(" ").append(method.getName()).append(" = new ").append(jsrName).append("(").append(isStatic ? JSOBJDATA_VAR_NAME : "this").append(",").append("\"").append(method.getName()).append("\");");
            this.getWriter().append(funcRef);
        }
        StringBuilder methodDeclBegin = new StringBuilder();
        methodDeclBegin.append("public ");
        if (method.isAbstract()) {
            methodDeclBegin.append("abstract ");
        }
        if (isStatic) {
            methodDeclBegin.append("static ");
        }
        if (method.isFinal()) {
            methodDeclBegin.append("final ");
        }
        if (!method.getParamNames().isEmpty()) {
            methodDeclBegin.append(method.getParamsDecoration()).append(" ");
        }
        String methodName = this.m_config.getFilters().decorateMethod(method);
        boolean isDecoratedMethod = methodName.equals(method.getOriginalName());
        String rtnTypeName = this.getTypeSimpleName(rtnType, this.isQualified(rtnType), IJsrTypeProvider.Type.AddParams);
        boolean isTypeRef = method.getRtnType() instanceof IJstRefType;
        boolean addExtends = !"Void".equals(rtnTypeName) && !this.m_config.getFilters().isJavaPrimitiveOrWrapper(rtnTypeName) && !rtnTypeName.endsWith("[]");
        String rtnJsFunc = "JsFunc<" + (addExtends ? "? extends " : "") + rtnTypeName + ">";
        methodDeclBegin.append(rtnJsFunc).append(" ").append(methodName).append("(");
        String rtnTypeClzStr = rtnType instanceof JstTypeWithArgs || rtnType instanceof JstParamType || isTypeRef || rtnType instanceof JstArray && (((JstArray)rtnType).getComponentType() instanceof JstTypeWithArgs || ((JstArray)rtnType).getComponentType() instanceof JstParamType) ? this.classTemplateCast(rtnTypeName) : (rtnType instanceof JstMixedType ? "Object.class" : String.valueOf(rtnTypeName) + ".class");
        for (List<SimpleParam> paramList : meta.m_argListPermutation) {
            this.writeMethod(method, paramList, methodDeclBegin.toString(), rtnTypeClzStr, isDecoratedMethod, false, false, oType);
            boolean needIV = this.needValueBinding(paramList);
            if (needIV) {
                this.writeMethod(method, paramList, methodDeclBegin.toString(), rtnTypeClzStr, isDecoratedMethod, true, false, oType);
            }
            if (!this.needNonProxyMethod(paramList)) continue;
            this.writeMethod(method, paramList, methodDeclBegin.toString(), rtnTypeClzStr, isDecoratedMethod, false, true, oType);
        }
    }

    private boolean needNonProxyMethod(List<SimpleParam> paramList) {
        for (SimpleParam param : paramList) {
            Class<?> javaTypeForSerialable = this.m_config.getFilters().getJavaTypeForSerialable(param.m_type);
            String name = javaTypeForSerialable == null ? param.m_type.getName() : javaTypeForSerialable.getName();
            if (!this.m_vjoSerializableTypeMgr.m_fullNameMap.containsKey(name)) continue;
            return true;
        }
        return false;
    }

    private void writeMethod(IJstMethod method, List<SimpleParam> paramList, String methodDeclBegin, String rtnTypeClzStr, boolean isDecoratedMethod, boolean useValueBinding, boolean useNonProxyParams, IJstType oType) {
        this.writeNewline();
        this.writeNewlineAndIndent();
        PrintWriter writer = this.getWriter();
        if (method.getDoc() != null) {
            writer.append("/**").append(this.getNewline());
            writer.append(method.getDoc().getComment());
            writer.append(this.getNewline()).append("*/").append(this.getNewline());
            this.writeNewline();
        }
        writer.append(methodDeclBegin);
        this.writeArgs(method.getOriginalName(), paramList, useValueBinding, useNonProxyParams, true, oType);
        writer.append(")");
        if (method.isAbstract() || this.m_clzType.isInterface()) {
            writer.append(";");
        } else {
            IJstType rtnType;
            writer.append("{");
            this.indent();
            this.writeNewlineAndIndent();
            writer.append("return call(");
            boolean isS = method.isStatic();
            if (isS) {
                writer.append(JSOBJDATA_VAR_NAME);
                writer.append(", ");
            }
            boolean firstArgEvent = false;
            if (method.getArgs().size() > 0) {
                firstArgEvent = this.checkFirstArgForEvent((JstArg)method.getArgs().get(0));
            }
            if (!((rtnType = method.getRtnType()) == null || "void".equals(rtnType.getName()) || rtnType instanceof JstRefType && ((JstRefType)rtnType).getRefType() == Void.class)) {
                writer.append(rtnTypeClzStr).append(", ");
            }
            writer.append("\"").append(method.getOriginalName()).append("\"");
            writer.append(")");
            if (paramList.size() > 0) {
                writer.append(".with(");
                int i = 0;
                while (i < paramList.size()) {
                    String pType;
                    boolean requireWrap;
                    String pName;
                    SimpleParam param = paramList.get(i);
                    if (i == 0 && firstArgEvent && method.getArgs().get(0) != param.getArg()) {
                        writer.append("org.eclipse.vjet.vsf.resource.html.event.handler.JsHandlerObjectEnum.nativeEvent ");
                        if (paramList.size() >= 1) {
                            writer.append(",");
                        }
                    }
                    if (i > 0) {
                        writer.append(", ");
                    }
                    if ((pName = param.m_arg.getName()) == null) {
                        pName = DEFAULT_PARAM_PREFIX + i;
                    }
                    String argName = param.m_mappedName == null ? pName : param.m_mappedName;
                    boolean booleanPrimitive = this.isBooleanPrimitive(param.m_type);
                    boolean booleanWrapper = this.isBooleanWrapper(param.m_type);
                    boolean jsrArray = this.isJsrArray(param);
                    boolean addedMethodAroundArg = false;
                    if (useValueBinding && booleanPrimitive) {
                        writer.append("check");
                        if (method.isStatic()) {
                            writer.append(JSOBJDATA_VAR_NAME);
                        }
                        writer.append("(");
                        addedMethodAroundArg = true;
                    }
                    boolean bl = requireWrap = booleanWrapper || jsrArray;
                    if (this.requiresWrap(useValueBinding, requireWrap)) {
                        writer.append("wrap");
                        if (method.isStatic()) {
                            writer.append(JSOBJDATA_VAR_NAME);
                        }
                        writer.append("(");
                        addedMethodAroundArg = true;
                    }
                    if (!jsrArray && paramList.size() == 1 && (pType = this.getTypeSimpleName(param.m_type, IJsrTypeProvider.Type.Primitive)).endsWith("[]") && !"Object[]".equals(pType) && !useValueBinding) {
                        writer.append("(Object)");
                    }
                    writer.append(argName);
                    if (addedMethodAroundArg) {
                        writer.append(")");
                    }
                    ++i;
                }
                writer.append(")");
            }
            writer.append(";");
            this.outdent();
            this.writeNewlineAndIndent();
            writer.append("}");
        }
    }

    private boolean isJsrArray(SimpleParam param) {
        if (this.m_JsToJavaMapper.isExcludedFromImport(param.m_arg.getType())) {
            return false;
        }
        if (param.m_arg != null && param.m_arg.getType() instanceof JstArray) {
            JstArray arry = (JstArray)param.m_arg.getType();
            IJstType componentType = arry.getComponentType();
            if (componentType.getExtend() == null || componentType instanceof JstRefType) {
                return false;
            }
            String groupName = componentType.getPackage().getGroupName();
            return !groupName.equals("JsNativeLib") && !groupName.equals("JavaPrimitive");
        }
        return false;
    }

    private boolean requiresWrap(boolean useValueBinding, boolean booleanWrapper) {
        return !useValueBinding && booleanWrapper;
    }

    private boolean checkFirstArgForEvent(JstArg jstArg) {
        JstType eventType = JstCache.getInstance().getType("Event");
        return jstArg != null && jstArg.getType().equals(eventType);
    }

    private boolean isBooleanWrapper(IJstType type) {
        JstType bool = JstCache.getInstance().getType("Boolean");
        if (bool != null && bool.equals(type)) {
            return true;
        }
        bool = JstCache.getInstance().getType(Boolean.class.getName());
        return bool != null && bool.equals(type);
    }

    private boolean isBooleanPrimitive(IJstType type) {
        JstType bool = JstCache.getInstance().getType("boolean");
        return bool != null && bool.equals(type);
    }

    private void writeArgs(String name, List<SimpleParam> paramList, boolean useValueBinding, boolean useNonProxyType, boolean newLine, IJstType oType) {
        int index;
        PrintWriter writer = this.getWriter();
        int argSize = paramList.size();
        int firstParam = 0;
        int i = 0;
        while (i < argSize) {
            SimpleParam param = paramList.get(i);
            if (param.m_mappedName != null) {
                ++firstParam;
            } else {
                String pName;
                if (i > firstParam) {
                    writer.append(", ");
                }
                String pType = this.getTypeSimpleName(param.m_type, this.isQualified(param.m_type), IJsrTypeProvider.Type.Primitive, IJsrTypeProvider.Type.AddParams);
                if (useValueBinding) {
                    pType = this.typeBinding(param.m_type);
                }
                writer.append(pType);
                if (param.m_arg.isVariable()) {
                    writer.append("...");
                }
                if ((pName = param.m_arg.getName()) == null) {
                    pName = DEFAULT_PARAM_PREFIX + i;
                }
                writer.append(" ").append(pName);
            }
            ++i;
        }
        if (useValueBinding && argSize > 0 && (index = this.getOverloadedIndex(name, argSize)) > 0) {
            writer.append(", ");
            if (newLine) {
                this.writeNewlineAndIndent();
                this.writeIndent();
                this.writeIndent();
            }
            writer.append("org.eclipse.vjet.vsf.jsref.d").append(".D").append(String.valueOf(index)).append("... notUsed");
        }
    }

    private IJsrTypeProvider.Type isQualified(IJstType type) {
        if (type == null) {
            return null;
        }
        IJsrTypeProvider.Type qualified = IJsrTypeProvider.Type.Qualified;
        if (type instanceof JstObjectLiteralType || type instanceof JstFunctionRefType) {
            return qualified;
        }
        IJstNode parentNode = type.getParentNode();
        IJstType outerType = this.m_clzType.getOuterType();
        if (type.isEmbededType() && outerType != null && !parentNode.equals(outerType)) {
            return qualified;
        }
        if (parentNode != null && outerType == null && !this.m_clzType.equals(parentNode)) {
            return qualified;
        }
        return null;
    }

    private String getTypeRefType(String pType) {
        return "JsTypeRef<" + pType + ">";
    }

    private void writeOTypes(List<IJstOType> otypes) {
        for (IJstOType otype : otypes) {
            if (otype instanceof JstObjectLiteralType) {
                this.writeOlType((JstObjectLiteralType)otype);
            } else if (otype instanceof JstFunctionRefType) {
                this.writeOlType((JstFunctionRefType)otype);
            }
            this.writeNewline();
        }
    }

    private void writeOlType(JstFunctionRefType otype) {
        this.writeOlType(otype, otype.getMethodRef());
        for (IJstMethod ovMtd : otype.getMethodRef().getOverloaded()) {
            this.writeOlType(otype, ovMtd);
        }
    }

    private void writeOlType(JstFunctionRefType otype, IJstMethod mtdRef) {
        this.indent();
        this.writeNewlineAndIndent();
        PrintWriter writer = this.getWriter();
        String jsrName = this.getTypeSimpleName((IJstType)otype, IJsrTypeProvider.Type.Wrapper);
        writer.append("public static class ").append(jsrName).append(" extends ").append("JsFuncRef").append("<").append(this.getWrapperType(mtdRef.getRtnType())).append(">").append(" { ");
        this.indent();
        this.writeNewlineAndIndent();
        writer.append(SERIAL_ID);
        this.writeNewline();
        this.writeNewlineAndIndent();
        this.writeOLConstructor(otype);
        this.outdent();
        this.writeNewlineAndIndent();
        writer.append("}");
        this.writeNewlineAndIndent();
        this.outdent();
    }

    private void writeOLConstructor(JstFunctionRefType otype) {
        PrintWriter writer = this.getWriter();
        String otypeName = this.getTypeSimpleName((IJstType)otype, IJsrTypeProvider.Type.Wrapper);
        writer.append("public ").append(otypeName).append(FNREF_JSOBJDATA_ARGS).append("{");
        this.indent();
        this.writeNewlineAndIndent();
        writer.append(SUPER_FNREF_CALL);
        this.outdent();
        this.writeNewlineAndIndent();
        writer.append("}");
        this.writeNewlineAndIndent();
        writer.append("public ").append(otypeName).append(FNREF_JSOBJ_ARGS).append("{");
        this.indent();
        this.writeNewlineAndIndent();
        writer.append(SUPER_FNREF_CALL);
        this.outdent();
        this.writeNewlineAndIndent();
        writer.append("}");
        this.writeNewlineAndIndent();
    }

    private void writeOlType(JstObjectLiteralType otype) {
        String otypeName = this.getTypeSimpleName((IJstType)otype, IJsrTypeProvider.Type.Wrapper);
        this.indent();
        this.writeNewlineAndIndent();
        PrintWriter writer = this.getWriter();
        writer.append("public static class ").append(otypeName).append(" extends ").append("JsObjectLiteral").append(" { ");
        this.indent();
        this.writeNewlineAndIndent();
        writer.append(SERIAL_ID);
        this.writeNewlineAndIndent();
        this.writeOLConstructor(otype);
        if (otype.getProperties().size() > 0) {
            this.writeNewlineAndIndent();
        }
        for (IJstProperty prop : otype.getProperties()) {
            String name = prop.getName().getName();
            String camelName = String.valueOf(name.substring(0, 1).toUpperCase()) + name.substring(1);
            this.writeOLTypeGetter(name, "get" + camelName, prop.getType(), prop.getType() instanceof IJstRefType);
        }
        this.outdent();
        this.writeNewlineAndIndent();
        writer.append("}");
        this.writeNewlineAndIndent();
        this.outdent();
    }

    private void writeOLConstructor(JstObjectLiteralType otype) {
        String olName = this.getTypeSimpleName((IJstType)otype, IJsrTypeProvider.Type.Wrapper);
        this.writeOLContructorNew(olName, (IJstMethod)otype.getConstructor(), false);
        if (otype.getProperties().size() != 0) {
            this.writeOLContructorNew(olName, (IJstMethod)otype.getConstructor(), true);
        }
        for (IJstMethod overloaded : otype.getConstructor().getOverloaded()) {
            this.writeOLContructorNew(olName, overloaded, false);
            if (overloaded.getArgs().size() == 0) continue;
            this.writeOLContructorNew(olName, overloaded, true);
        }
    }

    private void writeOLContructorNew(String olName, IJstMethod constructor, boolean iValueBinding) {
        PrintWriter writer = this.getWriter();
        this.writeNewlineAndIndent();
        writer.append("private ").append(olName).append("(");
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (JstArg prop : constructor.getArgs()) {
            if (!first) {
                sb.append(",").append(" ");
            }
            String type = this.getTypeSimpleName(prop.getType(), this.isQualified(prop.getType()), IJsrTypeProvider.Type.Primitive);
            sb.append(iValueBinding ? this.typeBinding(prop.getType()) : type).append(" ").append(prop.getName());
            first = false;
        }
        writer.append(sb).append("){");
        this.indent();
        first = true;
        StringBuilder sb2 = new StringBuilder();
        for (JstArg prop : constructor.getArgs()) {
            if (!first) {
                sb2.append(",");
            }
            first = false;
            String name = prop.getName();
            sb2.append(name);
            this.writeNewlineAndIndent();
            this.writeOLTypePut(name, name, prop.getType(), iValueBinding);
        }
        this.outdent();
        this.writeNewlineAndIndent();
        writer.append("}");
        this.writeNewlineAndIndent();
        this.writeOLCreateMethod(olName, sb.toString(), sb2.toString());
    }

    private void writeOLCreateMethod(String name, String paramsDecl, String params) {
        PrintWriter writer = this.getWriter();
        writer.append("public static ").append(name).append(" obj(").append(paramsDecl).append(") {");
        this.indent();
        this.writeNewlineAndIndent();
        writer.append("return new ").append(name).append("(").append(params).append(")").append(";");
        this.outdent();
        this.writeNewlineAndIndent();
        writer.append("}");
        this.writeNewlineAndIndent();
    }

    private void writeOLTypePut(String propName, String propVal, IJstType iJstType, boolean iValueBinding) {
        PrintWriter writer = this.getWriter();
        writer.append("put(\"").append(propName).append("\",");
        if (!this.m_JsToJavaMapper.isLiteral(iJstType) && !iValueBinding) {
            writer.append(propName).append(".getClass()").append(",");
        }
        writer.append(propVal).append(");");
    }

    private void writeOLTypeGetter(String propName, String methodName, IJstType type, boolean isTypeRef) {
        PrintWriter writer = this.getWriter();
        writer.append("public ").append(this.typeBinding(type)).append(" ").append(methodName).append("() {");
        this.indent();
        this.writeNewlineAndIndent();
        String typeStr = this.getWrapperType(type);
        writer.append("return BV.bind(").append(isTypeRef ? this.classTemplateCast(typeStr) : String.valueOf(typeStr) + ".class").append(", (").append(this.getQualifiedType(type)).append(")get(\"").append(propName).append("\"));");
        this.outdent();
        this.writeNewlineAndIndent();
        writer.append("}");
        this.writeNewlineAndIndent();
    }

    private void writeTypeRef() {
        this.writeNewlineAndIndent();
        this.writeNewlineAndIndent();
        String typeRef = "JsTypeRef<" + this.m_clzType.getSimpleName() + JSR_SUFFIX + ">";
        this.getWriter().append("public static ").append(typeRef).append(" prototype = new ").append(typeRef).append("(S);");
    }

    private void processJsrTypeImports() {
        this.addJsrTypeImport(this.m_clzType.getImports(), false);
        this.addJsrTypeImport(this.m_clzType.getExtends(), true);
        this.addJsrTypeImport(this.m_clzType.getSatisfies(), true);
        this.addJsrTypeImport(this.m_clzType.getExpects(), true);
        this.addJsrTypeImportFromParams(this.m_clzType.getParamTypes());
    }

    private void addJsrTypeImportFromParams(List<? extends IJstType> paramTypes) {
        for (IJstType iJstType : paramTypes) {
            JstParamType itmParam;
            IJstType iaimp = this.m_clzType.getInactiveImport(iJstType.getName());
            boolean added = false;
            if (iaimp == null) {
                iaimp = this.m_clzType.getInactiveImport(iJstType.getSimpleName());
            }
            if (iaimp != null) {
                this.addJsrTypeImport(iaimp, true, false);
                added = true;
            }
            if (!added) {
                IJstType imp = this.m_clzType.getImport(iJstType.getName());
                if (imp == null) {
                    imp = this.m_clzType.getImport(iJstType.getSimpleName());
                }
                if (imp != null) {
                    this.addJsrTypeImport(imp, true, true);
                }
            }
            if (!(iJstType instanceof JstParamType) || (itmParam = (JstParamType)iJstType).getBounds().isEmpty()) continue;
            this.addJsrTypeImportFromParams(itmParam.getBounds());
        }
    }

    private void processMixins(Set<IJstType> typeSet) {
        List mixins = this.m_clzType.getMixinsRef();
        for (IJstTypeReference ref : mixins) {
            IJstType mixinType = ref.getReferencedType();
            this.addJsrTypeImport(mixinType, false);
            for (IJstType imp : mixinType.getImports()) {
                this.addJsrTypeImport(imp, false);
            }
            for (IJstType inactiveImp : mixinType.getInactiveImports()) {
                if (!inactiveImp.isOType()) {
                    this.addJsrTypeImport(inactiveImp, false);
                }
                this.m_inactiveNeedsFromMixin.put(inactiveImp.getSimpleName(), inactiveImp);
            }
        }
    }

    private void processInnersForJsrType() {
        if (!this.isSameGroup(this.m_clzType.getRootType(), this.m_clzType)) {
            return;
        }
        Comparator<IJstType> comparator = new Comparator<IJstType>(){

            @Override
            public int compare(IJstType o1, IJstType o2) {
                return o1.getName().compareTo(o2.getName());
            }
        };
        TreeSet<IJstType> space = new TreeSet<IJstType>(comparator);
        this.loadLocalTypeSpace(this.m_clzType.getRootType(), space);
        this.loadLocalTypeSpace(this.m_clzType, space);
        if (space.isEmpty()) {
            return;
        }
        IJstType top = (IJstType)space.first();
        for (IJstType type : space) {
            if (comparator.compare(top, type) > 0) continue;
            SortedSet<IJstType> subSet = space.subSet(top, type);
            int len = subSet.size();
            IJstType[] array = new IJstType[len];
            subSet.toArray(array);
            int i = len;
            IJstType test = null;
            while (i > 0) {
                test = array[i - 1];
                if (this.checkInnerByName(type.getName(), test.getName())) break;
                --i;
            }
            if (i != 0) {
                JstType inner = this.unwrapJstType(type);
                JstType outer = this.unwrapJstType(test);
                if (inner == null || outer == null || inner.getOuterType() != null) continue;
                inner.setOuterType(outer);
                outer.addInnerType(inner);
                continue;
            }
            top = type;
        }
    }

    private boolean isSameGroup(IJstType type1, IJstType type2) {
        JstPackage pkg1 = type1.getPackage();
        JstPackage pkg2 = type2.getPackage();
        if (pkg1 == null && pkg2 == null) {
            return true;
        }
        if (pkg1 == null && pkg2 != null) {
            return false;
        }
        if (pkg1 != null && pkg2 == null) {
            return false;
        }
        String grp1 = pkg1.getGroupName();
        String grp2 = pkg2.getGroupName();
        if (grp1 == null && grp2 == null) {
            return true;
        }
        if (grp1 == null && grp2 != null) {
            return false;
        }
        if (grp1 != null && grp2 == null) {
            return false;
        }
        return grp1.equals(grp2);
    }

    private boolean checkInnerByName(String innerName, String outerName) {
        if (innerName.indexOf(outerName) == 0) {
            String remainder = innerName.substring(outerName.length());
            return remainder.indexOf(46) == 0;
        }
        return false;
    }

    private void loadLocalTypeSpace(IJstType type, Set<IJstType> space) {
        space.add(type);
        space.addAll(type.getImports());
        space.addAll(type.getExtends());
        space.addAll(type.getSatisfies());
        space.addAll(type.getExpects());
        List embeds = type.getEmbededTypes();
        for (IJstType embed : embeds) {
            this.loadLocalTypeSpace(embed, space);
        }
    }

    private JstType unwrapJstType(IJstType type) {
        if (type instanceof JstType) {
            return (JstType)type;
        }
        if (type instanceof JstProxyType) {
            return this.unwrapJstType(((JstProxyType)type).getType());
        }
        return null;
    }

    private void collectTypeFromProperties(Set<IJstType> typeSet, List<IJstProperty> properties, boolean isOnlyCollectType, boolean isInterface) {
        for (IJstProperty prop : properties) {
            if (!prop.isPublic() || prop instanceof ISynthesized || prop instanceof JstProxyProperty && ((JstProxyProperty)prop).getTargetProperty() instanceof ISynthesized) continue;
            this.m_hasProp = true;
            if (!prop.isFinal() && !isInterface) {
                this.m_needsPropSetter = true;
                if (!this.isMappedEventType(prop.getType())) {
                    this.m_needsIValueBinding = true;
                }
            }
            if (!isOnlyCollectType) {
                if (prop.isStatic()) {
                    this.m_staticProperties.add(prop);
                } else {
                    this.m_instanceProperties.add(prop);
                }
            }
            if (this.m_clzType.isOType() && this.m_clzType.getInactiveImport(prop.getType().getSimpleName()) != null) {
                this.addJsrTypeImport(this.m_clzType.getInactiveImport(prop.getType().getSimpleName()), true);
            } else if (this.m_clzType.isOType() && prop.getType().isImpliedImport()) {
                this.addJsrTypeImport(prop.getType(), true, false);
            }
            this.collectType(prop.getType(), typeSet);
        }
    }

    private void collectTypeFromMethods(Set<IJstType> typeSet, List<? extends IJstMethod> methods, boolean isOnlyCollectType) {
        for (IJstMethod iJstMethod : methods) {
            if (this.m_clzType.isMixin() || iJstMethod instanceof ISynthesized) continue;
            this.collectTypeFromMethod(iJstMethod, typeSet, isOnlyCollectType);
        }
    }

    private boolean isExists(List<MethodMeta> list, IJstMethod method) {
        for (MethodMeta meta : list) {
            if (!this.isEqual(meta.m_method, method)) continue;
            return true;
        }
        return false;
    }

    private void collectTypeFromMethod(IJstMethod jstMethod, Set<IJstType> typeSet, boolean isOnlyCollectType) {
        List<Stack<SimpleParam>> paramsPermutation;
        if (jstMethod instanceof ISynthesized) {
            return;
        }
        IJstMethod method = jstMethod;
        if (jstMethod instanceof JstProxyMethod) {
            method = ((JstProxyMethod)jstMethod).getTargetMethod();
        }
        List<MethodMeta> metaList = this.m_constructors;
        if (method == null) {
            return;
        }
        if (!method.isPublic()) {
            return;
        }
        JstType otype = null;
        if (method.isOType()) {
            otype = (JstType)((JstMethod)method).getOType().getParentNode();
        }
        if (method.isDispatcher()) {
            metaList = method.isConstructor() ? this.m_constructors : (method.isStatic() ? this.m_staticMethods : this.m_instanceMethods);
            List olconstrs = method.getOverloaded();
            if (olconstrs != null) {
                boolean setRtnType = false;
                for (IJstMethod cons : olconstrs) {
                    if (this.isExists(metaList, cons)) {
                        if (!(method instanceof JstMethod) || setRtnType) continue;
                        JstMethod jstMethod2 = (JstMethod)method;
                        jstMethod2.setRtnType((IJstType)JstCache.getInstance().getType(NATIVE_OBJECT, false));
                        setRtnType = true;
                        continue;
                    }
                    List args = cons.getArgs();
                    List<Stack<SimpleParam>> olParamsPermutation = this.collectArgTypesAndPermutation(0, args, typeSet, otype);
                    if (cons.isPublic() && !isOnlyCollectType) {
                        metaList.add(new MethodMeta(cons, olParamsPermutation));
                    }
                    if (method.isConstructor()) continue;
                    this.m_hasFunction = true;
                    IJstType returnType = cons.getRtnType();
                    if (returnType == null || !JsrGenerator.isPublic(returnType)) continue;
                    this.collectType(returnType, typeSet);
                }
                if (!this.isDispatcher(method) && !this.isExists(metaList, method)) {
                    List<Stack<SimpleParam>> paramsPermutation2 = this.collectArgTypesAndPermutation(0, method.getArgs(), typeSet, otype);
                    if (!isOnlyCollectType) {
                        MethodMeta methodMeta = new MethodMeta(method, paramsPermutation2);
                        if (method.isPublic() && !method.isPrivate() && !method.isProtected()) {
                            metaList.add(methodMeta);
                        }
                    }
                }
            }
            return;
        }
        if (!method.isConstructor()) {
            this.m_hasFunction = true;
            IJstType returnType = method.getRtnType();
            if (returnType != null) {
                if (!JsrGenerator.isPublic(returnType)) {
                    return;
                }
                if (this.m_clzType.isOType() && this.m_clzType.getInactiveImport(returnType.getSimpleName()) != null) {
                    this.addJsrTypeImport(this.m_clzType.getInactiveImport(returnType.getSimpleName()), false);
                } else if (otype != null && otype.getInactiveImport(returnType.getSimpleName()) != null) {
                    this.addJsrTypeImport(otype.getInactiveImport(returnType.getSimpleName()), false);
                } else {
                    this.addAsInactiveImport(returnType);
                }
                this.collectType(returnType, typeSet);
            }
            metaList = method.isStatic() ? this.m_staticMethods : this.m_instanceMethods;
        }
        if ((paramsPermutation = this.collectArgTypesAndPermutation(0, method.getArgs(), typeSet, otype)) == null) {
            return;
        }
        if (!isOnlyCollectType) {
            MethodMeta methodMeta = new MethodMeta(method, paramsPermutation);
            metaList.add(methodMeta);
        }
    }

    private boolean isDispatcher(IJstMethod method) {
        if (!method.isDispatcher()) {
            return false;
        }
        if (method.getOverloaded().size() > 1) {
            return true;
        }
        JstMethod mtd = (JstMethod)method.getOverloaded().get(0);
        return mtd.getSurffix() == null;
    }

    private void collectType(IJstType type, Set<IJstType> typeSet) {
        Class clz;
        if (type instanceof IJstRefType) {
            this.m_needsTypeRef = true;
            typeSet.add(type);
            this.addJsrTypeImport(((IJstRefType)type).getReferencedNode(), true);
            return;
        }
        if (type instanceof IJstOType) {
            IJstType otype = (IJstType)((IJstOType)type).getParentNode();
            typeSet.add(otype);
            this.addJsrTypeImport(otype, true);
        } else if (type.isImpliedImport()) {
            this.addJsrTypeImport(type, true, true);
        } else {
            this.addAsInactiveImport(type);
        }
        if (typeSet.contains(type)) {
            return;
        }
        if (type instanceof JstArray) {
            type = ((JstArray)type).getElementType();
        }
        if (!type.getModifiers().isPublic()) {
            return;
        }
        typeSet.add(type);
        if (type instanceof JstTypeWithArgs) {
            JstTypeWithArgs jstTypeWArgs = (JstTypeWithArgs)type;
            for (IJstType argType : jstTypeWArgs.getArgTypes()) {
                this.collectType(argType, typeSet);
                if (!(argType instanceof JstParamType)) continue;
                JstParamType wctype = (JstParamType)argType;
                for (IJstType boundedType : wctype.getBounds()) {
                    this.collectType(boundedType, typeSet);
                }
            }
        }
        String name = type.getName();
        if (this.m_config.getFilters().isJsr(name) && name != null && !name.equals(this.m_clzType.getName()) && !this.m_config.getFilters().isJavaWrapper(type.getSimpleName()) && (clz = JsNativeMeta.getClass((String)type.getSimpleName())) != null && !this.isInCurrentTypeDependencies(type)) {
            String javaName;
            String proxyName;
            String typeName = clz.getName();
            String simpleName = clz.getSimpleName();
            Alias alias = clz.getAnnotation(Alias.class);
            if (alias != null) {
                typeName = String.valueOf(clz.getPackage().getName()) + "." + alias.value();
                simpleName = alias.value();
            }
            if ((proxyName = this.getNativeProxyType(type)) != null) {
                typeName = proxyName;
                simpleName = proxyName.substring(proxyName.lastIndexOf(".") + 1);
            }
            if ((javaName = DataTypeHelper.getJavaTypeNameForNative((String)typeName)) != null) {
                typeName = javaName;
            }
            this.m_jsNativeTypeMgr.add(typeName, simpleName, true);
        }
    }

    private boolean isInCurrentTypeDependencies(IJstType type) {
        return this.m_jsrTypeMgr.get(String.valueOf(type.getName()) + JSR_SUFFIX) != null;
    }

    /*
     * Unable to fully structure code
     */
    private void addAsInactiveImport(IJstType type) {
        if (type instanceof JstArray) {
            ary = (JstArray)type;
            type = ary.getElementType();
        }
        if (this.m_JsToJavaMapper.isMappedEventType(type)) {
            this.addJsrTypeImport(type, true, false, false, true);
            this.m_jsrTypeMgr.add("org.eclipse.vjet.vsf.resource.html.event.handler.JsHandlerObjectEnum", "JsHandlerObjectEnum", false, true, true);
            return;
        }
        if (!type.isImpliedImport() && !this.m_JsToJavaMapper.isInactiveImport(type)) ** GOTO lbl12
        this.addJsrTypeImport(type, this.m_JsToJavaMapper.shouldImport(type) == false, false);
        return;
lbl-1000:
        // 1 sources

        {
            type = type.getOuterType();
lbl12:
            // 2 sources

            ** while (type.getOuterType() != null)
        }
lbl13:
        // 1 sources

        inactiveImport = this.m_clzType.getInactiveImport(type.getName());
        if (inactiveImport == null) {
            inactiveImport = this.m_clzType.getInactiveImport(type.getSimpleName());
        }
        if (inactiveImport != null) {
            this.addJsrTypeImport(inactiveImport, true, false);
        } else {
            this.addJsrTypeImportJavaAPI(type);
        }
    }

    private void addJsrTypeImportJavaAPI(IJstType inactiveImport) {
    }

    private void addJsrTypeImport(List<? extends IJstType> types, boolean usedInDecl) {
        if (types == null) {
            return;
        }
        for (IJstType iJstType : types) {
            if (this.m_config.getFilters().isSkipExtends(iJstType) || this.m_config.getFilters().isSkipSatisfies(iJstType)) continue;
            this.addJsrTypeImport(iJstType, usedInDecl);
        }
    }

    private void addJsrTypeImport(IJstType type, boolean usedInDecl) {
        boolean isInactive = false;
        if (this.m_JsToJavaMapper.isInactiveImport(type)) {
            isInactive = true;
        }
        if (this.m_JsToJavaMapper.shouldImport(type)) {
            isInactive = false;
        }
        this.addJsrTypeImport(type, isInactive, usedInDecl);
    }

    private void addJsrTypeImport(IJstType type, boolean isInactive, boolean usedInDecl) {
        String name = type.getAlias();
        if (this.isMappedEventType(type)) {
            return;
        }
        if (!this.shouldExcludeFromImport(type)) {
            boolean usedFullName = isInactive ? this.m_clzType.getInactiveImportsMap().containsKey(name) : this.m_clzType.getImportsMap().containsKey(name);
            if (this.m_JsToJavaMapper.isInactiveImport(type)) {
                isInactive = true;
            }
            if (this.m_JsToJavaMapper.shouldImport(type)) {
                isInactive = false;
            }
            this.addJsrTypeImport(type, isInactive, usedFullName, false, false);
        }
    }

    private void addJsrTypeImport(IJstType type, boolean isInactive, boolean usedFullName, boolean isImportOnly, boolean usedInDecl) {
        this.m_jsrTypeMgr.add(this.getJsrNameForInner(type, false), this.getJsrNameForInner(type, true), usedFullName, isInactive, usedInDecl);
    }

    private String getJsrNameForInner(IJstType type, boolean needSimpleName) {
        if (needSimpleName) {
            String javaTypeSimpleName = this.getTypeSimpleName(type, IJsrTypeProvider.Type.Wrapper);
            return javaTypeSimpleName;
        }
        String javaTypeFullName = this.getTypeName(type, this.isQualified(type));
        return javaTypeFullName;
    }

    private void addJavaTypeImport(Set<IJstType> typeSet) {
        for (IJstType type : typeSet) {
            boolean usedFullName = this.m_clzType.getImportsMap().containsKey(type.getName());
            if (!this.isJsrType(type)) {
                if (type instanceof JstRefType) {
                    if (!type.getName().startsWith("java.util")) continue;
                    this.m_javaTypeMgr.add(type.getName(), type.getSimpleName(), usedFullName);
                }
                if (!this.shouldExcludeFromImport(type)) {
                    this.m_javaTypeMgr.add(type.getName(), type.getSimpleName(), usedFullName);
                }
            }
            if (!this.m_config.getFilters().isSerializableForVjo(type, true)) continue;
            Class<?> javaTypeForSerialable = this.m_config.getFilters().getJavaTypeForSerialable(type);
            if (javaTypeForSerialable != null) {
                this.m_vjoSerializableTypeMgr.add(javaTypeForSerialable.getName(), javaTypeForSerialable.getSimpleName(), usedFullName);
                continue;
            }
            this.m_vjoSerializableTypeMgr.add(type.getName(), type.getSimpleName(), usedFullName);
        }
    }

    /*
     * WARNING - void declaration
     */
    private List<Stack<SimpleParam>> collectArgTypesAndPermutation(int index, List<JstArg> args, Set<IJstType> typeSet, JstType otype) {
        ArrayList<Stack<SimpleParam>> paramStackPermutation = new ArrayList<Stack<SimpleParam>>();
        if (index == args.size()) {
            paramStackPermutation.add(EMPTY_STACK);
            return paramStackPermutation;
        }
        JstArg arg = args.get(index);
        boolean isTypeRef = arg.getType() instanceof IJstRefType;
        List argTypes = arg.getTypes();
        boolean needsIValueBinding = false;
        if (index == args.size() - 1) {
            for (IJstType argType : argTypes) {
                if (!JsrGenerator.isPublic(argType)) {
                    return null;
                }
                if (otype != null && !this.m_clzType.isOType() && otype.getInactiveImport(argType.getSimpleName()) != null) {
                    this.addJsrTypeImport(otype.getInactiveImport(argType.getSimpleName()), false);
                } else {
                    this.addAsInactiveImport(argType);
                }
                boolean isObjectType = this.m_JsToJavaMapper.isObject(argType);
                this.isMappedEventType(argType);
                this.isBrowserEventType(argType);
                this.collectType(argType, typeSet);
                if (args.size() == 1 && !isObjectType && this.m_JsToJavaMapper.supportsValueBinding(argType)) {
                    this.m_needsIValueBinding = true;
                } else if (args.size() > 1 && this.m_JsToJavaMapper.supportsValueBinding(argType)) {
                    this.m_needsIValueBinding = true;
                }
                Stack<SimpleParam> paramStack = new Stack<SimpleParam>();
                SimpleParam simpleParam = this.processSimpleParam(arg, isTypeRef, argType);
                String string = this.getMappedEventName(argType.getSimpleName());
                if (string != null) {
                    simpleParam.setMappedName(string);
                    Stack<SimpleParam> eventParamStack = this.createEventArgStack(arg, isTypeRef, argType);
                    Stack<SimpleParam> eventParamStack2 = this.createEventArgStack(arg, isTypeRef, (IJstType)JstFactory.getInstance().createJstType("org.eclipse.vjet.vsf.resource.html.event.handler.JsHandlerObjectEnum", true));
                    paramStackPermutation.add(eventParamStack);
                    paramStackPermutation.add(eventParamStack2);
                    this.addJsrTypeImport(argType, true, true);
                }
                paramStack.push(simpleParam);
                paramStackPermutation.add(paramStack);
            }
        } else {
            List<Stack<SimpleParam>> tList = this.collectArgTypesAndPermutation(index + 1, args, typeSet, otype);
            if (tList == null) {
                return null;
            }
            int size = argTypes.size();
            int i = 0;
            while (i < size) {
                IJstType argType = (IJstType)argTypes.get(i);
                if (!this.isObjectType(argType) && !this.isMappedEventType(argType)) {
                    if (this.m_JsToJavaMapper.supportsValueBinding(argType)) {
                        needsIValueBinding = true;
                    }
                    this.collectType(argType, typeSet);
                } else {
                    this.collectType(argType, typeSet);
                    needsIValueBinding = false;
                }
                SimpleParam param = new SimpleParam(arg, argType, arg.isOptional(), isTypeRef);
                for (Stack<SimpleParam> stack : tList) {
                    void var15_21;
                    String mappedEventName;
                    if (i != size - 1) {
                        Stack stack2 = (Stack)stack.clone();
                    }
                    if ((mappedEventName = this.getMappedEventName(argType.getSimpleName())) != null) {
                        paramStackPermutation.add((Stack<SimpleParam>)var15_21);
                        Stack<SimpleParam> eventParamStack = (Stack<SimpleParam>)var15_21.clone();
                        Stack<SimpleParam> eventParamStack2 = (Stack<SimpleParam>)var15_21.clone();
                        eventParamStack = this.createEventArgStack(arg, isTypeRef, argType, eventParamStack);
                        eventParamStack2 = this.createEventArgStack(arg, isTypeRef, (IJstType)JstFactory.getInstance().createJstType("org.eclipse.vjet.vsf.resource.html.event.handler.JsHandlerObjectEnum", true), eventParamStack2);
                        paramStackPermutation.add(eventParamStack);
                        paramStackPermutation.add(eventParamStack2);
                        this.addJsrTypeImport(argType, true, true);
                        continue;
                    }
                    var15_21.push(param);
                    paramStackPermutation.add((Stack<SimpleParam>)var15_21);
                }
                ++i;
            }
            if (!this.m_needsIValueBinding) {
                this.m_needsIValueBinding = needsIValueBinding;
            }
        }
        return paramStackPermutation;
    }

    private Stack<SimpleParam> createEventArgStack(JstArg arg, boolean isTypeRef, IJstType argType) {
        return this.createEventArgStack(arg, isTypeRef, argType, new Stack<SimpleParam>());
    }

    private Stack<SimpleParam> createEventArgStack(JstArg arg, boolean isTypeRef, IJstType argType, Stack<SimpleParam> eventParamStack) {
        SimpleParam paramWithOutMapping = this.processSimpleParam(arg, isTypeRef, argType);
        eventParamStack.push(paramWithOutMapping);
        return eventParamStack;
    }

    private SimpleParam processSimpleParam(JstArg arg, boolean isTypeRef, IJstType argType) {
        SimpleParam simpleParam = new SimpleParam(arg, argType, arg.isOptional(), isTypeRef);
        return simpleParam;
    }

    private boolean isBrowserEventType(IJstType argType) {
        return this.m_JsToJavaMapper.isBrowserEventType(argType);
    }

    private static boolean isDuplicate(List<List<SimpleParam>> existedLists, List<SimpleParam> theList) {
        for (List<SimpleParam> existedOne : existedLists) {
            if (existedOne.size() != theList.size()) continue;
            boolean isDuplicate = true;
            int i = 0;
            while (i < theList.size()) {
                if (theList.get(i) != existedOne.get(i)) {
                    isDuplicate = false;
                    break;
                }
                ++i;
            }
            if (!isDuplicate) continue;
            return true;
        }
        return false;
    }

    private String getJsrNameForTypeDecl(IJstType type) {
        String jsrNameForInner = this.getJsrNameForInner(type, false);
        TypeMeta meta = this.m_jsrTypeMgr.get(jsrNameForInner);
        if (meta == null) {
            throw new RuntimeException(" JSR name = " + jsrNameForInner + " typename = " + type.getName() + " should not be in " + this.m_clzType.getName());
        }
        String name = meta.m_useFullName ? meta.m_fullName : meta.m_simpleName;
        name = type instanceof JstTypeWithArgs ? String.valueOf(name) + this.getArgsDecoration((JstTypeWithArgs)type) : String.valueOf(name) + this.getDefaultArgsDecoration(type.getParamTypes());
        return name;
    }

    private String getTypeName(IJstType type, boolean isNonProxy) {
        return this.getTypeName(this.m_clzType, type, isNonProxy);
    }

    private String getTypeName(IJstType type, IJsrTypeProvider.Type ... typeMapping) {
        TypeMeta tm = this.m_jsrTypeMgr.get(type.getName());
        if (tm != null && !tm.m_useFullName) {
            this.m_JsToJavaMapper.getJavaTypeSimpleName(type, typeMapping);
        }
        return this.m_JsToJavaMapper.getJavaTypeFullName(type, typeMapping);
    }

    private String getTypeSimpleName(IJstType type, IJsrTypeProvider.Type ... typeMapping) {
        TypeMeta tm;
        if (type != null && (tm = this.m_jsrTypeMgr.get(type.getName())) != null && tm.m_useFullName) {
            this.m_JsToJavaMapper.getJavaTypeFullName(type, typeMapping);
        }
        return this.m_JsToJavaMapper.getJavaTypeSimpleName(type, typeMapping);
    }

    private String getTypeName(IJstType currentType, IJstType type, boolean isNonProxy) {
        return this.m_JsToJavaMapper.getJavaTypeFullName(type, IJsrTypeProvider.Type.Wrapper);
    }

    private boolean isInnerOType(IJstType currentType, String name) {
        if (currentType.isOType() && currentType.getOTypes().size() > 0) {
            for (IJstOType otype : currentType.getOTypes()) {
                IJstOType type;
                if (!(otype instanceof IJstType) || !name.equals((type = otype).getName()) && !name.equals(type.getSimpleName())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean shouldExcludeFromImport(IJstType type) {
        if (type == null) {
            throw new NullPointerException("Invalid import type, JstType cannot be null");
        }
        if (type.getName() == null) {
            throw new NullPointerException("JstType cannot have a null name");
        }
        if (this.m_JsToJavaMapper.isExcludedFromImport(type)) {
            return true;
        }
        if (this.m_importExclusionList.contains(type)) {
            return true;
        }
        if (!this.shouldAcceptImport(type.getName()) || this.skipJsrImport(type) || this.isObjectType(type)) {
            this.m_importExclusionList.add(type);
            return true;
        }
        return false;
    }

    private boolean shouldAcceptImport(String typeName) {
        if (this.m_customJsrProvider == null) {
            return true;
        }
        return this.m_customJsrProvider.shouldAcceptImport(typeName);
    }

    private boolean skipJsrImport(IJstType type) {
        return this.m_config.getFilters().isSkipImportJsr(type);
    }

    private boolean isJsrType(IJstType type) {
        return this.m_config.getFilters().isJsr(type.getName());
    }

    private static boolean isPublic(IJstType type) {
        if (type instanceof JstArray) {
            type = ((JstArray)type).getElementType();
        }
        if (type instanceof JstParamType) {
            return true;
        }
        return type.getModifiers().isPublic();
    }

    private boolean needValueBinding(List<SimpleParam> list) {
        return this.m_JsToJavaMapper.supportsValueBinding(list);
    }

    private String typeBinding(IJstType typeName) {
        String typeName2 = this.getQualifiedType(typeName);
        boolean addExtends = !typeName2.endsWith("[]") && !"Void".equals(typeName2) && (this.m_hasGenericParams || !this.m_config.getFilters().isJavaPrimitiveOrWrapper(typeName2));
        return "IValueBinding<" + (addExtends ? "? extends " : "") + typeName2 + ">";
    }

    private String getNewJsObjDataString(IJstType jstType, String jsrName) {
        IJstType outer = jstType;
        if (outer.isEmbededType()) {
            outer = jstType.getOuterType();
            while (outer.getOuterType() != null) {
                outer = outer.getOuterType();
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append("new JsObjData(\"").append(jstType.getName()).append("\", ").append(jsrName).append(".class, \"").append(outer.getSimpleName()).append("\"");
        if (this.m_enableScriptingJava) {
            sb.append(", true");
        }
        sb.append(")");
        return sb.toString();
    }

    private boolean isObjectType(IJstType type) {
        String name = DataTypeHelper.getTypeName((String)type.getName());
        if ("java.lang.Object".equals(name) || NATIVE_OBJECT.equals(name) || Object.class.getName().equals(name)) {
            return true;
        }
        if (type instanceof JstRefType) {
            return ((JstRefType)type).getRefType() == java.lang.Object.class;
        }
        return false;
    }

    private boolean isMappedEventType(IJstType type) {
        return this.m_JsToJavaMapper.isMappedEventType(type);
    }

    private String getMappedEventName(String typeName) {
        return this.m_customJsrProvider == null ? null : this.m_customJsrProvider.getMappedEvent(typeName);
    }

    private String getWrapperType(IJstType type) {
        return this.m_JsToJavaMapper.getJavaTypeSimpleName(type, IJsrTypeProvider.Type.Wrapper, this.isQualified(type));
    }

    private String getQualifiedType(IJstType type) {
        return this.m_JsToJavaMapper.getJavaTypeSimpleName(type, this.isQualified(type), IJsrTypeProvider.Type.AddParams);
    }

    private String getParamsDecoration(IJstType type) {
        if (type.getParamNames().isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder("<");
        int i = 0;
        for (JstParamType p : type.getParamTypes()) {
            if (i++ > 0) {
                sb.append(",");
            }
            sb.append(this.getTypeName((IJstType)p, false));
            if (p.getBounds().isEmpty()) continue;
            IJstType bType = (IJstType)p.getBounds().get(0);
            sb.append(" extends ").append(this.getTypeSimpleName(bType, IJsrTypeProvider.Type.Qualified));
        }
        sb.append(">");
        return sb.toString();
    }

    private String getArgsDecoration(JstTypeWithArgs templatedType) {
        StringBuilder sb = new StringBuilder("<");
        int i = 0;
        for (IJstType p : templatedType.getArgTypes()) {
            if (i++ > 0) {
                sb.append(",");
            }
            if (p instanceof JstWildcardType) {
                sb.append("?");
                if ("?".equals(p.getSimpleName())) continue;
                if (((JstWildcardType)p).isUpperBound()) {
                    sb.append(" extends ").append(this.getTypeName(p, false));
                    continue;
                }
                if (!((JstWildcardType)p).isLowerBound()) continue;
                sb.append(" super ").append(this.getTypeName(p, false));
                continue;
            }
            sb.append(this.getTypeName(p, false));
        }
        sb.append(">");
        return sb.toString();
    }

    private String getDefaultArgsDecoration(List<JstParamType> params) {
        if (params.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder("<");
        int i = 0;
        while (i < params.size()) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(NATIVE_OBJECT);
            ++i;
        }
        sb.append(">");
        return sb.toString();
    }

    private int getOverloadedIndex(String methodName, int argSize) {
        String key = String.valueOf(methodName) + "_" + argSize;
        Integer value = this.m_overloadedMap.get(key);
        int index = 0;
        if (value != null) {
            index = value + 1;
        }
        this.m_overloadedMap.put(key, index);
        return index;
    }

    public JsrGenerator writeNewlineAndIndent() {
        super.writeNewline().writeIndent();
        return this;
    }

    private void writePkg() {
        if (this.m_clzType.getPackage() != null && this.m_clzType.getPackage().getName().length() > 0) {
            this.getWriter().append(PACKAGE).append(this.m_clzType.getPackage().getName()).append(";");
            this.writeNewline();
        }
    }

    public int getInitialIndent() {
        return this.m_initialIndent;
    }

    public void setInitialIndent(int indent) {
        this.m_initialIndent = indent;
    }

    private String classTemplateCast(String typeName) {
        return "(Class<" + typeName + ">)null";
    }

    private boolean isEqual(IJstMethod source, IJstMethod target) {
        List sourceArgs = source.getArgs();
        List targetArgs = target.getArgs();
        int sourceArgsCount = sourceArgs.size();
        int targetArgsCount = targetArgs.size();
        if (!source.getOriginalName().equals(target.getOriginalName())) {
            return false;
        }
        if (sourceArgsCount == 0 && targetArgsCount == 0) {
            return true;
        }
        if (sourceArgsCount == targetArgsCount) {
            int i = 0;
            while (i < sourceArgsCount) {
                IJstType sourceType = ((JstArg)sourceArgs.get(i)).getType();
                IJstType targetType = ((JstArg)targetArgs.get(i)).getType();
                if (this.m_JsToJavaMapper.isMappedEventType(sourceType) && this.m_JsToJavaMapper.isMappedEventType(targetType)) {
                    return true;
                }
                if (!sourceType.equals(targetType)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private String getNativeProxyType(IJstType nativeType) {
        return this.m_JsToJavaMapper.getJavaTypeFullName(nativeType, IJsrTypeProvider.Type.Wrapper);
    }

    public IJsrTypeProvider getJsToJavaMapper() {
        return this.m_JsToJavaMapper;
    }

    public void setJsToJavaMapper(IJsrTypeProvider jsToJavaMapper) {
        this.m_JsToJavaMapper = jsToJavaMapper;
    }

    private static class MethodMeta {
        IJstMethod m_method;
        List<List<SimpleParam>> m_argListPermutation;

        MethodMeta(IJstMethod method, List<Stack<SimpleParam>> params) {
            this.m_method = method;
            this.m_argListPermutation = new ArrayList<List<SimpleParam>>(params.size());
            for (Stack<SimpleParam> paramStack : params) {
                ArrayList<SimpleParam> argList = new ArrayList<SimpleParam>(paramStack.size());
                this.m_argListPermutation.add(argList);
                while (!paramStack.isEmpty()) {
                    argList.add(paramStack.pop());
                }
            }
        }
    }

    private static class TypeMeta {
        String m_fullName;
        String m_simpleName;
        String m_fullNameInJava;
        boolean m_useFullName = false;
        boolean m_inactiveType = false;
        boolean m_usedInDecl = false;

        TypeMeta(String fullName, String simpleName, boolean usedFullName) {
            this(fullName, simpleName, usedFullName, false, false);
        }

        TypeMeta(String fullName, String simpleName, boolean usedFullName, boolean isInactiveType, boolean usedInDecl) {
            this.m_fullName = fullName;
            this.m_simpleName = simpleName;
            this.m_fullNameInJava = this.m_fullName;
            this.m_inactiveType = isInactiveType;
            if (usedFullName || simpleName.equals(fullName)) {
                this.m_useFullName = true;
            }
        }

        public String toString() {
            return String.valueOf(this.m_fullName) + "[" + this.m_fullNameInJava + "]";
        }
    }

    private static class TypeMetaMgr {
        private Map<String, TypeMeta> m_fullNameMap = new LinkedHashMap<String, TypeMeta>();
        private Map<String, TypeMeta> m_simpleNameMap = new LinkedHashMap<String, TypeMeta>();
        private IJsrFilters m_jsrFilters = null;

        TypeMetaMgr() {
        }

        TypeMetaMgr(IJsrFilters jsrFilters) {
            this.m_jsrFilters = jsrFilters;
        }

        TypeMeta get(String fullName) {
            return this.m_fullNameMap.get(fullName);
        }

        void add(String fullName, String simpleName, boolean usedFullName) {
            this.add(fullName, simpleName, usedFullName, false, false);
        }

        void add(String fullName, String simpleName, boolean usedFullName, boolean isInactive, boolean usedInDecl) {
            if (!this.m_fullNameMap.containsKey(fullName)) {
                TypeMeta meta = new TypeMeta(fullName, simpleName, usedFullName, isInactive, usedInDecl);
                if (this.m_jsrFilters != null) {
                    meta.m_fullNameInJava = this.m_jsrFilters.normalize(fullName);
                }
                this.add(meta);
            }
        }

        private void add(TypeMeta type) {
            if (this.m_simpleNameMap.get(type.m_simpleName) != null) {
                type.m_useFullName = true;
            } else {
                this.m_simpleNameMap.put(type.m_simpleName, type);
            }
            this.m_fullNameMap.put(type.m_fullName, type);
        }

        void addToSimpleNameMap(TypeMeta type) {
            this.m_simpleNameMap.put(type.m_simpleName, type);
        }

        Iterator<TypeMeta> getMetaItr() {
            return this.m_fullNameMap.values().iterator();
        }
    }
}

