/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jsgen.shared.jstvalidator;

import java.io.PrintStream;
import java.util.List;
import org.eclipse.vjet.dsf.jsgen.shared.validation.common.IJstValidationPolicy;
import org.eclipse.vjet.dsf.jst.IScriptProblem;
import org.eclipse.vjet.dsf.jst.ProblemSeverity;

public class ProblemReporter {
    public static final char NEWLINE = System.getProperty("line.separator").charAt(0);
    private IJstValidationPolicy m_policy;
    private char[] m_fileSource;

    public void printToConsole(List<IScriptProblem> prbs, char[] fileSource) {
        this.m_fileSource = fileSource;
        for (IScriptProblem p : prbs) {
            this.printProblem(System.out, p);
        }
    }

    private void printProblem(PrintStream out, IScriptProblem p) {
        if (p.type() == ProblemSeverity.error) {
            out.print("ERROR:");
        }
        if (p.type() == ProblemSeverity.warning) {
            out.print("WARNING:");
        }
        out.println("Problem Type:" + p.getID().getName());
        if (p.getMessage() != null) {
            out.println(p.getMessage());
        }
        out.println("in file " + new String(p.getOriginatingFileName()));
        this.printLocationInfo(out, p);
        out.println("\n-------------------------");
    }

    private void printLocationInfo(PrintStream out, IScriptProblem p) {
        out.println("line : " + p.getSourceLineNumber() + " col: " + p.getColumn());
        int lineCount = 1;
        int startPrinting = 0;
        int i = 0;
        while (i < p.getSourceEnd() && i < this.m_fileSource.length) {
            if (this.m_fileSource[i] == NEWLINE) {
                ++lineCount;
            }
            if (lineCount == p.getSourceLineNumber()) {
                if (startPrinting == 0) {
                    startPrinting = i;
                }
                out.print(this.m_fileSource[i]);
            }
            ++i;
        }
        out.println();
        int j = 0;
        while (j <= p.getColumn()) {
            if (j == p.getColumn()) {
                out.println("^");
            } else if (startPrinting + j < this.m_fileSource.length && this.m_fileSource[startPrinting + j] != '\t') {
                out.print(" ");
            } else {
                out.print("\t");
            }
            ++j;
        }
    }
}

