/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.rules;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.VjoSemanticProblem;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.VjoSemanticProblemFactory;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.VjoSemanticRule;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.VjoConstants;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.rules.rulectx.InvalidIdentifierNameWithKeywordRuleCtx;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.term.JstIdentifier;

public class VjoInvalidIdentifierWithKeywordRule
extends VjoSemanticRule<InvalidIdentifierNameWithKeywordRuleCtx> {
    private static Pattern s_idPattern = Pattern.compile("[a-zA-Z_$][0-9a-zA-Z_$]*|\\$anonymous\\$");
    private static final String[] VJO_KEYWORDS = new String[]{"vj$", "base", "_getBase"};
    private static final String[] VJO_KEYWORDS_4_ETYPE = new String[]{"vj$", "base", "_getBase", "name", "ordinal", "values"};
    private static final String[] JAVA_FULL_KEYWORDS = VjoConstants.JAVA_FULL_KEYWORDS.toArray(new String[VjoConstants.JAVA_FULL_KEYWORDS.size()]);

    @Override
    public VjoSemanticProblem doFire(InvalidIdentifierNameWithKeywordRuleCtx ctx) {
        String identifierName = ctx.getIdentifierName();
        if (identifierName != null) {
            Matcher m = s_idPattern.matcher(identifierName);
            if (!m.matches()) {
                VjoSemanticProblem problem = VjoSemanticProblemFactory.getInstance().createProblem(ctx.getArguments(), ctx.getGroupId(), this.getProblemId(), this.getErrMsg(), ctx.getNode(), this);
                return problem;
            }
            String[] keywordsInCtx = ctx.getKeywordsInContext();
            if (keywordsInCtx != null) {
                if (this.isKeyword(identifierName, keywordsInCtx)) {
                    VjoSemanticProblem problem = VjoSemanticProblemFactory.getInstance().createProblem(ctx.getArguments(), ctx.getGroupId(), this.getProblemId(), this.getErrMsg(), ctx.getNode(), this);
                    return problem;
                }
            } else {
                if (this.isCorrectCtx(ctx.getNode()) && this.isKeyword(identifierName, ctx.isEnumContexted() ? VJO_KEYWORDS_4_ETYPE : VJO_KEYWORDS)) {
                    VjoSemanticProblem problem = VjoSemanticProblemFactory.getInstance().createProblem(ctx.getArguments(), ctx.getGroupId(), this.getProblemId(), this.getErrMsg(), ctx.getNode(), this);
                    return problem;
                }
                if (this.isKeyword(identifierName, JAVA_FULL_KEYWORDS)) {
                    VjoSemanticProblem problem = VjoSemanticProblemFactory.getInstance().createProblem(ctx.getArguments(), ctx.getGroupId(), this.getProblemId(), this.getErrMsg(), ctx.getNode(), this);
                    return problem;
                }
            }
        }
        return null;
    }

    private boolean isCorrectCtx(IJstNode node) {
        JstIdentifier id;
        return !(node instanceof JstIdentifier) || (id = (JstIdentifier)node).getQualifier() != null;
    }

    private boolean isKeyword(String name, String[] keywords) {
        String[] stringArray = keywords;
        int n = keywords.length;
        int n2 = 0;
        while (n2 < n) {
            String vjoKeyword = stringArray[n2];
            if (vjoKeyword.equals(name)) {
                return true;
            }
            if (name != null && name.startsWith("\"") && name.endsWith("\"") && name.length() > 1 && vjoKeyword.equals(name.substring(1, name.length() - 1))) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

