/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.validator;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.VjoSemanticValidator;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.VjoValidationCtx;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.rules.VjoSemanticRuleRepo;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.rules.rulectx.BaseVjoSemanticRuleCtx;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.rules.rulectx.MethodAndReturnFlowRuleCtx;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.rules.util.TypeCheckUtil;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.util.JstBindingUtil;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.visitor.IVjoValidationPostAllChildrenListener;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.visitor.IVjoValidationVisitorEvent;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstArg;
import org.eclipse.vjet.dsf.jst.declaration.JstBlock;
import org.eclipse.vjet.dsf.jst.declaration.JstMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstTypeWithArgs;
import org.eclipse.vjet.dsf.jst.expr.FieldAccessExpr;
import org.eclipse.vjet.dsf.jst.expr.MtdInvocationExpr;
import org.eclipse.vjet.dsf.jst.stmt.RtnStmt;
import org.eclipse.vjet.dsf.jst.stmt.SwitchStmt;
import org.eclipse.vjet.dsf.jst.stmt.ThrowStmt;
import org.eclipse.vjet.dsf.jst.term.SimpleLiteral;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.dsf.jst.util.JstTypeHelper;

public class VjoRtnStmtValidator
extends VjoSemanticValidator
implements IVjoValidationPostAllChildrenListener {
    private static List<Class<? extends IJstNode>> s_targetTypes = new ArrayList<Class<? extends IJstNode>>();

    static {
        s_targetTypes.add(RtnStmt.class);
        s_targetTypes.add(ThrowStmt.class);
    }

    @Override
    public List<Class<? extends IJstNode>> getTargetNodeTypes() {
        return s_targetTypes;
    }

    @Override
    public void onPostAllChildrenEvent(IVjoValidationVisitorEvent event) {
        VjoValidationCtx ctx = event.getValidationCtx();
        IJstNode jstNode = event.getVisitNode();
        if (!(jstNode instanceof RtnStmt) && !(jstNode instanceof ThrowStmt)) {
            return;
        }
        JstMethod meth = this.lookUpMethod(jstNode);
        if (jstNode instanceof ThrowStmt) {
            if (!(jstNode.getParentNode() instanceof JstBlock) || !(jstNode.getParentNode().getParentNode() instanceof SwitchStmt)) {
                ctx.getMethodControlFlowTable().addStmt((IJstMethod)meth, (ThrowStmt)jstNode);
            }
        } else {
            BaseVjoSemanticRuleCtx ruleCtx;
            RtnStmt rtnStmt = (RtnStmt)jstNode;
            if (meth == null) {
                return;
            }
            List rtnTypes = JstTypeHelper.getRtnTypes((JstMethod)meth);
            if (!(jstNode.getParentNode() instanceof JstBlock) || !(jstNode.getParentNode().getParentNode() instanceof SwitchStmt)) {
                ctx.getMethodControlFlowTable().addStmt((IJstMethod)meth, rtnStmt);
            }
            IExpr rtnExpr = rtnStmt.getExpression();
            IJstNode rtnBinding = JstBindingUtil.getJstBinding((IJstNode)rtnExpr);
            ArrayList<IJstType> rtnValues = new ArrayList<IJstType>();
            if (rtnBinding != null && rtnBinding instanceof JstArg) {
                rtnValues.addAll(((JstArg)rtnBinding).getTypes());
            } else if (rtnExpr != null && rtnExpr.getResultType() != null) {
                rtnValues.add(rtnExpr.getResultType());
            }
            JstTypeWithArgs typeWithArgs = null;
            if (rtnExpr != null) {
                IJstType resultType;
                IExpr qualifier;
                if (rtnExpr instanceof FieldAccessExpr) {
                    qualifier = ((FieldAccessExpr)rtnExpr).getExpr();
                    if (qualifier != null && (resultType = qualifier.getResultType()) != null && resultType instanceof JstTypeWithArgs) {
                        typeWithArgs = (JstTypeWithArgs)resultType;
                    }
                } else if (rtnExpr instanceof MtdInvocationExpr && (qualifier = ((MtdInvocationExpr)rtnExpr).getQualifyExpr()) != null && (resultType = qualifier.getResultType()) != null && resultType instanceof JstTypeWithArgs) {
                    typeWithArgs = (JstTypeWithArgs)resultType;
                }
            }
            boolean allVoid = true;
            boolean allNoneVoid = true;
            for (IJstType rtnType : rtnTypes) {
                if (rtnType == null) {
                    allNoneVoid = false;
                    continue;
                }
                if ("void".equals(rtnType.getSimpleName())) {
                    allNoneVoid = false;
                    continue;
                }
                allVoid = false;
            }
            if (allVoid) {
                MethodAndReturnFlowRuleCtx ruleCtx2 = new MethodAndReturnFlowRuleCtx((IJstNode)rtnStmt, ctx.getGroupId(), new String[]{meth.getName().getName()}, (IJstMethod)meth, ctx.getMethodControlFlowTable());
                this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().VOID_METHOD_SHOULD_NOT_HAVE_RETURN, ruleCtx2);
                return;
            }
            if (rtnValues.size() == 0 && !allVoid || rtnExpr == null) {
                return;
            }
            String[] ruleCtxArgs = new String[4];
            StringBuilder rtnValueSb = new StringBuilder();
            boolean first = true;
            for (IJstType rtnValue : rtnValues) {
                if (rtnValue != null && rtnValue.getName() != null) {
                    if (!first) {
                        rtnValueSb.append(",");
                    }
                    rtnValueSb.append(rtnValue.getName());
                }
                first = false;
            }
            String v = rtnValueSb.toString();
            if ("".equals(v)) {
                v = "Undefined";
            }
            ruleCtxArgs[0] = v;
            ruleCtxArgs[1] = VjoRtnStmtValidator.getTypeNames(rtnTypes);
            ruleCtxArgs[2] = meth.getName().getName();
            ruleCtxArgs[3] = rtnStmt.toStmtText();
            if (rtnExpr instanceof SimpleLiteral && "null".equals(rtnExpr.toExprText())) {
                return;
            }
            if (rtnValues.size() == 0 && allNoneVoid) {
                ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)rtnStmt, ctx.getGroupId(), ruleCtxArgs);
                this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().METHOD_RETURN_VALUE_SHOULD_COMPLY, ruleCtx);
                return;
            }
            if (rtnValues.size() > 0 && !VjoRtnStmtValidator.isAssignable(typeWithArgs, rtnTypes, rtnValues)) {
                ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)rtnStmt, ctx.getGroupId(), ruleCtxArgs);
                this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().METHOD_RETURN_VALUE_SHOULD_COMPLY, ruleCtx);
            }
        }
    }

    private static boolean isAssignable(JstTypeWithArgs typeWithArgs, List<IJstType> rtnTypes, List<IJstType> rtnValues) {
        for (IJstType rtnType : rtnTypes) {
            for (IJstType rtnValue : rtnValues) {
                if (rtnValue == null) {
                    if (rtnType != null && !"void".equals(rtnType.getName())) continue;
                    return true;
                }
                if (rtnType == null) {
                    return true;
                }
                if (!(rtnType instanceof JstTypeWithArgs && rtnValue instanceof JstTypeWithArgs ? TypeCheckUtil.isAssignable(null, typeWithArgs, (JstTypeWithArgs)rtnType, (JstTypeWithArgs)rtnValue) : TypeCheckUtil.isAssignable(rtnType, rtnValue))) continue;
                return true;
            }
        }
        return false;
    }

    private static String getTypeNames(List<IJstType> rtnTypes) {
        HashSet<IJstType> sets = new HashSet<IJstType>(rtnTypes);
        rtnTypes = new ArrayList<IJstType>(sets);
        if (sets.size() == 1) {
            IJstType type = rtnTypes.get(0);
            return type == null ? "null" : type.getSimpleName();
        }
        StringBuilder sb = new StringBuilder();
        IJstType type = null;
        int i = 1;
        while (i <= rtnTypes.size()) {
            type = rtnTypes.get(i - 1);
            sb.append(type == null ? "null" : type.getSimpleName());
            if (i == rtnTypes.size() - 1) {
                sb.append(" or ");
            }
            if (i < rtnTypes.size() - 1) {
                sb.append(" , ");
            }
            ++i;
        }
        return sb.toString();
    }
}

