/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jsnative.anno;

public enum BrowserType {
    IE_6("IE", 6),
    IE_6P("IE", 6, true),
    IE_7("IE", 7),
    IE_7P("IE", 7, true),
    IE_8("IE", 8),
    IE_8P("IE", 8, true),
    IE_9("IE", 9),
    IE_9P("IE", 9, true),
    FIREFOX_1("FIREFOX", 1),
    FIREFOX_1P("FIREFOX", 1, true),
    FIREFOX_2("FIREFOX", 2),
    FIREFOX_2P("FIREFOX", 2, true),
    FIREFOX_3("FIREFOX", 3),
    FIREFOX_3P("FIREFOX", 3, true),
    FIREFOX_4P("FIREFOX", 4, true),
    FIREFIX_4("FIREFOX", 4),
    FIREFOX_5P("FIREFOX", 5, true),
    FIREFIX_5("FIREFOX", 5),
    OPERA_7("OPERA", 7),
    OPERA_7P("OPERA", 7, true),
    OPERA_8("OPERA", 8),
    OPERA_8P("OPERA", 8, true),
    OPERA_9("OPERA", 9),
    OPERA_9P("OPERA", 9, true),
    SAFARI_3("SAFARI", 3),
    SAFARI_3P("SAFARI", 3, true),
    RHINO_1("Rhino", 1),
    RHINO_1P("Rhino", 1, true),
    NONE("None", 0),
    CHROME_1P("CHROME", 1, true),
    UNDEFINED("UNDEFINED", 0);

    private String m_name;
    private int m_version;
    private boolean m_plus = false;

    private BrowserType(String name, int version) {
        this.m_name = name;
        this.m_version = version;
    }

    private BrowserType(String name, int version, boolean plus) {
        this.m_name = name;
        this.m_version = version;
        this.m_plus = plus;
    }

    public String getName() {
        return this.m_name;
    }

    public int getVersion() {
        return this.m_version;
    }

    public boolean isPlus() {
        return this.m_plus;
    }

    public boolean isIE() {
        switch (this) {
            case IE_6: 
            case IE_6P: 
            case IE_7: 
            case IE_7P: 
            case IE_8: 
            case IE_8P: {
                return true;
            }
        }
        return false;
    }

    public boolean isFireFox() {
        switch (this) {
            case FIREFOX_1: 
            case FIREFOX_1P: 
            case FIREFOX_2: 
            case FIREFOX_2P: 
            case FIREFOX_3: 
            case FIREFOX_3P: {
                return true;
            }
        }
        return false;
    }

    public boolean isOpera() {
        switch (this) {
            case OPERA_7: 
            case OPERA_7P: 
            case OPERA_8: 
            case OPERA_8P: 
            case OPERA_9: 
            case OPERA_9P: {
                return true;
            }
        }
        return false;
    }

    public boolean isSafari() {
        switch (this) {
            case SAFARI_3: 
            case SAFARI_3P: {
                return true;
            }
        }
        return false;
    }
}

