/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jst.expr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.vjet.dsf.common.Z;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstRefType;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstParamType;
import org.eclipse.vjet.dsf.jst.declaration.JstTypeWithArgs;
import org.eclipse.vjet.dsf.jst.expr.FieldAccessExpr;
import org.eclipse.vjet.dsf.jst.term.JstIdentifier;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.dsf.jst.token.IStmt;
import org.eclipse.vjet.dsf.jst.traversal.IJstNodeVisitor;

public class MtdInvocationExpr
extends BaseJstNode
implements IExpr,
IStmt {
    private static final long serialVersionUID = 1L;
    private IExpr m_mtdIdentifier;
    private IExpr m_qualifyExpr;
    private List<IExpr> m_args;
    private IJstType m_resultType;

    public MtdInvocationExpr(String name, IExpr ... args) {
        this(new JstIdentifier(name), args);
    }

    public MtdInvocationExpr(JstIdentifier name, IExpr ... args) {
        this((IExpr)name, args);
    }

    public MtdInvocationExpr(IExpr mtdIdentifier, IExpr ... args) {
        this.m_mtdIdentifier = mtdIdentifier;
        this.addChild(mtdIdentifier);
        if (args.length > 0) {
            this.m_args = this.getArgs(true);
            IExpr[] iExprArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                IExpr arg = iExprArray[n2];
                this.m_args.add(arg);
                this.addChild(arg);
                ++n2;
            }
        }
    }

    @Override
    public IJstType getResultType() {
        if (this.m_resultType != null) {
            return this.m_resultType;
        }
        if (this.m_mtdIdentifier != null) {
            IJstType type = this.m_mtdIdentifier.getResultType();
            if (type instanceof JstParamType && this.m_qualifyExpr != null && (type = this.m_qualifyExpr.getResultType()) instanceof JstTypeWithArgs) {
                type = ((JstTypeWithArgs)type).getArgType();
            }
            if (type instanceof IJstRefType) {
                return type;
            }
        }
        return null;
    }

    @Override
    public String toExprText() {
        StringBuilder sb = new StringBuilder();
        String q = null;
        if (this.m_qualifyExpr != null) {
            q = this.m_qualifyExpr.toExprText();
        }
        String m = null;
        if (this.m_mtdIdentifier != null) {
            m = this.m_mtdIdentifier.toExprText();
        }
        if (q != null) {
            sb.append(q);
        }
        if (q != null && m != null) {
            sb.append(".");
        }
        if (m != null) {
            sb.append(m);
        }
        sb.append("(");
        if (this.m_args != null) {
            int i = 0;
            while (i < this.m_args.size()) {
                if (this.m_args.get(i) != null) {
                    if (i > 0) {
                        sb.append(",");
                    }
                    sb.append(this.m_args.get(i).toExprText());
                }
                ++i;
            }
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public String toStmtText() {
        return String.valueOf(this.toExprText()) + ";";
    }

    public IExpr getMethodIdentifier() {
        return this.m_mtdIdentifier;
    }

    public MtdInvocationExpr setQualifyExpr(IExpr qualifyExpr) {
        this.removeChild(this.m_qualifyExpr);
        this.addChild(qualifyExpr);
        this.m_qualifyExpr = qualifyExpr;
        return this;
    }

    public IExpr getQualifyExpr() {
        return this.m_qualifyExpr;
    }

    public List<IExpr> getArgs() {
        if (this.m_args == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_args);
    }

    public void setArg(int index, IExpr arg) {
        if (index < 0 || arg == null) {
            return;
        }
        if (this.m_args == null || this.m_args.size() < index + 1) {
            return;
        }
        this.m_args.set(index, arg);
    }

    public void setArgs(List<IExpr> args) {
        if (this.m_args != null) {
            for (IExpr arg : this.m_args) {
                this.removeChild(arg);
            }
        }
        if (args != null && args.size() > 0) {
            this.m_args = new ArrayList<IExpr>();
            for (IExpr arg : args) {
                this.m_args.add(arg);
                this.addChild(arg);
            }
        }
    }

    public MtdInvocationExpr addArg(IExpr expr) {
        assert (expr != null) : "expr canoot be null";
        this.getArgs(true).add(expr);
        this.addChild(expr);
        return this;
    }

    public void setResultType(IJstType resultType) {
        this.m_resultType = resultType;
    }

    public IJstNode getMethod() {
        if (this.m_mtdIdentifier instanceof JstIdentifier) {
            return ((JstIdentifier)this.m_mtdIdentifier).getJstBinding();
        }
        if (this.m_mtdIdentifier instanceof FieldAccessExpr) {
            return ((FieldAccessExpr)this.m_mtdIdentifier).getName().getJstBinding();
        }
        return null;
    }

    @Override
    public void accept(IJstNodeVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        Z z = new Z();
        z.format("m_funcName", (Object)this.m_mtdIdentifier);
        if (this.m_args != null) {
            for (IExpr p : this.m_args) {
                if (p == null) continue;
                z.format("arg", (Object)p.toString());
            }
        }
        if (this.m_resultType != null) {
            z.format("m_resultType", (Object)this.m_resultType);
        }
        return z.toString();
    }

    private List<IExpr> getArgs(boolean create) {
        if (this.m_args == null && create) {
            this.m_args = new ArrayList<IExpr>();
        }
        return this.m_args;
    }
}

