/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jst.stmt;

import org.eclipse.vjet.dsf.jst.declaration.JstBlock;
import org.eclipse.vjet.dsf.jst.stmt.BlockStmt;
import org.eclipse.vjet.dsf.jst.stmt.CatchStmt;
import org.eclipse.vjet.dsf.jst.token.ITryStmt;
import org.eclipse.vjet.dsf.jst.traversal.IJstNodeVisitor;

public class TryStmt
extends BlockStmt
implements ITryStmt {
    private static final long serialVersionUID = 1L;
    private JstBlock m_catchBlock;
    private JstBlock m_finallyBlock;

    public void addCatch(CatchStmt catchStmt) {
        this.getCatchBlock(true).addStmt(catchStmt);
    }

    @Override
    public JstBlock getCatchBlock() {
        return this.m_catchBlock;
    }

    public JstBlock getCatchBlock(boolean create) {
        if (this.m_catchBlock == null && create) {
            this.m_catchBlock = new JstBlock();
            this.addChild(this.m_catchBlock);
        }
        return this.m_catchBlock;
    }

    @Override
    public JstBlock getFinallyBlock() {
        return this.m_finallyBlock;
    }

    public JstBlock getFinallyBlock(boolean create) {
        if (this.m_finallyBlock == null && create) {
            this.m_finallyBlock = new JstBlock();
            this.addChild(this.m_finallyBlock);
        }
        return this.m_finallyBlock;
    }

    @Override
    public String toStmtText() {
        StringBuilder sb = new StringBuilder("try {");
        sb.append(this.getBody().toBlockText()).append("}");
        if (this.m_catchBlock != null) {
            sb.append(this.m_catchBlock.toBlockText());
        }
        if (this.m_finallyBlock != null) {
            sb.append(this.m_finallyBlock.toBlockText());
        }
        return sb.toString();
    }

    @Override
    public void accept(IJstNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public String toString() {
        return this.toStmtText();
    }
}

