/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jst.ts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.vjet.dsf.jst.IJstParseController;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.ts.JstTypeSpaceMgr;
import org.eclipse.vjet.dsf.ts.event.EventListenerStatus;
import org.eclipse.vjet.dsf.ts.event.ISourceEvent;
import org.eclipse.vjet.dsf.ts.event.ISourceEventCallback;
import org.eclipse.vjet.dsf.ts.event.TypeSpaceEvent;
import org.eclipse.vjet.dsf.ts.event.dispatch.IEventListenerHandle;
import org.eclipse.vjet.dsf.ts.event.group.AddGroupDependencyEvent;
import org.eclipse.vjet.dsf.ts.event.group.AddGroupEvent;
import org.eclipse.vjet.dsf.ts.event.group.BatchGroupLoadingEvent;
import org.eclipse.vjet.dsf.ts.event.group.IGroupEventListener;
import org.eclipse.vjet.dsf.ts.event.group.RemoveGroupDependencyEvent;
import org.eclipse.vjet.dsf.ts.event.group.RemoveGroupEvent;
import org.eclipse.vjet.dsf.ts.event.method.AddMethodEvent;
import org.eclipse.vjet.dsf.ts.event.method.IMethodEventListener;
import org.eclipse.vjet.dsf.ts.event.method.ModifyMethodEvent;
import org.eclipse.vjet.dsf.ts.event.method.RemoveMethodEvent;
import org.eclipse.vjet.dsf.ts.event.method.RenameMethodEvent;
import org.eclipse.vjet.dsf.ts.event.property.AddPropertyEvent;
import org.eclipse.vjet.dsf.ts.event.property.IPropertyEventListener;
import org.eclipse.vjet.dsf.ts.event.property.RemovePropertyEvent;
import org.eclipse.vjet.dsf.ts.event.property.RenamePropertyEvent;
import org.eclipse.vjet.dsf.ts.event.type.AddTypeEvent;
import org.eclipse.vjet.dsf.ts.event.type.ITypeEventListener;
import org.eclipse.vjet.dsf.ts.event.type.ModifyTypeEvent;
import org.eclipse.vjet.dsf.ts.event.type.RemoveTypeEvent;
import org.eclipse.vjet.dsf.ts.event.type.RenameTypeEvent;
import org.eclipse.vjet.dsf.ts.group.Group;
import org.eclipse.vjet.dsf.ts.group.IGroup;
import org.eclipse.vjet.dsf.ts.group.Project;
import org.eclipse.vjet.dsf.ts.type.TypeName;

public class JstEventListener
implements IGroupEventListener<IJstType>,
ITypeEventListener<IJstType>,
IPropertyEventListener,
IMethodEventListener {
    private JstTypeSpaceMgr m_mgr;

    public JstEventListener(JstTypeSpaceMgr mgr) {
        assert (mgr != null) : "mgr cannot be null";
        this.m_mgr = mgr;
    }

    @Override
    public EventListenerStatus<IJstType> onGroupAdded(AddGroupEvent event, IEventListenerHandle handle, ISourceEventCallback<IJstType> callBack) {
        if (event == null) {
            EventListenerStatus<IJstType> status = new EventListenerStatus<IJstType>(EventListenerStatus.Code.NoOp, "event is null");
            this.callback(callBack, status);
            return status;
        }
        ArrayList<AddGroupEvent> list = new ArrayList<AddGroupEvent>(1);
        list.add(event);
        EventListenerStatus<IJstType> status = new EventListenerStatus(EventListenerStatus.Code.Started);
        try {
            try {
                status = this.m_mgr.getJstTypeSpaceLoader().loadJstTypesIntoTS(list, callBack);
            }
            catch (Throwable e) {
                status = new EventListenerStatus(EventListenerStatus.Code.Exception, e.getMessage());
                this.notify(TypeSpaceEvent.EventId.Updated, event, status);
                this.callback(callBack, status);
            }
        }
        finally {
            this.notify(TypeSpaceEvent.EventId.Updated, event, status);
            this.callback(callBack, status);
        }
        return status;
    }

    @Override
    public EventListenerStatus<IJstType> onGroupRemoveDependency(RemoveGroupDependencyEvent event, IEventListenerHandle handle, ISourceEventCallback<IJstType> callBack) {
        if (event == null) {
            EventListenerStatus<IJstType> status = new EventListenerStatus<IJstType>(EventListenerStatus.Code.NoOp, "event is null");
            this.callback(callBack, status);
            return status;
        }
        EventListenerStatus<IJstType> status = new EventListenerStatus<IJstType>(EventListenerStatus.Code.Started);
        List<RemoveGroupEvent> dependencyList = event.getDependencyList();
        String targetProjName = event.getGroupName();
        IGroup target = this.m_mgr.getTypeSpaceImpl().getGroup(targetProjName);
        Project project = null;
        if (target != null && target instanceof Project) {
            project = (Project)target;
        }
        try {
            try {
                if (target == null) {
                    status = new EventListenerStatus(EventListenerStatus.Code.Failed, "fail to locate target group " + targetProjName);
                } else if (project != null) {
                    for (RemoveGroupEvent dependencyGrp : dependencyList) {
                        project.removeGroupDependency(dependencyGrp.getGroupName());
                    }
                }
            }
            catch (Throwable e) {
                status = new EventListenerStatus(EventListenerStatus.Code.Exception, e.getMessage());
                this.notify(TypeSpaceEvent.EventId.Updated, event, status);
                this.callback(callBack, status);
            }
        }
        finally {
            this.notify(TypeSpaceEvent.EventId.Updated, event, status);
            this.callback(callBack, status);
        }
        return status;
    }

    @Override
    public EventListenerStatus<IJstType> onGroupAddDependency(AddGroupDependencyEvent event, IEventListenerHandle handle, ISourceEventCallback<IJstType> callBack) {
        if (event == null) {
            EventListenerStatus<IJstType> status = new EventListenerStatus<IJstType>(EventListenerStatus.Code.NoOp, "event is null");
            this.callback(callBack, status);
            return status;
        }
        EventListenerStatus<IJstType> status = new EventListenerStatus<IJstType>(EventListenerStatus.Code.Started);
        List<AddGroupEvent> dependencyList = event.getDependencyList();
        String targetProjName = event.getGroupName();
        IGroup target = this.m_mgr.getTypeSpaceImpl().getGroup(targetProjName);
        try {
            try {
                if (target == null) {
                    status = new EventListenerStatus(EventListenerStatus.Code.Failed, "fail to locate target group " + targetProjName);
                } else {
                    ArrayList<AddGroupEvent> groupList = new ArrayList<AddGroupEvent>(1);
                    for (AddGroupEvent dependencyGrp : dependencyList) {
                        if (this.m_mgr.getTypeSpaceImpl().getGroup(dependencyGrp.getGroupName()) != null) continue;
                        groupList.add(dependencyGrp);
                    }
                    status = this.m_mgr.getJstTypeSpaceLoader().loadJstTypesIntoTS(groupList, callBack);
                    Project thisProj = null;
                    if (target instanceof Project) {
                        thisProj = (Project)target;
                    }
                    if (thisProj != null) {
                        for (AddGroupEvent dependencyGrp : dependencyList) {
                            thisProj.addGroupDependency(dependencyGrp.getGroupName());
                        }
                    }
                }
            }
            catch (Throwable e) {
                status = new EventListenerStatus(EventListenerStatus.Code.Exception, e.getMessage());
                this.notify(TypeSpaceEvent.EventId.Updated, event, status);
                this.callback(callBack, status);
            }
        }
        finally {
            this.notify(TypeSpaceEvent.EventId.Updated, event, status);
            this.callback(callBack, status);
        }
        return status;
    }

    @Override
    public EventListenerStatus<IJstType> onBatchGroupLoaded(BatchGroupLoadingEvent event, IEventListenerHandle handle, ISourceEventCallback<IJstType> callBack) {
        if (event == null) {
            EventListenerStatus<IJstType> status = new EventListenerStatus<IJstType>(EventListenerStatus.Code.NoOp, "event is null");
            this.callback(callBack, status);
            return status;
        }
        EventListenerStatus<IJstType> status = new EventListenerStatus(EventListenerStatus.Code.Started);
        try {
            try {
                status = this.m_mgr.getJstTypeSpaceLoader().loadJstTypesIntoTS(event.getAllGroups(), callBack);
            }
            catch (Throwable e) {
                e.printStackTrace();
                status = new EventListenerStatus(EventListenerStatus.Code.Exception, e.getMessage());
                this.notify(TypeSpaceEvent.EventId.Loaded, event, status);
                this.callback(callBack, status);
            }
        }
        finally {
            this.notify(TypeSpaceEvent.EventId.Loaded, event, status);
            this.callback(callBack, status);
        }
        return status;
    }

    @Override
    public void onGroupRemoved(RemoveGroupEvent event) {
        if (event == null) {
            return;
        }
        IGroup group = this.m_mgr.getTypeSpaceImpl().getGroup(event.getGroupName());
        if (group == null) {
            return;
        }
        Collection entities = ((Group)group).getEntities().values();
        ArrayList<String> entries = new ArrayList<String>();
        for (IJstType type : entities) {
            entries.add(type.getName());
        }
        if (group != null && entries != null && entries.size() > 0) {
            for (String key : entries) {
                try {
                    this.m_mgr.getTypeDependencyMgr().removeType(new TypeName(((Group)group).getName(), key));
                }
                catch (Exception exception) {}
            }
        }
        this.m_mgr.getTypeSpaceImpl().removeGroup(event.getGroupName());
    }

    @Override
    public EventListenerStatus<IJstType> onTypeAdded(AddTypeEvent<IJstType> event, IEventListenerHandle handle, ISourceEventCallback<IJstType> callback) {
        EventListenerStatus<IJstType> status;
        block10: {
            if (event == null) {
                EventListenerStatus<IJstType> status2 = new EventListenerStatus<IJstType>(EventListenerStatus.Code.NoOp, "event is null");
                this.callback(callback, status2);
                return status2;
            }
            IJstType type = event.getType();
            String groupName = event.getGroupName();
            String fileName = event.getFileName();
            status = new EventListenerStatus<IJstType>(EventListenerStatus.Code.Started);
            try {
                try {
                    JstType jstType;
                    IJstParseController jstParseController = this.m_mgr.getJstParseController();
                    if (type == null) {
                        type = jstParseController.parseAndResolve(groupName, fileName, event.getTypeSource());
                    }
                    if (type == null) {
                        status = new EventListenerStatus(EventListenerStatus.Code.Failed, "fail to parse the source of " + groupName + ": " + fileName);
                        break block10;
                    }
                    if (type instanceof JstType && !(jstType = (JstType)type).getStatus().hasResolution()) {
                        jstParseController.resolve(type);
                    }
                    this.m_mgr.getTypeDependencyMgr().addType(new TypeName(groupName, type.getName()), type);
                    Object userObj = event.getUserObject();
                    if (userObj != null) {
                        this.m_mgr.getTypeSpaceImpl().setUserObject(new TypeName(groupName, type.getName()), userObj);
                    }
                    status = new EventListenerStatus<IJstType>(EventListenerStatus.Code.Successful, type);
                }
                catch (Throwable e) {
                    status = new EventListenerStatus(EventListenerStatus.Code.Exception, e.getMessage());
                    this.notify(TypeSpaceEvent.EventId.Updated, event, status);
                    this.callback(callback, status);
                }
            }
            finally {
                this.notify(TypeSpaceEvent.EventId.Updated, event, status);
                this.callback(callback, status);
            }
        }
        return status;
    }

    @Override
    public EventListenerStatus<IJstType> onTypeRenamed(RenameTypeEvent event, IEventListenerHandle handle, ISourceEventCallback<IJstType> callback) {
        if (event == null) {
            EventListenerStatus<IJstType> status = new EventListenerStatus<IJstType>(EventListenerStatus.Code.NoOp, "event is null");
            this.callback(callback, status);
            return status;
        }
        IJstType type = null;
        EventListenerStatus<IJstType> status = new EventListenerStatus<IJstType>(EventListenerStatus.Code.Started);
        try {
            try {
                type = this.m_mgr.getTypeSpaceImpl().renameType(event.getTypeName(), event.getNewTypeName());
                if (type != null) {
                    this.renameTypeInPackage(type, event.getTypeName(), event.getNewTypeName());
                }
                status = new EventListenerStatus<IJstType>(EventListenerStatus.Code.Successful, type);
            }
            catch (Throwable e) {
                status = new EventListenerStatus(EventListenerStatus.Code.Exception, e.getMessage());
                this.notify(TypeSpaceEvent.EventId.Updated, event, status);
                this.callback(callback, status);
            }
        }
        finally {
            this.notify(TypeSpaceEvent.EventId.Updated, event, status);
            this.callback(callback, status);
        }
        return status;
    }

    private void renameTypeInPackage(IJstType type, TypeName oldName, String newName) {
        String oldPackageName = "";
        String newPackageName = "";
        String groupName = oldName.groupName();
        String oldTypeName = oldName.typeName();
        int last = oldTypeName.lastIndexOf(".");
        if (last > 0) {
            oldPackageName = oldTypeName.substring(0, last);
        }
        if ((last = newName.lastIndexOf(".")) > 0) {
            newPackageName = newName.substring(0, last);
        }
        this.m_mgr.getTypeSpaceImpl().removeTypeFromPackage(oldPackageName, oldName);
        this.m_mgr.getTypeSpaceImpl().addTypeToPackage(newPackageName, new TypeName(groupName, newName), type);
    }

    @Override
    public EventListenerStatus<IJstType> onTypeModified(ModifyTypeEvent event, IEventListenerHandle handle, ISourceEventCallback<IJstType> callback) {
        EventListenerStatus<IJstType> status;
        block12: {
            if (event == null) {
                EventListenerStatus<IJstType> status2 = new EventListenerStatus<IJstType>(EventListenerStatus.Code.NoOp, "event is null");
                this.callback(callback, status2);
                return status2;
            }
            IJstType type = event.getType();
            String groupName = event.getGroupName();
            String fileName = event.getFileName();
            status = new EventListenerStatus<IJstType>(EventListenerStatus.Code.Started);
            try {
                try {
                    if (type == null) {
                        IJstParseController jstParseController = this.m_mgr.getJstParseController();
                        type = jstParseController.parseAndResolve(groupName, fileName, event.getTypeSource());
                    }
                    if (type == null) {
                        status = new EventListenerStatus(EventListenerStatus.Code.Failed, "fail to parse the source");
                        break block12;
                    }
                    TypeName typeName = event.getTypeName();
                    if (typeName == null) {
                        typeName = new TypeName(groupName, type.getName());
                    }
                    this.m_mgr.getTypeDependencyMgr().removeType(typeName);
                    this.m_mgr.getTypeDependencyMgr().addType(typeName, type);
                    List<IJstType> dependents = null;
                    if (type.isMixin()) {
                        dependents = this.m_mgr.getTypeSpace().getAllDependents(typeName);
                        for (IJstType dependent : dependents) {
                            ((JstType)dependent).fixMixin(type);
                        }
                    }
                    dependents = this.m_mgr.getQueryExecutor().findAllDependentTypes(typeName);
                    for (IJstType dependent : dependents) {
                        this.m_mgr.getJstParseController().resolve(dependent);
                    }
                    status = new EventListenerStatus<IJstType>(EventListenerStatus.Code.Successful, type);
                }
                catch (Throwable e) {
                    status = new EventListenerStatus(EventListenerStatus.Code.Exception, e.getMessage());
                    this.notify(TypeSpaceEvent.EventId.Updated, event, status);
                    this.callback(callback, status);
                }
            }
            finally {
                this.notify(TypeSpaceEvent.EventId.Updated, event, status);
                this.callback(callback, status);
            }
        }
        return status;
    }

    @Override
    public EventListenerStatus<IJstType> onTypeRemoved(RemoveTypeEvent event, IEventListenerHandle handle, ISourceEventCallback<IJstType> callback) {
        if (event == null) {
            EventListenerStatus<IJstType> status = new EventListenerStatus<IJstType>(EventListenerStatus.Code.NoOp, "event is null");
            this.callback(callback, status);
            return status;
        }
        EventListenerStatus<IJstType> status = new EventListenerStatus<IJstType>(EventListenerStatus.Code.Started);
        IJstType type = null;
        try {
            try {
                type = this.m_mgr.getTypeDependencyMgr().removeType(event.getTypeName());
                status = new EventListenerStatus<IJstType>(EventListenerStatus.Code.Successful, type);
            }
            catch (Throwable e) {
                status = new EventListenerStatus(EventListenerStatus.Code.Exception, e.getMessage());
                this.notify(TypeSpaceEvent.EventId.Updated, event, status);
                this.callback(callback, status);
            }
        }
        finally {
            this.notify(TypeSpaceEvent.EventId.Updated, event, status);
            this.callback(callback, status);
        }
        return status;
    }

    @Override
    public void onPropertyAdded(AddPropertyEvent event) {
        if (event == null) {
            return;
        }
        IJstParseController jstParseController = this.m_mgr.getJstParseController();
        jstParseController.resolve(event.getProperty());
        this.m_mgr.getPropertyIndexMgr().addProperty(event.getPropertyName(), event.isPropertyStatic(), event.getProperty());
    }

    @Override
    public void onPropertyRenamed(RenamePropertyEvent event) {
        if (event == null) {
            return;
        }
        this.m_mgr.getTypeSpaceImpl().renameProperty(event.getPropertyName(), event.getNewPropertyName());
    }

    @Override
    public void onPropertyRemoved(RemovePropertyEvent event) {
        if (event == null) {
            return;
        }
        this.m_mgr.getPropertyIndexMgr().removeProperty(event.getPropertyName(), event.isPropertyStatic());
    }

    @Override
    public void onMethodAdded(AddMethodEvent event) {
        if (event == null) {
            return;
        }
        IJstParseController jstParseController = this.m_mgr.getJstParseController();
        jstParseController.resolve(event.getMethod());
        this.m_mgr.getMethodIndexMgr().addMethod(event.getMethodName(), event.getMethod());
    }

    @Override
    public void onMethodRenamed(RenameMethodEvent event) {
        if (event == null) {
            return;
        }
        this.m_mgr.getTypeSpaceImpl().renameMethod(event.getMethodName(), event.getNewMethodName());
    }

    @Override
    public void onMethodModified(ModifyMethodEvent event) {
        if (event == null) {
            return;
        }
        IJstParseController jstParseController = this.m_mgr.getJstParseController();
        jstParseController.resolve(event.getMethod());
        this.m_mgr.getMethodIndexMgr().modifyMethod(event.getMethodName(), event.isMethodStatic(), event.getMethod());
    }

    @Override
    public void onMethodRemoved(RemoveMethodEvent event) {
        if (event == null) {
            return;
        }
        this.m_mgr.getMethodIndexMgr().removeMethod(event.getMethodName(), event.isMethodStatic());
    }

    private void notify(TypeSpaceEvent.EventId eventId, ISourceEvent event, EventListenerStatus status) {
        this.m_mgr.getTypeSpaceEventDispatcher().dispatch(new TypeSpaceEvent<ISourceEvent>(eventId, event), status);
    }

    private void callback(ISourceEventCallback<IJstType> callback, EventListenerStatus<IJstType> status) {
        if (callback == null) {
            return;
        }
        callback.onComplete(status);
    }
}

