/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.ts.event;

import org.eclipse.vjet.dsf.common.Z;
import org.eclipse.vjet.dsf.ts.event.EventListenerStatus;
import org.eclipse.vjet.dsf.ts.event.ITypeSpaceEvent;
import org.eclipse.vjet.dsf.ts.event.ITypeSpaceEventListener;

public class TypeSpaceEvent<T>
implements ITypeSpaceEvent {
    private EventId m_id;
    private T m_trigger;

    public TypeSpaceEvent(EventId id) {
        this.m_id = id;
    }

    public TypeSpaceEvent(EventId id, T trigger) {
        this.m_id = id;
        this.m_trigger = trigger;
    }

    @Override
    public boolean isAppropriateListener(ITypeSpaceEventListener listener) {
        return true;
    }

    @Override
    public void dispatch(ITypeSpaceEventListener listener, EventListenerStatus status) {
        if (listener == null) {
            return;
        }
        if (this.m_id == EventId.Loaded) {
            listener.onLoaded(this, status);
        } else if (this.m_id == EventId.Updated) {
            listener.onUpdated(this, status);
        } else if (this.m_id == EventId.Unloaded) {
            listener.onUnloaded(this, status);
        }
    }

    public EventId getId() {
        return this.m_id;
    }

    public T getTrigger() {
        return this.m_trigger;
    }

    public String toString() {
        Z z = new Z();
        z.format("m_id", (Object)this.m_id);
        if (this.m_trigger != null) {
            z.format("m_trigger", (Object)this.m_trigger.getClass().getSimpleName());
        }
        return z.toString();
    }

    public static enum EventId {
        Init,
        Loaded,
        Updated,
        Unloaded;

    }
}

