/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.ts.event.type;

import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.ts.event.ISourceEventCallback;
import org.eclipse.vjet.dsf.ts.event.ISourceEventListener;
import org.eclipse.vjet.dsf.ts.event.dispatch.IEventListenerHandle;
import org.eclipse.vjet.dsf.ts.event.type.ITypeEventListener;
import org.eclipse.vjet.dsf.ts.event.type.TypeEvent;
import org.eclipse.vjet.dsf.ts.type.TypeName;

public final class AddTypeEvent<T>
extends TypeEvent {
    private String m_src;
    private String m_groupName;
    private String m_fileName;
    private IJstType m_type;
    private Object m_userObj;

    public AddTypeEvent(String fileName, String src) {
        this(null, fileName, src, null);
    }

    public AddTypeEvent(String fileName, String src, Object userObj) {
        this(null, fileName, src, userObj);
    }

    public AddTypeEvent(TypeName typeName, IJstType jstType) {
        this(typeName, jstType, null);
    }

    public AddTypeEvent(TypeName typeName, IJstType jstType, Object userObj) {
        super(typeName);
        if (typeName == null) {
            throw new AssertionError((Object)"typeName cannot be null");
        }
        this.m_src = null;
        this.m_groupName = typeName.groupName();
        this.m_fileName = typeName.typeName();
        this.m_type = jstType;
        this.m_userObj = userObj;
    }

    public AddTypeEvent(String groupName, String fileName, String src) {
        this(groupName, fileName, src, null);
    }

    public AddTypeEvent(String groupName, String fileName, String src, Object userObj) {
        super(new TypeName(groupName, fileName));
        this.m_src = src;
        this.m_groupName = groupName;
        this.m_fileName = fileName;
        this.m_userObj = userObj;
    }

    @Override
    public void dispatch(ISourceEventListener listener) {
        if (listener == null) {
            return;
        }
        ((ITypeEventListener)listener).onTypeAdded(this, null, null);
    }

    @Override
    public void dispatch(ISourceEventListener listener, IEventListenerHandle handle, ISourceEventCallback callback) {
        if (listener == null) {
            return;
        }
        ((ITypeEventListener)listener).onTypeAdded(this, handle, callback);
    }

    public String getGroupName() {
        return this.m_groupName;
    }

    public String getFileName() {
        return this.m_fileName;
    }

    public String getTypeSource() {
        return this.m_src;
    }

    public IJstType getType() {
        return this.m_type;
    }

    public Object getUserObject() {
        return this.m_userObj;
    }

    @Override
    public boolean shouldLock() {
        return true;
    }
}

