/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jsgroup.bootstrap;

import java.util.ArrayList;
import org.eclipse.vjet.dsf.jstojava.mixer.TypeExtensionRegistry;
import org.eclipse.vjet.dsf.jstojava.mixer.TypeMixer;
import org.eclipse.vjet.dsf.jstojava.resolver.FunctionMetaMapping;
import org.eclipse.vjet.dsf.jstojava.resolver.FunctionMetaRegistry;
import org.eclipse.vjet.dsf.jstojava.resolver.IMetaExtension;
import org.eclipse.vjet.dsf.jstojava.resolver.MapBasedTypeResolver;
import org.eclipse.vjet.dsf.jstojava.resolver.ScriptableBasedTypeResolver;
import org.eclipse.vjet.dsf.jstojava.resolver.SingleThreadExecutor;
import org.eclipse.vjet.dsf.jstojava.resolver.TypeResolverRegistry;
import org.mozilla.mod.javascript.Context;
import org.mozilla.mod.javascript.ContextFactory;
import org.mozilla.mod.javascript.Function;
import org.mozilla.mod.javascript.NativeArray;
import org.mozilla.mod.javascript.Scriptable;
import org.mozilla.mod.javascript.ScriptableObject;

public class JsLibBootstrapLoader {
    public static final String factoryFunctionMappings = "factoryFunctionMappings";
    public static final String functionArgMappings = "functionArgMappings";
    public static final String typeExtensions = "typeExtensions";

    public static void load(String bootstrapJS, String groupId) {
        SingleThreadExecutor executor = SingleThreadExecutor.getInstance();
        executor.execute(new Runner(bootstrapJS, groupId));
    }

    private static void loadMethodReturnTypeResolvers(Context cx, Scriptable scope, String groupId) {
        TypeResolverRegistry trs = TypeResolverRegistry.getInstance();
        Object fm = scope.get(factoryFunctionMappings, scope);
        if (fm instanceof Scriptable) {
            Scriptable factory = (Scriptable)fm;
            Object[] objectArray = factory.getIds();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Scriptable map;
                Object[] keys;
                Object resKey = objectArray[n2];
                Object def = factory.get(resKey.toString(), factory);
                if (def instanceof Function) {
                    trs.addResolver(resKey.toString(), new ScriptableBasedTypeResolver(groupId, cx, scope, (Function)def));
                } else if (def instanceof Scriptable && (keys = (map = (Scriptable)def).getIds()) != null && keys.length > 0) {
                    MapBasedTypeResolver resolver = new MapBasedTypeResolver(groupId);
                    Object[] objectArray2 = keys;
                    int n3 = keys.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Object key = objectArray2[n4];
                        resolver.addMapping(key.toString(), map.get(key.toString(), map).toString());
                        ++n4;
                    }
                    trs.addResolver(resKey.toString(), resolver);
                }
                ++n2;
            }
        }
    }

    private static void loadFunctionArgMetaExtension(Context cx, Scriptable scope, String groupId) {
        FunctionMetaRegistry fms = FunctionMetaRegistry.getInstance();
        Object fm = scope.get(functionArgMappings, scope);
        if (fm instanceof Scriptable) {
            Scriptable famMapping = (Scriptable)fm;
            FunctionMetaMapping funcMeta = new FunctionMetaMapping(groupId);
            boolean hasMapping = false;
            Object[] objectArray = famMapping.getIds();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Scriptable map;
                Object[] keys;
                Object methodId = objectArray[n2];
                Object def = famMapping.get(methodId.toString(), famMapping);
                if (def instanceof Scriptable && (keys = (map = (Scriptable)def).getIds()) != null && keys.length > 0) {
                    Object[] objectArray2 = keys;
                    int n3 = keys.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Object key = objectArray2[n4];
                        String[] metaList = null;
                        Object meta = map.get(key.toString(), map);
                        if (meta instanceof String) {
                            metaList = new String[]{(String)meta};
                        } else if (meta instanceof NativeArray) {
                            NativeArray metaArr = (NativeArray)meta;
                            metaList = new String[(int)metaArr.getLength()];
                            int i = 0;
                            while ((long)i < metaArr.getLength()) {
                                metaList[i] = metaArr.get(i, (Scriptable)metaArr).toString();
                                ++i;
                            }
                        }
                        if (metaList != null) {
                            funcMeta.addMapping(methodId.toString(), key.toString(), metaList);
                        }
                        hasMapping = true;
                        ++n4;
                    }
                }
                ++n2;
            }
            if (hasMapping) {
                fms.addMapping(funcMeta);
            }
        }
    }

    private static void loadTypeExtensions(Context cx, Scriptable scope, String groupId) {
        Object te = scope.get(typeExtensions, scope);
        if (te instanceof Scriptable) {
            Scriptable extensions = (Scriptable)te;
            TypeMixer mixer = new TypeMixer(groupId);
            Object[] objectArray = extensions.getIds();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object typeKey = objectArray[n2];
                Object def = extensions.get(typeKey.toString(), extensions);
                if (def instanceof String) {
                    mixer.addExtendedType(typeKey.toString(), def.toString());
                } else if (def instanceof NativeArray) {
                    NativeArray extension = (NativeArray)def;
                    int i = 0;
                    while ((long)i < extension.getLength()) {
                        Object item = extension.get(i, (Scriptable)extension);
                        if (item instanceof String) {
                            mixer.addExtendedType(typeKey.toString(), item.toString());
                        }
                        ++i;
                    }
                }
                ++n2;
            }
            TypeExtensionRegistry.getInstance().addMixer(mixer);
        }
    }

    public static void main(String[] args) {
        JsLibBootstrapLoader.load("var factoryFunctionMappings = {'a.b.A:f1':{'a':'xxx', 'b':'yyy'}, 'a.d.B::f2':function() {if (arguments[0] == '\"default\"') {return 'zzz'} else return 'uuu'}}", "g1");
        JsLibBootstrapLoader.load("var factoryFunctionMappings = {'x.b.A:f1':{'a':'xxx2', 'b':'yyy2'}, 'x.d.B::f2':function() {if (arguments[0] == '\"default\"') {return 'zzz2'} else return 'uuu2'}}", "g2");
        JsLibBootstrapLoader.load("var typeExtensions = {'y.b.A':'u.w.Y', 'y.d.B':'u.v.W'}", "g1");
        JsLibBootstrapLoader.load("var typeExtensions = {'x.b.A':'u.w.X', 'x.d.B':['u.v.Y', 'u.v.Z']}", "g2");
        JsLibBootstrapLoader.load("var functionArgMappings = {'a.b.A:f1':{'open':'void fn(int)', 'click':['boolean fn(String)', 'Date fn(boolean)'],'close':'Window:alert'}}", "g3");
        TypeResolverRegistry trs = TypeResolverRegistry.getInstance();
        System.out.println(trs.resolve("a.b.A:f1", new String[]{"'a'"}));
        System.out.println(trs.resolve("a.b.A:f1", new String[]{"\"b\""}));
        System.out.println(trs.resolve("a.d.B::f2", new String[]{"\"any\""}));
        System.out.println(trs.resolve("a.d.B::f2", new String[]{"\"default\""}));
        System.out.println(trs.resolve("x.b.A:f1", new String[]{"'a'"}));
        System.out.println(trs.resolve("x.b.A:f1", new String[]{"\"b\""}));
        System.out.println(trs.resolve("x.d.B::f2", new String[]{"\"any\""}));
        System.out.println(trs.resolve("x.d.B::f2", new String[]{"\"default\""}));
        TypeExtensionRegistry ter = TypeExtensionRegistry.getInstance();
        System.out.println(ter.getExtension("x.b.A", null, "g2", null));
        System.out.println(ter.getExtension("y.b.A", null, "g1", null));
        System.out.println(ter.getExtension("y.d.B", null, "g1", null));
        ArrayList<String> bases = new ArrayList<String>();
        bases.add("y.d.B");
        ArrayList<String> depGrps = new ArrayList<String>();
        depGrps.add("g1");
        System.out.println(ter.getExtension("x.d.B", bases, "g2", depGrps));
        System.out.println(ter.isNonExtendedType("x.d.C", "g2"));
        System.out.println(ter.getExtension("x.d.C", bases, "g2", null));
        System.out.println(ter.isNonExtendedType("x.d.C", "g2"));
        FunctionMetaRegistry fmr = FunctionMetaRegistry.getInstance();
        IMetaExtension method = fmr.getExtentedArgBinding("a.b.A:f1", "open", "g3", null);
        System.out.println(method.toString());
        method = fmr.getExtentedArgBinding("a.b.A:f1", "click", "g3", null);
        System.out.println(method.toString());
        method = fmr.getExtentedArgBinding("a.b.A:f1", "close", "g3", null);
        System.out.println(method.toString());
        System.out.println(fmr.isFuncMetaMappingSupported("a.b.A:f1"));
        System.out.println(fmr.isFuncMetaMappingSupported("a.b.A:f2"));
    }

    private static class Runner
    implements Runnable {
        private String m_bootstrapJS;
        private String m_groupId;

        private Runner(String bootstrapJS, String groupId) {
            this.m_bootstrapJS = bootstrapJS;
            this.m_groupId = groupId;
        }

        @Override
        public void run() {
            ScriptableObject scope;
            Context cx;
            try {
                cx = ContextFactory.getGlobal().enterContext();
                cx.setLanguageVersion(150);
                scope = cx.initStandardObjects();
                cx.evaluateString((Scriptable)scope, this.m_bootstrapJS, "TypeLibBoostrapJS", 1, null);
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            try {
                JsLibBootstrapLoader.loadMethodReturnTypeResolvers(cx, (Scriptable)scope, this.m_groupId);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                JsLibBootstrapLoader.loadFunctionArgMetaExtension(cx, (Scriptable)scope, this.m_groupId);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                JsLibBootstrapLoader.loadTypeExtensions(cx, (Scriptable)scope, this.m_groupId);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

