/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jstojava.cml.vjetv.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.vjet.dsf.jstojava.cml.vjetv.util.ParserHelper;
import org.eclipse.vjet.dsf.jstojava.loader.OnDemandAllTypeLoader;

public class FileOperator {
    private static final String LIB = "lib";
    public static final String USER_DIR = "user.dir";
    private static final String BIN = "bin";
    private static final String TARGET = "target";
    public static final String CLASSES = "classes";
    public static final String JAR_SUFFIX = ".jar";
    public static final String JAR_FOLDER_SUFFIX = String.valueOf(File.separatorChar) + "*.jar";
    public static final String TEMPFOLDER = String.valueOf(System.getProperty("user.dir")) + File.separatorChar + "VjetTempFolder";
    public static final char DOT = '.';
    private static final String DOT_PATTERN = "[.]";
    private static final int ONE = 1;
    private static final int ZERO = 0;
    public static final String JS_SUFFIX = ".js";
    public static final String JS_FOLDER_SUFFIX = String.valueOf(File.separatorChar) + "*" + ".js";
    public static final String SEPARATOR = File.pathSeparator;
    public static final String JDTCOMPILER = "org.eclipse.jdt.core";
    public static final String JAVASOURCEPATH = "java.source.path";

    public static String bindFileName(String mainFolder, String fileName) {
        StringBuffer sb = new StringBuffer();
        sb.append(mainFolder);
        sb.append(File.separatorChar);
        sb.append(fileName);
        sb.append(File.separatorChar);
        return sb.toString();
    }

    public static String getClassesDir(File home) {
        File[] list = home.listFiles();
        if (list != null) {
            int i = 0;
            while (i < list.length) {
                File temp = list[i];
                String fn = temp.getName();
                if (fn.equals(BIN)) {
                    return BIN;
                }
                if (fn.equals(TARGET)) {
                    File[] files = temp.listFiles();
                    int j = 0;
                    while (j < files.length) {
                        String fileName = files[j].getName();
                        if (fileName.equals(CLASSES)) {
                            StringBuffer sb = new StringBuffer();
                            sb.append(TARGET);
                            sb.append(File.separator);
                            sb.append(CLASSES);
                            return sb.toString();
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return null;
    }

    protected static File getClassFolderWithPackageName(File[] files, String[] pns) {
        int len = pns.length;
        int i = 0;
        while (i < len) {
            int j = 0;
            while (j < files.length) {
                if (files[j].getName().equals(pns[i])) {
                    if (len == 1) {
                        return files[j];
                    }
                    File[] fs = files[j].listFiles();
                    String[] temp = new String[pns.length - i - 1];
                    System.arraycopy(pns, i + 1, temp, 0, temp.length);
                    return FileOperator.getClassFolderWithPackageName(fs, temp);
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public static void getAllJSFiles(File file, LinkedHashSet<File> lists, char[][] exclusionRules) {
        if (file.isDirectory() && file.canRead()) {
            File[] files = file.listFiles();
            int i = 0;
            while (i < files.length) {
                if (files[i].isFile() && files[i].canRead()) {
                    if (FileOperator.isJSFiles(files[i]) && !OnDemandAllTypeLoader.isExcluded(files[i].getAbsolutePath().toCharArray(), null, exclusionRules, false)) {
                        lists.add(files[i]);
                    }
                } else if (files[i].isDirectory() && files[i].canRead()) {
                    FileOperator.getAllJSFiles(files[i], lists, exclusionRules);
                }
                ++i;
            }
        }
        if (file.isFile() && file.canRead() && FileOperator.isJSFiles(file)) {
            lists.add(file);
        }
    }

    private static boolean isJSFiles(File file) {
        return file.getAbsolutePath().toLowerCase().endsWith(JS_SUFFIX);
    }

    public static String getSourceFromFile(File f) {
        byte[] bytes = new byte[1024];
        StringBuffer sb = new StringBuffer();
        try {
            FileInputStream fis = new FileInputStream(f);
            while (fis.read(bytes) != -1) {
                sb.append(new String(bytes));
                bytes = new byte[1024];
            }
            fis.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public static String getSourceLineFromFile(String source, int start, int end) {
        String endString = source.substring(end);
        int newline = endString.indexOf("\n");
        int newEnd = newline == -1 ? source.length() : newline + end;
        int newStart = FileOperator.getNewStringPosition(source, start);
        try {
            return source.substring(newStart, newEnd);
        }
        catch (Exception exception) {
            return source.substring(start, end);
        }
    }

    public static int getNewStringPosition(String source, int start) {
        String startString = source.substring(0, start);
        int lastline = startString.lastIndexOf("\n");
        int newStart = lastline == -1 ? 0 : lastline + 1;
        return newStart;
    }

    public static void getJarsFiles(File file, HashSet<File> lists) {
        if (file.isDirectory() && file.canRead()) {
            File[] files = file.listFiles();
            int i = 0;
            while (i < files.length) {
                if (files[i].isFile() && files[i].canRead() && FileOperator.isJarFiles(files[i])) {
                    lists.add(files[i]);
                }
                ++i;
            }
        }
    }

    public static boolean isJarJsPathValid(String packageName, List<File> buildJars, boolean exist) {
        packageName = FileOperator.replaceSlash2ZipSlash(packageName);
        ZipEntry result = null;
        for (File file : buildJars) {
            ZipFile zip = null;
            try {
                zip = new ZipFile(file);
            }
            catch (ZipException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (packageName != null) {
                result = zip.getEntry(packageName);
            }
            if (result == null) continue;
            return true;
        }
        if (exist) {
            ParserHelper.exitSystem("Please check JS path : " + packageName + "Or exist in buildpath jars!");
        }
        return false;
    }

    private static String replaceDot2Slash(String packageName) {
        if (packageName == null) {
            ParserHelper.exitSystem("Please check JS path!");
        }
        if (packageName.equalsIgnoreCase("")) {
            ParserHelper.exitSystem("Please check JS path : " + packageName + "Or exist in buildpath jars!");
        }
        if (packageName.endsWith(JS_FOLDER_SUFFIX)) {
            packageName = packageName.substring(0, packageName.lastIndexOf(File.separatorChar));
        }
        if (packageName.contains(".")) {
            if (packageName.endsWith(JS_SUFFIX)) {
                packageName = packageName.substring(0, packageName.indexOf(JS_SUFFIX));
                packageName = packageName.replace('.', File.separatorChar);
                packageName = String.valueOf(packageName) + JS_SUFFIX;
            } else {
                packageName = packageName.replace('.', File.separatorChar);
            }
        }
        return packageName;
    }

    private static String replaceSlash2ZipSlash(String packageName) {
        if ((packageName = FileOperator.replaceDot2Slash(packageName)).contains("\\")) {
            packageName = packageName.replace('\\', '/');
        }
        return packageName;
    }

    public static boolean isJarJsPathValid(String packageName, List<File> buildJars) {
        return FileOperator.isJarJsPathValid(packageName, buildJars, true);
    }

    public static boolean isJarFiles(File file) {
        return file.getAbsolutePath().toLowerCase().endsWith(JAR_SUFFIX);
    }

    public static void gatherSpecifiedFiles(String specifiedpath, List<File> buildJars) {
        specifiedpath = FileOperator.replaceSlash2ZipSlash(specifiedpath);
        for (File buildFile : buildJars) {
            try {
                ZipFile zip = new ZipFile(buildFile);
                Enumeration<? extends ZipEntry> en = zip.entries();
                ZipEntry entry = null;
                InputStream input = null;
                BufferedOutputStream bos = null;
                File file = null;
                byte[] buffer = new byte[8192];
                int length = -1;
                while (en.hasMoreElements()) {
                    entry = en.nextElement();
                    if (entry.isDirectory() || !entry.getName().startsWith(specifiedpath) || !entry.getName().endsWith(JS_SUFFIX)) continue;
                    input = zip.getInputStream(entry);
                    file = new File(TEMPFOLDER, entry.getName());
                    if (!file.getParentFile().exists()) {
                        file.getParentFile().mkdirs();
                    }
                    bos = new BufferedOutputStream(new FileOutputStream(file));
                    while ((length = input.read(buffer)) != -1) {
                        bos.write(buffer, 0, length);
                    }
                    bos.close();
                    input.close();
                }
                zip.close();
            }
            catch (ZipException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void delFolder(String folderPath) {
        try {
            FileOperator.delAllFile(folderPath);
            new File(folderPath).delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static boolean delAllFile(String path) {
        boolean flag = false;
        File file = new File(path);
        if (!file.exists()) {
            return flag;
        }
        if (!file.isDirectory()) {
            return flag;
        }
        String[] tempList = file.list();
        File temp = null;
        int i = 0;
        while (i < tempList.length) {
            temp = path.endsWith(File.separator) ? new File(String.valueOf(path) + tempList[i]) : new File(String.valueOf(path) + File.separator + tempList[i]);
            if (temp.isFile()) {
                temp.delete();
            }
            if (temp.isDirectory()) {
                FileOperator.delAllFile(String.valueOf(path) + "/" + tempList[i]);
                FileOperator.delFolder(String.valueOf(path) + "/" + tempList[i]);
                flag = true;
            }
            ++i;
        }
        return flag;
    }
}

