/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jstojava.mixer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.vjet.dsf.jstojava.mixer.TypeMixer;

public class TypeExtensionRegistry {
    private static final TypeExtensionRegistry s_instance = new TypeExtensionRegistry();
    private Map<String, ExtensionInfo> m_extensionInfos = new LinkedHashMap<String, ExtensionInfo>();
    private Set<String> m_groupsWithMixer = new HashSet<String>();

    public static TypeExtensionRegistry getInstance() {
        return s_instance;
    }

    public boolean isNonExtendedType(String targetType, String groupId) {
        ExtensionInfo currentGroupInfo = this.m_extensionInfos.get(groupId);
        return currentGroupInfo != null && currentGroupInfo.isNonExtentedType(targetType);
    }

    public List<String> getExtension(String targetType, List<String> baseTypes, String groupId, List<String> dependentGroupIds) {
        List extensions = null;
        ExtensionInfo currentGroupInfo = this.m_extensionInfos.get(groupId);
        if (currentGroupInfo != null) {
            if (currentGroupInfo.isNonExtentedType(targetType)) {
                return null;
            }
            extensions = currentGroupInfo.getCombinedExtensions(targetType);
            if (extensions != null) {
                return extensions;
            }
        }
        extensions = new ArrayList();
        if (currentGroupInfo != null) {
            this.collectExtensions(extensions, currentGroupInfo, targetType, baseTypes);
        } else {
            currentGroupInfo = new ExtensionInfo(null);
            this.m_extensionInfos.put(groupId, currentGroupInfo);
        }
        if (dependentGroupIds != null) {
            int i = 0;
            while (i < dependentGroupIds.size()) {
                String depGrpId = dependentGroupIds.get(i);
                if (this.m_groupsWithMixer.contains(depGrpId)) {
                    ExtensionInfo info = this.m_extensionInfos.get(depGrpId);
                    this.collectExtensions(extensions, info, targetType, baseTypes);
                }
                ++i;
            }
        }
        if (extensions.isEmpty()) {
            currentGroupInfo.addNonExtentedType(targetType);
            return null;
        }
        currentGroupInfo.addCombinedExtensions(targetType, extensions);
        return extensions;
    }

    public void addMixer(TypeMixer mixer) {
        this.m_extensionInfos.put(mixer.getGroupId(), new ExtensionInfo(mixer));
        this.update();
    }

    public void clear(String groupId) {
        this.m_extensionInfos.remove(groupId);
        this.update();
    }

    public void clearAll() {
        this.m_extensionInfos.clear();
        this.m_groupsWithMixer.clear();
    }

    public void update() {
        this.m_groupsWithMixer.clear();
        for (Map.Entry<String, ExtensionInfo> entry : this.m_extensionInfos.entrySet()) {
            ExtensionInfo info = entry.getValue();
            info.clear();
            if (info.m_mixer == null) continue;
            this.m_groupsWithMixer.add(entry.getKey());
        }
    }

    private void collectExtensions(List<String> extensions, ExtensionInfo info, String targetType, List<String> baseTypes) {
        if (info == null) {
            return;
        }
        this.collect(extensions, info, targetType);
        if (baseTypes != null) {
            for (String baseType : baseTypes) {
                this.collect(extensions, info, baseType);
            }
        }
    }

    private void collect(List<String> extensions, ExtensionInfo info, String targetType) {
        List ext = info.getMixInTypes(targetType);
        if (ext != null) {
            extensions.addAll(ext);
        }
    }

    private static class ExtensionInfo {
        private final TypeMixer m_mixer;
        private Set<String> m_nonExtendedTypes = new HashSet<String>();
        private Map<String, List<String>> m_combinedExtensions = new HashMap<String, List<String>>();

        private ExtensionInfo(TypeMixer mixer) {
            this.m_mixer = mixer;
        }

        private List<String> getMixInTypes(String targetType) {
            return this.m_mixer == null ? null : this.m_mixer.getMixInTypes(targetType);
        }

        private void addNonExtentedType(String targetType) {
            this.m_nonExtendedTypes.add(targetType);
        }

        private boolean isNonExtentedType(String targetType) {
            return this.m_nonExtendedTypes.contains(targetType);
        }

        private List<String> getCombinedExtensions(String targetType) {
            return this.m_combinedExtensions.get(targetType);
        }

        private void addCombinedExtensions(String targetType, List<String> extensions) {
            this.m_combinedExtensions.put(targetType, extensions);
        }

        private void clear() {
            this.m_nonExtendedTypes.clear();
            this.m_combinedExtensions.clear();
        }
    }
}

