/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jstojava.parser;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.mod.wst.jsdt.core.ast.IASTNode;
import org.eclipse.mod.wst.jsdt.core.ast.IProgramElement;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.FieldReference;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.MessageSend;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.vjet.af.common.error.ErrorList;
import org.eclipse.vjet.af.common.error.ErrorObject;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.jsgen.shared.ids.ScopeIds;
import org.eclipse.vjet.dsf.jsgen.shared.jstvalidator.DefaultJstProblem;
import org.eclipse.vjet.dsf.jst.FileBinding;
import org.eclipse.vjet.dsf.jst.IJstLib;
import org.eclipse.vjet.dsf.jst.IJstParser;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.IScriptProblem;
import org.eclipse.vjet.dsf.jst.JstSource;
import org.eclipse.vjet.dsf.jst.ProblemSeverity;
import org.eclipse.vjet.dsf.jst.SimpleBinding;
import org.eclipse.vjet.dsf.jst.declaration.JstBlock;
import org.eclipse.vjet.dsf.jst.declaration.JstCache;
import org.eclipse.vjet.dsf.jst.declaration.JstFactory;
import org.eclipse.vjet.dsf.jst.declaration.JstPackage;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jstojava.parser.AstCompilationResult;
import org.eclipse.vjet.dsf.jstojava.parser.SyntaxTreeFactory2;
import org.eclipse.vjet.dsf.jstojava.report.ErrorReporter;
import org.eclipse.vjet.dsf.jstojava.resolver.TypeConstructorRegistry;
import org.eclipse.vjet.dsf.jstojava.translator.BlockTranslator;
import org.eclipse.vjet.dsf.jstojava.translator.TranslateConfig;
import org.eclipse.vjet.dsf.jstojava.translator.TranslateCtx;
import org.eclipse.vjet.dsf.jstojava.translator.robust.completion.JstCompletion;

public class VjoParser
implements IJstParser {
    public static final IJstType UNKNOWNUNIT = JstFactory.getInstance().createJstType("UNKNOWN_TYPE", false);
    private TranslateConfig m_config;
    private boolean s_debug = false;
    private static Set<String> VJO_TYPE_DEF_KEYS = new HashSet<String>();

    static {
        VJO_TYPE_DEF_KEYS.add("type");
        VJO_TYPE_DEF_KEYS.add("ctype");
        VJO_TYPE_DEF_KEYS.add("itype");
        VJO_TYPE_DEF_KEYS.add("ftype");
        VJO_TYPE_DEF_KEYS.add("mtype");
        VJO_TYPE_DEF_KEYS.add("otype");
        VJO_TYPE_DEF_KEYS.add("etype");
        VJO_TYPE_DEF_KEYS.add("ltype");
        VJO_TYPE_DEF_KEYS.add("needs");
    }

    public VjoParser() {
        this.m_config = new TranslateConfig();
    }

    public VjoParser(TranslateConfig cfg) {
        this.m_config = cfg;
    }

    public IJstType parse(String groupName, String fileName, String source) {
        return this.parseInternal(groupName, fileName, source, new TranslateCtx(this.m_config), null);
    }

    public IJstType parse(String groupName, String fileName, String source, TranslateCtx ctx) {
        return this.parseInternal(groupName, fileName, source, ctx, null);
    }

    public IJstType parse(String groupName, URL url) {
        return this.parse(groupName, url.getFile(), VjoParser.getContent(url));
    }

    public IJstType parse(String groupName, URL url, boolean skiptImplementation) {
        return this.parse(groupName, url.getFile(), VjoParser.getContent(url), skiptImplementation);
    }

    public IJstType parse(String groupName, File file) {
        return this.parseInternal(groupName, file.getAbsolutePath(), VjoParser.getContent(file), file);
    }

    public IJstType parse(String groupName, File file, TranslateCtx ctx) {
        return this.parseInternal(groupName, file.getAbsolutePath(), VjoParser.getContent(file), ctx, file);
    }

    public IJstType parse(String groupName, File file, boolean skiptImplementation) {
        return this.parseInternal(groupName, file.getAbsolutePath(), VjoParser.getContent(file), skiptImplementation, file);
    }

    public IJstType parse(String groupName, String fileName, File file, TranslateCtx ctx) {
        return this.parseInternal(groupName, fileName, VjoParser.getContent(file), ctx, file);
    }

    public IJstType parse(String groupName, String fileName, String source, boolean skiptImplementation) {
        return this.parseInternal(groupName, fileName, source, skiptImplementation, null);
    }

    private IJstType parseInternal(String groupName, String fileName, String source, File file) {
        return this.parseInternal(groupName, fileName, source, new TranslateCtx(this.m_config), file);
    }

    private IJstType parseInternal(String groupName, String fileName, String source, boolean skiptImplementation, File file) {
        TranslateConfig config = new TranslateConfig();
        config.setSkiptImplementation(skiptImplementation);
        return this.parseInternal(groupName, fileName, source, new TranslateCtx(config), file);
    }

    private IJstType parseInternal(String groupName, String fileName, String source, TranslateCtx ctx, File file) {
        if (this.s_debug) {
            this.printJstCacheTypes();
        }
        ctx.setGroup(groupName);
        Map settings = Collections.EMPTY_MAP;
        String mysource = this.convertHTMLCommentsToJsComments(source);
        char[] charsource = mysource.toCharArray();
        String encoding = null;
        AstCompilationResult astResult = SyntaxTreeFactory2.createASTCompilationResult(settings, charsource, fileName, encoding);
        CompilationUnitDeclaration ast = astResult.getCompilationUnitDeclaration();
        ctx.setAST(ast);
        SyntaxTreeFactory2.addAstErrorMessagesToCtx(mysource, ast.compilationResult.getAllProblems(), ctx.getErrorReporter());
        if (astResult.hasNonFakeTokenInsertionError()) {
            ast = SyntaxTreeFactory2.fixedProblems(settings, charsource, fileName, encoding, ast);
        }
        List<JstBlock> createJstBlock = this.createJstBlock(ctx, ast);
        ctx.setScriptUnitBlockList(createJstBlock);
        IJstType type = SyntaxTreeFactory2.createJST(ast, ctx);
        if (type == null) {
            return null;
        }
        if (type.getPackage() == null && type instanceof JstType) {
            ((JstType)type).setPackage(new JstPackage());
        }
        List<IScriptProblem> probs = this.createProblems(ctx);
        type.setProblems(probs);
        type.setJstBlockList(createJstBlock);
        if (type.getSource() != null && type.getSource().getBinding() == null) {
            if (file == null) {
                type.getSource().setBinding((JstSource.IBinding)new SimpleBinding(fileName, source));
            } else {
                type.getSource().setBinding((JstSource.IBinding)new FileBinding(file));
            }
        } else if (type.getSource() != null && type.getSource().getBinding() instanceof SimpleBinding) {
            type.getSource().setBinding((JstSource.IBinding)new SimpleBinding(fileName, source));
        }
        type.getPackage().setGroupName(groupName);
        return type;
    }

    private void printJstCacheTypes() {
        JstCache.getInstance().printTypes(System.out);
    }

    private List<JstBlock> createJstBlock(TranslateCtx ctx, CompilationUnitDeclaration ast) {
        IProgramElement[] statements = ast.getStatements();
        ArrayList<JstBlock> blocks = new ArrayList<JstBlock>(statements.length);
        IProgramElement[] iProgramElementArray = statements;
        int n = statements.length;
        int n2 = 0;
        while (n2 < n) {
            IProgramElement elem = iProgramElementArray[n2];
            if (VjoParser.isTypeDelaration(elem)) {
                TranslateConfig cfg = new TranslateConfig();
                cfg.setSkiptImplementation(true);
                cfg.setSkipJsExtSyntaxArgs(true);
                TranslateCtx ctx2 = new TranslateCtx(cfg);
                ctx2.setCompletionPos(ctx.getCompletionPos());
                ctx2.setAST(ctx.getAST());
                blocks.add(BlockTranslator.createJstBlock(ctx2, (IASTNode)elem));
                for (JstCompletion cmp : ctx2.getJstErrors()) {
                    if (!cmp.inScope(ScopeIds.METHOD_CALL)) continue;
                    ctx.addBlockCompletion(cmp);
                }
            }
            ++n2;
        }
        return blocks;
    }

    private static boolean isTypeDelaration(IProgramElement pElement) {
        IProgramElement receiver = pElement;
        IProgramElement pre = null;
        while (receiver != null) {
            if (receiver instanceof MessageSend) {
                pre = receiver;
                receiver = ((MessageSend)receiver).receiver;
                continue;
            }
            if (receiver instanceof FieldReference) {
                pre = receiver;
                receiver = ((FieldReference)receiver).receiver;
                continue;
            }
            if (!(receiver instanceof SingleNameReference)) break;
            String name = null;
            if (pre instanceof MessageSend) {
                name = new String(((MessageSend)pre).getSelector());
            } else if (pre instanceof FieldReference) {
                name = new String(((FieldReference)pre).getToken());
            }
            String receiverStr = ((SingleNameReference)receiver).toString();
            String key = String.valueOf(receiverStr) + ":" + name;
            boolean hasContructorResolver = false;
            hasContructorResolver = TypeConstructorRegistry.getInstance().hasResolver(key);
            if (!hasContructorResolver) {
                String cfr_ignored_0 = String.valueOf(receiverStr) + "::" + name;
                hasContructorResolver = TypeConstructorRegistry.getInstance().hasResolver(key);
            }
            if (hasContructorResolver) {
                return true;
            }
            if (!"vjo".equals(receiverStr) || name == null || !VjoParser.isValidTypeDef(name)) break;
            return true;
        }
        return false;
    }

    private List<IScriptProblem> createProblems(TranslateCtx ctx) {
        ErrorReporter errorReporter = ctx.getErrorReporter();
        ArrayList<IScriptProblem> problems = new ArrayList<IScriptProblem>();
        ErrorList errList = errorReporter.getErrors();
        ErrorList warnList = errorReporter.getWarnings();
        this.addProblems(ctx, problems, errList, ProblemSeverity.error);
        this.addProblems(ctx, problems, warnList, ProblemSeverity.warning);
        return problems;
    }

    private void addProblems(TranslateCtx ctx, List<IScriptProblem> problemList, ErrorList errList, ProblemSeverity severity) {
        ListIterator itr = errList.listIterator();
        while (itr.hasNext()) {
            ErrorObject eo = (ErrorObject)itr.next();
            int begin = VjoParser.getIntValue(eo, "begin");
            int end = VjoParser.getIntValue(eo, "end");
            int line = VjoParser.getIntValue(eo, "line");
            int col = VjoParser.getIntValue(eo, "column");
            String message = eo.getParameters().getValueByName("message");
            char[] fileName = ctx.getAST().getFileName();
            DefaultJstProblem prblm = new DefaultJstProblem(null, null, message, fileName, begin, end, line, col, severity);
            problemList.add((IScriptProblem)prblm);
        }
    }

    private static int getIntValue(ErrorObject errorObject, String name) {
        String value = errorObject.getParameters().getValueByName(name);
        return value == null ? 0 : Integer.parseInt(value);
    }

    private String convertHTMLCommentsToJsComments(String source) {
        if (source.contains("<!--")) {
            source = source.replace("<!--", "//--");
        }
        if (source.contains("-->")) {
            source = source.replace("-->", "///");
        }
        return source;
    }

    public VjoParser addLib(IJstLib lib) {
        JstCache.getInstance().addLib(lib);
        return this;
    }

    public static String getContent(File file) {
        FileInputStream inputStream;
        try {
            inputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new DsfRuntimeException("can not open '" + file.getAbsolutePath() + "'", (Throwable)e);
        }
        return VjoParser.load(inputStream, file.getAbsolutePath());
    }

    public static String getContent(URL url) {
        InputStream inputStream;
        try {
            inputStream = url.openStream();
        }
        catch (IOException e) {
            throw new DsfRuntimeException(url.toExternalForm(), (Throwable)e);
        }
        return VjoParser.load(inputStream, url.toExternalForm());
    }

    public static String load(InputStream inputStream, String source) {
        ByteArrayOutputStream os = new ByteArrayOutputStream(4096);
        byte[] buffer = new byte[4096];
        try {
            try {
                int numBytesXferred;
                while ((numBytesXferred = inputStream.read(buffer)) != -1) {
                    os.write(buffer, 0, numBytesXferred);
                }
            }
            finally {
                inputStream.close();
            }
            return os.toString("utf-8");
        }
        catch (IOException e) {
            throw new DsfRuntimeException("can not load '" + source + "'", (Throwable)e);
        }
    }

    public TranslateCtx getDefaultTranslateCtx() {
        return new TranslateCtx(this.m_config);
    }

    public void setDebug(boolean debug) {
        this.s_debug = debug;
    }

    private static boolean isValidTypeDef(String name) {
        return VJO_TYPE_DEF_KEYS.contains(name);
    }
}

