/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jstojava.parser.bootstrap;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.List;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.jsgen.shared.generate.JsrGenerator;
import org.eclipse.vjet.dsf.jst.IJstLib;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstCache;
import org.eclipse.vjet.dsf.jst.declaration.JstPackage;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jstojava.parser.bootstrap.Utils;
import org.eclipse.vjet.vjo.lib.LibManager;

public class GenVjoBootstrapJsr {
    private static final String[] TYPES = new String[]{"vjo.ctype", "vjo.mtype", "vjo.etype", "vjo.otype", "vjo.itype", "vjo.ltype", "vjo.ftype"};

    public static void main(String[] args) throws FileNotFoundException {
        String outputDir = args[0];
        IJstLib jsnative = LibManager.getInstance().getJsNativeGlobalLib();
        IJstLib jsbrowser = LibManager.getInstance().getBrowserTypesLib();
        IJstLib lib = LibManager.getInstance().getVjoSelfDescLib();
        List types = lib.getAllTypes(true);
        JstCache.getInstance().addLib(jsnative);
        JstCache.getInstance().addLib(jsbrowser);
        JstCache.getInstance().addLib(lib);
        for (IJstType type : types) {
            if (GenVjoBootstrapJsr.isExcluded(type)) continue;
            try {
                JstPackage package1 = type.getPackage();
                package1 = new JstPackage("vjo");
                JstType wc = null;
                if (type instanceof JstType) {
                    wc = (JstType)type;
                    GenVjoBootstrapJsr.fixType(wc);
                    Utils.removeGuts(wc);
                    File jsrFile = GenVjoBootstrapJsr.createJsrFile(outputDir, package1, type.getSimpleName());
                    System.out.println("gen jsr :" + jsrFile.getAbsolutePath());
                    PrintWriter pw2 = new PrintWriter(jsrFile);
                    JsrGenerator gen2 = Utils.createGenerator(pw2);
                    gen2.writeJsr((IJstType)wc);
                    pw2.flush();
                    continue;
                }
                throw new DsfRuntimeException("type was not a JstType as expected");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void fixType(JstType type) {
        if ("vjo".equals(type.getName())) {
            type.setPackage(new JstPackage("vjo"));
        }
    }

    private static boolean isExcluded(IJstType type) {
        if ("vjo".equals(type.getName())) {
            return true;
        }
        String[] stringArray = TYPES;
        int n = TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            String t = stringArray[n2];
            if (type.getName().contains(t)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static File createJsrFile(String outputDir, JstPackage package1, String simpleName) {
        File dir;
        String packageURI = "";
        if (package1 != null) {
            packageURI = package1.getName().replace('.', File.separatorChar);
        }
        if (!(dir = new File(String.valueOf(outputDir) + File.separatorChar + packageURI + File.separatorChar)).exists()) {
            dir.mkdirs();
        }
        File file = new File(dir, String.valueOf(simpleName) + "Jsr.java");
        return file;
    }

    private static File createFile(String outputDir, JstPackage package1, String simpleName) {
        File dir;
        String packageURI = "";
        if (package1 != null) {
            packageURI = package1.getName().replace('.', File.separatorChar);
        }
        if (!(dir = new File(String.valueOf(outputDir) + File.separatorChar + packageURI + File.separatorChar)).exists()) {
            dir.mkdirs();
        }
        File file = new File(dir, String.valueOf(simpleName) + ".js");
        return file;
    }
}

