/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jstojava.resolver;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.vjet.dsf.jstojava.resolver.IFunctionMetaMapping;
import org.eclipse.vjet.dsf.jstojava.resolver.IMetaExtension;

public class FunctionParamsMetaRegistry {
    private static FunctionParamsMetaRegistry s_instance = new FunctionParamsMetaRegistry();
    private Map<String, IFunctionMetaMapping> m_funcMetaMappings = new LinkedHashMap<String, IFunctionMetaMapping>();
    private Set<String> m_tergetFuncs = new HashSet<String>();

    public static FunctionParamsMetaRegistry getInstance() {
        return s_instance;
    }

    public void addMapping(IFunctionMetaMapping mapping) {
        String[] stringArray = mapping.getGroupIds();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String grp = stringArray[n2];
            this.m_funcMetaMappings.put(grp, mapping);
            ++n2;
        }
        this.m_tergetFuncs.addAll(mapping.getSupportedTargetFuncs());
    }

    public boolean isFuncMetaMappingSupported(String targetFunc) {
        return this.m_tergetFuncs.contains(targetFunc);
    }

    public IMetaExtension getExtentedArgBinding(String targetFunc, String key, String groupId, List<String> dependentGroupIds) {
        IMetaExtension method = this.getExtentedArgBinding(targetFunc, key, groupId);
        if (method == null && dependentGroupIds != null) {
            int i = 0;
            while (i < dependentGroupIds.size()) {
                method = this.getExtentedArgBinding(targetFunc, key, dependentGroupIds.get(i));
                if (method != null) break;
                ++i;
            }
        }
        return method;
    }

    public void clear(String groupId) {
        this.m_funcMetaMappings.remove(groupId);
        this.m_tergetFuncs.clear();
        for (IFunctionMetaMapping mapping : this.m_funcMetaMappings.values()) {
            this.m_tergetFuncs.addAll(mapping.getSupportedTargetFuncs());
        }
    }

    public void clearAll() {
        this.m_funcMetaMappings.clear();
        this.m_tergetFuncs.clear();
    }

    private IMetaExtension getExtentedArgBinding(String targetFunc, String key, String groupId) {
        for (String group : this.m_funcMetaMappings.keySet()) {
            if (!groupId.startsWith(group)) continue;
            IFunctionMetaMapping mapping = this.m_funcMetaMappings.get(group);
            return mapping == null ? null : mapping.getExtentedArgBinding(targetFunc, key);
        }
        return null;
    }

    public boolean isFirstArgumentType(String targetFunc, String groupId) {
        for (String key : this.m_funcMetaMappings.keySet()) {
            IFunctionMetaMapping mapping;
            if (!groupId.startsWith(key) || (mapping = this.m_funcMetaMappings.get(key)) == null) continue;
            return mapping.isFirstArgumentType(targetFunc);
        }
        return false;
    }
}

