/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jstojava.resolver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.vjet.dsf.jstojava.resolver.IThisObjScopeResolver;
import org.eclipse.vjet.dsf.jstojava.resolver.IThisScopeContext;

public class ThisObjScopeResolverRegistry {
    private static final ThisObjScopeResolverRegistry s_instance = new ThisObjScopeResolverRegistry();
    private Map<String, List<IThisObjScopeResolver>> m_resolvers = new HashMap<String, List<IThisObjScopeResolver>>();

    public static ThisObjScopeResolverRegistry getInstance() {
        return s_instance;
    }

    public ThisObjScopeResolverRegistry addResolver(String key, IThisObjScopeResolver resolver) {
        List<IThisObjScopeResolver> resolverList = this.m_resolvers.get(key);
        if (resolverList == null) {
            resolverList = new ArrayList<IThisObjScopeResolver>(1);
            this.m_resolvers.put(key, resolverList);
        }
        resolverList.add(resolver);
        return this;
    }

    public void resolve(String key, IThisScopeContext context) {
        Collection<List<IThisObjScopeResolver>> resolverList = this.m_resolvers.values();
        for (List<IThisObjScopeResolver> list : resolverList) {
            for (IThisObjScopeResolver iThisObjScopeResolver : list) {
                iThisObjScopeResolver.resolve(context);
            }
        }
    }

    public boolean hasResolver(String key) {
        return this.m_resolvers.containsKey(key);
    }

    public void clear(String groupId) {
        for (List<IThisObjScopeResolver> resolverList : this.m_resolvers.values()) {
            int i = resolverList.size() - 1;
            while (i >= 0) {
                IThisObjScopeResolver resolver = resolverList.get(i);
                String[] stringArray = resolver.getGroupIds();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String grp = stringArray[n2];
                    if (groupId.endsWith(grp)) {
                        resolverList.remove(resolver);
                    }
                    ++n2;
                }
                --i;
            }
        }
    }

    public void clearAll() {
        this.m_resolvers.clear();
    }
}

