/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jstojava.translator;

import java.util.List;
import org.eclipse.mod.wst.jsdt.core.ast.IASTNode;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.ObjectLiteral;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.ObjectLiteralField;
import org.eclipse.vjet.dsf.jsgen.shared.ids.ScopeIds;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstOType;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstCache;
import org.eclipse.vjet.dsf.jst.declaration.JstFunctionRefType;
import org.eclipse.vjet.dsf.jst.declaration.JstMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstModifiers;
import org.eclipse.vjet.dsf.jst.declaration.JstObjectLiteralType;
import org.eclipse.vjet.dsf.jst.declaration.JstPackage;
import org.eclipse.vjet.dsf.jst.declaration.JstProperty;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.expr.FieldAccessExpr;
import org.eclipse.vjet.dsf.jst.expr.FuncExpr;
import org.eclipse.vjet.dsf.jst.meta.IJsCommentMeta;
import org.eclipse.vjet.dsf.jst.term.NV;
import org.eclipse.vjet.dsf.jst.term.ObjLiteral;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.dsf.jst.traversal.IJstVisitor;
import org.eclipse.vjet.dsf.jst.traversal.JstDepthFirstTraversal;
import org.eclipse.vjet.dsf.jstojava.parser.comments.JsParam;
import org.eclipse.vjet.dsf.jstojava.translator.BasePropsProtosTranslator;
import org.eclipse.vjet.dsf.jstojava.translator.FunctionTypeRefVisitor;
import org.eclipse.vjet.dsf.jstojava.translator.IFindTypeSupport;
import org.eclipse.vjet.dsf.jstojava.translator.TranslateCtx;
import org.eclipse.vjet.dsf.jstojava.translator.TranslateHelper;
import org.eclipse.vjet.dsf.jstojava.translator.robust.ast2jst.BaseAst2JstTranslator;
import org.eclipse.vjet.dsf.jstojava.translator.robust.ast2jst.TranslatorFactory;

public class DefsTranslator
extends BasePropsProtosTranslator {
    public DefsTranslator(TranslateCtx ctx) {
        super(ctx);
        this.type = ScopeIds.DEFS;
    }

    @Override
    public void process(Expression expr, JstType jstType) {
        super.process(expr, jstType);
        if (this.m_ctx.hasFunctionTypeRefReplacements()) {
            JstDepthFirstTraversal.accept((IJstNode)jstType, (IJstVisitor)new FunctionTypeRefVisitor(this.m_ctx.getFunctionTypeRefReplacements()));
        }
    }

    @Override
    protected void translateExpr(Expression expr, JstType jstType) {
        this.getCtx().enterBlock(this.type);
        try {
            if (expr instanceof ObjectLiteral) {
                ObjectLiteral literal = (ObjectLiteral)expr;
                if (literal.fields != null) {
                    ObjectLiteralField[] objectLiteralFieldArray = literal.fields;
                    int n = literal.fields.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ObjectLiteralField field = objectLiteralFieldArray[n2];
                        if (field.getInitializer() instanceof ObjectLiteral) {
                            JstObjectLiteralType objLitType = new JstObjectLiteralType(field.fieldName.toString());
                            if (this.m_ctx.getCurrentType().getPackage() != null) {
                                objLitType.setPackage(new JstPackage(String.valueOf(this.m_ctx.getCurrentType().getPackage().getName()) + "." + this.m_ctx.getCurrentType().getName()));
                            }
                            jstType.addOType((IJstOType)objLitType);
                        }
                        ++n2;
                    }
                }
            }
            BaseAst2JstTranslator translator = TranslatorFactory.getTranslator((IASTNode)expr, this.getCtx());
            translator.setParent((BaseJstNode)jstType);
            Object node = translator.translate(expr);
            if (node instanceof ObjLiteral) {
                ObjLiteral literal = (ObjLiteral)node;
                for (NV field : literal.getNVs()) {
                    this.processDef(jstType, literal, field);
                }
            }
        }
        finally {
            this.getCtx().exitBlock();
        }
    }

    private void processDef(JstType jstType, ObjLiteral literal, NV field) {
        IExpr value = field.getValue();
        if (value != null) {
            if (value instanceof ObjLiteral) {
                this.processObjLiteralDef(jstType, field.getName(), (ObjLiteral)value);
            } else if (value instanceof FuncExpr) {
                this.processFunctionDef(jstType, ((FuncExpr)value).getFunc());
            } else if (value instanceof FieldAccessExpr) {
                IJstType type = ((FieldAccessExpr)value).getType();
                JstType fnType = JstCache.getInstance().getType("Function");
                if (fnType != null && fnType.equals(type)) {
                    this.processFunction(jstType, field.getName(), (FieldAccessExpr)value, field);
                }
            } else if (value instanceof BaseJstNode) {
                this.processObjLiteralDef(jstType, field.getName(), (BaseJstNode)value, field);
            }
        }
    }

    private void processObjLiteralDef(JstType jstType, String name, ObjLiteral value) {
        JstObjectLiteralType otype = (JstObjectLiteralType)jstType.getOType(name);
        if (otype == null) {
            otype = new JstObjectLiteralType(name);
        }
        otype.setPackage(new JstPackage(jstType.getName()));
        JstCache.getInstance().addOType((JstType)otype);
        jstType.addProperty((IJstProperty)new JstProperty((IJstType)otype, name));
        int i = 0;
        while (i < value.getNVs().size()) {
            NV field = (NV)value.getNVs().get(i);
            JstProperty prop = this.createPropertyFromNV(field);
            otype.addProperty((IJstProperty)prop);
            if (field.isOptional()) {
                otype.addOptionalField((IJstProperty)prop);
            }
            ++i;
        }
        jstType.addOType((IJstOType)otype);
    }

    private void processObjLiteralDef(JstType jstType, String name, BaseJstNode value, NV field) {
        if (value instanceof FieldAccessExpr) {
            FieldAccessExpr fieldAccessExpr = (FieldAccessExpr)value;
            IJstType type = fieldAccessExpr.getType();
            JstType fnType = JstCache.getInstance().getType("Function");
            if (fnType != null && fnType.equals(type)) {
                this.processFunction(jstType, name, fieldAccessExpr, field);
            }
        } else {
            JstObjectLiteralType otype = new JstObjectLiteralType(name);
            otype.setPackage(new JstPackage(jstType.getName()));
            JstCache.getInstance().addOType((JstType)otype);
            jstType.addProperty((IJstProperty)new JstProperty((IJstType)otype, name));
            jstType.addOType((IJstOType)otype);
        }
    }

    private void processFunction(JstType jstType, String name, FieldAccessExpr fieldAccessExpr, NV nv) {
        List<IJsCommentMeta> commentMeta = TranslateHelper.findMetaFromExpr((BaseJstNode)fieldAccessExpr);
        if (commentMeta != null) {
            JstMethod meth = (JstMethod)TranslateHelper.MethodTranslateHelper.createJstSynthesizedMethod(commentMeta, (IFindTypeSupport)this.m_ctx, name);
            meth.setSource(nv.getSource());
            this.processFunctionDef(jstType, meth);
        }
    }

    private IJsCommentMeta getLongestArgList(List<IJsCommentMeta> metaArr) {
        IJsCommentMeta maxMeta = null;
        int maxParamCount = 0;
        List<JsParam> params = null;
        for (IJsCommentMeta meta : metaArr) {
            if (maxMeta == null) {
                maxMeta = meta;
                params = TranslateHelper.getParams(meta);
                if (params == null) continue;
                maxParamCount = params.size();
                continue;
            }
            params = TranslateHelper.getParams(meta);
            if (params == null || params.size() <= maxParamCount) continue;
            maxParamCount = params.size();
            maxMeta = meta;
        }
        return maxMeta;
    }

    private JstProperty createPropertyFromNV(NV nv) {
        IExpr value = nv.getValue();
        if (nv.getName() != null && nv.getName().length() > 0 && value instanceof BaseJstNode) {
            BaseJstNode literal = (BaseJstNode)value;
            IJstType jstType = null;
            IJstType type = nv.getIdentifier().getType();
            if (type != null) {
                jstType = type;
            }
            if (jstType == null) {
                List<IJsCommentMeta> commentMeta = TranslateHelper.findMetaFromExpr(literal);
                IJsCommentMeta meta = null;
                if (commentMeta != null) {
                    meta = commentMeta.get(0);
                }
                if (meta != null) {
                    jstType = TranslateHelper.findType(this.m_ctx, meta.getTyping(), meta);
                }
            }
            if (jstType == null) {
                jstType = value.getResultType();
            }
            if (jstType == null) {
                jstType = JstCache.getInstance().getType("Object");
            }
            JstProperty jstProperty = new JstProperty(jstType, nv.getName(), value, new JstModifiers().setPublic());
            jstProperty.setSource(nv.getSource());
            jstProperty.setCommentLocations(nv.getCommentLocations());
            return jstProperty;
        }
        return null;
    }

    private void processFunctionDef(JstType type, JstMethod mtd) {
        if (mtd != null) {
            type.addMethod((IJstMethod)mtd);
            JstFunctionRefType ref = new JstFunctionRefType((IJstMethod)mtd);
            ref.setPackage(new JstPackage(type.getName()));
            type.addOType((IJstOType)ref);
        }
    }
}

