/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jstojava.translator;

import org.eclipse.mod.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.FunctionExpression;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.vjet.dsf.jsgen.shared.ids.ScopeIds;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.JstSource;
import org.eclipse.vjet.dsf.jst.declaration.JstBlock;
import org.eclipse.vjet.dsf.jst.declaration.JstCache;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.declaration.JstVars;
import org.eclipse.vjet.dsf.jst.expr.JstInitializer;
import org.eclipse.vjet.dsf.jst.term.JstIdentifier;
import org.eclipse.vjet.dsf.jst.token.ILHS;
import org.eclipse.vjet.dsf.jst.token.IStmt;
import org.eclipse.vjet.dsf.jstojava.translator.BasePropsProtosTranslator;
import org.eclipse.vjet.dsf.jstojava.translator.TranslateCtx;
import org.eclipse.vjet.dsf.jstojava.translator.TranslateHelper;
import org.eclipse.vjet.dsf.jstojava.translator.robust.completion.JstCompletion;
import org.eclipse.vjet.dsf.jstojava.translator.robust.completion.JstCompletionOnMemberAccess;
import org.eclipse.vjet.dsf.jstojava.translator.robust.completion.JstCompletionOnSingleNameReference;
import org.eclipse.vjet.dsf.jstojava.translator.robust.completion.JstFieldOrMethodCompletion;
import org.eclipse.vjet.dsf.jstojava.translator.robust.completion.JstTypeCompletion;

public class InitsTranslator
extends BasePropsProtosTranslator {
    public InitsTranslator(TranslateCtx ctx) {
        super(ctx);
        this.type = ScopeIds.INITS;
    }

    @Override
    public void process(Expression expr, JstType jstType) {
        if (expr instanceof FunctionExpression) {
            this.m_ctx.enterBlock(ScopeIds.INITS);
            JstBlock block = new JstBlock();
            FunctionExpression funcExp = (FunctionExpression)expr;
            MethodDeclaration astMethodDeclaration = funcExp.getMethodDeclaration();
            JstType refType = JstCache.getInstance().getType("Arguments");
            JstVars jstVar = new JstVars((IJstType)refType, new JstInitializer((ILHS)new JstIdentifier("arguments"), null));
            block.addChild((IJstNode)jstVar);
            TranslateHelper.addStatementsToJstBlock(astMethodDeclaration.statements, block, astMethodDeclaration.sourceEnd(), this.m_ctx);
            int declStart = astMethodDeclaration.declarationSourceStart;
            int declEnd = astMethodDeclaration.declarationSourceEnd;
            int bodyStart = astMethodDeclaration.bodyStart;
            int bodyEnd = astMethodDeclaration.bodyEnd;
            int completionPos = this.m_ctx.getCompletionPos();
            if (block.getStmts().size() > 0) {
                for (IStmt stmt : block.getStmts()) {
                    this.m_ctx.getCurrentType().addInit(stmt, true);
                }
                JstSource blockSource = TranslateHelper.createJstSource(this.m_ctx.getSourceUtil(), declEnd - declStart, declStart, declEnd);
                this.m_ctx.getCurrentType().getInitBlock().setSource(blockSource);
            }
            if (!this.m_ctx.isCreatedCompletion() && completionPos <= declEnd + 1 && completionPos >= declStart) {
                JstCompletion completion = null;
                boolean inMethod = completionPos >= bodyStart && completionPos <= bodyEnd + 1;
                completion = inMethod ? this.createJstCompletion() : new JstFieldOrMethodCompletion((BaseJstNode)this.m_ctx.getCurrentType(), true);
                completion.setToken("");
                JstSource completionSource = TranslateHelper.createJstSource(this.m_ctx.getSourceUtil(), 0, completionPos, completionPos);
                completion.setSource(completionSource);
                completion.setScopeStack(this.m_ctx.getScopeStack());
                if (inMethod) {
                    completion.getScopeStack().push(ScopeIds.METHOD);
                }
                this.m_ctx.setCreatedCompletion(true);
                this.m_ctx.addSyntaxError(completion);
            }
            this.m_ctx.exitBlock();
        } else {
            System.err.println("Unprocessed type: " + expr.getClass() + " in " + this.getClass().getName());
        }
    }

    private JstCompletion createJstCompletion() {
        char c = this.m_ctx.getOriginalSource()[this.m_ctx.getCompletionPos() - 1];
        JstType type = this.m_ctx.getCurrentType();
        JstTypeCompletion completion = null;
        completion = c == '.' ? new JstCompletionOnMemberAccess((BaseJstNode)type) : new JstCompletionOnSingleNameReference((BaseJstNode)type);
        return completion;
    }
}

