/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jstojava.translator.robust.ast2jst;

import org.eclipse.mod.wst.jsdt.core.ast.IASTNode;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.Statement;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.SwitchStatement;
import org.eclipse.vjet.dsf.jsgen.shared.ids.ScopeIds;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.JstSource;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.expr.FieldAccessExpr;
import org.eclipse.vjet.dsf.jst.stmt.ExprStmt;
import org.eclipse.vjet.dsf.jst.stmt.SwitchStmt;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.dsf.jst.token.IStmt;
import org.eclipse.vjet.dsf.jstojava.translator.TranslateHelper;
import org.eclipse.vjet.dsf.jstojava.translator.robust.ast2jst.BaseAst2JstTranslator;
import org.eclipse.vjet.dsf.jstojava.translator.robust.completion.JstCompletion;
import org.eclipse.vjet.dsf.jstojava.translator.robust.completion.JstCompletionOnSingleNameReference;

public class SwitchStatementTranslator
extends BaseAst2JstTranslator<SwitchStatement, SwitchStmt> {
    private static final String SPACE = "";
    private static final char SQUARE_OPEN_BRACKET = '{';

    @Override
    protected SwitchStmt doTranslate(SwitchStatement statement) {
        SwitchStmt switchStmt = new SwitchStmt();
        if (this.m_parent != null) {
            this.m_parent.addChild((IJstNode)switchStmt);
        }
        try {
            this.m_ctx.enterBlock(ScopeIds.SWITCH);
            this.doTranslate(statement, switchStmt);
        }
        finally {
            this.m_ctx.exitBlock();
        }
        return switchStmt;
    }

    private void doTranslate(SwitchStatement statement, SwitchStmt switchStmt) {
        IExpr expr = (IExpr)this.getTranslatorAndTranslate((IASTNode)statement.expression, (BaseJstNode)switchStmt);
        switchStmt.setExpr(expr);
        JstSource source = TranslateHelper.createJstSource(this.m_ctx.getSourceUtil(), statement.sourceEnd() - statement.sourceStart(), statement.sourceStart(), statement.sourceEnd());
        switchStmt.setSource(source);
        if (statement.statements != null) {
            Statement[] statementArray = statement.statements;
            int n = statement.statements.length;
            int n2 = 0;
            while (n2 < n) {
                IStmt st;
                Statement stmt = statementArray[n2];
                Object obj = this.getTranslatorAndTranslate((IASTNode)stmt, (BaseJstNode)switchStmt);
                if (obj != null && obj instanceof IStmt) {
                    st = (IStmt)obj;
                    switchStmt.addStmt(st);
                } else if (obj instanceof FieldAccessExpr) {
                    st = (FieldAccessExpr)obj;
                    switchStmt.addStmt((IStmt)new ExprStmt((IExpr)st));
                }
                ++n2;
            }
        }
    }

    @Override
    protected JstCompletion createCompletion(SwitchStatement astNode, boolean isAfterSource) {
        JstType node = this.m_ctx.getCurrentType();
        JstCompletionOnSingleNameReference completion = new JstCompletionOnSingleNameReference((BaseJstNode)node);
        completion.setToken(SPACE);
        completion.setSource(SwitchStatementTranslator.createSource(this.m_ctx.getCompletionPos(), this.m_ctx.getCompletionPos(), this.m_ctx.getSourceUtil()));
        completion.setScopeStack(this.m_ctx.getScopeStack());
        char[] cs = this.m_ctx.getOriginalSource();
        if (!Character.isWhitespace(cs[this.m_ctx.getCompletionPos() - 1])) {
            String token = this.getToken(cs, this.m_ctx.getCompletionPos() - 1);
            completion.setToken(token);
            completion.setSource(SwitchStatementTranslator.createSource(this.m_ctx.getCompletionPos() - token.length(), this.m_ctx.getCompletionPos(), this.m_ctx.getSourceUtil()));
        }
        this.m_ctx.setCreatedCompletion(true);
        completion.pushScope(ScopeIds.SWITCH);
        return completion;
    }

    private String getToken(char[] cs, int completionPos) {
        StringBuilder builder = new StringBuilder();
        int i = completionPos;
        while (i > 0) {
            if (Character.isWhitespace(cs[i]) || this.isSquareOpenBracket(cs[i])) break;
            builder.insert(0, cs[i]);
            --i;
        }
        return builder.toString();
    }

    private boolean isSquareOpenBracket(char c) {
        return c == '{';
    }
}

