/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vjo.lib;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.eclipse.vjet.dsf.jst.IJstLib;
import org.eclipse.vjet.dsf.jst.IJstSerializer;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.JstLib;
import org.eclipse.vjet.dsf.jst.datatype.JstReservedTypes;
import org.eclipse.vjet.dsf.jst.declaration.JstRefType;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.ts.util.JstTypeSerializer;
import org.eclipse.vjet.vjo.lib.IResourceResolver;
import org.eclipse.vjet.vjo.lib.ResourceHelper;
import org.eclipse.vjet.vjo.lib.VjoSelfDescribedLib;

public final class LibManager {
    private Map<String, JstLib> m_libs = new HashMap<String, JstLib>();
    private IResourceResolver m_resourceResolver = ResourceHelper.getInstance();
    private IJstSerializer m_jstSerializer = JstTypeSerializer.getInstance();
    public static final String JS_NATIVE_LIB_NAME = "JsNativeLib";
    public static final String JS_NATIVE_GLOBAL_LIB_NAME = "JsNativeGlobal";
    public static final String JAVA_PRIMITIVE_LIB_NAME = "JavaPrimitive";
    public static final String VJO_JAVA_LIB_NAME = "VjoJavaLib";
    public static final String VJO_BASE_LIB_NAME = "VjoBaseLib";
    public static final String VJO_LIB_SUFFIX = ".jar";
    public static final String VJO_SER_SUFFIX = ".ser";
    public static final String VJO_SELF_DESCRIBED = "VjoSelfDescribed";
    private static LibManager s_instance = new LibManager();

    private LibManager() {
    }

    public static LibManager getInstance() {
        return s_instance;
    }

    public LibManager setResourceResolver(IResourceResolver resourceResolver) {
        if (this.m_resourceResolver == null) {
            throw new RuntimeException("resourceResolver cannot be null");
        }
        this.m_resourceResolver = resourceResolver;
        if (this.m_resourceResolver.getJstSerializer() != null) {
            this.m_jstSerializer = this.m_resourceResolver.getJstSerializer();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IJstLib getJavaPrimitiveLib() {
        JstLib lib = this.m_libs.get(JAVA_PRIMITIVE_LIB_NAME);
        if (lib != null) {
            return lib;
        }
        lib = new JstLib(JAVA_PRIMITIVE_LIB_NAME);
        JstRefType[] jstRefTypeArray = JstReservedTypes.JavaPrimitive.ALL;
        int n = JstReservedTypes.JavaPrimitive.ALL.length;
        int n2 = 0;
        while (n2 < n) {
            JstRefType type = jstRefTypeArray[n2];
            lib.addType((JstType)type);
            ++n2;
        }
        lib.addType((JstType)JstReservedTypes.Other.VOID);
        Class<LibManager> clazz = LibManager.class;
        synchronized (LibManager.class) {
            this.m_libs.put(JAVA_PRIMITIVE_LIB_NAME, lib);
            // ** MonitorExit[var2_5] (shouldn't be in output)
            return lib;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IJstLib getVjoSelfDescLib() {
        JstLib lib = this.m_libs.get(VJO_SELF_DESCRIBED);
        if (lib != null) {
            return lib;
        }
        List<IJstType> jstTypes = null;
        try {
            VjoSelfDescribedLib.getInstance().setResourceResolver(this.m_resourceResolver);
            jstTypes = VjoSelfDescribedLib.getInstance().getTypes();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        lib = new JstLib(VJO_SELF_DESCRIBED);
        lib.addTypes(jstTypes);
        Class<LibManager> clazz = LibManager.class;
        synchronized (LibManager.class) {
            this.m_libs.put(VJO_SELF_DESCRIBED, lib);
            // ** MonitorExit[var3_4] (shouldn't be in output)
            return lib;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IJstLib getBrowserTypesLib() {
        JstLib lib = this.m_libs.get(JS_NATIVE_LIB_NAME);
        if (lib != null) {
            return lib;
        }
        List jstTypes = null;
        try {
            jstTypes = this.m_jstSerializer.deserialize(this.m_resourceResolver.getJsNativeSerializedStream());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (jstTypes == null) {
            return null;
        }
        lib = new JstLib(JS_NATIVE_LIB_NAME);
        lib.addTypes(jstTypes);
        Class<LibManager> clazz = LibManager.class;
        synchronized (LibManager.class) {
            this.m_libs.put(JS_NATIVE_LIB_NAME, lib);
            // ** MonitorExit[var3_4] (shouldn't be in output)
            return lib;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IJstLib getJsNativeGlobalLib() {
        JstLib lib = this.m_libs.get(JS_NATIVE_GLOBAL_LIB_NAME);
        if (lib != null) {
            return lib;
        }
        List jstTypes = null;
        try {
            jstTypes = this.m_jstSerializer.deserialize(this.m_resourceResolver.getJsNativeGlobalSerializedStream());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (jstTypes == null) {
            return null;
        }
        lib = new JstLib(JS_NATIVE_GLOBAL_LIB_NAME);
        lib.addTypes(jstTypes);
        Class<LibManager> clazz = LibManager.class;
        synchronized (LibManager.class) {
            this.m_libs.put(JS_NATIVE_GLOBAL_LIB_NAME, lib);
            // ** MonitorExit[var3_4] (shouldn't be in output)
            return lib;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IJstLib getVjoJavaLib() {
        JstLib lib = this.m_libs.get(VJO_JAVA_LIB_NAME);
        if (lib != null) {
            return lib;
        }
        List jstTypes = null;
        try {
            jstTypes = this.m_jstSerializer.deserialize(this.m_resourceResolver.getVjoJavaLibSerializedStream());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (jstTypes == null) {
            return null;
        }
        lib = new JstLib(VJO_JAVA_LIB_NAME);
        lib.addTypes(jstTypes);
        Class<LibManager> clazz = LibManager.class;
        synchronized (LibManager.class) {
            this.m_libs.put(VJO_JAVA_LIB_NAME, lib);
            // ** MonitorExit[var3_4] (shouldn't be in output)
            return lib;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IJstLib getVjoJstLib(String libPath, String libName) {
        String vjoLibName = libName;
        if (libName.endsWith(VJO_LIB_SUFFIX)) {
            vjoLibName = libName.substring(0, libName.lastIndexOf(VJO_LIB_SUFFIX));
        } else if (vjoLibName.endsWith(VJO_SER_SUFFIX)) {
            vjoLibName = libName.substring(0, libName.lastIndexOf(VJO_SER_SUFFIX));
        }
        JstLib lib = this.m_libs.get(vjoLibName);
        if (lib != null) {
            return lib;
        }
        List jstTypes = null;
        Manifest mf = null;
        try {
            String vjoLibFilePath = String.valueOf(libPath) + File.separatorChar + vjoLibName + VJO_LIB_SUFFIX;
            mf = this.getVjoJstLibManifest(vjoLibFilePath);
            jstTypes = this.m_jstSerializer.deserialize(this.getVjoJstLibSerializedStream(vjoLibFilePath, vjoLibName));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (jstTypes == null) {
            return null;
        }
        lib = new JstLib(vjoLibName, mf);
        lib.addTypes(jstTypes);
        Class<LibManager> clazz = LibManager.class;
        synchronized (LibManager.class) {
            this.m_libs.put(vjoLibName, lib);
            // ** MonitorExit[var7_7] (shouldn't be in output)
            return lib;
        }
    }

    private InputStream getVjoJstLibSerializedStream(String libFilePath, String libName) {
        try {
            URL libUrl = new File(libFilePath).toURL();
            URLClassLoader classLoader = new URLClassLoader(new URL[]{libUrl});
            if (!libName.endsWith(VJO_SER_SUFFIX)) {
                libName = String.valueOf(libName) + VJO_SER_SUFFIX;
            }
            URL serFile = classLoader.findResource(libName);
            return serFile.openStream();
        }
        catch (Exception exception) {
            throw new RuntimeException("Could not load Vjo library " + libName + "in " + libFilePath);
        }
    }

    private Manifest getVjoJstLibManifest(String libFilePath) {
        try {
            JarFile jar = new JarFile(libFilePath);
            return jar.getManifest();
        }
        catch (Exception exception) {
            throw new RuntimeException("Could not find Vjo library manifest.mf in " + libFilePath);
        }
    }

    public boolean hasType(String name) {
        for (JstLib lib : this.m_libs.values()) {
            for (JstType type : lib.getAllTypes(true)) {
                if (!type.getName().equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    public void clear() {
        this.m_libs.clear();
    }
}

