/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vjo.tool.codecompletion;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.vjet.dsf.jsgen.shared.util.JstDisplayUtils;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.ISynthesized;
import org.eclipse.vjet.dsf.jst.declaration.JstArg;
import org.eclipse.vjet.dsf.jst.declaration.JstCache;
import org.eclipse.vjet.dsf.jst.declaration.JstFuncType;
import org.eclipse.vjet.dsf.jst.declaration.JstInferredType;
import org.eclipse.vjet.dsf.jst.declaration.JstModifiers;
import org.eclipse.vjet.dsf.jst.declaration.JstObjectLiteralType;
import org.eclipse.vjet.dsf.jst.declaration.JstPackage;
import org.eclipse.vjet.dsf.jst.declaration.JstProxyMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstProxyProperty;
import org.eclipse.vjet.dsf.jst.reserved.JsCoreKeywords;
import org.eclipse.vjet.vjo.lib.TsLibLoader;
import org.eclipse.vjet.vjo.tool.codecompletion.IVjoCcProposalData;
import org.eclipse.vjet.vjo.tool.codecompletion.VjoCcCtx;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcCTypeProposalAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcTypeProposalAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.keyword.VjoKeywordFactory;

public class CodeCompletionUtils {
    public static final String SEPERATE_TOKEN = "<<Line_Seperator>>";
    public static final String CURSOR_POSITION_TOKEN = "<<CURSOR_POSITION>>";

    public static boolean isNativeType(IJstType jstType) {
        if (jstType == null) {
            return false;
        }
        JstPackage pkg = jstType.getPackage();
        if (pkg == null) {
            return true;
        }
        String groupName = pkg.getGroupName();
        return TsLibLoader.isDefaultLibName((String)groupName);
    }

    public static boolean isSameType(IJstType type1, IJstType type2) {
        if (type1 == null || type2 == null || type1.getName() == null || type2.getName() == null) {
            return false;
        }
        String callingName = type1.getName();
        String calledName = type2.getName();
        return calledName.equals(callingName);
    }

    public static boolean isInnerType(IJstType inner, IJstType outer) {
        if (inner == null) {
            return false;
        }
        IJstNode node = inner.getParentNode();
        while (node != null && node instanceof IJstType) {
            if (CodeCompletionUtils.isSameType(outer, (IJstType)node)) {
                return true;
            }
            node = node.getParentNode();
        }
        return false;
    }

    public static boolean isSamePackage(IJstType type1, IJstType type2) {
        if (type1 == null || type2 == null || type1.getName() == null || type2.getName() == null) {
            return false;
        }
        JstPackage pack1 = type1.getPackage();
        JstPackage pack2 = type2.getPackage();
        if (pack1 == null || pack2 == null || pack1.getName() == null || pack2.getName() == null) {
            return false;
        }
        return pack1.getName().equals(pack2.getName());
    }

    public static boolean isSuperType(IJstType type, IJstType superType) {
        if (type == null || superType == null || type.getName() == null || superType.getName() == null) {
            return false;
        }
        ArrayList<String> list = new ArrayList<String>();
        IJstType stype = type.getExtend();
        while (stype != null && stype.getName() != null) {
            list.add(stype.getName());
            stype = stype.getExtend();
        }
        return list.contains(superType.getName());
    }

    public static String getMthodsStr(IJstMethod method) {
        StringBuffer buffer = new StringBuffer();
        String name = method.getName().getName();
        buffer.append(name).append(":");
        List args = method.getArgs();
        if (args != null) {
            for (JstArg arg : args) {
                String argType = arg.getType().getName();
                buffer.append(argType).append(",");
            }
        }
        return buffer.toString();
    }

    public static boolean hasReturnValue(IJstMethod method) {
        String rname = CodeCompletionUtils.getReturnType(method);
        return !JsCoreKeywords.VOID.equals(rname);
    }

    public static String getReturnType(IJstMethod method) {
        IJstType ref = method.getRtnType();
        String rname = JsCoreKeywords.VOID;
        if (ref != null) {
            rname = ref.getName();
        }
        return rname;
    }

    public static String getFullMethodString(IJstMethod method) {
        return CodeCompletionUtils.getFullMethodString(method, method.getOwnerType());
    }

    public static String getFullMethodString(IJstMethod method, IJstType ownerType) {
        return CodeCompletionUtils.getFullMethodString(method, ownerType, false);
    }

    public static String getFullMethodString(IJstMethod method, IJstType ownerType, boolean optional) {
        return CodeCompletionUtils.getFullMethodString(method.getName().getName(), method, ownerType, false);
    }

    public static String getFullMethodString(String name, IJstMethod method, IJstType ownerType, boolean optional) {
        return JstDisplayUtils.getFullMethodString((String)name, (IJstMethod)method, (IJstType)ownerType, (boolean)optional);
    }

    public static String getJstArgsStringForReplace(IJstMethod method) {
        String result;
        StringBuffer buffer = new StringBuffer();
        List args = method.getArgs();
        if (args != null && !args.isEmpty()) {
            for (JstArg arg : args) {
                if (arg.getType() instanceof JstObjectLiteralType || arg.getType().getName().equals("ObjLiteral")) {
                    buffer.append("{<<CURSOR_POSITION>>}");
                } else if (arg.getType().getName().equals("Function") && !(arg.getType() instanceof JstFuncType)) {
                    buffer.append("function(){<<CURSOR_POSITION>>}");
                } else {
                    buffer.append(arg.getName());
                }
                buffer.append(", ");
            }
        }
        if ((result = buffer.toString()).length() > 2) {
            result = result.substring(0, result.length() - 2);
        }
        return result;
    }

    public static String getMethodStringForOverrideProposal(IJstMethod method) {
        StringBuffer buffer = new StringBuffer();
        String name = method.getName().getName();
        String opString = "Override";
        if (method.getOwnerType().isInterface()) {
            opString = "Implement";
        }
        buffer.append(name);
        buffer.append("(");
        IJstType ref = method.getRtnType();
        String aname = JstDisplayUtils.getJstArgsString((IJstMethod)method);
        if (aname.length() > 0) {
            buffer.append(aname);
        }
        buffer.append(")");
        if (ref != null) {
            String rname = ref.getName();
            buffer.append(" " + rname);
        }
        buffer.append(" - ");
        buffer.append(String.valueOf(opString) + " method in '");
        buffer.append(method.getOwnerType().getName());
        buffer.append("'");
        return buffer.toString();
    }

    public static String getReplaceStringForOverrideProposal(IJstMethod method, String indent) {
        StringBuffer buffer = new StringBuffer();
        String commStr = CodeCompletionUtils.getJstCommentStringR(method);
        buffer.append("//>" + commStr);
        buffer.append(SEPERATE_TOKEN);
        String name = method.getName().getName();
        buffer.append(name);
        buffer.append(" : function(");
        String aname = CodeCompletionUtils.getJstArgsStringR(method);
        if (aname.length() > 0) {
            buffer.append(aname);
        }
        buffer.append(")");
        IJstType rtype = method.getRtnType();
        String rExpr = CodeCompletionUtils.getReturnExprStr(rtype, method);
        buffer.append("{<<Line_Seperator>>" + indent + CURSOR_POSITION_TOKEN + rExpr + SEPERATE_TOKEN + "}");
        return buffer.toString();
    }

    private static String getReturnExprStr(IJstType rtype, IJstMethod method) {
        if (method.getOwnerType().isInterface()) {
            if (VjoCcCtx.isVoidType(rtype)) {
                return "";
            }
            return "return null;";
        }
        if (VjoCcCtx.isVoidType(rtype)) {
            return String.valueOf(JsCoreKeywords.THIS) + "." + "base" + "." + method.getName() + "(" + CodeCompletionUtils.getJstArgsStringForReplace(method) + ");";
        }
        return "return " + JsCoreKeywords.THIS + "." + "base" + "." + method.getName() + "(" + CodeCompletionUtils.getJstArgsStringForReplace(method) + ");";
    }

    public static String getDefaultValueStr(IJstType type) {
        String typeName = type.getSimpleName();
        if ("boolean".equals(typeName)) {
            return "false";
        }
        if ("int".equals(typeName) || "float".equals(typeName) || "double".equals(typeName)) {
            return "0";
        }
        return null;
    }

    public static String getJstCommentStringR(IJstMethod method) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(String.valueOf(CodeCompletionUtils.getModifierStr(method.getModifiers())) + " ");
        String name = method.getName().getName();
        IJstType ref = method.getRtnType();
        if (ref != null) {
            String rname = ref.getName();
            buffer.append(String.valueOf(rname) + " ");
        }
        buffer.append(name);
        buffer.append("(");
        String aname = JstDisplayUtils.getJstArgsString((IJstMethod)method);
        if (aname.length() > 0) {
            buffer.append(aname);
        }
        buffer.append(")");
        return buffer.toString();
    }

    public static String getModifierStr(JstModifiers modifies) {
        StringBuffer buffer = new StringBuffer();
        if (modifies.isPublic()) {
            buffer.append("public");
        }
        if (modifies.isProtected()) {
            buffer.append("protected");
        }
        if (modifies.isPrivate()) {
            buffer.append("private");
        }
        if (modifies.isFinal()) {
            buffer.append(" final");
        }
        return buffer.toString();
    }

    public static String getJstArgsStringR(IJstMethod method) {
        String result;
        StringBuffer buffer = new StringBuffer();
        List args = (method = CodeCompletionUtils.getDispatchMethod(method)).getArgs();
        if (args != null && !args.isEmpty()) {
            for (JstArg arg : args) {
                buffer.append(arg.getName());
                buffer.append(", ");
            }
        }
        if ((result = buffer.toString()).length() > 2) {
            result = result.substring(0, result.length() - 2);
        }
        return result;
    }

    public static IJstMethod getDispatchMethod(IJstMethod method) {
        IJstType type = method.getOwnerType();
        if (type == null || type.isInterface()) {
            return method;
        }
        IJstMethod m = type.getMethod(method.getName().getName());
        if (m != null) {
            return m;
        }
        return method;
    }

    public static String getConstructorString(String modifier, String indent) {
        if (modifier == null) {
            modifier = "public";
        }
        return "//>" + modifier + " constructs()" + SEPERATE_TOKEN + "constructs : function(){" + SEPERATE_TOKEN + indent + CURSOR_POSITION_TOKEN + SEPERATE_TOKEN + "}";
    }

    public static String getPropertyString(IJstProperty property) {
        StringBuilder strBldr = new StringBuilder();
        String name = property.getName().getName();
        String rname = property.getType() == null ? "" : property.getType().getSimpleName();
        strBldr.append(name);
        strBldr.append(" ");
        strBldr.append(rname);
        strBldr.append(CodeCompletionUtils.isOptionalProperty(property) ? " ?" : "");
        strBldr.append(" - ");
        strBldr.append(CodeCompletionUtils.getOwnerTypeName(property));
        return strBldr.toString();
    }

    private static boolean isOptionalProperty(IJstProperty property) {
        if (property == null) {
            return false;
        }
        IJstType ownerType = property.getOwnerType();
        if (ownerType instanceof JstObjectLiteralType) {
            return ((JstObjectLiteralType)ownerType).getOptionalFields().contains(property instanceof JstProxyProperty ? ((JstProxyProperty)property).getTargetProperty() : property);
        }
        return false;
    }

    public static String getOwnerTypeName(IJstProperty property) {
        IJstType type = property.getType();
        String rname = type == null ? "" : type.getName();
        IJstType otype = property.getOwnerType();
        if (otype != null) {
            if (otype instanceof JstObjectLiteralType) {
                JstObjectLiteralType objtype = (JstObjectLiteralType)otype;
                if (objtype.getParentNode() != null && objtype.getParentNode() instanceof IJstType) {
                    return String.valueOf(((IJstType)objtype.getParentNode()).getSimpleName()) + "::" + objtype.getSimpleName();
                }
                return objtype.getName();
            }
            return otype.getSimpleName();
        }
        return rname;
    }

    public static String getTypeDispalyString(IJstType type) {
        JstPackage packge = type.getPackage();
        if (packge == null) {
            return type.getSimpleName();
        }
        return String.valueOf(type.getSimpleName()) + " - " + packge.getName();
    }

    public static String getModifierStr(int modifer) {
        if ((modifer & 1) != 0) {
            return "public";
        }
        if ((modifer & 4) != 0) {
            return "protected";
        }
        if ((modifer & 2) != 0) {
            return "private";
        }
        if ((modifer & 8) != 0) {
            return "static";
        }
        if ((modifer & 0x10) != 0) {
            return "final";
        }
        return "";
    }

    public static String getCommentKeywordReplaceString(String name, String typeName, boolean inScriptUnit, String indent) {
        if ("needs".equals(name)) {
            return String.valueOf(name) + "(" + CURSOR_POSITION_TOKEN + ")";
        }
        return CodeCompletionUtils.getKeywordReplaceString(name, typeName, inScriptUnit, indent);
    }

    public static String getKeywordReplaceString(String name, String typeName, boolean inSciptUnit, String indent) {
        if (CodeCompletionUtils.isTypeDeclare(name)) {
            if (typeName == null || typeName.trim().equals("")) {
                return String.valueOf(name) + "()";
            }
            return String.valueOf(name) + "('" + typeName + "')";
        }
        if ("props".equals(name) || "defs".equals(name) || "options".equals(name) || "protos".equals(name) || "globals".equals(name)) {
            return String.valueOf(name) + "({" + SEPERATE_TOKEN + indent + CURSOR_POSITION_TOKEN + SEPERATE_TOKEN + "})";
        }
        if ("needs".equals(name) || "inherits".equals(name) || "satisfies".equals(name) || "mixin".equals(name) || "expects".equals(name) || "values".equals(name)) {
            return String.valueOf(name) + "('" + CURSOR_POSITION_TOKEN + "')";
        }
        if ("inits".equals(name)) {
            return String.valueOf(name) + "(" + "function(){" + SEPERATE_TOKEN + indent + CURSOR_POSITION_TOKEN + SEPERATE_TOKEN + "}" + ")";
        }
        if ("endType".equals(name)) {
            return String.valueOf(name) + "()" + (inSciptUnit ? ";" : "");
        }
        return name;
    }

    public static String getKeywordReplaceString(IJstMethod method, String typeName, boolean inSciptUnit, String indent) {
        String name = method.getName().getName();
        if (CodeCompletionUtils.isTypeDeclare(name)) {
            if (typeName == null || typeName.trim().equals("")) {
                return String.valueOf(name) + "()";
            }
            return String.valueOf(name) + "('" + typeName + "')";
        }
        if ("props".equals(name) || "defs".equals(name) || "options".equals(name) || "protos".equals(name)) {
            return String.valueOf(name) + "({" + SEPERATE_TOKEN + indent + CURSOR_POSITION_TOKEN + SEPERATE_TOKEN + "})";
        }
        if ("needs".equals(name) || "inherits".equals(name) || "satisfies".equals(name) || "mixin".equals(name) || "expects".equals(name) || "globals".equals(name) || "values".equals(name)) {
            JstArg arg;
            IJstType argType;
            List args = method.getArgs();
            if (args.size() == 2) {
                JstArg arg0 = (JstArg)args.get(0);
                JstArg arg1 = (JstArg)args.get(1);
                if (CodeCompletionUtils.isStringType(arg0.getType()) && CodeCompletionUtils.isStringType(arg1.getType())) {
                    return String.valueOf(name) + "('" + CURSOR_POSITION_TOKEN + "','')";
                }
            } else if (args.size() == 1 && CodeCompletionUtils.isArrayType(argType = (arg = (JstArg)args.get(0)).getType())) {
                return String.valueOf(name) + "(['" + CURSOR_POSITION_TOKEN + "'])";
            }
            return String.valueOf(name) + "('" + CURSOR_POSITION_TOKEN + "')";
        }
        if ("inits".equals(name)) {
            return String.valueOf(name) + "(" + "function(){" + SEPERATE_TOKEN + indent + CURSOR_POSITION_TOKEN + SEPERATE_TOKEN + "}" + ")";
        }
        if ("endType".equals(name)) {
            return String.valueOf(name) + "()" + (inSciptUnit ? ";" : "");
        }
        return name;
    }

    public static String getFunctionString(int identifier, String functionName, String indent) {
        String sidentifier = CodeCompletionUtils.getModifierStr(identifier);
        String cString = "//>" + sidentifier + " void " + functionName + "() " + SEPERATE_TOKEN + functionName + " : function(){" + SEPERATE_TOKEN + indent + CURSOR_POSITION_TOKEN + SEPERATE_TOKEN + "}";
        return cString;
    }

    public static String getFullFunctionWithoutOverloading(IJstMethod function, String indent) {
        return function.getName().getName() + " : " + CodeCompletionUtils.getFullFunctionWithoutOverloadingOrNaming(function, indent);
    }

    public static String getFullFunctionWithoutOverloadingOrNaming(IJstMethod function, String indent) {
        return "function(" + CodeCompletionUtils.getFullFunctionParams(function) + "){" + SEPERATE_TOKEN + indent + CURSOR_POSITION_TOKEN + CodeCompletionUtils.getReturnStmt(function, indent) + SEPERATE_TOKEN + '}';
    }

    private static String getReturnStmt(IJstMethod function, String indent) {
        IJstType rtnType = function.getRtnType();
        if (rtnType == null || rtnType.getName() == null || "void".equals(rtnType.getName())) {
            return "";
        }
        StringBuilder rtnStmt = new StringBuilder();
        rtnStmt.append(SEPERATE_TOKEN).append(indent).append("return ");
        if (rtnType.equals(JstCache.getInstance().getType("boolean"))) {
            rtnStmt.append("false;");
        } else {
            rtnStmt.append("null;");
        }
        return rtnStmt.toString();
    }

    private static StringBuilder getFullFunctionParams(IJstMethod function) {
        StringBuilder sb = new StringBuilder();
        for (JstArg param : function.getArgs()) {
            sb.append(param.getName()).append(',').append(' ');
        }
        if (sb.length() > 0) {
            sb.delete(sb.length() - 2, sb.length());
        }
        return sb;
    }

    public static String getMainFunctionString(String indent) {
        String cString = "//>public void main(String... args) <<Line_Seperator>>main : function(args){<<Line_Seperator>>" + indent + CURSOR_POSITION_TOKEN + SEPERATE_TOKEN + "}";
        return cString;
    }

    public static String getInterfaceFunctionString(int identifier, String functionName) {
        String sidentifier = CodeCompletionUtils.getModifierStr(identifier);
        String cString = "//>" + sidentifier + " void " + functionName + "() " + SEPERATE_TOKEN + functionName + " : vjo.NEEDS_IMPL";
        return cString;
    }

    public static String getPropertyProposalReplaceStr(boolean isGlobal, IJstProperty property, VjoCcCtx vjoCcCtx) {
        String ptyName;
        String replaceString = ptyName = property.getName().getName();
        if (!isGlobal && vjoCcCtx.getPositionType() != 1 && vjoCcCtx.getPositionType() != 2 && vjoCcCtx.getPositionType() != 3) {
            if (vjoCcCtx.hasNoPrefix()) {
                replaceString = property.isStatic() && (property.getOwnerType() != vjoCcCtx.getActingType() || !vjoCcCtx.isInStatic()) ? "this.vj$." + property.getOwnerType().getSimpleName() + '.' + replaceString : "this." + replaceString;
            }
            if (CodeCompletionUtils.isPropertyNameQuoted(ptyName)) {
                replaceString = new StringBuilder(ptyName.length() + 2).append('[').append(ptyName).append(']').toString();
            }
        }
        return replaceString;
    }

    private static boolean isPropertyNameQuoted(String ptyName) {
        if (ptyName == null) {
            return false;
        }
        int ptyNameLen = ptyName.length();
        return ptyNameLen > 0 && (ptyName.indexOf(39) == 0 && ptyName.lastIndexOf(39) == ptyNameLen - 1 || ptyName.indexOf(34) == 0 && ptyName.indexOf(34) == ptyNameLen - 1);
    }

    public static String getOuterMethodProposalReplaceStr(IJstMethod method) {
        String replaceString = String.valueOf(method.getName().getName()) + "(" + CodeCompletionUtils.getJstArgsStringForReplace(method) + ")";
        replaceString = method.isStatic() ? "this.vj$." + method.getOwnerType().getSimpleName() + '.' + replaceString : "this.vj$." + VjoKeywordFactory.KWD_OUTER.getName() + '.' + replaceString;
        return replaceString;
    }

    public static String getOuterPropertyProposalReplaceStr(IJstProperty property) {
        String replaceString = property.getName().getName();
        replaceString = property.isStatic() ? "this.vj$." + property.getOwnerType().getSimpleName() + '.' + replaceString : "this.vj$." + VjoKeywordFactory.KWD_OUTER.getName() + '.' + replaceString;
        return replaceString;
    }

    public static String getOuterPropertyProposalReplaceStr(IJstType type) {
        String replaceString = type.getSimpleName();
        IJstType parentType = (IJstType)type.getParentNode();
        replaceString = type.getModifiers().isStatic() ? "this.vj$." + parentType.getSimpleName() + '.' + replaceString : "this.vj$." + VjoKeywordFactory.KWD_OUTER.getName() + '.' + replaceString;
        return replaceString;
    }

    public static String getMethodProposalReplaceStr(boolean isGlobal, IJstMethod method, String name, VjoCcCtx vjoCcCtx) {
        name = JstDisplayUtils.renameInvoke((IJstMethod)method, (String)name);
        String replaceString = String.valueOf(name) + "(" + CodeCompletionUtils.getJstArgsStringForReplace(method) + ")";
        if (!isGlobal && vjoCcCtx.getPositionType() != 1 && vjoCcCtx.getPositionType() != 2 && vjoCcCtx.getPositionType() != 3 && vjoCcCtx.hasNoPrefix()) {
            IJstType mOwnwerType = method.getOwnerType();
            if (method.isStatic() && (mOwnwerType != vjoCcCtx.getActingType() || !vjoCcCtx.isInStatic())) {
                String typeName = mOwnwerType.getSimpleName();
                if (method.getOwnerType().isMixin()) {
                    typeName = vjoCcCtx.getActingType().getSimpleName();
                }
                replaceString = "this.vj$." + typeName + '.' + replaceString;
            } else {
                replaceString = "this." + replaceString;
            }
        }
        return replaceString;
    }

    public static void printProposal(List<IVjoCcProposalData> list) {
        System.out.println("Begin proposal...");
        for (IVjoCcProposalData pdata : list) {
            Object data = pdata.getData();
            String str = "";
            if (data instanceof IJstType) {
                str = ((IJstType)data).getName();
            } else if (data instanceof IJstMethod) {
                str = ((IJstMethod)data).getName().getName();
            } else if (data instanceof IJstProperty) {
                str = ((IJstProperty)data).getName().getName();
            } else if (data instanceof JstPackage) {
                JstPackage pck = (JstPackage)data;
                str = pck.getName();
            } else if (data instanceof String) {
                str = (String)data;
            }
            System.out.println(String.valueOf(pdata.getAdvisor()) + ":" + str);
        }
        System.out.println("End proposal...");
    }

    public static int[] getGeneralFieldCallLevel(IJstType callingType, IJstType calledType) {
        if (CodeCompletionUtils.isSameType(callingType, calledType) || CodeCompletionUtils.isInnerType(calledType, callingType) || CodeCompletionUtils.isInnerType(callingType, calledType)) {
            int[] nArray = new int[4];
            nArray[0] = 1;
            nArray[1] = 4;
            nArray[3] = 2;
            return nArray;
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(1);
        if (CodeCompletionUtils.isSamePackage(callingType, calledType)) {
            list.add(0);
            list.add(4);
        } else if (CodeCompletionUtils.isSuperType(callingType, calledType)) {
            list.add(4);
        }
        int[] is = new int[list.size()];
        int i = 0;
        Iterator it = list.iterator();
        while (it.hasNext()) {
            is[i++] = (Integer)it.next();
        }
        return is;
    }

    public static boolean levelCheck(JstModifiers modifies, int[] levels) {
        int[] nArray = levels;
        int n = levels.length;
        int n2 = 0;
        while (n2 < n) {
            int level = nArray[n2];
            switch (level) {
                case 1: {
                    if (!modifies.isPublic()) break;
                    return true;
                }
                case 0: {
                    if (modifies.isPublic() || modifies.isPrivate() || modifies.isProtected()) break;
                    return true;
                }
                case 4: {
                    if (!modifies.isProtected()) break;
                    return true;
                }
                case 2: {
                    if (!modifies.isPrivate()) break;
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    public static String getInnerTypeAsPropertyProposalReplaceStr(boolean isGlobal, IJstType jstType, VjoCcCtx vjoCcCtx) {
        String replaceString = jstType.getSimpleName();
        if (!isGlobal && vjoCcCtx.getPositionType() != 1 && vjoCcCtx.getPositionType() != 2 && vjoCcCtx.getPositionType() != 3 && vjoCcCtx.hasNoPrefix()) {
            replaceString = "this." + replaceString;
        }
        return replaceString;
    }

    public static boolean isTypeType(String typeName) {
        return "vjo.ctype".equals(typeName) || "vjo.mtype".equals(typeName) || "vjo.itype".equals(typeName) || "vjo.etype".equals(typeName) || "vjo.otype".equals(typeName) || "vjo.ftype".equals(typeName);
    }

    public static boolean isTypeRefDeclare(String name) {
        return "needs".equals(name);
    }

    public static boolean isInterfaceRefDeclare(String name, String type) {
        return "satisfies".equals(name) || "inherits".equals(name) && "itype".equals(type);
    }

    public static boolean isMixinTypeRefDeclare(String name) {
        return "mixin".equals(name);
    }

    public static boolean isCTypeRefDeclare(String name, String type) {
        return "inherits".equals(name) && !"itype".equals(type);
    }

    public static boolean isTypeDeclare(String key) {
        return "ctype".equals(key) || "etype".equals(key) || "itype".equals(key) || "mtype".equals(key) || "otype".equals(key);
    }

    public static IJstMethod getMethod(IJstType type, String methodName) {
        IJstMethod method = null;
        method = "constructs".equals(methodName) ? type.getConstructor() : type.getMethod(methodName);
        return method;
    }

    public static boolean isSynthesizedElement(Object obj) {
        if (ISynthesized.class.isAssignableFrom(obj.getClass())) {
            return true;
        }
        if (obj instanceof JstProxyProperty) {
            return CodeCompletionUtils.isSynthesizedElement(((JstProxyProperty)obj).getTargetProperty().getClass());
        }
        if (obj instanceof JstProxyMethod) {
            return CodeCompletionUtils.isSynthesizedElement(((JstProxyMethod)obj).getTargetMethod().getClass());
        }
        return false;
    }

    public static boolean isStringType(IJstType type) {
        if (type == null) {
            return false;
        }
        return "String".equals(type.getName()) && "JsNativeLib".equals(type.getPackage().getGroupName());
    }

    public static boolean isArrayType(IJstType type) {
        if (type == null) {
            return false;
        }
        return "Array".equals(type.getName()) && "JsNativeLib".equals(type.getPackage().getGroupName());
    }

    public static String getAliasOrTypeName(IJstType ownerType, IJstType type) {
        if (type instanceof JstInferredType) {
            type = ((JstInferredType)type).getType();
        }
        if (ownerType != null) {
            for (Map.Entry entry : ownerType.getImportsMap().entrySet()) {
                if (!((IJstType)entry.getValue()).equals(type)) continue;
                return (String)entry.getKey();
            }
        }
        return type.getSimpleName();
    }

    public static boolean isTypeAdvisor(String a1) {
        return a1.equals(VjoCcTypeProposalAdvisor.ID) || a1.equals(VjoCcCTypeProposalAdvisor.ID);
    }

    public static IJstType getOuterJstType(IJstType jstType) {
        IJstType result = jstType;
        while (result.getParentNode() != null) {
            if (!((result = result.getParentNode()) instanceof IJstType)) continue;
            jstType = result;
        }
        return jstType;
    }

    public static String getJstArgsString(IJstMethod method) {
        return JstDisplayUtils.getJstArgsString((IJstMethod)method);
    }
}

