/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.codeassist.compliance;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.vjet.dsf.jsnative.anno.BrowserType;

public class PredefinedBrowsersPreferenceKeys {
    private static final List<IBrowserKey> PREDEF_KEYS = new ArrayList<IBrowserKey>();
    static final IBrowserKey MSIE_KEY;
    static final IBrowserKey FF_KEY;
    static final IBrowserKey OPERA_KEY;
    static final IBrowserKey SAFARI_KEY;
    private static final String MSIE = "Internet Explorer";
    private static final Version MSIE_6X;
    private static final Version MSIE_6XP;
    private static final Version MSIE_7X;
    private static final Version MSIE_7XP;
    private static final Version MSIE_8X;
    private static final Version MSIE_8XP;
    private static final String FF = "Firefox/Mozilla";
    private static final Version FF_1X;
    private static final Version FF_1XP;
    private static final Version FF_2X;
    private static final Version FF_2XP;
    private static final Version FF_3X;
    private static final Version FF_3XP;
    private static final String OPERA = "Opera";
    private static final Version OPERA_7X;
    private static final Version OPERA_7XP;
    private static final Version OPERA_8X;
    private static final Version OPERA_8XP;
    private static final Version OPERA_9X;
    private static final Version OPERA_9XP;
    private static final String SAFARI = "Safari";
    private static final Version SAFARI_3;
    private static final Version SAFARI_3P;

    static {
        MSIE_6X = new Version(6);
        MSIE_6XP = new Version(6, true);
        MSIE_7X = new Version(7);
        MSIE_7XP = new Version(7, true);
        MSIE_8X = new Version(8);
        MSIE_8XP = new Version(8, true);
        FF_1X = new Version(1);
        FF_1XP = new Version(1, true);
        FF_2X = new Version(2);
        FF_2XP = new Version(2, true);
        FF_3X = new Version(3);
        FF_3XP = new Version(3, true);
        OPERA_7X = new Version(7);
        OPERA_7XP = new Version(7, true);
        OPERA_8X = new Version(8);
        OPERA_8XP = new Version(8, true);
        OPERA_9X = new Version(9);
        OPERA_9XP = new Version(9, true);
        SAFARI_3 = new Version(3);
        SAFARI_3P = new Version(3, true);
        MSIE_KEY = PredefinedBrowsersPreferenceKeys.register(MSIE, new Version[]{MSIE_6X, MSIE_6XP, MSIE_7X, MSIE_7XP, MSIE_8X, MSIE_8XP}, BrowserType.IE_6);
        FF_KEY = PredefinedBrowsersPreferenceKeys.register(FF, new Version[]{FF_1X, FF_1XP, FF_2X, FF_2XP, FF_3X, FF_3XP}, BrowserType.FIREFOX_1);
        OPERA_KEY = PredefinedBrowsersPreferenceKeys.register(OPERA, new Version[]{OPERA_7X, OPERA_7XP, OPERA_8X, OPERA_8XP, OPERA_9X, OPERA_9XP}, BrowserType.OPERA_7);
        SAFARI_KEY = PredefinedBrowsersPreferenceKeys.register(SAFARI, new Version[]{SAFARI_3, SAFARI_3P}, BrowserType.SAFARI_3);
    }

    public static IBrowserKey[] getPredefinedKeys() {
        return PREDEF_KEYS.toArray(new IBrowserKey[0]);
    }

    static int parseVersionNumber(String value) {
        return Version.parseVersionNumber(value);
    }

    private static IBrowserKey register(final String browser, final Version[] vers, final BrowserType type) {
        IBrowserKey registeredKey = new IBrowserKey(){

            @Override
            public String getBrowser() {
                return browser;
            }

            @Override
            public String[] getVersions() {
                String[] versions = new String[vers.length];
                int iter = 0;
                while (iter < vers.length) {
                    versions[iter] = vers[iter].toString();
                    ++iter;
                }
                return versions;
            }

            @Override
            public String isTargetedBrowserPredefKey() {
                return "is_targeted_browser_" + browser;
            }

            @Override
            public String takeTargetedBrowserVerPredefKey() {
                return "take_targeted_browser_ver_" + browser;
            }

            @Override
            public boolean sameAs(BrowserType typeToCompare) {
                return type.getName().equals(typeToCompare.getName());
            }
        };
        PREDEF_KEYS.add(registeredKey);
        return registeredKey;
    }

    public static interface IBrowserKey {
        public String getBrowser();

        public String[] getVersions();

        public String isTargetedBrowserPredefKey();

        public String takeTargetedBrowserVerPredefKey();

        public boolean sameAs(BrowserType var1);
    }

    private static class Version {
        private static final String ABOVE = ".x and above";
        private static final String ONLY = ".x only";
        private static final Map<String, Version> vers = new HashMap<String, Version>();
        int version;
        boolean plus;

        Version(int version) {
            this(version, false);
        }

        Version(int version, boolean plus) {
            this.version = version;
            this.plus = plus;
            vers.put(this.toString(), this);
        }

        public String toString() {
            return String.valueOf(this.version) + (this.plus ? ABOVE : ONLY);
        }

        static int parseVersionNumber(String value) {
            if (vers.containsKey(value)) {
                Version ver = vers.get(value);
                return ver.plus ? -ver.version : ver.version;
            }
            return 0;
        }
    }
}

