/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.codeassist.compliance;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.vjet.dsf.jsnative.anno.BrowserType;
import org.eclipse.vjet.dsf.jsnative.anno.SupportedBy;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstAnnotation;
import org.eclipse.vjet.dsf.jst.expr.AssignExpr;
import org.eclipse.vjet.dsf.jst.expr.JstArrayInitializer;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.eclipse.codeassist.compliance.PredefinedBrowsersPreferenceKeys;
import org.osgi.service.prefs.BackingStoreException;

public class SupportedByAnnotationAcceptor {
    private static final String SUPPORTED_BY_ANNO = SupportedBy.class.getSimpleName();
    private static final String BROWSERS_ANNO_VALUE = "browsers";
    private static final String DOM_LEVEL_ANNO_VALUE = "domLevel";
    private static Map<IProject, SupportedByAnnotationAcceptor> acceptors = new HashMap<IProject, SupportedByAnnotationAcceptor>();
    private IEclipsePreferences pref;
    private ProjectScope prjScope;
    private InstanceScope instScope;
    private List<PredefinedBrowsersPreferenceKeys.IBrowserKey> targetedBrowsers = new ArrayList<PredefinedBrowsersPreferenceKeys.IBrowserKey>();

    public static synchronized SupportedByAnnotationAcceptor getAcceptor(IProject prj) {
        SupportedByAnnotationAcceptor acceptor;
        if (acceptors.containsKey(prj)) {
            acceptor = acceptors.get(prj);
        } else {
            acceptor = new SupportedByAnnotationAcceptor(prj);
            acceptors.put(prj, acceptor);
        }
        acceptor.renew();
        return acceptor;
    }

    private SupportedByAnnotationAcceptor(IProject prj) {
        this.prjScope = new ProjectScope(prj);
        this.instScope = new InstanceScope();
    }

    private void setPrefValues(IEclipsePreferences pref) {
        PredefinedBrowsersPreferenceKeys.IBrowserKey[] iBrowserKeyArray = PredefinedBrowsersPreferenceKeys.getPredefinedKeys();
        int n = iBrowserKeyArray.length;
        int n2 = 0;
        while (n2 < n) {
            PredefinedBrowsersPreferenceKeys.IBrowserKey browserKey = iBrowserKeyArray[n2];
            if (pref.getBoolean(browserKey.isTargetedBrowserPredefKey(), false)) {
                this.targetedBrowsers.add(browserKey);
            }
            ++n2;
        }
    }

    private void renew() {
        boolean prjSettingEnabled = false;
        this.targetedBrowsers.clear();
        this.pref = this.prjScope.getNode("org.eclipse.vjet.eclipse.core");
        try {
            prjSettingEnabled = this.pref.keys().length > 0;
        }
        catch (BackingStoreException bse) {
            DLTKCore.error((String)bse.getMessage());
            prjSettingEnabled = false;
        }
        if (prjSettingEnabled) {
            this.setPrefValues(this.pref);
        } else {
            this.pref = this.instScope.getNode("org.eclipse.vjet.eclipse.core");
            this.setPrefValues(this.pref);
        }
    }

    private IJstAnnotation find(String annoName, List<IJstAnnotation> annotations) {
        for (IJstAnnotation anno : annotations) {
            if (!anno.getName().getName().equalsIgnoreCase(annoName)) continue;
            return anno;
        }
        return null;
    }

    private boolean acceptBrowserVersion(BrowserType dsfBrowser, PredefinedBrowsersPreferenceKeys.IBrowserKey predefKey) {
        String storedValue = this.pref.get(predefKey.takeTargetedBrowserVerPredefKey(), null);
        int predefVer = PredefinedBrowsersPreferenceKeys.parseVersionNumber(storedValue);
        int annoVer = dsfBrowser.isPlus() ? -dsfBrowser.getVersion() : dsfBrowser.getVersion();
        int sub = Math.abs(predefVer) - Math.abs(annoVer);
        boolean accepted = sub == 0 || annoVer < 0 && sub > 0;
        return accepted;
    }

    private BrowserType[] parseBrowserAnnotation(AssignExpr annoValue) {
        ArrayList<BrowserType> browsers = new ArrayList<BrowserType>();
        JstArrayInitializer arrIni = (JstArrayInitializer)annoValue.getExpr();
        for (BaseJstNode node : arrIni.getChildren()) {
            String browserName = node.toString();
            browsers.add(BrowserType.valueOf((String)browserName.substring(browserName.indexOf(46) + 1)));
        }
        return browsers.toArray(new BrowserType[0]);
    }

    private boolean acceptBrowserAnno(AssignExpr annoValue) {
        boolean accepted = true;
        BrowserType[] supportedAnnoBrowsers = this.parseBrowserAnnotation(annoValue);
        for (PredefinedBrowsersPreferenceKeys.IBrowserKey targetedBrowser : this.targetedBrowsers) {
            BrowserType coincidentBrowser = null;
            BrowserType[] browserTypeArray = supportedAnnoBrowsers;
            int n = supportedAnnoBrowsers.length;
            int n2 = 0;
            while (n2 < n) {
                BrowserType annoBrowser = browserTypeArray[n2];
                if (targetedBrowser.sameAs(annoBrowser)) {
                    coincidentBrowser = annoBrowser;
                    break;
                }
                ++n2;
            }
            boolean bl = accepted = coincidentBrowser != null && this.acceptBrowserVersion(coincidentBrowser, targetedBrowser);
            if (!accepted) break;
        }
        return accepted;
    }

    private boolean acceptDomLevelAnno(AssignExpr assign) {
        return true;
    }

    public boolean accept(List<IJstAnnotation> anno) {
        IJstAnnotation supportedBy = this.find(SUPPORTED_BY_ANNO, anno);
        boolean accepted = false;
        if (supportedBy != null) {
            List annoValues = supportedBy.values();
            for (IExpr exp : annoValues) {
                AssignExpr assign;
                String annoValueName;
                if (!(exp instanceof AssignExpr) || (accepted = (annoValueName = (assign = (AssignExpr)exp).getLHS().toLHSText()).equals(BROWSERS_ANNO_VALUE) ? this.acceptBrowserAnno(assign) : (annoValueName.equals(DOM_LEVEL_ANNO_VALUE) ? this.acceptDomLevelAnno(assign) : true))) {
                    continue;
                }
                break;
            }
        } else {
            return !accepted;
        }
        return accepted;
    }
}

