/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.codeassist.keywords;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.vjet.eclipse.codeassist.keywords.IVjoCompletionData;

public abstract class AbstractVjoCompletionData
implements IVjoCompletionData {
    static Map<String, IVjoCompletionData> installedKeywords = new HashMap<String, IVjoCompletionData>();
    private boolean isEnclosable = false;
    private boolean isComposable = false;
    private boolean isTopLevel = false;
    private String name;
    private String trailingPart;
    private String fullName;
    private int flags;
    private int type = 2;
    private int relevance = 1;
    private boolean isProposal = true;

    AbstractVjoCompletionData(String name, String trailingPart, boolean isEnclosable, boolean isComposable, boolean isTopLevel) {
        this.name = name;
        this.trailingPart = trailingPart;
        this.isEnclosable = isEnclosable;
        this.isComposable = isComposable;
        this.isTopLevel = isTopLevel;
        this.fullName = String.valueOf(name) + trailingPart;
        installedKeywords.put(name, this);
    }

    AbstractVjoCompletionData(String name, String trailingPart) {
        this(name, trailingPart, false, false, false);
    }

    @Override
    public boolean isEnclosableKeyword() {
        return this.isEnclosable;
    }

    @Override
    public boolean isComposableKeyword() {
        return this.isComposable;
    }

    @Override
    public boolean isUnclosed() {
        return false;
    }

    @Override
    public boolean isComplementedPart() {
        return false;
    }

    @Override
    public boolean isTopLevelKeyword() {
        return this.isTopLevel;
    }

    @Override
    public boolean canComplete(String text) {
        return text.length() > 0 && ("".equals(text) || this.name.toLowerCase().startsWith(text.toLowerCase()));
    }

    @Override
    public boolean isAllowedTrigger(char trigger) {
        return false;
    }

    @Override
    public int getCursorOffsetAfterCompletion() {
        return this.fullName.length();
    }

    @Override
    public String toString() {
        return this.fullName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setFlags(int flags) {
        this.flags = flags;
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public void setType(int type) {
        this.type = type;
    }

    @Override
    public boolean isProposal() {
        return this.isProposal;
    }

    @Override
    public void setProposal(boolean isProposal) {
        this.isProposal = isProposal;
    }

    @Override
    public int getRelevance() {
        return this.relevance;
    }

    @Override
    public void setRelevance(int relevance) {
        this.relevance = relevance;
    }
}

