/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.debug.ui.actions;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.actions.IVariableValueEditor;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.debug.core.eval.IScriptEvaluationResult;
import org.eclipse.dltk.mod.debug.core.model.IScriptStackFrame;
import org.eclipse.dltk.mod.debug.core.model.IScriptValue;
import org.eclipse.dltk.mod.debug.core.model.IScriptVariable;
import org.eclipse.dltk.mod.internal.debug.core.model.ScriptVariable;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.WorkbenchJob;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstArg;
import org.eclipse.vjet.dsf.jst.declaration.JstDefaultConstructor;
import org.eclipse.vjet.dsf.jst.declaration.JstVars;
import org.eclipse.vjet.dsf.jst.expr.AssignExpr;
import org.eclipse.vjet.dsf.jst.term.JstIdentifier;
import org.eclipse.vjet.dsf.jst.traversal.IJstNodeVisitor;
import org.eclipse.vjet.dsf.jstojava.translator.JstUtil;
import org.eclipse.vjet.eclipse.codeassist.CodeassistUtils;
import org.eclipse.vjet.eclipse.core.IVjoSourceModule;
import org.eclipse.vjet.eclipse.core.ts.GenericVisitor;
import org.eclipse.vjet.eclipse.debug.ui.VjetDebugUIPlugin;
import org.eclipse.vjet.eclipse.internal.debug.VjetDebugPlugin;
import org.eclipse.vjet.eclipse.internal.debug.ui.actions.ActionMessages;
import org.eclipse.vjet.eclipse.internal.debug.ui.actions.ChangeJsVariableValueInputDialog;

public class VjetScriptVariableValueEditor
implements IVariableValueEditor {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final char QUOT = '\"';
    private static final char SINGLE_QUOT = '\'';

    public boolean editVariable(IVariable variable, Shell shell) {
        String input;
        if (!(variable instanceof IScriptVariable)) {
            return false;
        }
        IScriptVariable scriptVar = (IScriptVariable)variable;
        if (scriptVar.isConstant() || !variable.supportsValueModification()) {
            return true;
        }
        try {
            input = this.getInput(variable, shell);
            String varValue = scriptVar.getValue().getValueString();
            if (input == null || varValue.equals(input)) {
                return true;
            }
        }
        catch (DebugException e) {
            VjetDebugUIPlugin.errorDialog(shell, ActionMessages.ChangeVariableValue_errorDialogTitle, ActionMessages.ChangeVariableValue_errorDialogMessage, e);
            return true;
        }
        this.asyncSetValue(scriptVar, input, shell);
        return true;
    }

    public boolean saveVariable(IVariable variable, String expression, Shell shell) {
        IScriptVariable scriptVar;
        block6: {
            if (!(variable instanceof IScriptVariable)) {
                return false;
            }
            scriptVar = (IScriptVariable)variable;
            if (scriptVar.isConstant() || !variable.supportsValueModification()) {
                return true;
            }
            String valueString = scriptVar.getValue().getValueString();
            if (!expression.equals(valueString)) break block6;
            return true;
        }
        try {
            if (!variable.verifyValue(expression)) {
                return true;
            }
        }
        catch (DebugException e) {
            VjetDebugUIPlugin.error(e.getLocalizedMessage(), e);
        }
        this.asyncSetValue(scriptVar, expression, shell);
        return true;
    }

    private void asyncSetValue(final IScriptVariable scriptVar, final String input, Shell shell) {
        WorkbenchJob job = new WorkbenchJob(shell.getDisplay(), ""){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                VjetScriptVariableValueEditor.this.setValue(scriptVar, input, this.getDisplay().getActiveShell());
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    private String concate(String[] errorMessages) {
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (i < errorMessages.length) {
            b.append(errorMessages[i]).append(LINE_SEPARATOR);
            ++i;
        }
        return b.toString();
    }

    private String convert2JSStringExp(String input) {
        return String.valueOf('\'') + this.escape(input) + '\'';
    }

    private String escape(String input) {
        input = input.replaceAll("\\\\", "\\\\\\\\");
        input = input.replaceAll("'", "\\\\'");
        input = input.replaceAll("\"", "\\\\\"");
        return input;
    }

    private IScriptValue evaluate(String input, IScriptStackFrame frame, Shell shell) {
        IScriptEvaluationResult evalResult = frame.getScriptThread().getEvaluationEngine().syncEvaluate(input, frame);
        if (evalResult.hasErrors()) {
            String[] errorMessages = evalResult.getErrorMessages();
            VjetDebugUIPlugin.errorDialog(shell, ActionMessages.ChangeVariableValue_errorDialogTitle, this.concate(errorMessages), evalResult.getException());
            return null;
        }
        return evalResult.getValue();
    }

    private String getInput(final IVariable variable, Shell shell) throws DebugException {
        ChangeJsVariableValueInputDialog inputDialog = new ChangeJsVariableValueInputDialog(shell, ActionMessages.ChangeVariableValue_1, MessageFormat.format(ActionMessages.ChangeVariableValue_2, variable.getName()), variable.getValue().getValueString(), new IInputValidator(){

            public String isValid(String input) {
                try {
                    if (variable.verifyValue(input)) {
                        return null;
                    }
                }
                catch (DebugException debugException) {
                    return ActionMessages.ChangeVariableValue_3;
                }
                return ActionMessages.ChangeVariableValue_4;
            }
        });
        int flags = inputDialog.open();
        if (1 == flags) {
            return null;
        }
        String input = inputDialog.getValue();
        return input;
    }

    private IScriptStackFrame getStackFrame() {
        return (IScriptStackFrame)DebugUITools.getDebugContext().getAdapter(IScriptStackFrame.class);
    }

    private String getTypeNameFromJST(String varName, IScriptStackFrame frame, IVjoSourceModule vjoSourceModule) throws BadLocationException, ModelException, DebugException {
        IJstType valueType = this.getJstType(varName, vjoSourceModule, frame);
        return valueType != null ? valueType.getName() : null;
    }

    private IJstType getJstType(final String varName, IVjoSourceModule vjoSourceModule, IScriptStackFrame frame) throws BadLocationException, ModelException, DebugException {
        int lineOffset = new Document(vjoSourceModule.getSource()).getLineOffset(frame.getLineNumber() - 1);
        IJstType jstType = CodeassistUtils.getJstType((IVjoSourceModule)vjoSourceModule);
        if (jstType == null) {
            return null;
        }
        IJstMethod jstMethod = this.getJstMethod(lineOffset, jstType);
        if (jstMethod == null) {
            return null;
        }
        final IJstType[] results = new IJstType[1];
        jstMethod.accept((IJstNodeVisitor)new GenericVisitor(){

            public void visit(JstArg jstArg) {
                if (varName.equals(jstArg.getName())) {
                    results[0] = jstArg.getType();
                }
            }

            public void visit(JstVars jstVars) {
                List assignments = jstVars.getInitializer().getAssignments();
                for (AssignExpr assignExpr : assignments) {
                    IJstNode jstNode = (IJstNode)assignExpr.getChildren().get(0);
                    if (!(jstNode instanceof JstIdentifier) || !varName.equals(((JstIdentifier)jstNode).getName())) continue;
                    results[0] = jstVars.getType();
                    return;
                }
            }
        });
        IJstType valueType = results[0];
        return valueType;
    }

    private IJstMethod getJstMethod(int lineOffset, IJstType jstType) {
        ArrayList<IJstMethod> methods = new ArrayList<IJstMethod>();
        methods.addAll(jstType.getInstanceMethods());
        methods.addAll(jstType.getStaticMethods());
        if (!(jstType.getConstructor() instanceof JstDefaultConstructor)) {
            methods.add(jstType.getConstructor());
        }
        return JstUtil.getMethod((int)lineOffset, methods);
    }

    private boolean isAssignable(String typeName, String evalValue) {
        if (this.isStringType(typeName)) {
            return true;
        }
        if (this.isNumberType(typeName)) {
            try {
                Double.parseDouble(evalValue);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        if (this.isBooleanType(typeName)) {
            return "true".equalsIgnoreCase(evalValue) || "false".equalsIgnoreCase(evalValue);
        }
        if (this.isCharType(typeName)) {
            return evalValue.length() == 1;
        }
        return "null".equalsIgnoreCase(evalValue);
    }

    private boolean isCharType(String typeName) {
        return "char".equals(typeName) || "org.eclipse.vjet.vjo.java.lang.Character".equals(typeName);
    }

    private boolean isBooleanType(String typeName) {
        return "boolean".equals(typeName) || "org.eclipse.vjet.vjo.java.lang.Boolean".equals(typeName);
    }

    private boolean isNumberType(String typeName) {
        return "Number".equals(typeName) || "int".equals(typeName) || "byte".equals(typeName) || "short".equals(typeName) || "long".equals(typeName) || "float".equals(typeName) || "double".equals(typeName) || "org.eclipse.vjet.vjo.java.lang.Integer".equals(typeName) || "org.eclipse.vjet.vjo.java.lang.Byte".equals(typeName) || "org.eclipse.vjet.vjo.java.lang.Short".equals(typeName) || "org.eclipse.vjet.vjo.java.lang.Long".equals(typeName) || "org.eclipse.vjet.vjo.java.lang.Float".equals(typeName) || "org.eclipse.vjet.vjo.java.lang.Double".equals(typeName);
    }

    private boolean isStringType(String typeName) {
        return "String".equals(typeName) || "org.eclipse.vjet.vjo.java.lang.String".equals(typeName);
    }

    private void setValue(IScriptVariable variable, String input, Shell shell) {
        if (!this.enableModicicationConstraints()) {
            try {
                variable.setValue(input);
            }
            catch (DebugException e) {
                VjetDebugUIPlugin.error(e.getLocalizedMessage(), e);
            }
            return;
        }
        IScriptStackFrame frame = this.getStackFrame();
        Object sourceElement = variable.getLaunch().getSourceLocator().getSourceElement((IStackFrame)frame);
        if (sourceElement instanceof IFile) {
            IModelElement element = DLTKCore.create((IFile)((IFile)sourceElement));
            if (element == null || !(element instanceof IVjoSourceModule)) {
                return;
            }
            IVjoSourceModule vjoSourceModule = (IVjoSourceModule)element;
            try {
                IScriptValue evalValue;
                boolean isChar;
                String fullName;
                String[] propNames;
                String localVarName;
                IJstType localVarType;
                IJstType varType;
                ScriptVariable scriptVar;
                String varName = variable.getName();
                String varTypeName = null;
                if (variable instanceof ScriptVariable && (scriptVar = (ScriptVariable)variable).isChild() && (varType = this.getSubVariableJstType(localVarType = this.getJstType(localVarName = (propNames = (fullName = scriptVar.getEvalName()).split("\\."))[0], vjoSourceModule, frame), propNames)) != null) {
                    varTypeName = varType.getName();
                }
                if (varTypeName == null) {
                    varTypeName = this.getTypeNameFromJST(varName, frame, vjoSourceModule);
                }
                if (varTypeName == null) {
                    variable.setValue(input);
                    return;
                }
                boolean isString = this.isStringType(varTypeName);
                if (isString) {
                    input = this.convert2JSStringExp(input);
                }
                if (isChar = this.isCharType(varTypeName)) {
                    input = this.convert2Char(input);
                }
                if ((evalValue = this.evaluate(input, frame, shell)) == null) {
                    return;
                }
                String evalValueString = evalValue.getValueString();
                if (evalValueString.equals(variable.getValue().getValueString())) {
                    return;
                }
                if (!this.isAssignable(varTypeName, evalValueString)) {
                    return;
                }
                if (isString) {
                    evalValueString = this.convert2JSStringExp(evalValueString);
                } else if (this.isNumberType(varTypeName)) {
                    evalValueString = Double.valueOf(evalValueString).toString();
                } else if (isChar) {
                    evalValueString = this.convert2Char(evalValueString);
                }
                variable.setValue(evalValueString);
            }
            catch (Exception e) {
                VjetDebugUIPlugin.error(e.getLocalizedMessage(), e);
            }
        } else {
            try {
                variable.setValue(input);
            }
            catch (DebugException e) {
                VjetDebugUIPlugin.error(e.getLocalizedMessage(), e);
            }
        }
    }

    private String convert2Char(String evalValueString) {
        return String.valueOf('\'') + this.escape(String.valueOf(evalValueString.toCharArray()[0])) + '\'';
    }

    private boolean enableModicicationConstraints() {
        return VjetDebugPlugin.getDefault().getPreferenceStore().getBoolean("vjet_enable_modification_constraints");
    }

    private IJstType getSubVariableJstType(IJstType varType, String[] propNames) {
        IJstType type = varType;
        IJstProperty prop = null;
        int i = 1;
        while (i < propNames.length && type != null) {
            prop = type.getProperty(propNames[i], false, true);
            if (prop == null) {
                prop = type.getProperty(propNames[i], true, true);
            }
            if (prop == null) break;
            type = prop.getType();
            ++i;
        }
        if (prop == null || type == null) {
            return null;
        }
        return type;
    }
}

